/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.beneathcursedsands;

import com.google.inject.Inject;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

public class TombRiddle
extends DetailedOwnerStep {
    @Inject
    protected EventBus eventBus;
    @Inject
    protected Client client;
    Integer northernEmblem;
    Integer centreNorthEmblem;
    Integer centreSouthEmblem;
    Integer southernEmblem;
    private final HashMap<String, Integer> gods = new HashMap();
    private final HashMap<String, Integer> items = new HashMap();
    private final HashMap<Integer, ItemRequirement> emblems = new HashMap();
    private boolean solutionFound;
    ItemRequirement baboonEmblem;
    ItemRequirement humanEmblem;
    ItemRequirement crocodileEmblem;
    ItemRequirement scarabEmblem;
    DetailedQuestStep inspectPlaque;
    DetailedQuestStep obtainEmblems;
    DetailedQuestStep placeNorthernUrn;
    DetailedQuestStep placeCentreNorthUrn;
    DetailedQuestStep placeCentreSouthUrn;
    DetailedQuestStep placeSouthernUrn;
    DetailedQuestStep pullLever;

    public TombRiddle(QuestHelper questHelper) {
        super(questHelper, "Solve the riddle.", new Requirement[0]);
        int SCARAB = 4;
        int HUMAN = 2;
        int CROCODILE = 3;
        boolean BABOON = true;
        this.gods.put("god of isolation", 4);
        this.gods.put("god of health", 2);
        this.gods.put("goddess of resourcefulness", 3);
        this.gods.put("goddess of companionship", 1);
        this.items.put("a carving", 4);
        this.items.put("some wine", 2);
        this.items.put("a necklace", 3);
        this.items.put("some linen", 1);
        this.emblems.put(1, this.baboonEmblem);
        this.emblems.put(2, this.humanEmblem);
        this.emblems.put(3, this.crocodileEmblem);
        this.emblems.put(4, this.scarabEmblem);
    }

    @Override
    public void startUp() {
        this.updateSteps();
    }

    @Override
    public void shutDown() {
        this.shutDownStep();
        this.currentStep = null;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    @Override
    protected void updateSteps() {
        if (!this.solutionFound) {
            this.startUpStep(this.inspectPlaque);
            return;
        }
        int currentNorthernEmblem = this.client.getVarbitValue(13862);
        int currentCentreNorthEmblem = this.client.getVarbitValue(13861);
        int currentCentreSouthEmblem = this.client.getVarbitValue(13860);
        int currentSouthernEmblem = this.client.getVarbitValue(13859);
        if (currentNorthernEmblem != this.northernEmblem) {
            if (!this.emblems.get(this.northernEmblem).check(this.client)) {
                this.startUpStep(this.obtainEmblems);
            } else {
                this.startUpStep(this.placeNorthernUrn);
            }
        } else if (currentCentreNorthEmblem != this.centreNorthEmblem) {
            if (!this.emblems.get(this.centreNorthEmblem).check(this.client)) {
                this.startUpStep(this.obtainEmblems);
            } else {
                this.startUpStep(this.placeCentreNorthUrn);
            }
        } else if (currentCentreSouthEmblem != this.centreSouthEmblem) {
            if (!this.emblems.get(this.centreSouthEmblem).check(this.client)) {
                this.startUpStep(this.obtainEmblems);
            } else {
                this.startUpStep(this.placeCentreSouthUrn);
            }
        } else if (currentSouthernEmblem != this.southernEmblem) {
            if (!this.emblems.get(this.southernEmblem).check(this.client)) {
                this.startUpStep(this.obtainEmblems);
            } else {
                this.startUpStep(this.placeSouthernUrn);
            }
        } else {
            this.startUpStep(this.pullLever);
        }
    }

    private void setupItemRequirements() {
        this.baboonEmblem = new ItemRequirement("Baboon emblem", 26958);
        this.baboonEmblem.setHighlightInInventory(true);
        this.humanEmblem = new ItemRequirement("Human emblem", 26957);
        this.humanEmblem.setHighlightInInventory(true);
        this.crocodileEmblem = new ItemRequirement("Crocodile emblem", 26959);
        this.crocodileEmblem.setHighlightInInventory(true);
        this.scarabEmblem = new ItemRequirement("Scarab emblem", 26956);
        this.scarabEmblem.setHighlightInInventory(true);
    }

    @Override
    protected void setupSteps() {
        this.inspectPlaque = new ObjectStep(this.questHelper, 20391, new WorldPoint(3391, 9251, 0), "Inspect the north-western plaque and read it.", new Requirement[0]);
        this.obtainEmblems = new ObjectStep(this.questHelper, 20392, new WorldPoint(3391, 9245, 0), "Inspect the south-western plaque to get four emblems.", new Requirement[0]);
        this.pullLever = new ObjectStep(this.questHelper, 20288, new WorldPoint(3390, 9247, 0), "Pull the lever to the south-west.", new Requirement[0]);
        this.placeNorthernUrn = new ObjectStep(this.questHelper, 44590, "Place the emblem in the northernmost urn.", new Requirement[0]);
        this.placeCentreNorthUrn = new ObjectStep(this.questHelper, 44589, "Place the emblem in the centre-north urn.", new Requirement[0]);
        this.placeCentreSouthUrn = new ObjectStep(this.questHelper, 44588, "Place the emblem in the centre-south urn.", new Requirement[0]);
        this.placeSouthernUrn = new ObjectStep(this.questHelper, 44587, "Place the emblem in the southernmost urn.", new Requirement[0]);
        this.setupItemRequirements();
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.inspectPlaque, this.obtainEmblems, this.placeNorthernUrn, this.placeCentreNorthUrn, this.placeCentreSouthUrn, this.placeSouthernUrn, this.pullLever);
    }

    @Override
    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (!this.solutionFound && widgetLoaded.getGroupId() == 749) {
            Widget plaqueWidget = this.client.getWidget(749, 2);
            if (plaqueWidget == null || plaqueWidget.getStaticChildren() == null) {
                return;
            }
            String riddle = Arrays.stream(plaqueWidget.getStaticChildren()).map(Widget::getText).reduce("", (carry, widget) -> carry + widget + " ");
            if (riddle.length() > 0) {
                this.northernEmblem = this.gods.entrySet().stream().filter(e -> riddle.contains((String)e.getKey() + " arrived just before")).map(Map.Entry::getValue).findFirst().orElse(null);
                this.centreNorthEmblem = this.gods.entrySet().stream().filter(e -> riddle.contains("arrived just before the " + (String)e.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
                this.centreSouthEmblem = this.items.entrySet().stream().filter(e -> riddle.contains("To the one that arrived first, he offered " + (String)e.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
                this.southernEmblem = this.items.entrySet().stream().filter(e -> riddle.contains("The one that was offered " + (String)e.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
                if (this.northernEmblem == null || this.centreNorthEmblem == null || this.centreSouthEmblem == null || this.southernEmblem == null) {
                    return;
                }
                this.placeNorthernUrn.addItemRequirements(Collections.singletonList(this.emblems.get(this.northernEmblem)));
                this.placeNorthernUrn.addIcon(this.emblems.get(this.northernEmblem).getId());
                this.placeCentreNorthUrn.addItemRequirements(Collections.singletonList(this.emblems.get(this.centreNorthEmblem)));
                this.placeCentreNorthUrn.addIcon(this.emblems.get(this.centreNorthEmblem).getId());
                this.placeCentreSouthUrn.addItemRequirements(Collections.singletonList(this.emblems.get(this.centreSouthEmblem)));
                this.placeCentreSouthUrn.addIcon(this.emblems.get(this.centreSouthEmblem).getId());
                this.placeSouthernUrn.addItemRequirements(Collections.singletonList(this.emblems.get(this.southernEmblem)));
                this.placeSouthernUrn.addIcon(this.emblems.get(this.southernEmblem).getId());
                this.solutionFound = true;
            }
        }
    }
}

