/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.beneathcursedsands;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.beneathcursedsands.TombRiddle;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetModelRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.DigStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuestDescriptor(quest=QuestHelperQuest.BENEATH_CURSED_SANDS)
public class BeneathCursedSands
extends BasicQuestHelper {
    private static final Logger log = LoggerFactory.getLogger(BeneathCursedSands.class);
    ItemRequirement coal;
    ItemRequirement tinderbox;
    ItemRequirement ironBar;
    ItemRequirement spade;
    ItemRequirement meat;
    ItemRequirement prayerPotions;
    ItemRequirement fiveCoins;
    ItemRequirement waterskins;
    ItemRequirement antipoison;
    ItemRequirement accessToFairyRings;
    ItemRequirement pharaohsSceptre;
    ItemRequirement food;
    ItemRequirement meleeCombatGear;
    ItemRequirement rangedCombatGear;
    ItemRequirement staminaPotions;
    ItemRequirement nardahTeleport;
    ItemRequirement messageFromJamila;
    ItemRequirement stoneTablet;
    ItemRequirement chest;
    ItemRequirement scarabMould;
    ItemRequirement scarabEmblem;
    ItemRequirement rustyKey;
    ItemRequirement lilyOfTheElid;
    ItemRequirement cureCrate;
    QuestStep talkToJamilaToStart;
    QuestStep receiveSpecialItemFromJamila;
    QuestStep readMessage;
    QuestStep talkToMaisaStartInvestigation;
    QuestStep inspectBlockedPyramidEntry;
    QuestStep talkToCitizenOrGuard;
    QuestStep fightHeadMenaphiteGuard;
    QuestStep talkToMaisaExploreCliffs;
    QuestStep goFromCampsiteToRuinsOfUllek;
    QuestStep inspectFurnace;
    QuestStep useCoalOnFurnace;
    QuestStep useTinderboxOnFurnace;
    QuestStep searchWell;
    QuestStep readStoneTablet;
    QuestStep leaveRuinsOfUllek;
    QuestStep digForChest;
    QuestStep openChest;
    QuestStep craftEmblem;
    QuestStep useEmblemOnPillar;
    QuestStep rotateScarabLeft;
    QuestStep rotateScarabRight;
    QuestStep confirmScarabRotation;
    QuestStep enterDungeonToFightScarabMages;
    QuestStep fightScarabMages;
    QuestStep climbDownStairsAgain;
    QuestStep pullLever;
    QuestStep pullSecondLever;
    QuestStep enterRiddleDoor;
    QuestStep solveTombRiddle;
    QuestStep enterTombDoor;
    QuestStep talkToSpirit;
    QuestStep takeRustyKey;
    QuestStep unlockBossDoor;
    QuestStep fightChampionOfScabaras;
    QuestStep talkToScabarasHighPriest;
    QuestStep talkToMaisaInNardah;
    QuestStep attemptSteppingStones;
    QuestStep pickLilyOfElid;
    QuestStep takeLilyToZahur;
    QuestStep talkToZahur;
    QuestStep warmUpChemistryEquipment;
    QuestStep bringCureToPriest;
    QuestStep prepareFightMenaphiteAkh;
    QuestStep talkToSophanemHighPriest;
    QuestStep defeatMenaphiteAkh;
    QuestStep defeatMenaphiteShadow;
    QuestStep finishQuest;
    QuestStep talkToMaisaPostFightCutsceneInterruption;
    QuestStep obtainTinderbox;
    QuestStep obtainSpade;
    QuestStep goToRuinsOfUllek;
    QuestStep enterDungeon;
    QuestStep leaveTombDoor;
    QuestStep leaveRiddleDoor;
    QuestStep climbUpstairs;
    QuestStep openBossDoor;
    QuestStep fightScarabSwarm;
    QuestStep destroyShadowRift;
    QuestStep goToScabarasHighPriestDoorOne;
    QuestStep goToScabarasHighPriestDoorTwo;
    QuestStep leaveHighPriestDoorOne;
    QuestStep leaveHighPriestDoorTwo;
    QuestStep leaveDungeon;
    QuestStep purchaseBeef;
    QuestStep chemistryValveDecreaseLeft;
    QuestStep chemistryValveIncreaseMiddle;
    QuestStep chemistryValveDecreaseMiddle;
    QuestStep chemistryValveIncreaseRight;
    QuestStep chemistryValveDecreaseRight;
    QuestStep talkToOsman;
    Requirement inRuinsOfUllek;
    Requirement inScarabMageArea;
    Requirement inLeverMazeArea;
    Requirement inRiddleArea;
    Requirement inTombArea;
    Requirement inBossArea;
    Requirement inBossTransitionArea;
    VarbitRequirement investigatedPyramid;
    VarbitRequirement hasReadStoneTablet;
    VarbitRequirement scarabRotatedDownwards;
    VarbitRequirement scarabRotationQuickestRight;
    VarbitRequirement chemistryValveLeftStepZero;
    VarbitRequirement chemistryValveLeftStepOne;
    VarbitRequirement chemistryValveLeftStepTwo;
    VarbitRequirement chemistryValveLeftStepThree;
    VarbitRequirement chemistryValveMiddleNearMax;
    VarbitRequirement chemistryValveMiddleAtMaximum;
    VarbitRequirement chemistryValveRightAtMaximum;
    VarbitRequirement chemistryValveRightNearMax;
    ObjectCondition firstLeverPulled;
    NpcCondition shouldFightScarabSwarm;
    NpcCondition shouldDestroyShadowRift;
    NpcCondition shouldFightMenaphiteShadow;
    WidgetModelRequirement isRotatingScarab;
    WidgetModelRequirement inChemistryPuzzle;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToJamilaToStart);
        steps.put(2, this.receiveSpecialItemFromJamila);
        steps.put(4, this.readMessage);
        steps.put(6, this.talkToMaisaStartInvestigation);
        steps.put(8, this.talkToMaisaStartInvestigation);
        steps.put(10, this.talkToMaisaStartInvestigation);
        steps.put(12, this.talkToMaisaStartInvestigation);
        ConditionalStep investigatePyramid = new ConditionalStep((QuestHelper)this, this.inspectBlockedPyramidEntry, new Requirement[0]);
        investigatePyramid.addStep(new Conditions(this.investigatedPyramid), this.talkToCitizenOrGuard);
        steps.put(14, investigatePyramid);
        steps.put(16, this.talkToCitizenOrGuard);
        steps.put(18, this.fightHeadMenaphiteGuard);
        steps.put(20, this.talkToMaisaPostFightCutsceneInterruption);
        steps.put(22, this.talkToMaisaExploreCliffs);
        steps.put(24, this.talkToMaisaExploreCliffs);
        ConditionalStep goToAndInspectFurnace = new ConditionalStep((QuestHelper)this, this.goFromCampsiteToRuinsOfUllek, new Requirement[0]);
        goToAndInspectFurnace.addStep(new Conditions(LogicType.NOR, this.tinderbox), this.obtainTinderbox);
        goToAndInspectFurnace.addStep(new Conditions(LogicType.NOR, this.spade), this.obtainSpade);
        goToAndInspectFurnace.addStep(new Conditions(this.inRuinsOfUllek), this.inspectFurnace);
        steps.put(26, goToAndInspectFurnace);
        steps.put(28, this.useCoalOnFurnace);
        steps.put(30, this.useTinderboxOnFurnace);
        ConditionalStep obtainEmblem = new ConditionalStep((QuestHelper)this, this.goToRuinsOfUllek, new Requirement[0]);
        obtainEmblem.addStep(new Conditions(new Conditions(LogicType.NOR, this.hasReadStoneTablet, this.stoneTablet), this.inRuinsOfUllek), this.searchWell);
        obtainEmblem.addStep(new Conditions(new Conditions(LogicType.NOR, this.hasReadStoneTablet), this.stoneTablet), this.readStoneTablet);
        obtainEmblem.addStep(new Conditions(new Conditions(LogicType.NOR, this.chest, this.scarabMould, this.scarabEmblem), this.inRuinsOfUllek), this.leaveRuinsOfUllek);
        obtainEmblem.addStep(new Conditions(LogicType.NOR, this.chest, this.scarabMould, this.scarabEmblem), this.digForChest);
        obtainEmblem.addStep(new Conditions(this.chest), this.openChest);
        obtainEmblem.addStep(new Conditions(new Conditions(LogicType.NOR, this.scarabEmblem), this.scarabMould, this.inRuinsOfUllek), this.craftEmblem);
        obtainEmblem.addStep(new Conditions(this.scarabEmblem, this.inRuinsOfUllek), this.useEmblemOnPillar);
        steps.put(32, obtainEmblem);
        steps.put(34, obtainEmblem);
        ConditionalStep rotateScarab = new ConditionalStep((QuestHelper)this, this.goToRuinsOfUllek, new Requirement[0]);
        rotateScarab.addStep(new Conditions(new Conditions(LogicType.NOR, this.isRotatingScarab), this.inRuinsOfUllek), this.useEmblemOnPillar);
        rotateScarab.addStep(new Conditions(this.isRotatingScarab, this.scarabRotatedDownwards), this.confirmScarabRotation);
        rotateScarab.addStep(new Conditions(this.isRotatingScarab, this.scarabRotationQuickestRight), this.rotateScarabRight);
        rotateScarab.addStep(new Conditions(this.isRotatingScarab), this.rotateScarabLeft);
        steps.put(36, rotateScarab);
        ConditionalStep defeatScarabMages = new ConditionalStep((QuestHelper)this, this.goToRuinsOfUllek, new Requirement[0]);
        defeatScarabMages.addStep(new Conditions(this.inRuinsOfUllek), this.enterDungeonToFightScarabMages);
        defeatScarabMages.addStep(new Conditions(this.inScarabMageArea), this.fightScarabMages);
        steps.put(38, defeatScarabMages);
        steps.put(40, defeatScarabMages);
        ConditionalStep climbDownSecondSteps = new ConditionalStep((QuestHelper)this, this.goToRuinsOfUllek, new Requirement[0]);
        climbDownSecondSteps.addStep(new Conditions(this.inRuinsOfUllek), this.enterDungeon);
        climbDownSecondSteps.addStep(new Conditions(this.inScarabMageArea), this.climbDownStairsAgain);
        steps.put(42, climbDownSecondSteps);
        ConditionalStep pullFirstLever = new ConditionalStep((QuestHelper)this, this.goToRuinsOfUllek, new Requirement[0]);
        pullFirstLever.addStep(new Conditions(this.inRuinsOfUllek), this.enterDungeon);
        pullFirstLever.addStep(new Conditions(this.inScarabMageArea), this.climbDownStairsAgain);
        pullFirstLever.addStep(new Conditions(new Conditions(LogicType.NOR, this.firstLeverPulled), this.inLeverMazeArea), this.pullLever);
        pullFirstLever.addStep(new Conditions(this.inLeverMazeArea), this.pullSecondLever);
        steps.put(44, pullFirstLever);
        ConditionalStep solveRiddle = new ConditionalStep((QuestHelper)this, this.goToRuinsOfUllek, new Requirement[0]);
        solveRiddle.addStep(new Conditions(this.inRuinsOfUllek), this.enterDungeon);
        solveRiddle.addStep(new Conditions(this.inScarabMageArea), this.climbDownStairsAgain);
        solveRiddle.addStep(new Conditions(this.inLeverMazeArea), this.enterRiddleDoor);
        solveRiddle.addStep(new Conditions(this.inRiddleArea), this.solveTombRiddle);
        steps.put(46, solveRiddle);
        ConditionalStep enterTomb = new ConditionalStep((QuestHelper)this, this.goToRuinsOfUllek, new Requirement[0]);
        enterTomb.addStep(new Conditions(this.inRuinsOfUllek), this.enterDungeon);
        enterTomb.addStep(new Conditions(this.inScarabMageArea), this.climbDownStairsAgain);
        enterTomb.addStep(new Conditions(this.inLeverMazeArea), this.enterRiddleDoor);
        enterTomb.addStep(new Conditions(this.inRiddleArea), this.enterTombDoor);
        enterTomb.addStep(new Conditions(this.inTombArea), this.talkToSpirit);
        steps.put(48, enterTomb);
        steps.put(50, enterTomb);
        steps.put(52, enterTomb);
        ConditionalStep obtainKey = new ConditionalStep((QuestHelper)this, this.goToRuinsOfUllek, new Requirement[0]);
        obtainKey.addStep(new Conditions(this.inRuinsOfUllek), this.enterDungeon);
        obtainKey.addStep(new Conditions(this.inScarabMageArea), this.climbDownStairsAgain);
        obtainKey.addStep(new Conditions(this.inLeverMazeArea), this.enterRiddleDoor);
        obtainKey.addStep(new Conditions(this.inRiddleArea), this.enterTombDoor);
        obtainKey.addStep(new Conditions(this.inTombArea), this.takeRustyKey);
        steps.put(54, obtainKey);
        ConditionalStep beginChampionOfScabarasFight = new ConditionalStep((QuestHelper)this, this.goToRuinsOfUllek, new Requirement[0]);
        beginChampionOfScabarasFight.addStep(new Conditions(this.inRuinsOfUllek), this.enterDungeon);
        beginChampionOfScabarasFight.addStep(new Conditions(this.inScarabMageArea, this.rustyKey), this.unlockBossDoor);
        beginChampionOfScabarasFight.addStep(new Conditions(this.inScarabMageArea), this.openBossDoor);
        beginChampionOfScabarasFight.addStep(new Conditions(this.inLeverMazeArea), this.climbUpstairs);
        beginChampionOfScabarasFight.addStep(new Conditions(this.inRiddleArea), this.leaveRiddleDoor);
        beginChampionOfScabarasFight.addStep(new Conditions(this.inTombArea), this.leaveTombDoor);
        steps.put(56, beginChampionOfScabarasFight);
        ConditionalStep championOfScabarasFight = new ConditionalStep((QuestHelper)this, this.goToRuinsOfUllek, new Requirement[0]);
        championOfScabarasFight.addStep(new Conditions(this.inRuinsOfUllek), this.enterDungeon);
        championOfScabarasFight.addStep(new Conditions(this.inScarabMageArea), this.openBossDoor);
        championOfScabarasFight.addStep(new Conditions(this.inBossArea), this.fightChampionOfScabaras);
        steps.put(58, championOfScabarasFight);
        steps.put(60, championOfScabarasFight);
        ConditionalStep highPriest = new ConditionalStep((QuestHelper)this, this.goToRuinsOfUllek, new Requirement[0]);
        highPriest.addStep(new Conditions(this.inRuinsOfUllek), this.enterDungeon);
        highPriest.addStep(new Conditions(this.inScarabMageArea), this.goToScabarasHighPriestDoorOne);
        highPriest.addStep(new Conditions(this.inBossTransitionArea), this.goToScabarasHighPriestDoorTwo);
        highPriest.addStep(new Conditions(this.inBossArea), this.talkToScabarasHighPriest);
        steps.put(62, highPriest);
        steps.put(64, highPriest);
        steps.put(66, highPriest);
        ConditionalStep goToNardah = new ConditionalStep((QuestHelper)this, this.talkToMaisaInNardah, new Requirement[0]);
        goToNardah.addStep(new Conditions(this.inRuinsOfUllek), this.leaveRuinsOfUllek);
        goToNardah.addStep(new Conditions(this.inScarabMageArea), this.leaveDungeon);
        goToNardah.addStep(new Conditions(this.inBossTransitionArea), this.leaveHighPriestDoorTwo);
        goToNardah.addStep(new Conditions(this.inBossArea), this.leaveHighPriestDoorOne);
        steps.put(68, goToNardah);
        steps.put(70, goToNardah);
        ConditionalStep buyMeat = new ConditionalStep((QuestHelper)this, this.talkToMaisaInNardah, new Requirement[0]);
        buyMeat.addStep(new Conditions(LogicType.NOR, this.meat), this.purchaseBeef);
        buyMeat.addStep(new Conditions(this.meat), this.attemptSteppingStones);
        steps.put(72, buyMeat);
        steps.put(74, buyMeat);
        ConditionalStep returnToZahur = new ConditionalStep((QuestHelper)this, this.pickLilyOfElid, new Requirement[0]);
        returnToZahur.addStep(new Conditions(this.lilyOfTheElid), this.takeLilyToZahur);
        steps.put(76, returnToZahur);
        steps.put(78, returnToZahur);
        steps.put(80, this.talkToZahur);
        ConditionalStep chemistryPuzzle = new ConditionalStep((QuestHelper)this, this.warmUpChemistryEquipment, new Requirement[0]);
        chemistryPuzzle.addStep(new Conditions(this.inChemistryPuzzle, this.chemistryValveLeftStepZero, new Conditions(LogicType.NAND, this.chemistryValveMiddleAtMaximum)), this.chemistryValveIncreaseMiddle);
        chemistryPuzzle.addStep(new Conditions(this.inChemistryPuzzle, this.chemistryValveLeftStepZero, this.chemistryValveMiddleAtMaximum, new Conditions(LogicType.NAND, this.chemistryValveRightAtMaximum)), this.chemistryValveIncreaseRight);
        chemistryPuzzle.addStep(new Conditions(this.inChemistryPuzzle, this.chemistryValveLeftStepZero, this.chemistryValveMiddleAtMaximum, this.chemistryValveRightAtMaximum), this.chemistryValveDecreaseRight);
        chemistryPuzzle.addStep(new Conditions(this.inChemistryPuzzle, this.chemistryValveLeftStepOne, this.chemistryValveMiddleAtMaximum, this.chemistryValveRightNearMax), this.chemistryValveDecreaseMiddle);
        chemistryPuzzle.addStep(new Conditions(this.inChemistryPuzzle, this.chemistryValveLeftStepTwo, this.chemistryValveMiddleNearMax, this.chemistryValveRightAtMaximum), this.chemistryValveDecreaseRight);
        chemistryPuzzle.addStep(new Conditions(this.inChemistryPuzzle, this.chemistryValveLeftStepThree, this.chemistryValveMiddleNearMax, this.chemistryValveRightNearMax), this.chemistryValveDecreaseMiddle);
        chemistryPuzzle.addStep(new Conditions(this.inChemistryPuzzle), this.chemistryValveDecreaseLeft);
        steps.put(82, chemistryPuzzle);
        steps.put(84, this.talkToZahur);
        steps.put(86, this.talkToZahur);
        steps.put(88, this.bringCureToPriest);
        steps.put(90, this.talkToSophanemHighPriest);
        steps.put(92, this.prepareFightMenaphiteAkh);
        steps.put(94, this.prepareFightMenaphiteAkh);
        steps.put(96, this.prepareFightMenaphiteAkh);
        ConditionalStep menaphiteAkhFight = new ConditionalStep((QuestHelper)this, this.defeatMenaphiteAkh, new Requirement[0]);
        steps.put(98, menaphiteAkhFight);
        steps.put(100, this.talkToOsman);
        steps.put(102, this.finishQuest);
        steps.put(104, this.finishQuest);
        steps.put(106, this.finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.coal = new ItemRequirement("Coal", 453);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.tinderbox.canBeObtainedDuringQuest();
        this.ironBar = new ItemRequirement("Iron bar", 2351);
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.spade.canBeObtainedDuringQuest();
        this.meat = new ItemRequirement("Any cooked or raw meat", 2142);
        this.meat.addAlternates(2132, 2136, 25833, 2134, 2138);
        this.meat.setTooltip("Purchasable from a shop during the quest. Fish will NOT work");
        this.waterskins = new ItemRequirement("Waterskin(s)", 1823).isNotConsumed();
        this.waterskins.addAlternates(1825, 1827, 1829);
        this.waterskins.setTooltip("Used for protection against the desert heat");
        this.antipoison = new ItemRequirement("Antipoison", ItemCollections.ANTIPOISONS);
        this.accessToFairyRings = new ItemRequirement("Access to Fairy Rings", 772).isNotConsumed();
        this.accessToFairyRings.addAlternates(9084);
        this.pharaohsSceptre = new ItemRequirement("Pharaoh's sceptre", ItemCollections.PHAROAH_SCEPTRE).isNotConsumed();
        this.pharaohsSceptre.setTooltip("When visiting Necropolis during the quest, you can unlock the direct teleport by using 'Commune' on the Obelisk.");
        this.food = new ItemRequirement("Food", -1, -1);
        this.food.setDisplayItemId(BankSlotIcons.getFood());
        this.meleeCombatGear = new ItemRequirement("Melee combat gear", -1, -1).isNotConsumed();
        this.meleeCombatGear.setDisplayItemId(BankSlotIcons.getMeleeCombatGear());
        this.rangedCombatGear = new ItemRequirement("Ranged combat gear", -1, -1).isNotConsumed();
        this.rangedCombatGear.setDisplayItemId(BankSlotIcons.getRangedCombatGear());
        this.staminaPotions = new ItemRequirement("Stamina Potions", ItemCollections.STAMINA_POTIONS, -1);
        this.nardahTeleport = new ItemRequirement("Nardah Teleport", 13136);
        this.nardahTeleport.addAlternates(12402, 13135, 13134);
        this.prayerPotions = new ItemRequirement("Prayer potions", ItemCollections.PRAYER_POTIONS, -1);
        this.prayerPotions.addAlternates(ItemCollections.SUPER_RESTORE_POTIONS);
        this.messageFromJamila = new ItemRequirement("Message", 26942);
        this.messageFromJamila.setHighlightInInventory(true);
        this.stoneTablet = new ItemRequirement("Stone tablet", 26954);
        this.stoneTablet.setHighlightInInventory(true);
        this.chest = new ItemRequirement("Chest", 26955);
        this.chest.setHighlightInInventory(true);
        this.chest.alsoCheckBank(this.questBank);
        this.scarabMould = new ItemRequirement("Scarab mould", 26952);
        this.scarabEmblem = new ItemRequirement("Scarab emblem", 26953);
        this.scarabEmblem.setHighlightInInventory(true);
        this.rustyKey = new ItemRequirement("Rusty key", 26960);
        this.rustyKey.setHighlightInInventory(true);
        this.fiveCoins = new ItemRequirement("Coins", ItemCollections.COINS, 5);
        this.lilyOfTheElid = new ItemRequirement("Lily of the Elid", 26961);
        this.cureCrate = new ItemRequirement("Cure crate", 26962);
    }

    public void setupZones() {
        Zone ruinsOfUllekArea1 = new Zone(new WorldPoint(3388, 2821, 0), new WorldPoint(3416, 2803, 0));
        Zone ruinsOfUllekArea2 = new Zone(new WorldPoint(3388, 2821, 0), new WorldPoint(3445, 2858, 0));
        Zone ruinsOfUllekArea3 = new Zone(new WorldPoint(3393, 2803, 0), new WorldPoint(3404, 2793, 0));
        Zone ruinsOfUllekArea4 = new Zone(new WorldPoint(3412, 2799, 0), new WorldPoint(3400, 2802, 0));
        this.inRuinsOfUllek = new ZoneRequirement(ruinsOfUllekArea1, ruinsOfUllekArea2, ruinsOfUllekArea3, ruinsOfUllekArea4);
        Zone scarabMageArea = new Zone(new WorldPoint(3446, 9240, 2), new WorldPoint(3433, 9256, 2));
        this.inScarabMageArea = new ZoneRequirement(scarabMageArea);
        Zone leverMazeArea = new Zone(new WorldPoint(3440, 9217, 0), new WorldPoint(3406, 9277, 0));
        this.inLeverMazeArea = new ZoneRequirement(leverMazeArea);
        Zone riddleArea = new Zone(new WorldPoint(3390, 9240, 0), new WorldPoint(3405, 9256, 0));
        this.inRiddleArea = new ZoneRequirement(riddleArea);
        Zone tombArea = new Zone(new WorldPoint(3389, 9240, 0), new WorldPoint(3365, 9254, 0));
        this.inTombArea = new ZoneRequirement(tombArea);
        Zone bossArea = new Zone(new WorldPoint(3432, 9241, 2), new WorldPoint(3404, 9255, 2));
        this.inBossArea = new ZoneRequirement(bossArea);
        Zone bossTransitionArea = new Zone(new WorldPoint(3421, 9241, 2), new WorldPoint(3434, 9255, 2));
        this.inBossTransitionArea = new ZoneRequirement(bossTransitionArea);
    }

    public void setupConditions() {
        this.investigatedPyramid = new VarbitRequirement(13844, 1, Operation.EQUAL);
        this.hasReadStoneTablet = new VarbitRequirement(13847, 2, Operation.GREATER_EQUAL);
        this.isRotatingScarab = new WidgetModelRequirement(750, 3, -1);
        this.scarabRotatedDownwards = new VarbitRequirement(13849, 15);
        this.scarabRotationQuickestRight = new VarbitRequirement(13849, 15, Operation.GREATER_EQUAL);
        this.firstLeverPulled = new ObjectCondition(43968, new WorldPoint(3439, 9225, 0));
        this.shouldFightScarabSwarm = new NpcCondition(11484);
        this.shouldDestroyShadowRift = new NpcCondition(11485);
        this.inChemistryPuzzle = new WidgetModelRequirement(751, 3, -1);
        this.chemistryValveLeftStepZero = new VarbitRequirement(13863, 0);
        this.chemistryValveLeftStepOne = new VarbitRequirement(13863, 3);
        this.chemistryValveLeftStepTwo = new VarbitRequirement(13863, 6);
        this.chemistryValveLeftStepThree = new VarbitRequirement(13863, 9);
        this.chemistryValveMiddleAtMaximum = new VarbitRequirement(13864, 45);
        this.chemistryValveMiddleNearMax = new VarbitRequirement(13864, 42);
        this.chemistryValveRightAtMaximum = new VarbitRequirement(13865, 45);
        this.chemistryValveRightNearMax = new VarbitRequirement(13865, 42);
        this.shouldFightMenaphiteShadow = new NpcCondition(11462);
    }

    public void setupSteps() {
        this.talkToJamilaToStart = new NpcStep((QuestHelper)this, 3892, new WorldPoint(3311, 2779, 0), "Talk to Jamila in Sophanem to start the quest.", new Requirement[0]);
        this.talkToJamilaToStart.addDialogSteps("What's this special item?", "Yes.");
        this.receiveSpecialItemFromJamila = new NpcStep((QuestHelper)this, 3892, new WorldPoint(3311, 2779, 0), "Talk to Jamila to obtain a special item", new Requirement[0]);
        this.receiveSpecialItemFromJamila.addDialogStep("About that special item...");
        this.readMessage = new DetailedQuestStep((QuestHelper)this, "Read the message.", this.messageFromJamila);
        this.talkToMaisaStartInvestigation = new NpcStep((QuestHelper)this, 11474, new WorldPoint(3378, 2792, 0), "Talk to Maisa at the campsite east of Sophanem, and investigate the excavation.", new Requirement[0]);
        this.talkToMaisaStartInvestigation.addDialogStep("Let's go.");
        this.inspectBlockedPyramidEntry = new ObjectStep((QuestHelper)this, 44596, new WorldPoint(3358, 2712, 0), "Inspect the blocked entry at the Jaltevas Pyramid.", new Requirement[0]);
        this.talkToCitizenOrGuard = new NpcStep((QuestHelper)this, 11537, new WorldPoint(3347, 2718, 0), "Prepare to fight the Head Menaphite Guard, and talk to either a citizen or Menaphite Guard to start the fight.", true, new Requirement[0]);
        ((NpcStep)this.talkToCitizenOrGuard).addAlternateNpcs(11536, 11534, 11515, 11516, 11518);
        this.fightHeadMenaphiteGuard = new NpcStep((QuestHelper)this, 11529, "Fight the Head Menaphite Guard. This boss uses melee, and can hit up to 16. DO NOT USE ANY OVERHEAD PROTECTION PRAYERS, OR YOU WILL GET HIT FOR 1/3RD OF YOUR HITPOINTS", this.meleeCombatGear, this.food);
        this.talkToMaisaPostFightCutsceneInterruption = new NpcStep((QuestHelper)this, 11474, new WorldPoint(3327, 2740, 0), "Talk to Maisa to continue the quest.", new Requirement[0]);
        this.talkToMaisaExploreCliffs = new NpcStep((QuestHelper)this, 11474, new WorldPoint(3378, 2792, 0), "Go back to Maisa's camp and talk to her.", new Requirement[0]);
        this.inspectFurnace = new ObjectStep((QuestHelper)this, 2883, new WorldPoint(3404, 2824, 0), "Inspect the furnace.", new Requirement[0]);
        this.obtainTinderbox = new ObjectStep((QuestHelper)this, 43889, new WorldPoint(3379, 2791, 0), "Search the camping equipment by the tent for a tinderbox.", new Requirement[0]);
        this.obtainTinderbox.addIcon(590);
        this.obtainSpade = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3355, 2758, 0), "Pick up a spade south of the campsite.", new Requirement[0]);
        this.obtainSpade.addIcon(952);
        this.goFromCampsiteToRuinsOfUllek = new ObjectStep((QuestHelper)this, 44113, new WorldPoint(3419, 2803, 0), "From the campsite, head south and then to the east, around the cliffs, where you will find a set of stairs to the Ruins of Ullek.", new Requirement[0]);
        ((DetailedQuestStep)this.goFromCampsiteToRuinsOfUllek).setLinePoints(Arrays.asList(new WorldPoint(3370, 2795, 0), new WorldPoint(3370, 2773, 0), new WorldPoint(3387, 2758, 0), new WorldPoint(3402, 2758, 0), new WorldPoint(3402, 2758, 0), new WorldPoint(3419, 2778, 0), new WorldPoint(3419, 2802, 0)));
        this.useCoalOnFurnace = new ObjectStep((QuestHelper)this, 2883, new WorldPoint(3404, 2824, 0), "Use coal on the furnace to refuel it.", this.tinderbox, this.coal.highlighted());
        this.useCoalOnFurnace.addDialogStep("Yes.");
        this.useCoalOnFurnace.addIcon(453);
        this.useTinderboxOnFurnace = new ObjectStep((QuestHelper)this, 2883, new WorldPoint(3404, 2824, 0), "Use your tinderbox on the furnace to light it.", this.tinderbox.highlighted());
        this.useTinderboxOnFurnace.addDialogStep("Yes.");
        this.useTinderboxOnFurnace.addIcon(590);
        this.searchWell = new ObjectStep((QuestHelper)this, 6630, new WorldPoint(3400, 2828, 0), "Search the well to receive a stone tablet.", new Requirement[0]);
        this.readStoneTablet = new DetailedQuestStep((QuestHelper)this, "Read the stone tablet.", this.stoneTablet);
        this.leaveRuinsOfUllek = new ObjectStep((QuestHelper)this, 44111, new WorldPoint(3417, 2805, 0), "Leave the Ruins of Ullek using the steps in the south-east.", new Requirement[0]);
        this.digForChest = new DigStep((QuestHelper)this, new WorldPoint(3411, 2786, 0), "Dig in front of the southernmost ritual pillar", new Requirement[0]);
        this.openChest = new DetailedQuestStep((QuestHelper)this, "Open the chest and input the passcode \"1118513\".", this.chest);
        this.goToRuinsOfUllek = new ObjectStep((QuestHelper)this, 44113, new WorldPoint(3419, 2803, 0), "Return to the Ruins of Ullek.", new Requirement[0]);
        this.craftEmblem = new ObjectStep((QuestHelper)this, 2883, new WorldPoint(3404, 2824, 0), "Craft a scarab emblem using the furnace.", this.scarabMould, this.ironBar.highlighted());
        this.craftEmblem.addDialogStep("Yes.");
        this.craftEmblem.addIcon(2351);
        this.useEmblemOnPillar = new ObjectStep((QuestHelper)this, 6579, new WorldPoint(3418, 2848, 0), "Inspect the pillar to the north to insert the emblem.", this.scarabEmblem);
        this.useEmblemOnPillar.addIcon(26953);
        this.useEmblemOnPillar.addDialogStep("Yes.");
        this.rotateScarabLeft = new WidgetStep((QuestHelper)this, "Rotate the scarab on the emblem so it faces downwards.", 750, 7);
        this.rotateScarabRight = new WidgetStep((QuestHelper)this, "Rotate the scarab on the emblem so it faces downwards.", 750, 8);
        this.confirmScarabRotation = new WidgetStep((QuestHelper)this, "Rotate the scarab on the emblem so it faces downwards.", 750, 9);
        this.enterDungeonToFightScarabMages = new ObjectStep((QuestHelper)this, 6643, new WorldPoint(3409, 2848, 0), "Enter the dungeon.", this.meleeCombatGear, this.food);
        this.enterDungeon = new ObjectStep((QuestHelper)this, 6643, new WorldPoint(3409, 2848, 0), "Enter the dungeon.", new Requirement[0]);
        this.fightScarabMages = new NpcStep((QuestHelper)this, 11508, "Use Protect from Magic and defeat the two Scarab Mages.", this.meleeCombatGear, this.food, this.antipoison);
        this.climbDownStairsAgain = new ObjectStep((QuestHelper)this, 43959, "Climb down the stairs.", new Requirement[0]);
        ((ObjectStep)this.climbDownStairsAgain).addAlternateObjects(43958);
        this.pullLever = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3439, 9225, 0), "Avoid the projectiles, run west to the junction, run south, follow the corridor, and pull the lever at the end.", this.food, this.staminaPotions);
        ((DetailedQuestStep)this.pullLever).setLinePoints(Arrays.asList(new WorldPoint(3436, 9239, 0), new WorldPoint(3430, 9239, 0), new WorldPoint(3430, 9246, 0), new WorldPoint(3429, 9247, 0), new WorldPoint(3415, 9247, 0), new WorldPoint(3412, 9244, 0), new WorldPoint(3411, 9243, 0), new WorldPoint(3411, 9239, 0), new WorldPoint(3410, 9239, 0), new WorldPoint(3411, 9238, 0), new WorldPoint(3411, 9234, 0), new WorldPoint(3412, 9234, 0), new WorldPoint(3411, 9233, 0), new WorldPoint(3411, 9233, 0), new WorldPoint(3411, 9230, 0), new WorldPoint(3415, 9226, 0), new WorldPoint(3419, 9226, 0), new WorldPoint(3420, 9227, 0), new WorldPoint(3421, 9226, 0), new WorldPoint(3430, 9226, 0), new WorldPoint(3431, 9227, 0), new WorldPoint(3435, 9227, 0), new WorldPoint(3437, 9225, 0)));
        this.pullSecondLever = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3439, 9271, 0), "As fast as possible, run back to the juncture, then run north and pull the second lever.", this.food, this.staminaPotions);
        ((DetailedQuestStep)this.pullSecondLever).setLinePoints(Arrays.asList(new WorldPoint(3437, 9225, 0), new WorldPoint(3435, 9222, 0), new WorldPoint(3432, 9222, 0), new WorldPoint(3430, 9224, 0), new WorldPoint(3426, 9224, 0), new WorldPoint(3425, 9223, 0), new WorldPoint(3420, 9227, 0), new WorldPoint(3419, 9226, 0), new WorldPoint(3415, 9226, 0), new WorldPoint(3411, 9230, 0), new WorldPoint(3411, 9237, 0), new WorldPoint(3410, 9237, 0), new WorldPoint(3410, 9244, 0), new WorldPoint(3408, 9246, 0), new WorldPoint(3408, 9249, 0), new WorldPoint(3411, 9252, 0), new WorldPoint(3411, 9257, 0), new WorldPoint(3410, 9257, 0), new WorldPoint(3411, 9258, 0), new WorldPoint(3411, 9262, 0), new WorldPoint(3412, 9262, 0), new WorldPoint(3412, 9267, 0), new WorldPoint(3415, 9270, 0), new WorldPoint(3419, 9270, 0), new WorldPoint(3420, 9269, 0), new WorldPoint(3421, 9270, 0), new WorldPoint(3429, 9270, 0), new WorldPoint(3430, 9269, 0), new WorldPoint(3433, 9268, 0), new WorldPoint(3436, 9268, 0), new WorldPoint(3438, 9271, 0)));
        this.enterRiddleDoor = new ObjectStep((QuestHelper)this, 43961, new WorldPoint(3405, 9248, 0), "With the traps disabled, go through the door west of the juncture.", new Requirement[0]);
        this.solveTombRiddle = new TombRiddle(this);
        this.enterTombDoor = new ObjectStep((QuestHelper)this, 43962, new WorldPoint(3389, 9248, 0), "Enter the tomb.", new Requirement[0]);
        this.talkToSpirit = new NpcStep((QuestHelper)this, 11478, new WorldPoint(3377, 9248, 0), "Speak to the Spirit.", new Requirement[0]);
        ((NpcStep)this.talkToSpirit).addAlternateNpcs(11479);
        this.takeRustyKey = new ObjectStep((QuestHelper)this, 44591, new WorldPoint(3368, 9248, 0), "Take the rusty key from the urn in the back of the room.", new Requirement[0]);
        this.leaveTombDoor = new ObjectStep((QuestHelper)this, 43962, new WorldPoint(3389, 9248, 0), "Leave the tomb.", new Requirement[0]);
        this.leaveRiddleDoor = new ObjectStep((QuestHelper)this, 43961, new WorldPoint(3405, 9248, 0), "Leave the riddle area.", new Requirement[0]);
        this.climbUpstairs = new ObjectStep((QuestHelper)this, 43956, "Go back upstairs.", new Requirement[0]);
        ((ObjectStep)this.climbUpstairs).addAlternateObjects(43957);
        ((DetailedQuestStep)this.climbUpstairs).setLinePoints(Arrays.asList(new WorldPoint(3408, 9248, 0), new WorldPoint(3411, 9244, 0), new WorldPoint(3415, 9248, 0), new WorldPoint(3431, 9248, 0), new WorldPoint(3431, 9239, 0), new WorldPoint(3438, 9239, 0), new WorldPoint(3438, 9243, 0)));
        this.unlockBossDoor = new ObjectStep((QuestHelper)this, 43960, "Prepare to fight the Champion of Scabaras, and unlock the door to start the fight.", this.rangedCombatGear, this.food, this.antipoison, this.staminaPotions, this.prayerPotions, this.rustyKey);
        this.unlockBossDoor.addIcon(26960);
        this.unlockBossDoor.addSubSteps(this.leaveTombDoor, this.leaveRiddleDoor, this.climbUpstairs);
        this.openBossDoor = new ObjectStep((QuestHelper)this, 43960, "Prepare to fight the Champion of Scabaras, and open the door to start the fight.", this.rangedCombatGear, this.food, this.antipoison, this.staminaPotions, this.prayerPotions);
        this.fightChampionOfScabaras = new NpcStep((QuestHelper)this, 11483, "Fight the Champion of Scabaras.", this.rangedCombatGear, this.food, this.antipoison, this.staminaPotions, this.prayerPotions);
        this.fightChampionOfScabaras.addText("Protect from Magic, and keep 4+ tiles distance at all times.");
        this.fightChampionOfScabaras.addText("Whenever a rift or swarm appears, kill it.");
        this.fightChampionOfScabaras.addText("He is weak to ranged attacks, so bring your best ranged gear.");
        this.fightScarabSwarm = new NpcStep((QuestHelper)this, 11484, "Defeat the Swarm as soon as possible, to prevent shadow flames from hindering your movement.", new Requirement[0]);
        this.destroyShadowRift = new NpcStep((QuestHelper)this, 11485, "Destroy the Shadow Rift as soon as possible, to prevent 35+ damage from occurring once it explodes.", new Requirement[0]);
        this.goToScabarasHighPriestDoorOne = new ObjectStep((QuestHelper)this, 43960, "Go back to the Champion of Scabaras boss area, and talk to the High Priest of Scabaras.", new Requirement[0]);
        this.goToScabarasHighPriestDoorTwo = new ObjectStep((QuestHelper)this, 43963, "Go back to the Champion of Scabaras boss area, and talk to the High Priest of Scabaras.", new Requirement[0]);
        this.talkToScabarasHighPriest = new NpcStep((QuestHelper)this, 11480, "Talk to the High Priest of Scabaras.", new Requirement[0]);
        this.leaveHighPriestDoorOne = new ObjectStep((QuestHelper)this, 43963, "Leave the dungeon.", new Requirement[0]);
        this.leaveHighPriestDoorTwo = new ObjectStep((QuestHelper)this, 43960, "Leave the dungeon.", new Requirement[0]);
        this.leaveDungeon = new ObjectStep((QuestHelper)this, 43955, "Leave the dungeon.", new Requirement[0]);
        this.talkToMaisaInNardah = new NpcStep((QuestHelper)this, 11474, new WorldPoint(3425, 2909, 0), "Talk to Maisa or Zahur in Nardah.", new Requirement[0]);
        ((NpcStep)this.talkToMaisaInNardah).addAlternateNpcs(4753);
        this.talkToMaisaInNardah.addSubSteps(this.leaveHighPriestDoorOne, this.leaveHighPriestDoorTwo, this.leaveDungeon);
        this.purchaseBeef = new NpcStep((QuestHelper)this, 4755, new WorldPoint(3415, 2908, 0), "Purchase some meat from the General Store.", this.fiveCoins);
        this.attemptSteppingStones = new ObjectStep((QuestHelper)this, 43988, new WorldPoint(3353, 2923, 0), "Head west and attempt to jump to the stepping stones over the River Elid.", this.meat);
        this.attemptSteppingStones.addDialogStep("Yes.");
        this.pickLilyOfElid = new ObjectStep((QuestHelper)this, 44593, new WorldPoint(3353, 2927, 0), "Attempt to cross the stepping stones again, and pick the Lily of the Elid.", new Requirement[0]);
        this.takeLilyToZahur = new NpcStep((QuestHelper)this, 4753, new WorldPoint(3425, 2909, 0), "Go back to Zahur in Nardah.", this.lilyOfTheElid);
        this.talkToZahur = new NpcStep((QuestHelper)this, 4753, new WorldPoint(3425, 2909, 0), "Talk to Zahur in Nardah.", new Requirement[0]);
        this.warmUpChemistryEquipment = new ObjectStep((QuestHelper)this, 44594, new WorldPoint(3424, 2905, 0), "Warm up Zahur's Chemistry Equipment.", new Requirement[0]);
        this.chemistryValveDecreaseLeft = new WidgetStep((QuestHelper)this, "Warm up the Chemistry Equipment. Decrease the temperature of the first valve.", 751, 24);
        this.chemistryValveIncreaseMiddle = new WidgetStep((QuestHelper)this, "Warm up the Chemistry Equipment. Increase the temperature of the second valve.", 751, 25);
        this.chemistryValveDecreaseMiddle = new WidgetStep((QuestHelper)this, "Warm up the Chemistry Equipment. Decrease the temperature of the second valve.", 751, 26);
        this.chemistryValveIncreaseRight = new WidgetStep((QuestHelper)this, "Warm up the Chemistry Equipment. Increase the temperature of the third valve.", 751, 27);
        this.chemistryValveDecreaseRight = new WidgetStep((QuestHelper)this, "Warm up the Chemistry Equipment. Decrease the temperature of the third valve.", 751, 28);
        this.warmUpChemistryEquipment.addSubSteps(this.chemistryValveDecreaseLeft, this.chemistryValveIncreaseMiddle, this.chemistryValveDecreaseMiddle, this.chemistryValveIncreaseRight, this.chemistryValveDecreaseRight);
        this.bringCureToPriest = new NpcStep((QuestHelper)this, 4206, new WorldPoint(3281, 2772, 0), "Bring the cure crate to the High Priest in Sophanem.", this.cureCrate);
        this.talkToSophanemHighPriest = new NpcStep((QuestHelper)this, 4206, new WorldPoint(3281, 2772, 0), "Talk to the High Priest in Sophanem.", new Requirement[0]);
        this.prepareFightMenaphiteAkh = new NpcStep((QuestHelper)this, 11474, new WorldPoint(3327, 2740, 0), "Prepare to fight the Menaphite Akh (lvl 351), and talk to Maisa in Necropolis when ready.", this.meleeCombatGear, this.waterskins);
        this.defeatMenaphiteAkh = new NpcStep((QuestHelper)this, 11492, "Defeat the Menaphite Akh. This boss uses melee, and will occasionally cast lightning in front of her, so be prepared to walk behind her to avoid this attack. Whenever a shadow version of them appears, kill them quickly as they'll deal a lot of damage.", this.meleeCombatGear, this.waterskins);
        this.talkToOsman = new NpcStep((QuestHelper)this, 11486, new WorldPoint(3369, 2799, 0), "Talk to Osman", new Requirement[0]);
        this.finishQuest = new NpcStep((QuestHelper)this, 11474, new WorldPoint(3281, 2772, 0), "Talk to Maisa or the High Priest in Sophanem to finish the quest.", new Requirement[0]);
        ((NpcStep)this.finishQuest).addAlternateNpcs(4206);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.waterskins, this.antipoison, this.accessToFairyRings, this.pharaohsSceptre, this.meleeCombatGear, this.food, this.staminaPotions, this.nardahTeleport);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coal, this.tinderbox, this.ironBar, this.spade, this.meat);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Head Menaphite Guard (lvl 174) without protection prayers", "Two Scabarite Mages (lvl 119)", "Champion of Scabaras (lvl 379)", "Menaphite Akh (lvl 351)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.AGILITY, 50000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Tombs of Amascut."), new UnlockReward("Ability to unlock the Jaltevas teleport option on the Pharaoh's sceptre"), new UnlockReward("Access to fairy ring code A.K.P (a small island south-west of Necropolis)"));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("A Keris Partisan", 25979, 1), new ItemReward("A Circlet of Water", 26969, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToJamilaToStart, this.readMessage), Collections.emptyList(), Collections.singletonList(this.waterskins)));
        allSteps.add(new PanelDetails("Entranced Menaphites", Arrays.asList(this.talkToMaisaStartInvestigation, this.inspectBlockedPyramidEntry, this.talkToCitizenOrGuard, this.fightHeadMenaphiteGuard, this.talkToMaisaPostFightCutsceneInterruption), Collections.singletonList(this.meleeCombatGear), Arrays.asList(this.waterskins, this.food)));
        allSteps.add(new PanelDetails("The Ruins of Ullek", Arrays.asList(this.talkToMaisaExploreCliffs, this.goFromCampsiteToRuinsOfUllek, this.inspectFurnace, this.useCoalOnFurnace, this.useTinderboxOnFurnace, this.searchWell, this.readStoneTablet, this.digForChest, this.openChest, this.craftEmblem, this.useEmblemOnPillar, this.confirmScarabRotation, this.enterDungeonToFightScarabMages, this.fightScarabMages, this.climbDownStairsAgain, this.pullLever, this.pullSecondLever, this.enterRiddleDoor), Arrays.asList(this.meleeCombatGear, this.coal, this.tinderbox, this.spade, this.ironBar), Arrays.asList(this.food, this.antipoison, this.waterskins)));
        allSteps.add(new PanelDetails("Riddle of the Tomb", Arrays.asList(this.solveTombRiddle, this.enterTombDoor, this.talkToSpirit, this.takeRustyKey), new Requirement[0]));
        allSteps.add(new PanelDetails("The Champion of Scabaras", Arrays.asList(this.unlockBossDoor, this.fightChampionOfScabaras, this.talkToScabarasHighPriest), Arrays.asList(this.rangedCombatGear, this.food, this.rustyKey)));
        allSteps.add(new PanelDetails("Cure for the Pox", Arrays.asList(this.talkToMaisaInNardah, this.purchaseBeef, this.attemptSteppingStones, this.pickLilyOfElid, this.takeLilyToZahur, this.talkToZahur, this.warmUpChemistryEquipment, this.bringCureToPriest), Arrays.asList(this.meat, this.waterskins)));
        allSteps.add(new PanelDetails("Fight with the Menaphite Akh", Arrays.asList(this.prepareFightMenaphiteAkh, this.defeatMenaphiteAkh, this.finishQuest), Arrays.asList(this.meleeCombatGear, this.waterskins)));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.CONTACT, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.AGILITY, 62));
        req.add(new SkillRequirement(Skill.CRAFTING, 55));
        req.add(new SkillRequirement(Skill.FIREMAKING, 55));
        return req;
    }
}

