/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.belowicemountain;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.npc.NpcRequirement;
import com.questhelper.requirements.quest.QuestPointRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcEmoteStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.emote.QuestEmote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.BELOW_ICE_MOUNTAIN)
public class BelowIceMountain
extends BasicQuestHelper {
    private static final int VARBIT_CHECKAL_LINE = 12065;
    private static final int VARBIT_MARLEY_LINE = 12064;
    private static final int VARBIT_BURNTOF_LINE = 12066;
    ItemRequirement cookedMeat;
    ItemRequirement bread;
    ItemRequirement knife;
    ItemRequirement coins;
    ItemRequirement knifeHighlight;
    ItemRequirement breadHighlight;
    ItemRequirement steakSandwich;
    ItemRequirement beerHighlight;
    ItemRequirement iceMountainTeleport;
    ItemRequirement faladorTeleport;
    ItemRequirement varrockTeleport;
    ItemRequirement combatGearOrPickaxe;
    Requirement needFlex;
    Requirement leftFlexBeforeLearning;
    Requirement haveFlex;
    Requirement recruitedCheckal;
    Requirement needRecipe;
    Requirement haveRecipe;
    Requirement haveIngredients;
    Requirement fedMarley;
    Requirement recruitedMarley;
    Requirement needBeer;
    Requirement gaveBeer;
    Requirement needRPS;
    Requirement recruitedBurntof;
    Requirement inDungeon;
    QuestStep talkToWillowToStart;
    QuestStep recruitCheckal;
    QuestStep talkToAtlas;
    QuestStep flexCheckal;
    QuestStep talkToMarley;
    QuestStep talkToCook;
    QuestStep getIngredients;
    QuestStep makeSandwich;
    QuestStep feedMarley;
    QuestStep talkToMarleyAfterFeeding;
    QuestStep talkToBurntof;
    QuestStep buyBeer;
    QuestStep giveBeer;
    QuestStep playRPS;
    QuestStep goToDungeon;
    QuestStep reenterDungeon;
    QuestStep defeatGuardian;
    QuestStep watchCutscene;
    ConditionalStep getCheckal;
    ConditionalStep getMarley;
    ConditionalStep getBurntof;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToWillowToStart);
        steps.put(5, this.talkToWillowToStart);
        steps.put(7, this.talkToWillowToStart);
        this.getCheckal = new ConditionalStep((QuestHelper)this, this.recruitCheckal, new Requirement[0]);
        this.getCheckal.addStep(this.needFlex, this.talkToAtlas);
        this.getCheckal.addStep(this.leftFlexBeforeLearning, this.talkToAtlas);
        this.getCheckal.addStep(this.haveFlex, this.flexCheckal);
        this.getCheckal.setLockingCondition(this.recruitedCheckal);
        steps.put(10, this.getCheckal);
        this.getMarley = new ConditionalStep((QuestHelper)this, this.talkToMarley, new Requirement[0]);
        this.getMarley.addStep(this.fedMarley, this.talkToMarleyAfterFeeding);
        this.getMarley.addStep(this.needRecipe, this.talkToCook);
        this.getMarley.addStep(this.steakSandwich, this.feedMarley);
        this.getMarley.addStep(new Conditions(LogicType.AND, this.haveRecipe, this.haveIngredients), this.makeSandwich);
        this.getMarley.addStep(this.haveRecipe, this.getIngredients);
        this.getMarley.setLockingCondition(this.recruitedMarley);
        this.getBurntof = new ConditionalStep((QuestHelper)this, this.talkToBurntof, new Requirement[0]);
        this.getBurntof.addStep(this.needRPS, this.playRPS);
        this.getBurntof.addStep(this.gaveBeer, this.playRPS);
        this.getBurntof.addStep(new Conditions(LogicType.AND, this.needBeer, this.beerHighlight), this.giveBeer);
        this.getBurntof.addStep(this.needBeer, this.buyBeer);
        this.getBurntof.setLockingCondition(this.recruitedBurntof);
        ConditionalStep marleyAndBurntof = new ConditionalStep((QuestHelper)this, (QuestStep)this.getMarley, new Requirement[0]);
        marleyAndBurntof.addStep(this.recruitedMarley, this.getBurntof);
        steps.put(15, marleyAndBurntof);
        steps.put(20, this.goToDungeon);
        steps.put(25, this.goToDungeon);
        steps.put(30, this.reenterDungeon);
        ConditionalStep guardian = new ConditionalStep((QuestHelper)this, this.reenterDungeon, new Requirement[0]);
        guardian.addStep(this.inDungeon, this.defeatGuardian);
        steps.put(35, guardian);
        steps.put(40, this.watchCutscene);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.cookedMeat = new ItemRequirement("Cooked Meat", 2142, 1);
        this.bread = new ItemRequirement("Bread", 2309, 1);
        this.knife = new ItemRequirement("Knife", 946).isNotConsumed();
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS, 3);
        this.knifeHighlight = this.knife.highlighted();
        this.breadHighlight = this.bread.highlighted();
        this.steakSandwich = new ItemRequirement("Steak Sandwich", 25631);
        this.beerHighlight = new ItemRequirement(true, "Asgarnian Ale", 1905);
        this.iceMountainTeleport = new ItemRequirement("A teleport to near Ice Mountain", ItemCollections.AMULET_OF_GLORIES);
        this.iceMountainTeleport.addAlternates(ItemCollections.COMBAT_BRACELETS);
        this.iceMountainTeleport.addAlternates(8009, 12780);
        this.faladorTeleport = new ItemRequirement("Falador teleport", 8009);
        this.varrockTeleport = new ItemRequirement("Varrock teleport", 8007);
        this.combatGearOrPickaxe = new ItemRequirement("Combat gear or a pickaxe if you don't want to fight", -1, -1).isNotConsumed();
        this.combatGearOrPickaxe.setDisplayItemId(BankSlotIcons.getCombatGear());
    }

    public void setupConditions() {
        this.needFlex = new VarbitRequirement(12065, 5);
        this.leftFlexBeforeLearning = new VarbitRequirement(12065, 10);
        this.haveFlex = new VarbitRequirement(12065, 15);
        this.recruitedCheckal = new VarbitRequirement(12065, 40);
        this.needRecipe = new VarbitRequirement(12064, 5);
        this.haveRecipe = new VarbitRequirement(12064, 10);
        this.haveIngredients = new ItemRequirements(this.cookedMeat, this.bread, this.knife);
        this.fedMarley = new VarbitRequirement(12064, 35);
        this.recruitedMarley = new VarbitRequirement(12064, 40);
        this.needBeer = new VarbitRequirement(12066, 5);
        this.gaveBeer = new VarbitRequirement(12066, 10);
        this.needRPS = new VarbitRequirement(12066, 15);
        this.recruitedBurntof = new VarbitRequirement(12066, 40);
        this.inDungeon = new NpcRequirement("Ancient Guardian", 10654);
    }

    public void setupSteps() {
        this.talkToWillowToStart = new NpcStep((QuestHelper)this, 10655, new WorldPoint(3003, 3435, 0), "Talk to Willow outside Falador, south of the Ice Mountain dwarves.", new Requirement[0]);
        this.talkToWillowToStart.addDialogStep("Yes.");
        this.recruitCheckal = new NpcStep((QuestHelper)this, 10657, new WorldPoint(3087, 3415, 0), "Attempt to recruit Checkal to your team in Barbarian Village.", new Requirement[0]);
        this.talkToAtlas = new NpcStep((QuestHelper)this, 10658, new WorldPoint(3076, 3440, 0), "Speak to Atlas in the Barbarian Village Inn to learn how to Flex.", new Requirement[0]);
        this.talkToAtlas.addDialogStep("Yes.");
        this.flexCheckal = new NpcEmoteStep((QuestHelper)this, 10657, QuestEmote.FLEX, new WorldPoint(3087, 3415, 0), "Flex your muscles at Checkal to prove your worth.", new Requirement[0]);
        this.talkToMarley = new NpcStep((QuestHelper)this, 10656, new WorldPoint(3088, 3470, 0), "Speak to Marley in the Edgeville Ruins.", new Requirement[0]);
        this.talkToCook = new NpcStep((QuestHelper)this, 2895, new WorldPoint(3230, 3401, 0), "Ask the Cook at the Blue Moon Inn for a steak sandwich.", new Requirement[0]);
        this.talkToCook.addDialogStep("I was wondering if you'd be able to make me a Steak sandwich?");
        this.getIngredients = new DetailedQuestStep((QuestHelper)this, "Collect meat, bread and a knife to make a steak sandwich.", this.cookedMeat, this.bread, this.knife);
        this.makeSandwich = new DetailedQuestStep((QuestHelper)this, "Use the knife on the bread to make a steak sandwich. Be careful not to eat it!", this.knifeHighlight, this.breadHighlight);
        this.feedMarley = new NpcStep((QuestHelper)this, 10656, new WorldPoint(3088, 3470, 0), "Return to Marley and give him the steak sandwich. Be careful not to eat it!", this.steakSandwich);
        this.talkToMarleyAfterFeeding = new NpcStep((QuestHelper)this, 10656, new WorldPoint(3088, 3470, 0), "Talk to Marley to send him off to the excavation site.", new Requirement[0]);
        this.feedMarley.addSubSteps(this.talkToMarleyAfterFeeding);
        this.talkToBurntof = new NpcStep((QuestHelper)this, 10659, new WorldPoint(2956, 3367, 0), "Talk to Burntof in the Falador Inn.", new Requirement[0]);
        this.buyBeer = new NpcStep((QuestHelper)this, 1316, new WorldPoint(2954, 3368, 0), "Buy an Asgarnian Ale for Burntof.", this.coins);
        this.buyBeer.addDialogSteps("What ales are you serving?", "One Asgarnian Ale, please.");
        this.giveBeer = new NpcStep((QuestHelper)this, 10659, new WorldPoint(2956, 3367, 0), "Give Burntof the Asgarnian Ale.", this.beerHighlight);
        this.playRPS = new NpcStep((QuestHelper)this, 10659, new WorldPoint(2956, 3367, 0), "Beat Burntof in a match of Rock-Paper-Scissors. Your choices of Rock, Paper and Scissors do not matter.", new Requirement[0]);
        this.playRPS.addDialogStep("Rock.");
        this.goToDungeon = new NpcStep((QuestHelper)this, 10655, new WorldPoint(2996, 3494, 0), "Talk with Willow at the dungeon entrance on the west side of Ice Mountain.", new Requirement[0]);
        this.goToDungeon.addDialogStep("Yes.");
        this.reenterDungeon = new ObjectStep((QuestHelper)this, 41357, new WorldPoint(3000, 3494, 0), "Re-enter the dungeon to finish the quest.", new Requirement[0]);
        this.reenterDungeon.addDialogStep("Yes.");
        this.defeatGuardian = new NpcStep((QuestHelper)this, 10654, "Defeat the Lvl-25 Ancient Guardian. Alternatively, with Level 10 Mining, mine the 4 pillars in the corners.", new Requirement[0]);
        this.defeatGuardian.addSubSteps(this.reenterDungeon);
        this.watchCutscene = new ObjectStep((QuestHelper)this, 41357, new WorldPoint(3000, 3494, 0), "Watch the cutscene to finish the quest.", new Requirement[0]);
        this.watchCutscene.addDialogStep("Yes.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.cookedMeat);
        reqs.add(this.bread);
        reqs.add(this.knife);
        reqs.add(this.coins);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.iceMountainTeleport, this.faladorTeleport, this.varrockTeleport, this.combatGearOrPickaxe);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Ancient Guardian (level 25), or 10 mining + a pickaxe");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new QuestPointRequirement(16));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 2000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Ruins of Camdozaal."), new UnlockReward("Flex Emote"), new UnlockReward("The ability to make a steak sandwich"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting Off", Collections.singletonList(this.talkToWillowToStart), new Requirement[0]));
        PanelDetails checkalPanel = new PanelDetails("Recruit Checkal", Arrays.asList(this.recruitCheckal, this.talkToAtlas, this.flexCheckal), new Requirement[0]);
        checkalPanel.setLockingStep(this.getCheckal);
        allSteps.add(checkalPanel);
        PanelDetails marleyPanel = new PanelDetails("Recruit Marley", Arrays.asList(this.talkToMarley, this.talkToCook, this.getIngredients, this.makeSandwich, this.feedMarley), this.cookedMeat, this.bread, this.knife);
        marleyPanel.setLockingStep(this.getMarley);
        allSteps.add(marleyPanel);
        PanelDetails burntofPanel = new PanelDetails("Recruit Burntof", Arrays.asList(this.talkToBurntof, this.buyBeer, this.giveBeer, this.playRPS), this.coins);
        burntofPanel.setLockingStep(this.getBurntof);
        allSteps.add(burntofPanel);
        allSteps.add(new PanelDetails("Excavation!", Arrays.asList(this.goToDungeon, this.defeatGuardian, this.watchCutscene), this.combatGearOrPickaxe));
        return allSteps;
    }
}

