/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.bearyoursoul;

import com.questhelper.collections.KeyringCollection;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.DigStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.BEAR_YOUR_SOUL)
public class BearYourSoul
extends BasicQuestHelper {
    ItemRequirement spade;
    ItemRequirement dustyKeyOr70AgilOrKeyMasterTeleport;
    ItemRequirement damagedSoulBearer;
    Requirement inTaverleyDungeon;
    Requirement inKeyMaster;
    QuestStep findSoulJourneyAndRead;
    QuestStep talkToAretha;
    QuestStep arceuusChurchDig;
    QuestStep goToTaverleyDungeon;
    QuestStep enterCaveToKeyMaster;
    QuestStep speakKeyMaster;
    Zone inTaverleyDungeonZone;
    Zone inKeyMasterZone;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.findSoulJourneyAndRead);
        steps.put(1, this.talkToAretha);
        ConditionalStep repairSoulBearer = new ConditionalStep((QuestHelper)this, this.arceuusChurchDig, new Requirement[0]);
        repairSoulBearer.addStep(this.inKeyMaster, this.speakKeyMaster);
        repairSoulBearer.addStep(this.inTaverleyDungeon, this.enterCaveToKeyMaster);
        repairSoulBearer.addStep(this.damagedSoulBearer, this.goToTaverleyDungeon);
        steps.put(2, repairSoulBearer);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.dustyKeyOr70AgilOrKeyMasterTeleport = new KeyringRequirement("Dusty key, or another way to get into the deep Taverley Dungeon", this.configManager, KeyringCollection.DUSTY_KEY).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.damagedSoulBearer = new ItemRequirement("Damaged soul bearer", 19636);
    }

    public void loadZones() {
        this.inTaverleyDungeonZone = new Zone(new WorldPoint(2816, 9668, 0), new WorldPoint(2973, 9855, 0));
        this.inKeyMasterZone = new Zone(new WorldPoint(1289, 1236, 0), new WorldPoint(1333, 1274, 0));
    }

    public void setupConditions() {
        this.inTaverleyDungeon = new ZoneRequirement(this.inTaverleyDungeonZone);
        this.inKeyMaster = new ZoneRequirement(this.inKeyMasterZone);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("A Soul Bearer", 19634, 1));
    }

    public void setupSteps() {
        this.findSoulJourneyAndRead = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1632, 3808, 0), "Go to the Arceuus library and find The Soul journey book in one of the bookcases, then read it. You can ask Biblia for help locating it, or make use of the Runelite Kourend Library plugin.", new Requirement[0]);
        this.talkToAretha = new NpcStep((QuestHelper)this, 7042, new WorldPoint(1814, 3851, 0), "Talk to Aretha at the Soul Altar.", new Requirement[0]);
        this.talkToAretha.addDialogStep("I've been reading your book...");
        this.talkToAretha.addDialogStep("Yes please.");
        this.arceuusChurchDig = new DigStep((QuestHelper)this, new WorldPoint(1699, 3794, 0), "Go to the Arceuus church and dig for the Damaged soul bearer.", new Requirement[0]);
        this.goToTaverleyDungeon = new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2884, 3397, 0), "Go to Taverley Dungeon, or teleport to the Key Master directly.", this.damagedSoulBearer, this.dustyKeyOr70AgilOrKeyMasterTeleport);
        this.enterCaveToKeyMaster = new ObjectStep((QuestHelper)this, 26567, new WorldPoint(2874, 9846, 0), "Enter the cave to the Key Master.", this.damagedSoulBearer, this.dustyKeyOr70AgilOrKeyMasterTeleport);
        this.speakKeyMaster = new NpcStep((QuestHelper)this, 5870, new WorldPoint(1310, 1251, 0), "Talk to Key Master in the Cerberus' Lair.", this.damagedSoulBearer);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.spade);
        reqs.add(this.dustyKeyOr70AgilOrKeyMasterTeleport);
        return reqs;
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Find the Soul journey book", Collections.singletonList(this.findSoulJourneyAndRead), new Requirement[0]));
        allSteps.add(new PanelDetails("Talk to Aretha", Collections.singletonList(this.talkToAretha), new Requirement[0]));
        allSteps.add(new PanelDetails("Dig up the Soul Bearer", Collections.singletonList(this.arceuusChurchDig), this.spade));
        allSteps.add(new PanelDetails("Have the Soul Bearer repaired", Arrays.asList(this.goToTaverleyDungeon, this.enterCaveToKeyMaster, this.speakKeyMaster), this.dustyKeyOr70AgilOrKeyMasterTeleport));
        return allSteps;
    }
}

