/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.atailoftwocats;

import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.NpcCollections;
import com.questhelper.collections.TeleportCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.FollowerItemRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.NpcRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.A_TAIL_OF_TWO_CATS)
public class ATailOfTwoCats
extends BasicQuestHelper {
    ItemRequirement catspeak;
    ItemRequirement catspeakE;
    ItemRequirement deathRune5;
    ItemRequirement chocolateCake;
    ItemRequirement logs;
    ItemRequirement tinderbox;
    ItemRequirement milk;
    ItemRequirement shears;
    ItemRequirement potatoSeed4;
    ItemRequirement rake;
    ItemRequirement dibber;
    ItemRequirement vialOfWater;
    ItemRequirement desertTop;
    ItemRequirement desertBottom;
    ItemRequirement hat;
    ItemRequirement catspeakEWorn;
    ItemRequirement cat;
    ItemRequirement burthorpeTeleport;
    ItemRequirement varrockTeleport;
    ItemRequirement sophanemTeleport;
    ItemRequirement staminaPotion;
    Requirement bobNearby;
    Requirement rakedPatch;
    Requirement madeBed;
    Requirement plantedSeed;
    Requirement placedLogs;
    Requirement litLogs;
    Requirement placedCake;
    Requirement placedMilk;
    Requirement usedShears;
    Requirement grownPotatoes;
    DetailedQuestStep talkToUnferth;
    DetailedQuestStep talkToHild;
    DetailedQuestStep findBob;
    DetailedQuestStep talkToBob;
    DetailedQuestStep talkToGertrude;
    DetailedQuestStep talkToReldo;
    DetailedQuestStep findBobAgain;
    DetailedQuestStep talkToBobAgain;
    DetailedQuestStep talkToSphinx;
    DetailedQuestStep useRake;
    DetailedQuestStep plantSeeds;
    DetailedQuestStep makeBed;
    DetailedQuestStep useLogsOnFireplace;
    DetailedQuestStep lightLogs;
    DetailedQuestStep useChocolateCakeOnTable;
    DetailedQuestStep useMilkOnTable;
    DetailedQuestStep useShearsOnUnferth;
    DetailedQuestStep reportToUnferth;
    DetailedQuestStep talkToApoth;
    DetailedQuestStep talkToUnferthAsDoctor;
    DetailedQuestStep findBobToFinish;
    DetailedQuestStep talkToBobToFinish;
    DetailedQuestStep talkToUnferthToFinish;
    DetailedQuestStep waitForPotatoesToGrow;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToUnferth);
        steps.put(5, this.talkToHild);
        steps.put(10, this.talkToHild);
        ConditionalStep findbob1 = new ConditionalStep((QuestHelper)this, (QuestStep)this.findBob, new Requirement[0]);
        findbob1.addStep(this.bobNearby, this.talkToBob);
        steps.put(15, findbob1);
        steps.put(20, this.talkToGertrude);
        steps.put(25, this.talkToReldo);
        steps.put(28, this.talkToReldo);
        ConditionalStep findbob2 = new ConditionalStep((QuestHelper)this, (QuestStep)this.findBobAgain, new Requirement[0]);
        findbob2.addStep(this.bobNearby, this.talkToBobAgain);
        steps.put(30, findbob2);
        steps.put(35, this.talkToSphinx);
        ConditionalStep doChores = new ConditionalStep((QuestHelper)this, (QuestStep)this.useRake, new Requirement[0]);
        doChores.addStep(new Conditions(this.plantedSeed, this.madeBed, this.litLogs, this.placedMilk, this.usedShears), this.waitForPotatoesToGrow);
        doChores.addStep(new Conditions(this.plantedSeed, this.madeBed, this.litLogs, this.placedMilk), this.useShearsOnUnferth);
        doChores.addStep(new Conditions(this.plantedSeed, this.madeBed, this.litLogs, this.placedCake), this.useMilkOnTable);
        doChores.addStep(new Conditions(this.plantedSeed, this.madeBed, this.litLogs), this.useChocolateCakeOnTable);
        doChores.addStep(new Conditions(this.plantedSeed, this.madeBed, this.placedLogs), this.lightLogs);
        doChores.addStep(new Conditions(this.plantedSeed, this.madeBed), this.useLogsOnFireplace);
        doChores.addStep(this.plantedSeed, this.makeBed);
        doChores.addStep(this.rakedPatch, this.plantSeeds);
        steps.put(40, doChores);
        steps.put(45, this.reportToUnferth);
        steps.put(50, this.talkToApoth);
        steps.put(55, this.talkToUnferthAsDoctor);
        ConditionalStep findbob3 = new ConditionalStep((QuestHelper)this, (QuestStep)this.findBobToFinish, new Requirement[0]);
        findbob3.addStep(this.bobNearby, this.talkToBobToFinish);
        steps.put(60, findbob3);
        steps.put(65, this.talkToUnferthToFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.catspeak = new ItemRequirement("Catspeak amulet", 4677, 1, true).isNotConsumed();
        this.catspeak.setTooltip("You can get another from the Sphinx in Sophanem");
        this.catspeakE = new ItemRequirement("Catspeak amulet (e)", 6544).isNotConsumed();
        this.catspeakEWorn = this.catspeakE.equipped();
        this.catspeakE.setHighlightInInventory(true);
        this.deathRune5 = new ItemRequirement("Death runes", 560, 5);
        this.cat = new FollowerItemRequirement("A cat", ItemCollections.CATS, NpcCollections.getCats()).isNotConsumed();
        this.chocolateCake = new ItemRequirement("Chocolate cake", 1897);
        this.chocolateCake.setHighlightInInventory(true);
        this.logs = new ItemRequirement("Logs", 1511);
        this.logs.addAlternates(ItemCollections.LOGS_FOR_FIRE);
        this.logs.setHighlightInInventory(true);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.tinderbox.setHighlightInInventory(true);
        this.milk = new ItemRequirement("Bucket of milk", 1927).isNotConsumed();
        this.milk.setHighlightInInventory(true);
        this.shears = new ItemRequirement("Shears", 1735).isNotConsumed();
        this.shears.setHighlightInInventory(true);
        this.potatoSeed4 = new ItemRequirement("Potato seeds", 5318, 4);
        this.potatoSeed4.setHighlightInInventory(true);
        this.rake = new ItemRequirement("Rake", 5341).isNotConsumed();
        this.rake.setHighlightInInventory(true);
        this.dibber = new ItemRequirement("Seed dibber", 5343).isNotConsumed();
        this.vialOfWater = new ItemRequirement("Vial of water", 227);
        this.desertBottom = new ItemRequirement("Desert robe", 1835, 1, true).isNotConsumed();
        this.desertTop = new ItemRequirement("Desert shirt", 1833, 1, true).isNotConsumed();
        this.hat = new ItemRequirement("Doctor's or Nurse hat", 6547, 1, true).isNotConsumed();
        this.hat.addAlternates(6548);
        this.hat.setDisplayMatchedItemName(true);
        this.burthorpeTeleport = TeleportCollections.BURTHORPE_TELEPORT.getItemRequirement();
        this.varrockTeleport = TeleportCollections.VARROCK_TELEPORT.getItemRequirement();
        this.sophanemTeleport = TeleportCollections.SOPHANEM_TELEPORT.getItemRequirement();
        this.staminaPotion = new ItemRequirement("Stamina potions", ItemCollections.STAMINA_POTIONS);
    }

    public void setupConditions() {
        this.bobNearby = new NpcRequirement("Bob nearby", 8034);
        this.rakedPatch = new VarbitRequirement(1033, 3);
        this.plantedSeed = new VarbitRequirement(1033, 4, Operation.GREATER_EQUAL);
        this.grownPotatoes = new VarbitRequirement(1033, 8);
        this.madeBed = new VarbitRequirement(1029, 1);
        this.placedLogs = new VarbitRequirement(1030, 1);
        this.litLogs = new VarbitRequirement(1030, 2);
        this.placedCake = new VarbitRequirement(1031, 3);
        this.placedMilk = new VarbitRequirement(1031, 4);
        this.usedShears = new VarbitRequirement(1032, 8);
    }

    public void setupSteps() {
        this.talkToUnferth = new NpcStep((QuestHelper)this, 4237, new WorldPoint(2919, 3559, 0), "Talk to Unferth in north east Burthorpe.", this.cat, this.catspeak);
        this.talkToUnferth.addDialogSteps("I'll help you.", "Yes.");
        this.talkToUnferth.addTeleport(this.burthorpeTeleport);
        this.talkToHild = new NpcStep((QuestHelper)this, 4112, new WorldPoint(2930, 3568, 0), "Talk to Hild in the house north east of Unferth.", this.deathRune5, this.catspeak);
        this.findBob = new DetailedQuestStep((QuestHelper)this, "Operate the catspeak amulet (e) to locate Bob the Cat. He's often in Catherby Archery Shop or at the Varrock Anvil.", this.catspeakE);
        this.findBob.addTeleport(this.varrockTeleport);
        this.talkToBob = new NpcStep((QuestHelper)this, 8034, "Talk to Bob the Cat.", this.cat, this.catspeakEWorn);
        this.talkToGertrude = new NpcStep((QuestHelper)this, 7723, new WorldPoint(3151, 3413, 0), "Talk to Gertrude west of Varrock.", this.cat, this.catspeakEWorn);
        this.talkToGertrude.addDialogStep("Ask about Bob's parents.");
        this.talkToGertrude.addTeleport(this.varrockTeleport);
        this.talkToReldo = new NpcStep((QuestHelper)this, 4243, new WorldPoint(3211, 3494, 0), "Talk to Reldo in the Varrock Castle's library.", this.cat, this.catspeakEWorn);
        this.talkToReldo.addDialogStep("Ask about Robert the Strong.");
        this.findBobAgain = new DetailedQuestStep((QuestHelper)this, "Use the catspeak amulet (e) again to locate Bob the Cat.", this.catspeakE);
        this.talkToBobAgain = new NpcStep((QuestHelper)this, 8034, "Talk to Bob the Cat again.", this.cat, this.catspeakEWorn);
        this.talkToSphinx = new NpcStep((QuestHelper)this, 4209, new WorldPoint(3302, 2784, 0), "Talk to the Sphinx in Sophanem.", this.cat, this.catspeakEWorn);
        this.talkToSphinx.addDialogStep("Ask the Sphinx for help for Bob.");
        this.talkToSphinx.addTeleport(this.sophanemTeleport);
        this.useRake = new ObjectStep((QuestHelper)this, 9399, new WorldPoint(2919, 3562, 0), "Rake Unferth's patch", this.rake);
        this.useRake.addIcon(5341);
        this.useRake.addTeleport(this.burthorpeTeleport);
        this.plantSeeds = new ObjectStep((QuestHelper)this, 9399, new WorldPoint(2919, 3562, 0), "Plant 4 potato seeds in Unferth's patch. These can take 15-35 minutes to grow.", this.dibber, this.potatoSeed4);
        this.plantSeeds.addIcon(5318);
        this.makeBed = new ObjectStep((QuestHelper)this, 9438, new WorldPoint(2917, 3557, 0), "Make Unferth's bed.", new Requirement[0]);
        this.useLogsOnFireplace = new ObjectStep((QuestHelper)this, 9442, new WorldPoint(2919, 3557, 0), "Use logs on Unferth's fireplace", this.logs);
        this.useLogsOnFireplace.addIcon(1511);
        this.lightLogs = new ObjectStep((QuestHelper)this, 9442, new WorldPoint(2919, 3557, 0), "Use a tinderbox on Unferth's fireplace.", this.tinderbox.highlighted());
        this.lightLogs.addIcon(590);
        this.useChocolateCakeOnTable = new ObjectStep((QuestHelper)this, 9435, new WorldPoint(2921, 3556, 0), "Use a chocolate cake on Unferth's table.", this.chocolateCake);
        this.useChocolateCakeOnTable.addIcon(1897);
        this.useMilkOnTable = new ObjectStep((QuestHelper)this, 9435, new WorldPoint(2921, 3556, 0), "Use a bucket of milk on Unferth's table.", this.milk);
        this.useMilkOnTable.addIcon(1927);
        this.useShearsOnUnferth = new NpcStep((QuestHelper)this, 4241, new WorldPoint(2919, 3559, 0), "Use some shears on Unferth in north east Burthorpe.", this.shears);
        ((NpcStep)this.useShearsOnUnferth).addAlternateNpcs(4237, 4238, 4239, 4240);
        this.useShearsOnUnferth.addIcon(1735);
        this.waitForPotatoesToGrow = new DetailedQuestStep((QuestHelper)this, "You now need to wait 15-35 minutes for the potatoes to grow.", new Requirement[0]);
        this.reportToUnferth = new NpcStep((QuestHelper)this, 4237, new WorldPoint(2919, 3559, 0), "Talk to Unferth in north east Burthorpe again.", this.cat, this.catspeakEWorn);
        this.talkToApoth = new NpcStep((QuestHelper)this, 5036, new WorldPoint(3195, 3405, 0), "Talk to the Apothecary in south west Varrock.", this.cat, this.catspeakEWorn);
        this.talkToApoth.addDialogStep("Talk about A Tail of Two Cats.");
        this.talkToApoth.addTeleport(this.varrockTeleport);
        this.talkToUnferthAsDoctor = new NpcStep((QuestHelper)this, 4237, new WorldPoint(2919, 3559, 0), "Talk to Unferth whilst wearing the doctor/nurse hat, a desert shirt and a desert robe, and no weapon/shield.", this.cat, this.catspeakEWorn, this.hat, this.desertTop, this.desertBottom, this.vialOfWater);
        this.talkToUnferthAsDoctor.addTeleport(this.burthorpeTeleport);
        this.findBobToFinish = new DetailedQuestStep((QuestHelper)this, "Use the catspeak amulet (e) to locate Bob once more.", this.catspeakE);
        this.findBobToFinish.addTeleport(this.varrockTeleport);
        this.talkToBobToFinish = new NpcStep((QuestHelper)this, 8034, "Talk to Bob the Cat again.", this.cat, this.catspeakEWorn);
        this.talkToUnferthToFinish = new NpcStep((QuestHelper)this, 4237, new WorldPoint(2919, 3559, 0), "Talk to Unferth to complete the quest.", new Requirement[0]);
        this.talkToUnferthToFinish.addTeleport(this.burthorpeTeleport);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.cat, this.catspeak, this.deathRune5, this.chocolateCake, this.logs, this.tinderbox, this.milk, this.shears, this.potatoSeed4, this.rake, this.dibber, this.vialOfWater, this.desertTop, this.desertBottom);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.burthorpeTeleport.quantity(4), this.varrockTeleport.quantity(4), this.sophanemTeleport);
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("2,500 Experience Lamps (Any skill over level 30).", 4447, 2), new ItemReward("A Doctors hat", 6547, 1), new ItemReward("A Nurse hat", 6548, 1), new ItemReward("A Mouse Toy", 6541, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToUnferth, this.talkToHild, this.findBob, this.talkToBob), this.cat, this.catspeak, this.deathRune5));
        allSteps.add(new PanelDetails("Bob's past", Arrays.asList(this.talkToGertrude, this.talkToReldo, this.findBobAgain, this.talkToBobAgain, this.talkToSphinx), this.cat));
        allSteps.add(new PanelDetails("Helping Unferth", Arrays.asList(this.useRake, this.plantSeeds, this.makeBed, this.useLogsOnFireplace, this.lightLogs, this.useChocolateCakeOnTable, this.useMilkOnTable, this.useShearsOnUnferth, this.reportToUnferth), this.cat, this.catspeakE, this.rake, this.dibber, this.potatoSeed4, this.logs, this.tinderbox, this.chocolateCake, this.milk, this.shears));
        allSteps.add(new PanelDetails("'Curing' Unferth", Arrays.asList(this.talkToApoth, this.talkToUnferthAsDoctor, this.findBobToFinish, this.talkToBobToFinish, this.talkToUnferthToFinish), this.cat, this.catspeakE, this.vialOfWater, this.desertTop, this.desertBottom));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new QuestRequirement(QuestHelperQuest.ICTHLARINS_LITTLE_HELPER, QuestState.FINISHED));
    }
}

