/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.asoulsbane;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.A_SOULS_BANE)
public class ASoulsBane
extends BasicQuestHelper {
    ItemRequirement rope;
    ItemRequirement combatGear;
    ItemRequirement angerSword;
    ItemRequirement angerSpear;
    ItemRequirement angerMace;
    ItemRequirement angerBattleaxe;
    ItemRequirement food;
    ItemRequirement digsiteTeleport;
    ItemRequirement antipoison;
    Requirement ropeUsed;
    Requirement inAngerRoom;
    Requirement hasWeapon;
    Requirement hasSword;
    Requirement hasSpear;
    Requirement hasMace;
    Requirement hasBattleaxe;
    Requirement watchedTolnaLeavingCutscene;
    Requirement inHole0;
    Requirement inHole1;
    Requirement inHole2;
    Requirement inHole3;
    Requirement inHole4;
    Requirement inHole5;
    Requirement inFearRoom;
    Requirement reaperNearby;
    Requirement inConfusionRoom;
    Requirement inHopelessRoom;
    Requirement inHopeRoom;
    Requirement inTolnaRoom;
    DetailedQuestStep talkToLauna;
    DetailedQuestStep useRopeOnRift;
    DetailedQuestStep enterRift;
    DetailedQuestStep takeWeapon;
    DetailedQuestStep killAnimals;
    DetailedQuestStep killBears;
    DetailedQuestStep killRats;
    DetailedQuestStep killUnicorn;
    DetailedQuestStep killGoblins;
    DetailedQuestStep leaveAngerRoom;
    DetailedQuestStep lookInsideHole0;
    DetailedQuestStep lookInsideHole1;
    DetailedQuestStep lookInsideHole2;
    DetailedQuestStep lookInsideHole3;
    DetailedQuestStep lookInsideHole4;
    DetailedQuestStep lookInsideHole5;
    DetailedQuestStep lookInsideHoles;
    DetailedQuestStep killReaper;
    DetailedQuestStep leaveFearRoom;
    DetailedQuestStep killRealConfusionBeast;
    DetailedQuestStep leaveConfusionRoom;
    DetailedQuestStep leaveHopelessRoom;
    DetailedQuestStep talkToTolna;
    DetailedQuestStep talkToTolnaAgain;
    NpcStep killHopelessCreatures;
    NpcStep killHeads;
    Zone rageRoom;
    Zone fearRoom;
    Zone confusionRoom;
    Zone hopelessRoom;
    Zone hopeRoom;
    Zone tolnaRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToLauna);
        ConditionalStep firstRoomSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.useRopeOnRift, new Requirement[0]);
        firstRoomSteps.addStep(this.hasSpear, this.killBears);
        firstRoomSteps.addStep(this.hasBattleaxe, this.killGoblins);
        firstRoomSteps.addStep(this.hasSword, this.killUnicorn);
        firstRoomSteps.addStep(this.hasMace, this.killRats);
        firstRoomSteps.addStep(this.hasWeapon, this.killAnimals);
        firstRoomSteps.addStep(this.inAngerRoom, this.takeWeapon);
        firstRoomSteps.addStep(this.ropeUsed, this.enterRift);
        ConditionalStep secondRoomSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterRift, new Requirement[0]);
        secondRoomSteps.addStep(new Conditions(this.inFearRoom, this.reaperNearby), this.killReaper);
        secondRoomSteps.addStep(new Conditions(this.inFearRoom), this.lookInsideHoles);
        secondRoomSteps.addStep(this.inAngerRoom, this.leaveAngerRoom);
        ConditionalStep thirdRoomSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterRift, new Requirement[0]);
        thirdRoomSteps.addStep(this.inConfusionRoom, this.killRealConfusionBeast);
        thirdRoomSteps.addStep(this.inFearRoom, this.leaveFearRoom);
        ConditionalStep fourthRoomSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterRift, new Requirement[0]);
        fourthRoomSteps.addStep(this.inHopelessRoom, this.killHopelessCreatures);
        fourthRoomSteps.addStep(this.inConfusionRoom, this.leaveConfusionRoom);
        ConditionalStep tolnaRoomSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterRift, new Requirement[0]);
        tolnaRoomSteps.addStep(this.inTolnaRoom, this.killHeads);
        tolnaRoomSteps.addStep(this.inHopeRoom, this.leaveHopelessRoom);
        ConditionalStep tolnaSaveSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterRift, new Requirement[0]);
        tolnaSaveSteps.addStep(this.inTolnaRoom, this.talkToTolna);
        steps.put(1, firstRoomSteps);
        steps.put(2, firstRoomSteps);
        steps.put(3, secondRoomSteps);
        steps.put(4, secondRoomSteps);
        steps.put(5, thirdRoomSteps);
        steps.put(6, thirdRoomSteps);
        steps.put(7, fourthRoomSteps);
        steps.put(8, fourthRoomSteps);
        steps.put(9, tolnaRoomSteps);
        steps.put(10, tolnaRoomSteps);
        steps.put(11, tolnaSaveSteps);
        steps.put(12, this.talkToTolnaAgain);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.rope = new ItemRequirement("Rope", 954);
        this.rope.setHighlightInInventory(true);
        this.combatGear = new ItemRequirement("Combat gear + food", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.angerBattleaxe = new ItemRequirement("Anger battleaxe", 7807);
        this.angerMace = new ItemRequirement("Anger mace", 7808);
        this.angerSpear = new ItemRequirement("Anger spear", 7809);
        this.angerSword = new ItemRequirement("Anger sword", 7806);
        this.food = new ItemRequirement("Food", -1, -1);
        this.food.setDisplayItemId(BankSlotIcons.getFood());
        this.digsiteTeleport = new ItemRequirement("Digsite Teleport", 12403);
        this.digsiteTeleport.addAlternates(ItemCollections.DIGSITE_PENDANTS);
        this.antipoison = new ItemRequirement("Antipoison (or equivalent)", ItemCollections.ANTIPOISONS);
    }

    public void setupConditions() {
        this.ropeUsed = new VarbitRequirement(2032, 1);
        this.hasWeapon = new ItemRequirements(LogicType.OR, "", this.angerBattleaxe, this.angerMace, this.angerSpear, this.angerSword);
        this.hasSword = new VarbitRequirement(2029, 1);
        this.hasSpear = new VarbitRequirement(2029, 2);
        this.hasMace = new VarbitRequirement(2029, 3);
        this.hasBattleaxe = new VarbitRequirement(2029, 4);
        this.inAngerRoom = new ZoneRequirement(this.rageRoom);
        this.inFearRoom = new ZoneRequirement(this.fearRoom);
        this.inConfusionRoom = new ZoneRequirement(this.confusionRoom);
        this.inHopelessRoom = new ZoneRequirement(this.hopelessRoom);
        this.inHopeRoom = new ZoneRequirement(this.hopeRoom);
        this.inTolnaRoom = new ZoneRequirement(this.tolnaRoom);
        this.watchedTolnaLeavingCutscene = new VarbitRequirement(2560, 1);
        this.inHole0 = new VarbitRequirement(2012, 0);
        this.inHole1 = new VarbitRequirement(2012, 1);
        this.inHole2 = new VarbitRequirement(2012, 2);
        this.inHole3 = new VarbitRequirement(2012, 3);
        this.inHole4 = new VarbitRequirement(2012, 4);
        this.inHole5 = new VarbitRequirement(2012, 5);
        this.reaperNearby = new VarbitRequirement(2035, 1);
    }

    public void loadZones() {
        this.rageRoom = new Zone(new WorldPoint(3010, 5217, 0), new WorldPoint(3038, 5246, 0));
        this.fearRoom = new Zone(new WorldPoint(3044, 5218, 0), new WorldPoint(3071, 5247, 0));
        this.confusionRoom = new Zone(new WorldPoint(3043, 5185, 0), new WorldPoint(3071, 5213, 0));
        this.hopelessRoom = new Zone(new WorldPoint(3074, 5186, 0), new WorldPoint(3102, 5214, 0));
        this.hopeRoom = new Zone(new WorldPoint(3010, 5185, 0), new WorldPoint(3038, 5214, 0));
        this.tolnaRoom = new Zone(new WorldPoint(2967, 5201, 1), new WorldPoint(2993, 5225, 1));
    }

    public void setupSteps() {
        this.talkToLauna = new NpcStep((QuestHelper)this, 1054, new WorldPoint(3307, 3454, 0), "Talk to Launa east of Varrock.", new Requirement[0]);
        this.talkToLauna.addDialogStep("Would you like me to go down to look for your husband and son?");
        this.useRopeOnRift = new ObjectStep((QuestHelper)this, 13968, new WorldPoint(3310, 3452, 0), "Use a rope on the rift.", this.rope);
        this.useRopeOnRift.addIcon(954);
        this.enterRift = new ObjectStep((QuestHelper)this, 13968, new WorldPoint(3310, 3452, 0), "Enter the rift.", this.combatGear);
        this.takeWeapon = new ObjectStep((QuestHelper)this, 13993, new WorldPoint(3012, 5244, 0), "Take a weapon from the weapon rack. Kill the angry monsters with the appropriate weapon:", new Requirement[0]);
        this.takeWeapon.setText(Arrays.asList("Take a weapon from the weapon rack. Kill the angry monsters with the appropriate weapon:", "Sword - Unicorn", "Spear - Bear", "Mace - Rat", "Battleaxe - Goblin"));
        List<String> killText = Arrays.asList("Kill animals with appropriate weapons until the Rage Metre fills.", "Sword - Unicorn", "Spear - Bear", "Mace - Rat", "Battleaxe - Goblin");
        this.killAnimals = new DetailedQuestStep((QuestHelper)this, "", new Requirement[0]);
        this.killAnimals.setText(killText);
        this.killBears = new NpcStep((QuestHelper)this, 1060, new WorldPoint(3027, 5232, 0), "", true, new Requirement[0]);
        this.killBears.setText(killText);
        this.killGoblins = new NpcStep((QuestHelper)this, 1065, new WorldPoint(3027, 5232, 0), "", true, new Requirement[0]);
        this.killGoblins.setText(killText);
        this.killRats = new NpcStep((QuestHelper)this, 1062, new WorldPoint(3027, 5232, 0), "", true, new Requirement[0]);
        this.killRats.setText(killText);
        this.killUnicorn = new NpcStep((QuestHelper)this, 1061, new WorldPoint(3027, 5232, 0), "", true, new Requirement[0]);
        this.killUnicorn.setText(killText);
        this.killAnimals.addSubSteps(this.killBears, this.killGoblins, this.killRats, this.killUnicorn);
        this.leaveAngerRoom = new ObjectStep((QuestHelper)this, 13882, new WorldPoint(3038, 5229, 0), "Go to the next room.", new Requirement[0]);
        this.lookInsideHole0 = new ObjectStep((QuestHelper)this, 13891, new WorldPoint(3066, 5245, 0), "Look inside the Dark Holes to cause fear reapers to appear. Kill 5-6 of them.", new Requirement[0]);
        this.lookInsideHole1 = new ObjectStep((QuestHelper)this, 13892, new WorldPoint(3069, 5227, 0), "Look inside the Dark Holes to cause fear reapers to appear. Kill 5-6 of them.", new Requirement[0]);
        this.lookInsideHole2 = new ObjectStep((QuestHelper)this, 13893, new WorldPoint(3064, 5219, 0), "Look inside the Dark Holes to cause fear reapers to appear. Kill 5-6 of them.", new Requirement[0]);
        this.lookInsideHole3 = new ObjectStep((QuestHelper)this, 13894, new WorldPoint(3053, 5219, 0), "Look inside the Dark Holes to cause fear reapers to appear. Kill 5-6 of them.", new Requirement[0]);
        this.lookInsideHole4 = new ObjectStep((QuestHelper)this, 13895, new WorldPoint(3046, 5230, 0), "Look inside the Dark Holes to cause fear reapers to appear. Kill 5-6 of them.", new Requirement[0]);
        this.lookInsideHole5 = new ObjectStep((QuestHelper)this, 13896, new WorldPoint(3046, 5240, 0), "Look inside the Dark Holes to cause fear reapers to appear. Kill 5-6 of them.", new Requirement[0]);
        this.lookInsideHoles = new ObjectStep((QuestHelper)this, 13896, new WorldPoint(3046, 5240, 0), "Look inside the Dark Holes to cause fear reapers to appear. Kill 5-6 of them.", true, new Requirement[0]);
        ((ObjectStep)this.lookInsideHoles).addAlternateObjects(13891, 13892, 13893, 13894, 13895);
        this.killReaper = new NpcStep((QuestHelper)this, 1066, new WorldPoint(3058, 5230, 0), "Kill the Fear Reaper.", new Requirement[0]);
        this.lookInsideHoles.addSubSteps(this.killReaper);
        this.lookInsideHole0.addSubSteps(this.lookInsideHole1, this.lookInsideHole2, this.lookInsideHole3, this.lookInsideHole4, this.lookInsideHole5, this.killReaper);
        this.leaveFearRoom = new ObjectStep((QuestHelper)this, 13898, new WorldPoint(3046, 5236, 0), "Continue to the next room.", new Requirement[0]);
        this.killRealConfusionBeast = new NpcStep((QuestHelper)this, 1067, new WorldPoint(3055, 5199, 0), "Attack the confusion beasts until you find one which takes damage, and kill it. The others will take 8 hits to die.", true, new Requirement[0]);
        ((NpcStep)this.killRealConfusionBeast).addAlternateNpcs(1068, 1069, 1070, 1071);
        this.leaveConfusionRoom = new ObjectStep((QuestHelper)this, 13912, new WorldPoint(3051, 5200, 0), "Leave the room through the confusing door.", new Requirement[0]);
        this.killHopelessCreatures = new NpcStep((QuestHelper)this, 1072, new WorldPoint(3087, 5198, 0), "Kill each hopeless creature 3 times.", true, new Requirement[0]);
        this.killHopelessCreatures.addAlternateNpcs(1073, 1074, 4695);
        this.leaveHopelessRoom = new ObjectStep((QuestHelper)this, 13933, new WorldPoint(3021, 5188, 0), "Continue through the exit of the room.", new Requirement[0]);
        this.killHeads = new NpcStep((QuestHelper)this, 1075, new WorldPoint(2984, 5212, 1), "Kill all three of Tolna's heads.", true, new Requirement[0]);
        this.killHeads.addAlternateNpcs(1076, 1077);
        this.talkToTolna = new NpcStep((QuestHelper)this, 1057, new WorldPoint(2984, 5212, 1), "Talk to Tolna.", new Requirement[0]);
        this.talkToTolnaAgain = new NpcStep((QuestHelper)this, 1058, new WorldPoint(3307, 3454, 0), "Talk to Tolna outside the rift.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.rope, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.digsiteTeleport, this.antipoison);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Multiple level 40-46 enemies");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.DEFENCE, 500), new ExperienceReward(Skill.HITPOINTS, 500));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 500));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to the Dungeon of Tolna"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToLauna, this.useRopeOnRift, this.enterRift), this.rope, this.combatGear));
        allSteps.add(new PanelDetails("Anger room", Arrays.asList(this.takeWeapon, this.killAnimals, this.leaveAngerRoom), this.combatGear));
        allSteps.add(new PanelDetails("Fear room", Arrays.asList(this.lookInsideHoles, this.leaveFearRoom), this.combatGear));
        allSteps.add(new PanelDetails("Confusion room", Arrays.asList(this.killRealConfusionBeast, this.leaveConfusionRoom), this.combatGear));
        allSteps.add(new PanelDetails("Hopelessness room", Arrays.asList(this.killHopelessCreatures, this.leaveHopelessRoom), this.combatGear));
        allSteps.add(new PanelDetails("Save Tolna", Arrays.asList(this.killHeads, this.talkToTolna, this.talkToTolnaAgain), this.combatGear));
        return allSteps;
    }
}

