/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.aporcineofinterest;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.A_PORCINE_OF_INTEREST)
public class APorcineOfInterest
extends BasicQuestHelper {
    ItemRequirement rope;
    ItemRequirement slashItem;
    ItemRequirement reinforcedGoggles;
    ItemRequirement combatGear;
    ItemRequirement hoof;
    Requirement inCave;
    DetailedQuestStep readNotice;
    DetailedQuestStep talkToSarah;
    DetailedQuestStep useRopeOnHole;
    DetailedQuestStep enterHole;
    DetailedQuestStep investigateSkeleton;
    DetailedQuestStep talkToSpria;
    DetailedQuestStep enterHoleAgain;
    DetailedQuestStep killSourhog;
    DetailedQuestStep enterHoleForFoot;
    DetailedQuestStep cutOffFoot;
    DetailedQuestStep returnToSarah;
    DetailedQuestStep returnToSpria;
    Zone cave;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.readNotice);
        steps.put(5, this.talkToSarah);
        steps.put(10, this.useRopeOnHole);
        ConditionalStep investigateCave = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterHole, new Requirement[0]);
        investigateCave.addStep(this.inCave, this.investigateSkeleton);
        steps.put(15, investigateCave);
        steps.put(20, this.talkToSpria);
        ConditionalStep goKillSourhog = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterHoleAgain, new Requirement[0]);
        goKillSourhog.addStep(this.inCave, this.killSourhog);
        steps.put(25, goKillSourhog);
        ConditionalStep getFootSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterHoleForFoot, new Requirement[0]);
        getFootSteps.addStep(this.hoof, this.returnToSarah);
        getFootSteps.addStep(this.inCave, this.cutOffFoot);
        steps.put(30, getFootSteps);
        steps.put(35, this.returnToSpria);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.rope = new ItemRequirement("Rope", 954);
        this.rope.setHighlightInInventory(true);
        this.slashItem = new ItemRequirement("A knife or slash weapon", 946).isNotConsumed();
        this.slashItem.setTooltip("Except abyssal whip, abyssal tentacle, or dragon claws.");
        this.reinforcedGoggles = new ItemRequirement("Reinforced goggles", 24942, 1, true).isNotConsumed();
        this.reinforcedGoggles.setTooltip("You can get another pair from Spria");
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.hoof = new ItemRequirement("Sourhog foot", 24944);
        this.hoof.setTooltip("You can get another from Sourhog's corpse in his cave");
    }

    public void loadZones() {
        this.cave = new Zone(new WorldPoint(3152, 9669, 0), new WorldPoint(3181, 9720, 0));
    }

    public void setupConditions() {
        this.inCave = new ZoneRequirement(this.cave);
    }

    public void setupSteps() {
        this.readNotice = new ObjectStep((QuestHelper)this, 40307, new WorldPoint(3086, 3251, 0), "Read the notice board in Draynor Village.", new Requirement[0]);
        this.readNotice.addDialogStep("Yes.");
        this.talkToSarah = new NpcStep((QuestHelper)this, 501, new WorldPoint(3033, 3293, 0), "Talk to Sarah in the South Falador Farm.", new Requirement[0]);
        this.talkToSarah.addDialogSteps("Talk about the bounty.");
        this.useRopeOnHole = new ObjectStep((QuestHelper)this, 40341, new WorldPoint(3151, 3348, 0), "Use a rope on the Strange Hole east of Draynor Manor.", this.rope);
        this.useRopeOnHole.addIcon(954);
        this.useRopeOnHole.addDialogSteps("I think that'll be all for now.");
        this.enterHole = new ObjectStep((QuestHelper)this, 40341, new WorldPoint(3151, 3348, 0), "Climb down into the Strange Hole east of Draynor Manor.", new Requirement[0]);
        this.investigateSkeleton = new ObjectStep((QuestHelper)this, 40350, new WorldPoint(3164, 9676, 0), "Go to the end of the cave and investigate the skeleton there.", new Requirement[0]);
        this.talkToSpria = new NpcStep((QuestHelper)this, 10434, new WorldPoint(3092, 3267, 0), "Talk to Spria in Draynor Village.", new Requirement[0]);
        this.enterHoleAgain = new ObjectStep((QuestHelper)this, 40341, new WorldPoint(3151, 3348, 0), "Climb down into the Strange Hole east of Draynor Manor. Be prepared to fight Sourhog (level 37)", this.reinforcedGoggles, this.slashItem, this.combatGear);
        this.killSourhog = new NpcStep((QuestHelper)this, 10436, "Kill Sourhog.", this.reinforcedGoggles);
        this.killSourhog.addDialogStep("Yes");
        this.enterHoleForFoot = new ObjectStep((QuestHelper)this, 40341, new WorldPoint(3151, 3348, 0), "Climb down into the Strange Hole east of Draynor Manor.", this.slashItem);
        this.cutOffFoot = new ObjectStep((QuestHelper)this, 40348, "Cut off Sourhog's foot.", this.slashItem);
        ((ObjectStep)this.cutOffFoot).addAlternateObjects(40349);
        this.cutOffFoot.addSubSteps(this.enterHoleForFoot);
        this.returnToSarah = new NpcStep((QuestHelper)this, 501, new WorldPoint(3033, 3293, 0), "Return to Sarah in the South Falador Farm.", this.hoof);
        this.returnToSarah.addDialogSteps("Talk about the bounty.");
        this.returnToSpria = new NpcStep((QuestHelper)this, 10434, new WorldPoint(3092, 3267, 0), "Return to Spria in Draynor Village.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.rope, this.slashItem);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.combatGear);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Sourhog (level 37)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.SLAYER, 1000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 5000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("30 Slayer Points"), new UnlockReward("Access to Sourhog Cave"), new UnlockReward("Sourhog can be assigned as a slayer task by Spria or Tureal"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.readNotice, this.talkToSarah, this.useRopeOnHole, this.enterHole, this.investigateSkeleton, this.talkToSpria, this.enterHoleAgain, this.killSourhog, this.cutOffFoot, this.returnToSarah, this.returnToSpria), this.rope, this.slashItem, this.combatGear));
        return allSteps;
    }
}

