/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.anothersliceofham;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.FollowerRequirement;
import com.questhelper.requirements.npc.NpcInteractingRequirement;
import com.questhelper.requirements.npc.NpcInteractingWithNpcRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ANOTHER_SLICE_OF_HAM)
public class AnotherSliceOfHam
extends BasicQuestHelper {
    ItemRequirement lightSource;
    ItemRequirement tinderbox;
    ItemRequirement combatGearRangedMagic;
    ItemRequirement combatGear;
    ItemRequirement lumbridgeTeleports;
    ItemRequirement trowel;
    ItemRequirement specimenBrush;
    ItemRequirement artefact1;
    ItemRequirement artefact2;
    ItemRequirement artefact3;
    ItemRequirement artefact4;
    ItemRequirement artefact5;
    ItemRequirement artefact6;
    ItemRequirement armourShard;
    ItemRequirement axeHead;
    ItemRequirement helmetFragment;
    ItemRequirement shieldFragment;
    ItemRequirement swordFragment;
    ItemRequirement mace;
    ItemRequirement ancientMace;
    FollowerRequirement zanikFollower;
    Requirement inBasement;
    Requirement inTunnels;
    Requirement inMines;
    Requirement inCityF0;
    Requirement inCityF1;
    Requirement inRailway;
    Requirement inTower;
    Requirement inGoblinVillage;
    Requirement inSwamp;
    Requirement inBase;
    Requirement atCrate;
    Requirement inFinalRoom;
    Requirement dug1;
    Requirement dug2;
    Requirement dug3;
    Requirement dug4;
    Requirement dug5;
    Requirement dug6;
    Requirement cleaned1;
    Requirement cleaned2;
    Requirement cleaned3;
    Requirement cleaned4;
    Requirement cleaned5;
    Requirement cleaned6;
    Requirement cleanedAll;
    Requirement handedIn1;
    Requirement handedIn2;
    Requirement handedIn3;
    Requirement handedIn4;
    Requirement handedIn5;
    Requirement handedIn6;
    Requirement zanikFollowing;
    Requirement guardsPassed;
    Requirement guardEngaged;
    Requirement weakSigmundNearby;
    DetailedQuestStep talkToMistagToTravel;
    DetailedQuestStep goDownIntoBasement;
    DetailedQuestStep climbThroughHole;
    DetailedQuestStep talkToKazgar;
    DetailedQuestStep enterCity;
    DetailedQuestStep climbToF1City;
    DetailedQuestStep talkToUrtag;
    DetailedQuestStep enterRailway;
    DetailedQuestStep talkToTegdak;
    DetailedQuestStep dig1;
    DetailedQuestStep dig2;
    DetailedQuestStep dig3;
    DetailedQuestStep dig4;
    DetailedQuestStep dig5;
    DetailedQuestStep dig6;
    DetailedQuestStep cleanArtefacts;
    DetailedQuestStep showTegdakArtefacts;
    DetailedQuestStep talkToZanikRailway;
    DetailedQuestStep leaveRailway;
    DetailedQuestStep talkToScribe;
    DetailedQuestStep goDownToF0City;
    DetailedQuestStep talkToOldak;
    DetailedQuestStep goToGoblinVillage;
    DetailedQuestStep talkToGenerals;
    DetailedQuestStep goUpLadder;
    DetailedQuestStep killHamMageAndArcher;
    DetailedQuestStep talkToGeneralsAgain;
    DetailedQuestStep talkToSergeant;
    DetailedQuestStep enterSwamp;
    DetailedQuestStep climbEnterHamBase;
    DetailedQuestStep goToCrate;
    DetailedQuestStep waitAtCrate;
    DetailedQuestStep lureHamMember;
    DetailedQuestStep enterFinalFight;
    DetailedQuestStep useSpecial;
    DetailedQuestStep defeatSigmund;
    DetailedQuestStep untieZanik;
    ConditionalStep goTalkToUrtag;
    ConditionalStep goTalkToTegdak;
    ConditionalStep goGetArtefacts;
    ConditionalStep goTalkToScribe;
    ConditionalStep goTalkToOldak;
    Zone basement;
    Zone tunnels;
    Zone mines;
    Zone cityF0;
    Zone cityF1;
    Zone railway;
    Zone tower;
    Zone goblinVillage;
    Zone swamp;
    Zone base;
    Zone finalRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        this.setupConditionalSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.goTalkToUrtag);
        steps.put(1, this.goTalkToTegdak);
        steps.put(2, this.goGetArtefacts);
        steps.put(3, this.goTalkToScribe);
        steps.put(4, this.goTalkToOldak);
        steps.put(5, this.talkToGenerals);
        ConditionalStep goKillHamRangers = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToGoblinVillage, new Requirement[0]);
        goKillHamRangers.addStep(this.inTower, this.killHamMageAndArcher);
        goKillHamRangers.addStep(this.inGoblinVillage, this.goUpLadder);
        steps.put(6, goKillHamRangers);
        steps.put(7, this.talkToGeneralsAgain);
        steps.put(8, this.talkToSergeant);
        ConditionalStep goInfiltrateBase = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterSwamp, new Requirement[0]);
        goInfiltrateBase.addStep(this.weakSigmundNearby, this.defeatSigmund);
        goInfiltrateBase.addStep(this.inFinalRoom, this.useSpecial);
        goInfiltrateBase.addStep(new Conditions(this.inBase, this.guardEngaged), this.enterFinalFight);
        goInfiltrateBase.addStep(new Conditions(this.inBase, this.guardsPassed), this.lureHamMember);
        goInfiltrateBase.addStep(new Conditions(this.inBase, this.atCrate), this.waitAtCrate);
        goInfiltrateBase.addStep(this.inBase, this.goToCrate);
        goInfiltrateBase.addStep(this.inSwamp, this.climbEnterHamBase);
        steps.put(9, goInfiltrateBase);
        ConditionalStep goFinish = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterSwamp, new Requirement[0]);
        goFinish.addStep(this.inFinalRoom, this.untieZanik);
        goFinish.addStep(this.inBase, this.enterFinalFight);
        goFinish.addStep(this.inSwamp, this.climbEnterHamBase);
        steps.put(10, goFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.lightSource = new ItemRequirement("A light source", ItemCollections.LIGHT_SOURCES).isNotConsumed();
        this.lumbridgeTeleports = new ItemRequirement("Lumbridge teleports", 8008, 3);
        this.zanikFollower = new FollowerRequirement("Zanik following you. If she's not, retrieve her from the Dorgesh-Kaan railway", 5147);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.combatGearRangedMagic = new ItemRequirement("Magic or ranged combat gear", -1, -1).isNotConsumed();
        this.combatGearRangedMagic.setDisplayItemId(BankSlotIcons.getMagicCombatGear());
        this.trowel = new ItemRequirement("Trowel", 676).isNotConsumed();
        this.trowel.setTooltip("You can get another from Tegdak");
        this.specimenBrush = new ItemRequirement("Specimen brush", 670).isNotConsumed();
        this.specimenBrush.setTooltip("You can get another from Tegdak");
        this.artefact1 = new ItemRequirement("Artefact", 11049);
        this.artefact2 = new ItemRequirement("Artefact", 11051);
        this.artefact3 = new ItemRequirement("Artefact", 11053);
        this.artefact4 = new ItemRequirement("Artefact", 11055);
        this.artefact5 = new ItemRequirement("Artefact", 11057);
        this.artefact6 = new ItemRequirement("Artefact", 11059);
        this.armourShard = new ItemRequirement("Armour shard", 11048);
        this.axeHead = new ItemRequirement("Axe head", 11050);
        this.helmetFragment = new ItemRequirement("Helmet fragment", 11052);
        this.shieldFragment = new ItemRequirement("Shield fragment", 11054);
        this.swordFragment = new ItemRequirement("Sword fragment", 11056);
        this.mace = new ItemRequirement("Mace", 11058);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.ancientMace = new ItemRequirement("Ancient mace", 11061);
        this.ancientMace.setTooltip("You can get this back from the Goblin Village Generals");
    }

    public void loadZones() {
        this.basement = new Zone(new WorldPoint(3208, 9614, 0), new WorldPoint(3219, 9625, 0));
        this.tunnels = new Zone(new WorldPoint(3221, 9602, 0), new WorldPoint(3308, 9661, 0));
        this.mines = new Zone(new WorldPoint(3309, 9600, 0), new WorldPoint(3327, 9655, 0));
        this.cityF0 = new Zone(new WorldPoint(2688, 5248, 0), new WorldPoint(2750, 5375, 0));
        this.cityF1 = new Zone(new WorldPoint(2688, 5248, 1), new WorldPoint(2750, 5375, 1));
        this.railway = new Zone(new WorldPoint(2523, 5630, 0), new WorldPoint(2505, 5527, 0));
        this.tower = new Zone(new WorldPoint(2440, 5416, 2), new WorldPoint(2447, 5418, 2));
        this.goblinVillage = new Zone(new WorldPoint(2434, 5409, 0), new WorldPoint(2459, 5438, 0));
        this.swamp = new Zone(new WorldPoint(3138, 9536, 0), new WorldPoint(3261, 9601, 0));
        this.base = new Zone(new WorldPoint(2393, 5525, 0), new WorldPoint(2414, 5560, 0));
        this.finalRoom = new Zone(new WorldPoint(2532, 5509, 0), new WorldPoint(2553, 5520, 0));
    }

    public void setupConditions() {
        this.inBasement = new ZoneRequirement(this.basement);
        this.inTunnels = new ZoneRequirement(this.tunnels);
        this.inMines = new ZoneRequirement(this.mines);
        this.inCityF0 = new ZoneRequirement(this.cityF0);
        this.inCityF1 = new ZoneRequirement(this.cityF1);
        this.inRailway = new ZoneRequirement(this.railway);
        this.inTower = new ZoneRequirement(this.tower);
        this.inGoblinVillage = new ZoneRequirement(this.goblinVillage);
        this.inSwamp = new ZoneRequirement(this.swamp);
        this.inBase = new ZoneRequirement(this.base);
        this.inFinalRoom = new ZoneRequirement(this.finalRoom);
        this.dug1 = new VarbitRequirement(3551, 1, Operation.GREATER_EQUAL);
        this.dug2 = new VarbitRequirement(3552, 1, Operation.GREATER_EQUAL);
        this.dug3 = new VarbitRequirement(3553, 1, Operation.GREATER_EQUAL);
        this.dug4 = new VarbitRequirement(3554, 1, Operation.GREATER_EQUAL);
        this.dug5 = new VarbitRequirement(3555, 1, Operation.GREATER_EQUAL);
        this.dug6 = new VarbitRequirement(3556, 1, Operation.GREATER_EQUAL);
        this.handedIn1 = new VarbitRequirement(3551, 2);
        this.handedIn2 = new VarbitRequirement(3552, 2);
        this.handedIn3 = new VarbitRequirement(3553, 2);
        this.handedIn4 = new VarbitRequirement(3554, 2);
        this.handedIn5 = new VarbitRequirement(3555, 2);
        this.handedIn6 = new VarbitRequirement(3556, 2);
        this.cleaned1 = new Conditions(LogicType.OR, this.handedIn1, this.armourShard);
        this.cleaned2 = new Conditions(LogicType.OR, this.handedIn2, this.shieldFragment);
        this.cleaned3 = new Conditions(LogicType.OR, this.handedIn3, this.helmetFragment);
        this.cleaned4 = new Conditions(LogicType.OR, this.handedIn4, this.swordFragment);
        this.cleaned5 = new Conditions(LogicType.OR, this.handedIn5, this.axeHead);
        this.cleaned6 = new Conditions(LogicType.OR, this.handedIn6, this.mace);
        this.cleanedAll = new Conditions(this.cleaned1, this.cleaned2, this.cleaned3, this.cleaned4, this.cleaned5, this.cleaned6);
        this.zanikFollowing = new Conditions(LogicType.OR, new VarbitRequirement(3557, 0), new NpcInteractingRequirement(5147));
        this.atCrate = new VarbitRequirement(3558, 1);
        this.guardsPassed = new NpcCondition(5141, new WorldPoint(2397, 5551, 0));
        this.guardEngaged = new Conditions(LogicType.OR, new NpcInteractingWithNpcRequirement(5161, "Guard"), new NpcInteractingWithNpcRequirement(5162, "Guard"));
        this.weakSigmundNearby = new NpcCondition(5146);
    }

    public void setupSteps() {
        this.goDownIntoBasement = new ObjectStep((QuestHelper)this, 14880, new WorldPoint(3209, 3216, 0), "Enter the Lumbridge Castle basement.", new Requirement[0]);
        this.climbThroughHole = new ObjectStep((QuestHelper)this, 6898, new WorldPoint(3219, 9618, 0), "", new Requirement[0]);
        this.talkToKazgar = new NpcStep((QuestHelper)this, 7300, new WorldPoint(3230, 9610, 0), "Travel with Kazgar to shortcut to Mistag.", new Requirement[0]);
        this.talkToMistagToTravel = new NpcStep((QuestHelper)this, 7298, new WorldPoint(3319, 9615, 0), "Travel with Mistag back to Lumbridge.", new Requirement[0]);
        this.enterCity = new ObjectStep((QuestHelper)this, 6919, new WorldPoint(3317, 9601, 0), "Enter Dorgesh-Kaan.", new Requirement[0]);
        this.climbToF1City = new ObjectStep((QuestHelper)this, 22939, new WorldPoint(2721, 5360, 0), "Climb up to the next floor.", new Requirement[0]);
        this.talkToUrtag = new NpcStep((QuestHelper)this, 2315, new WorldPoint(2733, 5366, 1), "Talk to Ur-tag in the north east building.", new Requirement[0]);
        this.talkToUrtag.setWorldMapPoint(new WorldPoint(2797, 5429, 1));
        this.enterRailway = new ObjectStep((QuestHelper)this, 23052, new WorldPoint(2695, 5277, 1), "Enter the railway entrance in the south west of Dorgesh-Kaan.", new Requirement[0]);
        this.enterRailway.setWorldMapPoint(new WorldPoint(2760, 5341, 1));
        this.talkToTegdak = new NpcStep((QuestHelper)this, 5182, new WorldPoint(2512, 5564, 0), "", new Requirement[0]);
        this.dig1 = new ObjectStep((QuestHelper)this, 23290, new WorldPoint(2513, 5563, 0), "", this.trowel.highlighted());
        this.dig1.addIcon(676);
        this.dig2 = new ObjectStep((QuestHelper)this, 23293, new WorldPoint(2511, 5561, 0), "", this.trowel.highlighted());
        this.dig2.addIcon(676);
        this.dig3 = new ObjectStep((QuestHelper)this, 23296, new WorldPoint(2513, 5550, 0), "", this.trowel.highlighted());
        this.dig3.addIcon(676);
        this.dig4 = new ObjectStep((QuestHelper)this, 23534, new WorldPoint(2511, 5547, 0), "", this.trowel.highlighted());
        this.dig4.addIcon(676);
        this.dig5 = new ObjectStep((QuestHelper)this, 23301, new WorldPoint(2512, 5544, 0), "", this.trowel.highlighted());
        this.dig5.addIcon(676);
        this.dig6 = new ObjectStep((QuestHelper)this, 23304, new WorldPoint(2513, 5539, 0), "", this.trowel.highlighted());
        this.dig6.addIcon(676);
        this.cleanArtefacts = new ObjectStep((QuestHelper)this, 23305, new WorldPoint(2513, 5559, 0), "Clean the artefacts on the specimen table.", this.artefact1.highlighted().hideConditioned(this.cleaned1), this.artefact2.highlighted().hideConditioned(this.cleaned2), this.artefact3.highlighted().hideConditioned(this.cleaned3), this.artefact4.highlighted().hideConditioned(this.cleaned4), this.artefact5.highlighted().hideConditioned(this.cleaned5), this.artefact6.highlighted().hideConditioned(this.cleaned6));
        this.cleanArtefacts.addIcon(11049);
        this.showTegdakArtefacts = new NpcStep((QuestHelper)this, 5182, new WorldPoint(2512, 5564, 0), "Show Tegdak the artefacts.", this.armourShard.hideConditioned(this.handedIn1), this.shieldFragment.hideConditioned(this.handedIn2), this.helmetFragment.hideConditioned(this.handedIn3), this.swordFragment.hideConditioned(this.handedIn4), this.axeHead.hideConditioned(this.handedIn5), this.mace.hideConditioned(this.handedIn6));
        this.talkToZanikRailway = new NpcStep((QuestHelper)this, 5184, new WorldPoint(2512, 5564, 0), "Talk to Zanik.", new Requirement[0]);
        this.leaveRailway = new ObjectStep((QuestHelper)this, 23285, new WorldPoint(2521, 5607, 0), "Leave the railway.", new Requirement[0]);
        this.talkToScribe = new NpcStep((QuestHelper)this, 2302, new WorldPoint(2716, 5369, 1), "", new Requirement[0]);
        this.talkToScribe.setWorldMapPoint(new WorldPoint(2778, 5432, 1));
        this.goDownToF0City = new ObjectStep((QuestHelper)this, 22940, new WorldPoint(2721, 5360, 1), "Go downstairs.", new Requirement[0]);
        this.goDownToF0City.setWorldMapPoint(new WorldPoint(2784, 5425, 1));
        this.talkToOldak = new NpcStep((QuestHelper)this, 11265, new WorldPoint(2704, 5365, 0), "", new Requirement[0]);
        this.talkToGenerals = new NpcStep((QuestHelper)this, 670, new WorldPoint(2957, 3512, 0), "Talk to General Wartface and General Bentnoze in Goblin Village.", this.zanikFollower, this.combatGearRangedMagic);
        this.goToGoblinVillage = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2955, 3501, 0), "Go to Goblin Village, ready to fight.", this.combatGearRangedMagic);
        this.goUpLadder = new ObjectStep((QuestHelper)this, 23531, new WorldPoint(2442, 5417, 0), "Make your way to the tower to the south, using the buildings as cover, and climb up the ladder.", new Requirement[0]);
        this.goUpLadder.setLinePoints(Arrays.asList(new WorldPoint(2438, 5429, 0), new WorldPoint(2438, 5423, 0), new WorldPoint(2436, 5423, 0), new WorldPoint(2436, 5419, 0), new WorldPoint(2440, 5417, 0)));
        this.killHamMageAndArcher = new NpcStep((QuestHelper)this, 5158, new WorldPoint(2447, 5417, 2), "Kill the H.A.M. Mage and H.A.M. Archer with a ranged/magic weapon.", true, this.combatGearRangedMagic);
        ((NpcStep)this.killHamMageAndArcher).addAlternateNpcs(5157);
        this.talkToGeneralsAgain = new NpcStep((QuestHelper)this, 670, new WorldPoint(2957, 3512, 0), "Talk to General Wartface and General Bentnoze in Goblin Village again.", new Requirement[0]);
        this.talkToSergeant = new NpcStep((QuestHelper)this, 5162, new WorldPoint(3170, 3170, 0), "Talk to the Sergeants in Lumbridge Swamp.", this.combatGear, this.ancientMace, this.lightSource);
        this.enterSwamp = new ObjectStep((QuestHelper)this, 5947, new WorldPoint(3169, 3172, 0), "Enter the Lumbridge Swamp Caves.", this.combatGear, this.ancientMace, this.lightSource);
        this.climbEnterHamBase = new ObjectStep((QuestHelper)this, 23282, new WorldPoint(3171, 9568, 0), "Climb down the ladder to the secret H.A.M. base.", new Requirement[0]);
        this.goToCrate = new ObjectStep((QuestHelper)this, 23283, new WorldPoint(2408, 5538, 0), "Hide behind the marked crate, and wait for the guards to walk past and around the corner.", new Requirement[0]);
        this.waitAtCrate = new DetailedQuestStep((QuestHelper)this, "Wait for the guards to go around the corner.", new Requirement[0]);
        this.goToCrate.addSubSteps(this.waitAtCrate);
        this.lureHamMember = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2412, 5537, 0), "Run out infront of the final guard, and wait for one of the sergeants to attack them.", new Requirement[0]);
        this.enterFinalFight = new ObjectStep((QuestHelper)this, 23376, new WorldPoint(2413, 5526, 0), "Climb down the ladder.", new Requirement[0]);
        this.useSpecial = new NpcStep((QuestHelper)this, 5142, new WorldPoint(2543, 5511, 0), "When Sigmund starts using protection prayers, use the ancient mace's special attack on Sigmund to remove them and then defeat him.", this.ancientMace.equipped().highlighted());
        ((NpcStep)this.useSpecial).addAlternateNpcs(5143, 5144, 5145);
        this.defeatSigmund = new NpcStep((QuestHelper)this, 5146, new WorldPoint(2543, 5511, 0), "Defeat Sigmund.", new Requirement[0]);
        this.useSpecial.addSubSteps(this.defeatSigmund);
        this.untieZanik = new ObjectStep((QuestHelper)this, 23284, new WorldPoint(2542, 5513, 0), "Untie Zanik.", new Requirement[0]);
    }

    private void setupConditionalSteps() {
        ConditionalStep goToCityF0 = new ConditionalStep((QuestHelper)this, (QuestStep)this.goDownIntoBasement, new Requirement[0]);
        goToCityF0.addStep(this.inMines, this.enterCity);
        goToCityF0.addStep(this.inTunnels, this.talkToKazgar);
        goToCityF0.addStep(this.inBasement, this.climbThroughHole);
        ConditionalStep goToCityF1 = new ConditionalStep((QuestHelper)this, (QuestStep)goToCityF0, new Requirement[0]);
        goToCityF1.addStep(this.inCityF0, this.climbToF1City);
        this.goTalkToUrtag = new ConditionalStep((QuestHelper)this, (QuestStep)goToCityF1, "Travel to Dorgesh-Kaan under Lumbridge, and talk to Ur-tag there.", this.lightSource);
        this.goTalkToUrtag.addStep(this.inCityF1, this.talkToUrtag);
        this.goTalkToUrtag.addDialogSteps("What are you arguing about?", "I'd love to help!");
        this.goTalkToTegdak = new ConditionalStep((QuestHelper)this, (QuestStep)goToCityF1, "Talk to Tegdak through the doorway in south-west Dorgesh-Kaan.", this.lightSource);
        this.goTalkToTegdak.addStep(this.inRailway, this.talkToTegdak);
        this.goTalkToTegdak.addStep(this.inCityF1, this.enterRailway);
        this.goGetArtefacts = new ConditionalStep((QuestHelper)this, (QuestStep)goToCityF1, "Dig up the 6 artefacts in the railway tunnel, clean them, and show them to Tegdak.", new Requirement[0]);
        this.goGetArtefacts.addStep(new Conditions(this.inRailway, this.cleanedAll), this.showTegdakArtefacts);
        this.goGetArtefacts.addStep(new Conditions(this.inRailway, this.dug1, this.dug2, this.dug3, this.dug4, this.dug5, this.dug6), this.cleanArtefacts);
        this.goGetArtefacts.addStep(new Conditions(this.inRailway, this.dug1, this.dug2, this.dug3, this.dug4, this.dug5), this.dig6);
        this.goGetArtefacts.addStep(new Conditions(this.inRailway, this.dug1, this.dug2, this.dug3, this.dug4), this.dig5);
        this.goGetArtefacts.addStep(new Conditions(this.inRailway, this.dug1, this.dug2, this.dug3), this.dig4);
        this.goGetArtefacts.addStep(new Conditions(this.inRailway, this.dug1, this.dug2), this.dig3);
        this.goGetArtefacts.addStep(new Conditions(this.inRailway, this.dug1), this.dig2);
        this.goGetArtefacts.addStep(this.inRailway, this.dig1);
        this.goGetArtefacts.addStep(this.inCityF1, this.enterRailway);
        this.goTalkToScribe = new ConditionalStep((QuestHelper)this, (QuestStep)goToCityF1, "Talk to Zanik in the railway, and then go talk to the Goblin Scribe in the north of Dorgesh-Kaan with her.", new Requirement[0]);
        this.goTalkToScribe.addStep(new Conditions(this.inCityF1, this.zanikFollowing), this.talkToScribe);
        this.goTalkToScribe.addStep(new Conditions(this.inRailway, this.zanikFollowing), this.leaveRailway);
        this.goTalkToScribe.addStep(this.inRailway, this.talkToZanikRailway);
        this.goTalkToScribe.addStep(this.inCityF1, this.enterRailway);
        this.goTalkToScribe.addDialogStep("Yes");
        this.goTalkToOldak = new ConditionalStep((QuestHelper)this, (QuestStep)goToCityF0, "Talk to Oldak in the north west of Dorgesh-Kaan with Zanik.", this.zanikFollower);
        this.goTalkToOldak.addStep(new Conditions(this.inCityF0, this.zanikFollowing), this.talkToOldak);
        this.goTalkToOldak.addStep(new Conditions(this.inCityF1, this.zanikFollowing), this.goDownToF0City);
        this.goTalkToOldak.addStep(new Conditions(this.inRailway, this.zanikFollowing), this.leaveRailway);
        this.goTalkToOldak.addStep(this.inRailway, this.talkToZanikRailway);
        this.goTalkToOldak.addStep(this.inCityF1, this.enterRailway);
        this.goTalkToOldak.addDialogStep("Yes");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.lightSource, this.tinderbox, this.combatGearRangedMagic);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.lumbridgeTeleports);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("H.A.M. Archer (level 30)", "H.A.M. Mage (level 30)", "Sigmund (level 64)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.MINING, 3000), new ExperienceReward(Skill.PRAYER, 3000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("An Ancient Mace", 11061, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Dorgeshuun Train Access."), new UnlockReward("Ability to buy Goblin Village Teleport Spheres"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.goTalkToUrtag, this.goTalkToTegdak, this.goGetArtefacts, this.goTalkToScribe), this.lightSource));
        allSteps.add(new PanelDetails("To Goblin Village", Arrays.asList(this.goTalkToOldak, this.talkToGenerals, this.goUpLadder, this.killHamMageAndArcher, this.talkToGeneralsAgain), this.combatGearRangedMagic));
        allSteps.add(new PanelDetails("Saving Zanik", Arrays.asList(this.talkToSergeant, this.enterSwamp, this.climbEnterHamBase, this.goToCrate, this.lureHamMember, this.enterFinalFight, this.useSpecial, this.untieZanik), this.combatGear, this.ancientMace, this.lightSource));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.DEATH_TO_THE_DORGESHUUN, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.THE_GIANT_DWARF, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.THE_DIG_SITE, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.ATTACK, 15));
        req.add(new SkillRequirement(Skill.PRAYER, 25));
        return req;
    }
}

