/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.animalmagnetism;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.animalmagnetism.PuzzleSolver;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.PuzzleStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ANIMAL_MAGNETISM)
public class AnimalMagnetism
extends BasicQuestHelper {
    ItemRequirement mithrilAxe;
    ItemRequirement ironBar5;
    ItemRequirement ghostspeak;
    ItemRequirement ghostspeakEquip;
    ItemRequirement ectoToken20;
    ItemRequirement hammer;
    ItemRequirement hardLeather;
    ItemRequirement holySymbol;
    ItemRequirement polishedButtons;
    ItemRequirement croneMadeAmulet;
    ItemRequirement undeadChicken2;
    ItemRequirement selectedIron;
    ItemRequirement barMagnet;
    ItemRequirement blessedAxe;
    ItemRequirement twigs;
    ItemRequirement researchNotes;
    ItemRequirement translatedNotes;
    ItemRequirement pattern;
    ItemRequirement container;
    ItemRequirement draynorTeleport;
    ItemRequirement burthorpeTeleport;
    ItemRequirement portPhasmatysTeleport;
    QuestStep talkToAva;
    QuestStep giveChickensToAva;
    QuestStep talkToAlice;
    QuestStep talkToAlice2;
    QuestStep talkToAlicesHusband;
    QuestStep talkToAlicesHusband2;
    QuestStep talkToAlicesHusband3;
    QuestStep talkToOldCrone;
    QuestStep giveAmuletToHusband;
    QuestStep buyUndeadChickens;
    QuestStep talkToWitch;
    QuestStep goToIronMine;
    QuestStep useHammerOnMagnet;
    QuestStep giveMagnetToAva;
    QuestStep attemptToCutTree;
    QuestStep talkToTurael;
    QuestStep cutTree;
    QuestStep giveTwigsToAva;
    QuestStep getNotesFromAva;
    QuestStep translateNotes;
    QuestStep giveNotesToAva;
    QuestStep buildPattern;
    QuestStep giveContainerToAva;
    Requirement inIronMine;
    Zone ironMine;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToAva);
        steps.put(10, this.talkToAlicesHusband);
        steps.put(20, this.talkToAlice);
        steps.put(30, this.talkToAlicesHusband2);
        steps.put(40, this.talkToAlice2);
        steps.put(50, this.talkToAlicesHusband2);
        steps.put(60, this.talkToAlice2);
        steps.put(70, this.talkToOldCrone);
        steps.put(73, this.talkToOldCrone);
        steps.put(76, this.giveAmuletToHusband);
        steps.put(80, this.talkToAlicesHusband3);
        steps.put(90, this.talkToAlicesHusband3);
        ConditionalStep undeadChickens = new ConditionalStep((QuestHelper)this, this.buyUndeadChickens, new Requirement[0]);
        undeadChickens.addStep(this.undeadChicken2, this.giveChickensToAva);
        steps.put(100, undeadChickens);
        steps.put(110, undeadChickens);
        steps.put(120, this.talkToWitch);
        steps.put(130, this.talkToWitch);
        ConditionalStep createMagnet = new ConditionalStep((QuestHelper)this, this.goToIronMine, new Requirement[0]);
        createMagnet.addStep(this.barMagnet, this.giveMagnetToAva);
        createMagnet.addStep(this.inIronMine, this.useHammerOnMagnet);
        steps.put(140, createMagnet);
        steps.put(150, this.attemptToCutTree);
        steps.put(160, this.talkToTurael);
        steps.put(170, this.talkToTurael);
        ConditionalStep getTwigs = new ConditionalStep((QuestHelper)this, this.cutTree, new Requirement[0]);
        getTwigs.addStep(this.twigs, this.giveTwigsToAva);
        steps.put(180, getTwigs);
        steps.put(190, this.getNotesFromAva);
        steps.put(200, this.translateNotes);
        steps.put(210, this.giveNotesToAva);
        steps.put(220, this.buildPattern);
        steps.put(230, this.giveContainerToAva);
        return steps;
    }

    private void loadZones() {
        this.ironMine = new Zone(new WorldPoint(2971, 3248, 0), new WorldPoint(2987, 3234, 0));
    }

    @Override
    public void setupRequirements() {
        this.ghostspeak = new ItemRequirement("Ghostspeak amulet", 552).isNotConsumed();
        this.ghostspeakEquip = new ItemRequirement("Ghostspeak amulet", 552, 1, true);
        this.croneMadeAmulet = new ItemRequirement("Crone-made amulet", 10500);
        this.ectoToken20 = new ItemRequirement("Ecto-token", 4278, 20);
        this.undeadChicken2 = new ItemRequirement("Undead chicken", 10487, 2);
        this.undeadChicken2.setTooltip("You will buy the undead chickens from Malcolm.");
        this.ironBar5 = new ItemRequirement("Iron Bar", 2351, 5);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.selectedIron = new ItemRequirement("Selected Iron", 10488);
        this.barMagnet = new ItemRequirement("Bar magnet", 10489);
        this.mithrilAxe = new ItemRequirement("Mithril Axe", 1355);
        this.holySymbol = new ItemRequirement("Holy Symbol", 1718).isNotConsumed();
        this.blessedAxe = new ItemRequirement("Blessed axe", 10491);
        this.twigs = new ItemRequirement("Undead twigs", 10490);
        this.researchNotes = new ItemRequirement("Research notes", 291);
        this.researchNotes.setHighlightInInventory(true);
        this.translatedNotes = new ItemRequirement("Translated notes", 10493);
        this.hardLeather = new ItemRequirement("Hard Leather", 1743);
        this.hardLeather.setHighlightInInventory(true);
        this.polishedButtons = new ItemRequirement("Polished Buttons", 10496);
        this.polishedButtons.setHighlightInInventory(true);
        this.draynorTeleport = new ItemRequirement("Teleport to Draynor", 19615, 5);
        this.draynorTeleport.addAlternates(ItemCollections.AMULET_OF_GLORIES);
        this.burthorpeTeleport = new ItemRequirement("Teleport to Burthorpe", ItemCollections.GAMES_NECKLACES);
        this.portPhasmatysTeleport = new ItemRequirement("Teleport to Port Phasmatys", 4251);
        this.portPhasmatysTeleport.addAlternates(19621);
        this.pattern = new ItemRequirement("A pattern", 10494);
        this.pattern.setHighlightInInventory(true);
        this.container = new ItemRequirement("A container", 10495);
    }

    private void setupConditions() {
        this.inIronMine = new ZoneRequirement(this.ironMine);
    }

    private void setupSteps() {
        this.talkToAva = new NpcStep((QuestHelper)this, 4407, new WorldPoint(3093, 3357, 0), "Talk to Ava to begin the quest.", new Requirement[0]);
        this.talkToAva.addDialogStep("I would be happy to make your home a better place.");
        this.talkToAlicesHusband = new NpcStep((QuestHelper)this, 4411, new WorldPoint(3618, 3526, 0), "Talk to Malcolm at the farm west of the Ectofuntus.", this.ghostspeakEquip);
        this.talkToAlice = new NpcStep((QuestHelper)this, 504, new WorldPoint(3627, 3526, 0), "Talk to Alice.", new Requirement[0]);
        this.talkToAlice.addDialogStep("I'm here about a quest.");
        this.talkToAlicesHusband2 = new NpcStep((QuestHelper)this, 4411, new WorldPoint(3618, 3526, 0), "Talk to Malcolm again.", this.ghostspeakEquip);
        this.talkToAlice2 = new NpcStep((QuestHelper)this, 504, new WorldPoint(3627, 3526, 0), "Talk to Alice again.", new Requirement[0]);
        this.talkToAlice2.addDialogStep("I'm here about a quest.");
        this.talkToOldCrone = new NpcStep((QuestHelper)this, 2996, new WorldPoint(3461, 3558, 0), "Talk to the Old crone just east of the Slayer Tower twice.", this.ghostspeakEquip);
        this.talkToOldCrone.addDialogStep("I'm here about the farmers east of here.");
        this.giveAmuletToHusband = new NpcStep((QuestHelper)this, 4411, new WorldPoint(3618, 3526, 0), "Give the Crone-made amulet to Malcolm.", this.ghostspeakEquip, this.croneMadeAmulet);
        this.giveAmuletToHusband.addDialogStep("Okay, you need it more than I do, I suppose.");
        this.talkToAlicesHusband3 = new NpcStep((QuestHelper)this, 4412, new WorldPoint(3618, 3526, 0), "Talk to Malcolm again to watch a cutscene.", this.ghostspeakEquip);
        this.buyUndeadChickens = new NpcStep((QuestHelper)this, 4412, new WorldPoint(3618, 3526, 0), "Buy two undead chickens from Malcolm. You can acquire ecto-tokens using the Ectofuntus to the east.", this.ghostspeakEquip, this.ectoToken20);
        this.buyUndeadChickens.addDialogSteps("Could I buy those chickens now, then?", "Could I buy 2 chickens?");
        this.giveChickensToAva = new NpcStep((QuestHelper)this, 4407, new WorldPoint(3093, 3357, 0), "Give the two Undead chickens to Ava.", this.undeadChicken2);
        this.talkToWitch = new NpcStep((QuestHelper)this, 4409, new WorldPoint(3099, 3370, 0), "Talk to the witch in the manor twice.", this.ironBar5);
        this.goToIronMine = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2978, 3240, 0), "Go to the iron mine in Rimmington northeast of the house portal.", this.hammer, this.selectedIron);
        this.useHammerOnMagnet = new ItemStep((QuestHelper)this, "While looking north, use the hammer on the Selected iron.", this.hammer.highlighted(), this.selectedIron.highlighted());
        this.giveMagnetToAva = new NpcStep((QuestHelper)this, 4407, new WorldPoint(3093, 3357, 0), "Give the Bar magnet to Ava.", this.barMagnet);
        this.attemptToCutTree = new NpcStep((QuestHelper)this, 4417, "Try to chop an undead tree outside Draynor manor.", true, this.mithrilAxe);
        this.talkToTurael = new NpcStep((QuestHelper)this, 401, new WorldPoint(2931, 3536, 0), "Talk to Turael in Burthorpe twice, giving him the Mithril axe and Holy symbol.", this.mithrilAxe, this.holySymbol);
        this.talkToTurael.addDialogSteps("I'm here about a quest.", "Hello, I'm here about those trees again.", "I'd love one, thanks.");
        this.cutTree = new NpcStep((QuestHelper)this, 4417, "Try to chop an undead tree outside Draynor manor with the Blessed axe until you receive undead twigs.", true, this.blessedAxe);
        this.giveTwigsToAva = new NpcStep((QuestHelper)this, 4407, new WorldPoint(3093, 3357, 0), "Give the Undead twigs to Ava.", this.twigs);
        this.getNotesFromAva = new NpcStep((QuestHelper)this, 4407, new WorldPoint(3093, 3357, 0), "Talk to Ava to receive the research notes.", new Requirement[0]);
        this.translateNotes = new PuzzleStep((QuestHelper)this, "Translate research notes by clicking on all the highlighted switches.", new PuzzleSolver()::solver, this.researchNotes);
        this.giveNotesToAva = new NpcStep((QuestHelper)this, 4407, new WorldPoint(3093, 3357, 0), "Give Ava the translated research notes.", this.translatedNotes);
        this.buildPattern = new ItemStep((QuestHelper)this, "Combine Hard leather and Polished buttons with the pattern.", this.pattern, this.hardLeather, this.polishedButtons);
        this.giveContainerToAva = new NpcStep((QuestHelper)this, 4407, new WorldPoint(3093, 3357, 0), "Give Ava the container.", this.container);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.mithrilAxe, this.ironBar5, this.ghostspeak, this.ectoToken20, this.hammer, this.hardLeather, this.holySymbol, this.polishedButtons);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.draynorTeleport, this.burthorpeTeleport, this.portPhasmatysTeleport);
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.CRAFTING, 1000), new ExperienceReward(Skill.FLETCHING, 1000), new ExperienceReward(Skill.SLAYER, 1000), new ExperienceReward(Skill.WOODCUTTING, 2500));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Ava's Attractor", 10498, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to purchase Ava's Devices"));
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.SLAYER, 18));
        req.add(new SkillRequirement(Skill.CRAFTING, 19));
        req.add(new SkillRequirement(Skill.RANGED, 30));
        req.add(new SkillRequirement(Skill.WOODCUTTING, 35));
        req.add(new QuestRequirement(QuestHelperQuest.THE_RESTLESS_GHOST, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.ERNEST_THE_CHICKEN, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.PRIEST_IN_PERIL, QuestState.FINISHED));
        return req;
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToAva), new Requirement[0]));
        allSteps.add(new PanelDetails("Undead Chickens", Arrays.asList(this.talkToAlicesHusband, this.talkToAlice, this.talkToAlicesHusband2, this.talkToAlice2, this.talkToOldCrone, this.giveAmuletToHusband, this.talkToAlicesHusband3, this.buyUndeadChickens, this.giveChickensToAva), this.ghostspeak, this.ectoToken20));
        allSteps.add(new PanelDetails("Magnet", Arrays.asList(this.talkToWitch, this.goToIronMine, this.useHammerOnMagnet, this.giveMagnetToAva), this.ironBar5, this.hammer));
        allSteps.add(new PanelDetails("Undead twigs", Arrays.asList(this.attemptToCutTree, this.talkToTurael, this.cutTree, this.giveTwigsToAva, this.getNotesFromAva, this.translateNotes, this.giveNotesToAva, this.buildPattern, this.giveContainerToAva), this.mithrilAxe, this.polishedButtons, this.hardLeather, this.holySymbol));
        return allSteps;
    }
}

