/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.akingdomdivided;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import net.runelite.api.coords.WorldPoint;

public class XericsLookoutStepper
extends ConditionalStep {
    int floor;
    QuestStep speakToWho;
    ObjectStep goDownLookoutF3toF2;
    ObjectStep goDownLookoutF2toF1;
    ObjectStep goDownLookoutF1toF0;
    ObjectStep goDownLookoutF0toBasement;
    ObjectStep goUpLookoutBasementtoF0;
    ObjectStep goUpLookoutF0toF1;
    ObjectStep goUpLookoutF1toF2;
    ObjectStep goUpLookoutF2toF3;
    Requirement inLookoutBasement;
    Requirement inLookoutF0;
    Requirement inLookoutF1;
    Requirement inLookoutF2;
    Requirement inLookoutF3;
    Zone lookoutBasement;
    Zone lookoutF1;
    Zone lookoutF2;
    Zone lookoutF3;

    public XericsLookoutStepper(QuestHelper questHelper, QuestStep speakToWho, int floor, QuestStep sidebar) {
        super(questHelper, speakToWho, new Requirement[0]);
        this.speakToWho = speakToWho;
        this.floor = floor;
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        sidebar.addSubSteps(this.goDownLookoutF3toF2, this.goDownLookoutF2toF1, this.goDownLookoutF1toF0, this.goDownLookoutF0toBasement, this.goUpLookoutBasementtoF0, this.goUpLookoutF0toF1, this.goUpLookoutF1toF2, this.goUpLookoutF2toF3);
        this.addSteppers();
    }

    public XericsLookoutStepper(QuestHelper questHelper, QuestStep speakToWho, int floor) {
        super(questHelper, speakToWho, new Requirement[0]);
        this.speakToWho = speakToWho;
        this.floor = floor;
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        speakToWho.addSubSteps(this.goDownLookoutF3toF2, this.goDownLookoutF2toF1, this.goDownLookoutF1toF0, this.goDownLookoutF0toBasement, this.goUpLookoutBasementtoF0, this.goUpLookoutF0toF1, this.goUpLookoutF1toF2, this.goUpLookoutF2toF3);
        this.addSteppers();
    }

    private void addSteppers() {
        if (this.floor == 3) {
            this.addStep(new Conditions(this.inLookoutF3), this.speakToWho);
        } else if (this.floor == 2) {
            this.addStep(new Conditions(this.inLookoutF2), this.speakToWho);
        } else if (this.floor == 1) {
            this.addStep(new Conditions(this.inLookoutF1), this.speakToWho);
        } else if (this.floor == 0) {
            this.addStep(new Conditions(this.inLookoutF0), this.speakToWho);
        } else if (this.floor == -1) {
            this.addStep(new Conditions(this.inLookoutBasement), this.speakToWho);
        }
        if (this.floor > -1) {
            this.addStep(new Conditions(this.inLookoutBasement), this.goUpLookoutBasementtoF0);
        }
        if (this.floor < 0) {
            this.addStep(new Conditions(this.inLookoutF0), this.goDownLookoutF0toBasement);
        } else if (this.floor > 0) {
            this.addStep(this.inLookoutF0, this.goUpLookoutF0toF1);
        }
        if (this.floor < 1) {
            this.addStep(new Conditions(this.inLookoutF1), this.goDownLookoutF1toF0);
        } else if (this.floor > 1) {
            this.addStep(new Conditions(this.inLookoutF1), this.goUpLookoutF1toF2);
        }
        if (this.floor < 2) {
            this.addStep(new Conditions(this.inLookoutF2), this.goDownLookoutF2toF1);
        } else if (this.floor > 2) {
            this.addStep(new Conditions(this.inLookoutF2), this.goUpLookoutF2toF3);
        }
        if (this.floor < 3) {
            this.addStep(new Conditions(this.inLookoutF3), this.goDownLookoutF3toF2);
        }
    }

    public void setupZones() {
        this.lookoutF3 = new Zone(new WorldPoint(1589, 3533, 3), new WorldPoint(1595, 3527, 3));
        this.lookoutF2 = new Zone(new WorldPoint(1589, 3533, 2), new WorldPoint(1595, 3527, 2));
        this.lookoutF1 = new Zone(new WorldPoint(1589, 3533, 1), new WorldPoint(1595, 3527, 1));
        this.lookoutBasement = new Zone(new WorldPoint(1558, 9960, 0), new WorldPoint(1572, 9945, 0));
    }

    public void setupConditions() {
        this.inLookoutBasement = new ZoneRequirement(this.lookoutBasement);
        this.inLookoutF1 = new ZoneRequirement(this.lookoutF1);
        this.inLookoutF2 = new ZoneRequirement(this.lookoutF2);
        this.inLookoutF3 = new ZoneRequirement(this.lookoutF3);
        this.inLookoutF0 = new Conditions(LogicType.NOR, this.inLookoutBasement, this.inLookoutF1, this.inLookoutF2, this.inLookoutF3);
    }

    public void setupSteps() {
        this.goDownLookoutF3toF2 = new ObjectStep(this.getQuestHelper(), 11890, new WorldPoint(1592, 3530, 3), this.getStepText(), this.getStepRequirements());
        this.goDownLookoutF2toF1 = new ObjectStep(this.getQuestHelper(), 11889, new WorldPoint(1592, 3529, 2), this.getStepText(), this.getStepRequirements());
        this.goDownLookoutF2toF1.addDialogSteps("Climb down");
        this.goDownLookoutF1toF0 = new ObjectStep(this.getQuestHelper(), 11889, new WorldPoint(1592, 3529, 1), this.getStepText(), this.getStepRequirements());
        this.goDownLookoutF1toF0.addDialogSteps("Climb down");
        this.goDownLookoutF0toBasement = new ObjectStep(this.getQuestHelper(), 41916, new WorldPoint(1590, 3526, 0), this.getStepText(), this.getStepRequirements());
        this.goUpLookoutBasementtoF0 = new ObjectStep(this.getQuestHelper(), 41917, new WorldPoint(1564, 9949, 0), this.getStepText(), this.getStepRequirements());
        this.goUpLookoutF0toF1 = new ObjectStep(this.getQuestHelper(), 11888, new WorldPoint(1592, 3529, 0), this.getStepText(), this.getStepRequirements());
        this.goUpLookoutF1toF2 = new ObjectStep(this.getQuestHelper(), 11889, new WorldPoint(1592, 3529, 1), this.getStepText(), this.getStepRequirements());
        this.goUpLookoutF1toF2.addDialogSteps("Climb up");
        this.goUpLookoutF2toF3 = new ObjectStep(this.getQuestHelper(), 11889, new WorldPoint(1592, 3529, 2), this.getStepText(), this.getStepRequirements());
        this.goUpLookoutF2toF3.addDialogSteps("Climb up");
    }

    private String getStepText() {
        return this.speakToWho.getText().toString().replaceAll("\\[|\\]", "");
    }

    private Requirement[] getStepRequirements() {
        DetailedQuestStep step = (DetailedQuestStep)this.speakToWho;
        return step.getRequirements().toArray(new Requirement[0]);
    }
}

