/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.akingdomdivided;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class StonePuzzleStep
extends DetailedOwnerStep {
    Requirement inPanelZone;
    private boolean rStoneDone = false;
    private boolean oStoneDone = false;
    private boolean sStoneDone = false;
    private boolean eStoneDone = false;
    private boolean codeFound = false;
    DetailedQuestStep checkRStone;
    DetailedQuestStep checkOStone;
    DetailedQuestStep checkSStone;
    DetailedQuestStep checkEStone;
    DetailedQuestStep chopVines;
    DetailedQuestStep squeezeThroughVines;
    DetailedQuestStep checkPanel;
    Zone panelArea1;
    Zone panelArea2;
    private final HashMap<String, String> answers = new HashMap();

    public StonePuzzleStep(QuestHelper questHelper) {
        super(questHelper, "Solve the wall panel puzzle.", new Requirement[0]);
    }

    @Override
    protected void updateSteps() {
        if (!this.codeFound) {
            if (!this.eStoneDone) {
                this.startUpStep(this.checkEStone);
            } else if (!this.rStoneDone) {
                this.startUpStep(this.checkRStone);
            } else if (!this.sStoneDone) {
                this.startUpStep(this.checkSStone);
            } else if (!this.oStoneDone) {
                this.startUpStep(this.checkOStone);
            } else {
                this.checkPanel.addText("Enter code: " + this.answers.get("R") + this.answers.get("O") + this.answers.get("S") + this.answers.get("E"));
                this.codeFound = true;
            }
        } else if (this.inPanelZone.check(this.client)) {
            this.startUpStep(this.checkPanel);
        } else {
            this.startUpStep(this.squeezeThroughVines);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    @Override
    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() != 229) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            Matcher foundStoneValue;
            boolean foundAnswer;
            Widget widgetStone = this.client.getWidget(229, 1);
            if (widgetStone != null && !widgetStone.isHidden() && !this.codeFound && (foundAnswer = (foundStoneValue = Pattern.compile("(?:^|)'([^']*?)'(?:\\s|$)").matcher(widgetStone.getText())).find())) {
                String value = foundStoneValue.group(0);
                String letter = value.substring(1, 2);
                String number = value.substring(value.length() - 2, value.length() - 1);
                switch (letter) {
                    case "R": {
                        this.answers.put("R", number);
                        this.rStoneDone = true;
                        break;
                    }
                    case "O": {
                        this.answers.put("O", number);
                        this.oStoneDone = true;
                        break;
                    }
                    case "S": {
                        this.answers.put("S", number);
                        this.sStoneDone = true;
                        break;
                    }
                    case "E": {
                        this.answers.put("E", number);
                        this.eStoneDone = true;
                    }
                }
            }
        });
    }

    protected void setupZones() {
        this.panelArea1 = new Zone(new WorldPoint(1670, 3577, 0), new WorldPoint(1671, 3576, 0));
        this.panelArea2 = new Zone(new WorldPoint(1669, 3581, 0), new WorldPoint(1672, 3578, 0));
    }

    public void setupConditions() {
        this.inPanelZone = new ZoneRequirement(this.panelArea1, this.panelArea2);
    }

    @Override
    protected void setupSteps() {
        this.setupZones();
        this.setupConditions();
        this.checkRStone = new ObjectStep(this.getQuestHelper(), 41827, new WorldPoint(1678, 3567, 0), "Check the south east stone pile.", new Requirement[0]);
        this.checkOStone = new ObjectStep(this.getQuestHelper(), 41827, new WorldPoint(1670, 3575, 0), "Check the north west stone pile.", new Requirement[0]);
        this.checkSStone = new ObjectStep(this.getQuestHelper(), 41827, new WorldPoint(1672, 3571, 0), "Check the south west stone pile.", new Requirement[0]);
        this.checkEStone = new ObjectStep(this.getQuestHelper(), 41827, new WorldPoint(1680, 3576, 0), "Check the north east stone pile.", new Requirement[0]);
        this.chopVines = new ObjectStep(this.getQuestHelper(), 41815, new WorldPoint(1671, 3577, 0), "Chop the vines south of Martin Holt.", new Requirement[0]);
        this.squeezeThroughVines = new ObjectStep(this.getQuestHelper(), 41816, new WorldPoint(1671, 3577, 0), "Squeeze through the vines.", new Requirement[0]);
        this.checkPanel = new ObjectStep(this.getQuestHelper(), 41822, new WorldPoint(1672, 3579, 0), "Check the panel on the wall.", new Requirement[0]);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.checkEStone, this.checkRStone, this.checkSStone, this.checkOStone, this.squeezeThroughVines, this.checkPanel);
    }
}

