/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.akingdomdivided;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class StatuePuzzle
extends DetailedOwnerStep {
    DetailedQuestStep checkPanel;
    DetailedQuestStep climbUpPillarLeglessFaun;
    DetailedQuestStep climbDownLeglessFaun;
    DetailedQuestStep moveShayzienStatue;
    DetailedQuestStep moveHosidiusStatue;
    DetailedQuestStep moveLovakengjStatue;
    DetailedQuestStep movePiscStatue;
    DetailedQuestStep moveArceuusStatue;
    DetailedQuestStep invalidState;
    Zone leglessFaunF1;
    Requirement inLeglessFaunF1;
    Requirement statuesAllValid;
    Requirement[] statueStates;
    Boolean readOnce = false;
    ArrayList<KourendCities> cityOrder;
    HashMap<KourendCities, DetailedQuestStep> statueMap;

    public StatuePuzzle(QuestHelper questHelper) {
        super(questHelper, "Solve the statue puzzle.", new Requirement[0]);
    }

    @Override
    protected void updateSteps() {
        if (!this.readOnce.booleanValue()) {
            if (this.inLeglessFaunF1.check(this.client)) {
                this.startUpStep(this.checkPanel);
            } else {
                this.startUpStep(this.climbUpPillarLeglessFaun);
            }
        } else if (this.statuesAllValid != null && !this.statuesAllValid.check(this.client)) {
            this.startUpStep(this.invalidState);
        } else if (this.inLeglessFaunF1.check(this.client)) {
            this.startUpStep(this.climbDownLeglessFaun);
        } else if (this.statueStates[0].check(this.client)) {
            this.startUpStep(this.statueMap.get((Object)this.cityOrder.get(0)));
        } else if (this.statueStates[1].check(this.client)) {
            this.startUpStep(this.statueMap.get((Object)this.cityOrder.get(1)));
        } else if (this.statueStates[2].check(this.client)) {
            this.startUpStep(this.statueMap.get((Object)this.cityOrder.get(2)));
        } else if (this.statueStates[3].check(this.client)) {
            this.startUpStep(this.statueMap.get((Object)this.cityOrder.get(3)));
        } else {
            this.startUpStep(this.statueMap.get((Object)this.cityOrder.get(4)));
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Widget widgetPanel = this.client.getWidget(229, 1);
        if (widgetPanel != null && !widgetPanel.isHidden() && !this.readOnce.booleanValue()) {
            String[] panelWords;
            for (String word : panelWords = widgetPanel.getText().replaceAll("<br>", " ").replaceAll(",", "").split(" ")) {
                if (!word.equalsIgnoreCase(KourendCities.SHAYZIEN.toString()) && !word.equalsIgnoreCase(KourendCities.PISCARILIUS.toString()) && !word.equalsIgnoreCase(KourendCities.HOSIDIUS.toString()) && !word.equalsIgnoreCase(KourendCities.LOVAKENGJ.toString()) && !word.equalsIgnoreCase(KourendCities.ARCEUUS.toString())) continue;
                this.cityOrder.add(KourendCities.valueOf(word.toUpperCase()));
            }
            if (this.cityOrder.size() == 5) {
                if (this.statueStates == null) {
                    return;
                }
                this.readOnce = true;
                ArrayList<Requirement> validState = new ArrayList<Requirement>();
                for (int i = 0; i < this.cityOrder.size() - 1; ++i) {
                    VarbitRequirement correctValue = new VarbitRequirement(12306 + i, this.cityOrder.get(i).getPos());
                    validState.add(new Conditions(LogicType.OR, this.statueStates[i], correctValue));
                }
                this.statuesAllValid = new Conditions(validState);
            }
        }
        this.updateSteps();
    }

    protected void setupZones() {
        this.leglessFaunF1 = new Zone(new WorldPoint(1766, 3686, 1), new WorldPoint(1773, 3679, 1));
    }

    public void setupConditions() {
        this.inLeglessFaunF1 = new ZoneRequirement(this.leglessFaunF1);
        this.statueStates = new Requirement[]{new VarbitRequirement(12306, 0), new VarbitRequirement(12307, 0), new VarbitRequirement(12308, 0), new VarbitRequirement(12309, 0)};
    }

    @Override
    protected void setupSteps() {
        this.setupZones();
        this.setupConditions();
        this.cityOrder = new ArrayList();
        this.statueMap = new HashMap();
        this.checkPanel = new ObjectStep(this.getQuestHelper(), 41833, new WorldPoint(1768, 3686, 1), "Check the panel on the wall.", new Requirement[0]);
        this.climbUpPillarLeglessFaun = new ObjectStep(this.getQuestHelper(), 41836, new WorldPoint(1772, 3680, 0), "Climb up the pillar west of Martin Holt.", new Requirement[0]);
        this.climbDownLeglessFaun = new ObjectStep(this.getQuestHelper(), 41839, new WorldPoint(1772, 3679, 1), "Climb down the wall.", new Requirement[0]);
        this.moveArceuusStatue = new ObjectStep(this.getQuestHelper(), 41842, new WorldPoint(1777, 3686, 0), "Inspect the Arceuus statue.", new Requirement[0]);
        this.moveArceuusStatue.addDialogStep("Press it in.");
        this.movePiscStatue = new ObjectStep(this.getQuestHelper(), 41848, new WorldPoint(1780, 3687, 0), "Inspect the Piscarilius statue.", new Requirement[0]);
        this.movePiscStatue.addDialogStep("Press it in.");
        this.moveHosidiusStatue = new ObjectStep(this.getQuestHelper(), 41844, new WorldPoint(1780, 3677, 0), "Inspect the Hosidius statue.", new Requirement[0]);
        this.moveHosidiusStatue.addDialogStep("Press it in.");
        this.moveLovakengjStatue = new ObjectStep(this.getQuestHelper(), 41846, new WorldPoint(1776, 3682, 0), "Inspect the Lovakengj statue.", new Requirement[0]);
        this.moveLovakengjStatue.addDialogStep("Press it in.");
        this.moveShayzienStatue = new ObjectStep(this.getQuestHelper(), 41850, new WorldPoint(1777, 3678, 0), "Inspect the Shayzien statue.", new Requirement[0]);
        this.moveShayzienStatue.addDialogStep("Press it in.");
        this.invalidState = new DetailedQuestStep(this.getQuestHelper(), "You've inspected the statues in the wrong order. Inspect the remaining statues to reset the puzzle.", new Requirement[0]);
        this.statueMap.put(KourendCities.ARCEUUS, this.moveArceuusStatue);
        this.statueMap.put(KourendCities.HOSIDIUS, this.moveHosidiusStatue);
        this.statueMap.put(KourendCities.PISCARILIUS, this.movePiscStatue);
        this.statueMap.put(KourendCities.LOVAKENGJ, this.moveLovakengjStatue);
        this.statueMap.put(KourendCities.SHAYZIEN, this.moveShayzienStatue);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.checkPanel, this.climbUpPillarLeglessFaun, this.climbDownLeglessFaun, this.moveArceuusStatue, this.moveHosidiusStatue, this.moveLovakengjStatue, this.moveShayzienStatue, this.movePiscStatue, this.invalidState);
    }

    public static enum KourendCities {
        HOSIDIUS,
        ARCEUUS,
        SHAYZIEN,
        LOVAKENGJ,
        PISCARILIUS;


        public int getPos() {
            KourendCities[] cities = KourendCities.values();
            for (int i = 0; i < cities.length; ++i) {
                if (cities[i] != this) continue;
                return i + 1;
            }
            return 0;
        }
    }
}

