/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.mischelpers.knightswaves;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KNIGHT_WAVES_TRAINING_GROUNDS)
public class KnightWaves
extends BasicQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement poisonedWeapon;
    ItemRequirement food;
    ItemRequirement potions;
    QuestStep talkToSquire;
    QuestStep enterGrounds;
    QuestStep killKnights;
    QuestStep goToFloor1;
    QuestStep goToFloor2;
    ConditionalStep talkToSquireSteps;
    ConditionalStep killKnightsSteps;
    Zone floor1;
    Zone floor2;
    Zone room;
    Requirement onFloor2;
    Requirement onFloor1;
    Requirement inRoom;
    Requirement talkedToSquire;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doQuest = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToSquireSteps, new Requirement[0]);
        doQuest.addStep(this.talkedToSquire, this.killKnightsSteps);
        steps.put(0, doQuest);
        steps.put(1, doQuest);
        steps.put(2, doQuest);
        steps.put(3, doQuest);
        steps.put(4, doQuest);
        steps.put(5, doQuest);
        steps.put(6, doQuest);
        steps.put(7, doQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.floor1 = new Zone(new WorldPoint(2740, 3480, 1), new WorldPoint(2770, 3518, 1));
        this.floor2 = new Zone(new WorldPoint(2740, 3480, 2), new WorldPoint(2770, 3518, 2));
        this.room = new Zone(new WorldPoint(2752, 3502, 2), new WorldPoint(2764, 3513, 2));
        this.onFloor1 = new ZoneRequirement(this.floor1);
        this.onFloor2 = new ZoneRequirement(this.floor2);
        this.inRoom = new ZoneRequirement(this.room);
        this.combatGear = new ItemRequirement("Melee combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getMeleeCombatGear());
        this.poisonedWeapon = new ItemRequirement("Poisoned weapon such as Dragon dagger (p++)", 5698);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, 25);
        this.potions = new ItemRequirement("Attack and strength potions for boost", -1, -1);
        this.talkedToSquire = new VarbitRequirement(3908, 1);
    }

    public void setupSteps() {
        this.goToFloor1 = new ObjectStep((QuestHelper)this, 26107, new WorldPoint(2747, 3493, 0), "Climb the south west ladder of Camelot.", new Requirement[0]);
        this.goToFloor2 = new ObjectStep((QuestHelper)this, 26107, new WorldPoint(2749, 3491, 1), "Climb up to the roof.", new Requirement[0]);
        this.talkToSquire = new NpcStep((QuestHelper)this, 4353, new WorldPoint(2750, 3507, 2), "", new Requirement[0]);
        this.talkToSquireSteps = new ConditionalStep((QuestHelper)this, this.goToFloor1, "Talk to the Squire on the roof of Camelot.", this.combatGear, this.poisonedWeapon, this.food, this.potions);
        this.talkToSquireSteps.addStep(this.onFloor2, this.talkToSquire);
        this.talkToSquireSteps.addStep(this.onFloor1, this.goToFloor2);
        this.enterGrounds = new ObjectStep((QuestHelper)this, 25595, new WorldPoint(2751, 3508, 2), "Enter the room to fight.", new Requirement[0]);
        this.killKnights = new NpcStep((QuestHelper)this, 4356, new WorldPoint(2757, 3507, 2), "", true, new Requirement[0]);
        ((NpcStep)this.killKnights).addAlternateNpcs(4348, 4345, 4361, 4347, 4350, 4360, 4346, 4359, 4343, 4358, 4342, 4357, 4349, 4352, 4355, 4344, 4354);
        ((NpcStep)this.killKnights).addSafeSpots(new WorldPoint(2752, 3511, 2));
        ((NpcStep)this.killKnights).addTileMarker(new WorldPoint(2753, 3510, 2), 1452);
        this.killKnightsSteps = new ConditionalStep((QuestHelper)this, this.goToFloor1, "Defeat the 8 Knights of the Round Table in the room on top of Camelot. It's recommended to flinch the knights on one of the dummies around the room, and use a poisoned weapon to make the process even easier.", this.combatGear, this.poisonedWeapon, this.food, this.potions);
        this.killKnightsSteps.addStep(this.inRoom, this.killKnights);
        this.killKnightsSteps.addStep(this.onFloor2, this.enterGrounds);
        this.killKnightsSteps.addStep(this.onFloor1, this.goToFloor2);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.KINGS_RANSOM, QuestState.FINISHED));
        return req;
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.poisonedWeapon, this.food, this.potions);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.ATTACK, 20000), new ExperienceReward(Skill.STRENGTH, 20000), new ExperienceReward(Skill.DEFENCE, 20000), new ExperienceReward(Skill.HITPOINTS, 20000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to Chivalry Prayer (60 Prayer & 65 Defence)"), new UnlockReward("Access to Piety (70 Prayer & 70 Defence)"), new UnlockReward("Ability to change your spawn point to Camelot."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Complete the Knight Waves", Arrays.asList(this.talkToSquireSteps, this.killKnightsSteps), this.combatGear, this.poisonedWeapon, this.food, this.potions));
        return allSteps;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("8 Knights of the Round Table (levels 110-127)");
    }
}

