/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.mischelpers.herbrun;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.mischelpers.herbrun.FarmingHandler;
import com.questhelper.helpers.mischelpers.herbrun.FarmingPatch;
import com.questhelper.helpers.mischelpers.herbrun.FarmingWorld;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.HelperConfig;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ManualRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.Favour;
import com.questhelper.requirements.player.FavourRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.runelite.RuneliteRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.timetracking.Tab;
import net.runelite.client.plugins.timetracking.farming.CropState;
import net.runelite.client.util.Text;

@QuestDescriptor(quest=QuestHelperQuest.HERB_RUN)
public class HerbRun
extends ComplexStateQuestHelper {
    @Inject
    private FarmingWorld farmingWorld;
    private FarmingHandler farmingHandler;
    DetailedQuestStep waitForHerbs;
    DetailedQuestStep ardougnePatch;
    DetailedQuestStep catherbyPatch;
    DetailedQuestStep faladorPatch;
    DetailedQuestStep farmingGuildPatch;
    DetailedQuestStep harmonyPatch;
    DetailedQuestStep morytaniaPatch;
    DetailedQuestStep trollStrongholdPatch;
    DetailedQuestStep weissPatch;
    DetailedQuestStep hosidiusPatch;
    DetailedQuestStep ardougnePlant;
    DetailedQuestStep catherbyPlant;
    DetailedQuestStep faladorPlant;
    DetailedQuestStep farmingGuildPlant;
    DetailedQuestStep harmonyPlant;
    DetailedQuestStep morytaniaPlant;
    DetailedQuestStep trollStrongholdPlant;
    DetailedQuestStep weissPlant;
    DetailedQuestStep hosidiusPlant;
    ItemRequirement spade;
    ItemRequirement dibber;
    ItemRequirement rake;
    ItemRequirement seed;
    ItemRequirement compost;
    ItemRequirement ectophial;
    ItemRequirement magicSec;
    ItemRequirement explorerRing2;
    ItemRequirement ardyCloak2;
    ItemRequirement xericsTalisman;
    ItemRequirement catherbyTeleport;
    ItemRequirement trollheimTeleport;
    ItemRequirement icyBasalt;
    ItemRequirement stonyBasalt;
    ItemRequirement farmingGuildTeleport;
    ItemRequirement hosidiusHouseTeleport;
    ItemRequirement gracefulHood;
    ItemRequirement gracefulTop;
    ItemRequirement gracefulLegs;
    ItemRequirement gracefulGloves;
    ItemRequirement gracefulBoots;
    ItemRequirement gracefulCape;
    ItemRequirement gracefulOutfit;
    ItemRequirement farmingHat;
    ItemRequirement farmingTop;
    ItemRequirement farmingLegs;
    ItemRequirement farmingBoots;
    ItemRequirement farmersOutfit;
    Requirement accessToHarmony;
    Requirement accessToWeiss;
    Requirement accessToTrollStronghold;
    Requirement accessToFarmingGuildPatch;
    ManualRequirement ardougneEmpty;
    ManualRequirement catherbyEmpty;
    ManualRequirement faladorEmpty;
    ManualRequirement farmingGuildEmpty;
    ManualRequirement harmonyEmpty;
    ManualRequirement morytaniaEmpty;
    ManualRequirement trollStrongholdEmpty;
    ManualRequirement weissEmpty;
    ManualRequirement hosidiusEmpty;
    ManualRequirement ardougneReady;
    ManualRequirement catherbyReady;
    ManualRequirement faladorReady;
    ManualRequirement farmingGuildReady;
    ManualRequirement harmonyReady;
    ManualRequirement morytaniaReady;
    ManualRequirement trollStrongholdReady;
    ManualRequirement weissReady;
    ManualRequirement hosidiusReady;
    private final String HERB_SEEDS = "herbSeeds";
    private final String GRACEFUL_OR_FARMING = "gracefulOrFarming";

    @Override
    public QuestStep loadStep() {
        this.farmingHandler = new FarmingHandler(this.client, this.configManager);
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        ConditionalStep steps = new ConditionalStep((QuestHelper)this, (QuestStep)this.waitForHerbs, this.spade, this.dibber, this.rake, this.seed, this.magicSec, this.farmersOutfit, this.gracefulOutfit);
        steps.addStep(this.faladorReady, this.faladorPatch);
        steps.addStep(this.faladorEmpty, this.faladorPlant);
        steps.addStep(this.ardougneReady, this.ardougnePatch);
        steps.addStep(this.ardougneEmpty, this.ardougnePlant);
        steps.addStep(this.catherbyReady, this.catherbyPatch);
        steps.addStep(this.catherbyEmpty, this.catherbyPlant);
        steps.addStep(this.morytaniaReady, this.morytaniaPatch);
        steps.addStep(this.morytaniaEmpty, this.morytaniaPlant);
        steps.addStep(this.hosidiusReady, this.hosidiusPatch);
        steps.addStep(this.hosidiusEmpty, this.hosidiusPlant);
        steps.addStep(new Conditions(this.accessToTrollStronghold, this.trollStrongholdReady), this.trollStrongholdPatch);
        steps.addStep(new Conditions(this.accessToTrollStronghold, this.trollStrongholdEmpty), this.trollStrongholdPlant);
        steps.addStep(new Conditions(this.accessToWeiss, this.weissReady), this.weissPatch);
        steps.addStep(new Conditions(this.accessToWeiss, this.weissEmpty), this.weissPlant);
        steps.addStep(new Conditions(this.accessToFarmingGuildPatch, this.farmingGuildReady), this.farmingGuildPatch);
        steps.addStep(new Conditions(this.accessToFarmingGuildPatch, this.farmingGuildEmpty), this.farmingGuildPlant);
        steps.addStep(new Conditions(this.accessToHarmony, this.harmonyReady), this.harmonyPatch);
        steps.addStep(new Conditions(this.accessToHarmony, this.harmonyEmpty), this.harmonyPlant);
        return steps;
    }

    public void setupConditions() {
        this.ardougneReady = new ManualRequirement();
        this.catherbyReady = new ManualRequirement();
        this.faladorReady = new ManualRequirement();
        this.farmingGuildReady = new ManualRequirement();
        this.harmonyReady = new ManualRequirement();
        this.morytaniaReady = new ManualRequirement();
        this.trollStrongholdReady = new ManualRequirement();
        this.weissReady = new ManualRequirement();
        this.hosidiusReady = new ManualRequirement();
        this.ardougneEmpty = new ManualRequirement();
        this.catherbyEmpty = new ManualRequirement();
        this.faladorEmpty = new ManualRequirement();
        this.farmingGuildEmpty = new ManualRequirement();
        this.harmonyEmpty = new ManualRequirement();
        this.morytaniaEmpty = new ManualRequirement();
        this.trollStrongholdEmpty = new ManualRequirement();
        this.weissEmpty = new ManualRequirement();
        this.hosidiusEmpty = new ManualRequirement();
        this.accessToHarmony = new QuestRequirement(QuestHelperQuest.THE_GREAT_BRAIN_ROBBERY, QuestState.FINISHED);
        this.accessToWeiss = new QuestRequirement(QuestHelperQuest.MAKING_FRIENDS_WITH_MY_ARM, QuestState.FINISHED);
        this.accessToTrollStronghold = new QuestRequirement(QuestHelperQuest.MY_ARMS_BIG_ADVENTURE, QuestState.FINISHED);
        this.accessToFarmingGuildPatch = new Conditions(new FavourRequirement(Favour.HOSIDIUS, 60), new SkillRequirement(Skill.FARMING, 65));
    }

    @Override
    public void setupRequirements() {
        this.spade = new ItemRequirement("Spade", 952);
        this.dibber = new ItemRequirement("Seed dibber", 5343);
        this.rake = new ItemRequirement("Rake", 5341).hideConditioned(new VarbitRequirement(5557, 2));
        this.seed = new ItemRequirement("Seeds of your choice", 5291);
        String seedName = this.configManager.getRSProfileConfiguration("questhelpervars", "herbSeeds");
        if (seedName != null) {
            try {
                this.seed.setId(Seed.valueOf((String)seedName).seedID);
            }
            catch (IllegalArgumentException err) {
                this.questHelperPlugin.getConfigManager().setRSProfileConfiguration("questhelpervars", "herbSeeds", (Object)Seed.GUAM);
            }
            this.seed.setName(Text.titleCase((Enum)Seed.valueOf(seedName)) + " seed");
        } else {
            this.questHelperPlugin.getConfigManager().setConfiguration("questhelpervars", "herbSeeds", (Object)Seed.GUAM);
        }
        this.compost = new ItemRequirement("Compost", ItemCollections.COMPOST);
        this.ectophial = new ItemRequirement("Ectophial", 4251).showConditioned(new QuestRequirement(QuestHelperQuest.GHOSTS_AHOY, QuestState.FINISHED));
        this.ectophial.addAlternates(4252);
        this.magicSec = new ItemRequirement("Magic secateurs", 7409).showConditioned(new QuestRequirement(QuestHelperQuest.FAIRYTALE_I__GROWING_PAINS, QuestState.FINISHED));
        this.explorerRing2 = new ItemRequirement("Explorers' ring 2+", 13126).showConditioned(new QuestRequirement(QuestHelperQuest.LUMBRIDGE_MEDIUM, QuestState.FINISHED));
        this.explorerRing2.addAlternates(13127, 13128);
        this.ardyCloak2 = new ItemRequirement("Ardougne cloak 2+", 13122).showConditioned(new QuestRequirement(QuestHelperQuest.ARDOUGNE_MEDIUM, QuestState.FINISHED));
        this.ardyCloak2.addAlternates(13123, 13124);
        this.xericsTalisman = new ItemRequirement("Xeric's talisman", 13393);
        this.hosidiusHouseTeleport = new ItemRequirement("Teleport to Hosidius House", 19651);
        this.hosidiusHouseTeleport.addAlternates(13393);
        ItemRequirements catherbyRunes = new ItemRequirements("Catherby teleport runes", new ItemRequirement("Law rune", 563), new ItemRequirement("Air rune", 556, 5));
        ItemRequirement catherbyTablet = new ItemRequirement("Catherby tablet", 24961);
        this.catherbyTeleport = new ItemRequirements(LogicType.OR, "Catherby teleport", catherbyRunes, catherbyTablet);
        ItemRequirements trollheimRunes = new ItemRequirements("Trollheim teleport runes", new ItemRequirement("Law rune", 563, 2), new ItemRequirement("Fire rune", 554, 2));
        ItemRequirement trollheimTablet = new ItemRequirement("Trollheim tablet", 11747);
        this.trollheimTeleport = new ItemRequirements(LogicType.OR, "Trollheim teleport", trollheimRunes, trollheimTablet).hideConditioned(new QuestRequirement(QuestHelperQuest.MAKING_FRIENDS_WITH_MY_ARM, QuestState.FINISHED));
        this.icyBasalt = new ItemRequirement("Icy basalt", 22599).showConditioned(new QuestRequirement(QuestHelperQuest.MAKING_FRIENDS_WITH_MY_ARM, QuestState.FINISHED));
        this.stonyBasalt = new ItemRequirement("Stony basalt", 22601).showConditioned(new QuestRequirement(QuestHelperQuest.MAKING_FRIENDS_WITH_MY_ARM, QuestState.FINISHED));
        this.farmingGuildTeleport = new ItemRequirement("Farming guild teleport (Skills' Necklace or CIR fairy ring)", 9811).showConditioned(this.accessToFarmingGuildPatch);
        this.farmingGuildTeleport.addAlternates(9810);
        this.farmingGuildTeleport.addAlternates(ItemCollections.SKILLS_NECKLACES);
        this.farmingGuildTeleport.addAlternates(ItemCollections.FAIRY_STAFF);
        this.gracefulHood = new ItemRequirement("Graceful hood", ItemCollections.GRACEFUL_HOOD, 1, true).isNotConsumed();
        this.gracefulTop = new ItemRequirement("Graceful top", ItemCollections.GRACEFUL_TOP, 1, true).isNotConsumed();
        this.gracefulLegs = new ItemRequirement("Graceful legs", ItemCollections.GRACEFUL_LEGS, 1, true).isNotConsumed();
        this.gracefulCape = new ItemRequirement("Graceful cape", ItemCollections.GRACEFUL_CAPE, 1, true).isNotConsumed();
        this.gracefulGloves = new ItemRequirement("Graceful gloves", ItemCollections.GRACEFUL_GLOVES, 1, true).isNotConsumed();
        this.gracefulBoots = new ItemRequirement("Graceful boots", ItemCollections.GRACEFUL_BOOTS, 1, true).isNotConsumed();
        this.gracefulBoots.addAlternates(88);
        this.gracefulOutfit = new ItemRequirements("Graceful outfit (equipped)", this.gracefulHood, this.gracefulTop, this.gracefulLegs, this.gracefulGloves, this.gracefulBoots, this.gracefulCape).isNotConsumed().showConditioned(new RuneliteRequirement(this.configManager, "gracefulOrFarming", GracefulOrFarming.GRACEFUL.name()));
        this.farmingHat = new ItemRequirement("Farmer's strawhat", 13646, 1, true).isNotConsumed();
        this.farmingHat.addAlternates(13647, 21253, 21254);
        this.farmingTop = new ItemRequirement("Farmer's top", 13642, 1, true).isNotConsumed();
        this.farmingTop.addAlternates(13643);
        this.farmingLegs = new ItemRequirement("Farmer's boro trousers", 13640, 1, true).isNotConsumed();
        this.farmingLegs.addAlternates(13641);
        this.farmingBoots = new ItemRequirement("Graceful cape", 13644, 1, true).isNotConsumed();
        this.farmingBoots.addAlternates(13645);
        this.farmersOutfit = new ItemRequirements("Farmer's outfit (equipped)", this.farmingHat, this.farmingTop, this.farmingLegs, this.farmingBoots).isNotConsumed().showConditioned(new RuneliteRequirement(this.configManager, "gracefulOrFarming", GracefulOrFarming.FARMING.name()));
    }

    public void setupSteps() {
        this.waitForHerbs = new DetailedQuestStep((QuestHelper)this, "Wait for your herbs to grow.", new Requirement[0]);
        this.ardougnePatch = new ObjectStep((QuestHelper)this, 8152, new WorldPoint(2670, 3374, 0), "Harvest your herbs from the Ardougne patch.", this.ardyCloak2);
        this.catherbyPatch = new ObjectStep((QuestHelper)this, 8151, new WorldPoint(2813, 3463, 0), "Harvest your herbs from the Catherby patch.", this.catherbyTeleport);
        this.faladorPatch = new ObjectStep((QuestHelper)this, 8150, new WorldPoint(3058, 3311, 0), "Harvest your herbs from the Falador patch.", this.explorerRing2);
        this.hosidiusPatch = new ObjectStep((QuestHelper)this, 27115, new WorldPoint(1738, 3550, 0), "Harvest your herbs from the Hosidius patch.", this.xericsTalisman);
        this.farmingGuildPatch = new ObjectStep((QuestHelper)this, 38979, new WorldPoint(1238, 3726, 0), "Harvest your herbs from the Farming Guild patch.", this.farmingGuildTeleport);
        this.farmingGuildPatch.conditionToHideInSidebar(new Conditions(LogicType.NOR, this.accessToFarmingGuildPatch));
        this.harmonyPatch = new ObjectStep((QuestHelper)this, 9372, new WorldPoint(3789, 2837, 0), "Harvest your herbs from the Harmony patch.", this.ectophial);
        this.harmonyPatch.conditionToHideInSidebar(new Conditions(LogicType.NOR, this.accessToHarmony));
        this.morytaniaPatch = new ObjectStep((QuestHelper)this, 8153, new WorldPoint(3605, 3529, 0), "Harvest your herbs from the Morytania patch.", this.ectophial);
        this.trollStrongholdPatch = new ObjectStep((QuestHelper)this, 18816, new WorldPoint(2826, 3694, 0), "Harvest your herbs from the Troll Stronghold patch.", this.trollheimTeleport, this.stonyBasalt);
        this.trollStrongholdPatch.conditionToHideInSidebar(new Conditions(LogicType.NOR, this.accessToTrollStronghold));
        this.weissPatch = new ObjectStep((QuestHelper)this, 33176, new WorldPoint(2848, 3934, 0), "Harvest your herbs from the Weiss patch.", this.icyBasalt);
        this.weissPatch.conditionToHideInSidebar(new Conditions(LogicType.NOR, this.accessToWeiss));
        this.ardougnePlant = new ObjectStep((QuestHelper)this, 8152, new WorldPoint(2670, 3374, 0), "Plant your seeds into the Ardougne patch.", this.ardyCloak2);
        this.ardougnePlant.addIcon(5295);
        this.ardougnePatch.addSubSteps(this.ardougnePlant);
        this.catherbyPlant = new ObjectStep((QuestHelper)this, 8151, new WorldPoint(2813, 3463, 0), "Plant your seeds into the Catherby patch.", this.catherbyTeleport);
        this.catherbyPlant.addIcon(5295);
        this.catherbyPatch.addSubSteps(this.catherbyPlant);
        this.faladorPlant = new ObjectStep((QuestHelper)this, 8150, new WorldPoint(3058, 3311, 0), "Plant your seeds into the Falador patch.", this.explorerRing2);
        this.faladorPlant.addIcon(5295);
        this.faladorPatch.addSubSteps(this.faladorPlant);
        this.hosidiusPlant = new ObjectStep((QuestHelper)this, 27115, new WorldPoint(1738, 3550, 0), "Plant your seeds into the Hosidius patch.", this.hosidiusHouseTeleport);
        this.hosidiusPlant.addIcon(5295);
        this.hosidiusPlant.addSubSteps(this.hosidiusPlant);
        this.farmingGuildPlant = new ObjectStep((QuestHelper)this, 33979, new WorldPoint(1238, 3726, 0), "Plant your seeds into the Farming Guild patch.", this.farmingGuildTeleport);
        this.farmingGuildPlant.conditionToHideInSidebar(new Conditions(LogicType.NOR, this.accessToFarmingGuildPatch));
        this.farmingGuildPlant.addIcon(5295);
        this.farmingGuildPatch.addSubSteps(this.farmingGuildPlant);
        this.harmonyPlant = new ObjectStep((QuestHelper)this, 9372, new WorldPoint(3789, 2837, 0), "Plant your seeds into the Harmony patch.", this.ectophial);
        this.harmonyPlant.conditionToHideInSidebar(new Conditions(LogicType.NOR, this.accessToHarmony));
        this.harmonyPlant.addIcon(5295);
        this.harmonyPatch.addSubSteps(this.harmonyPlant);
        this.morytaniaPlant = new ObjectStep((QuestHelper)this, 8153, new WorldPoint(3605, 3529, 0), "Plant your seeds into the Morytania patch.", this.ectophial);
        this.morytaniaPlant.addIcon(5295);
        this.morytaniaPatch.addSubSteps(this.morytaniaPlant);
        this.trollStrongholdPlant = new ObjectStep((QuestHelper)this, 18816, new WorldPoint(2826, 3694, 0), "Plant your seeds into the Troll Stronghold patch.", this.trollheimTeleport, this.stonyBasalt);
        this.trollStrongholdPlant.conditionToHideInSidebar(new Conditions(LogicType.NOR, this.accessToTrollStronghold));
        this.trollStrongholdPlant.addIcon(5295);
        this.trollStrongholdPatch.addSubSteps(this.trollStrongholdPlant);
        this.weissPlant = new ObjectStep((QuestHelper)this, 33176, new WorldPoint(2848, 3934, 0), "Plant your seeds into the Weiss patch.", this.icyBasalt);
        this.weissPlant.conditionToHideInSidebar(new Conditions(LogicType.NOR, this.accessToWeiss));
        this.weissPlant.addIcon(5295);
        this.weissPatch.addSubSteps(this.weissPlant);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("questhelpervars")) {
            return;
        }
        if (event.getKey().equals("herbSeeds")) {
            try {
                Seed selectedSeed = Seed.valueOf(event.getNewValue());
                this.seed.setId(selectedSeed.seedID);
                this.seed.setName(Text.titleCase((Enum)selectedSeed) + " seed");
                this.questHelperPlugin.refreshBank();
            }
            catch (IllegalArgumentException err) {
                this.questHelperPlugin.getConfigManager().setConfiguration("questhelpervars", "herbSeeds", (Object)Seed.GUAM);
            }
        }
        if (event.getKey().equals("gracefulOrFarming")) {
            this.questHelperPlugin.refreshBank();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        for (FarmingPatch patch : this.farmingWorld.getTabs().get(Tab.HERB)) {
            CropState state = this.farmingHandler.predictPatch(patch);
            boolean isHarvestable = state == CropState.HARVESTABLE;
            boolean isPlantable = state == CropState.EMPTY || state == CropState.DEAD;
            switch (patch.getRegion().getName()) {
                case "Ardougne": {
                    this.ardougneReady.setShouldPass(isHarvestable);
                    this.ardougneEmpty.setShouldPass(isPlantable);
                    break;
                }
                case "Catherby": {
                    this.catherbyReady.setShouldPass(isHarvestable);
                    this.catherbyEmpty.setShouldPass(isPlantable);
                    break;
                }
                case "Falador": {
                    this.faladorReady.setShouldPass(isHarvestable);
                    this.faladorEmpty.setShouldPass(isPlantable);
                    break;
                }
                case "Farming Guild": {
                    this.farmingGuildReady.setShouldPass(isHarvestable);
                    this.farmingGuildEmpty.setShouldPass(isPlantable);
                    break;
                }
                case "Harmony": {
                    this.harmonyReady.setShouldPass(isHarvestable);
                    this.harmonyEmpty.setShouldPass(isPlantable);
                    break;
                }
                case "Morytania": {
                    this.morytaniaReady.setShouldPass(isHarvestable);
                    this.morytaniaEmpty.setShouldPass(isPlantable);
                    break;
                }
                case "Kourend": {
                    this.hosidiusReady.setShouldPass(isHarvestable);
                    this.hosidiusEmpty.setShouldPass(isPlantable);
                    break;
                }
                case "Troll Stronghold": {
                    this.trollStrongholdReady.setShouldPass(isHarvestable);
                    this.trollStrongholdEmpty.setShouldPass(isPlantable);
                    break;
                }
                case "Weiss": {
                    this.weissReady.setShouldPass(isHarvestable);
                    this.weissEmpty.setShouldPass(isPlantable);
                }
            }
        }
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.spade, this.dibber, this.rake, this.seed);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.ectophial, this.magicSec, this.explorerRing2, this.ardyCloak2, this.xericsTalisman, this.hosidiusHouseTeleport, this.catherbyTeleport, this.trollheimTeleport, this.icyBasalt, this.stonyBasalt, this.farmingGuildTeleport, this.gracefulOutfit, this.farmersOutfit);
    }

    @Override
    public List<HelperConfig> getConfigs() {
        HelperConfig seedsConfig = new HelperConfig("Seeds", "herbSeeds", Seed.values());
        HelperConfig outfitConfig = new HelperConfig("Outfit", "gracefulOrFarming", GracefulOrFarming.values());
        return Arrays.asList(seedsConfig, outfitConfig);
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Farm run", Arrays.asList(this.faladorPatch, this.ardougnePatch, this.catherbyPatch, this.morytaniaPatch, this.hosidiusPatch, this.trollStrongholdPatch, this.weissPatch, this.farmingGuildPatch, this.harmonyPatch), Arrays.asList(this.spade, this.dibber, this.rake, this.seed, this.magicSec), Arrays.asList(this.ectophial, this.magicSec, this.explorerRing2, this.ardyCloak2, this.xericsTalisman, this.catherbyTeleport, this.trollheimTeleport, this.icyBasalt, this.stonyBasalt, this.farmingGuildTeleport, this.gracefulOutfit, this.farmersOutfit)));
        return allSteps;
    }

    private static enum GracefulOrFarming {
        NONE,
        GRACEFUL,
        FARMING;

    }

    private static enum Seed {
        GUAM(5291),
        MARRENTILL(5292),
        TARROMIN(5293),
        HARRALANDER(5294),
        RANARR(5295),
        TOADFLAX(5296),
        IRIT(5297),
        AVANTOE(5298),
        KWUARM(5299),
        SNAPDRAGON(5300),
        CADANTINE(5301),
        LATANDYME(5302),
        DWARF_WEED(5303),
        TORSTOL(5304);

        final int seedID;

        private Seed(int seedID) {
            this.seedID = seedID;
        }
    }
}

