/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.mischelpers.herbrun;

import com.questhelper.helpers.mischelpers.herbrun.FarmingPatch;
import com.questhelper.helpers.mischelpers.herbrun.PatchState;
import java.time.Instant;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.timetracking.farming.CropState;
import net.runelite.client.plugins.timetracking.farming.Produce;

public class FarmingHandler {
    private final Client client;
    private final ConfigManager configManager;

    public FarmingHandler(Client client, ConfigManager configManager) {
        this.client = client;
        this.configManager = configManager;
    }

    public CropState predictPatch(FarmingPatch patch) {
        return this.predictPatch(patch, this.configManager.getRSProfileKey());
    }

    @Nullable
    public CropState predictPatch(FarmingPatch patch, String profile) {
        boolean botanist;
        PatchState state;
        long unixNow = Instant.now().getEpochSecond();
        String key = patch.configKey();
        String storedValue = this.configManager.getConfiguration("timetracking", profile, key);
        if (storedValue == null) {
            return null;
        }
        long unixTime = 0L;
        int value = 0;
        String[] parts = storedValue.split(":");
        if (parts.length == 2) {
            try {
                value = Integer.parseInt(parts[0]);
                unixTime = Long.parseLong(parts[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((state = patch.getImplementation().forVarbitValue(value)) == null) {
            return null;
        }
        if (state.getCropState() == CropState.EMPTY) {
            return CropState.EMPTY;
        }
        if (state.getProduce() == Produce.WEEDS) {
            return CropState.EMPTY;
        }
        if (state.getCropState() == CropState.DEAD) {
            return CropState.DEAD;
        }
        if (unixTime <= 0L) {
            return null;
        }
        int stage = state.getStage();
        int stages = state.getStages();
        int tickrate = state.getTickRate();
        boolean bl = botanist = this.client.getVarbitValue(10053) == 1;
        if (botanist) {
            tickrate /= 5;
        }
        long doneEstimate = 0L;
        if (tickrate > 0) {
            long tickTime = this.getTickTime(tickrate, 0, unixTime, profile);
            doneEstimate = this.getTickTime(tickrate, stages - 1 - stage, tickTime, profile);
        }
        if (unixNow >= doneEstimate) {
            return CropState.HARVESTABLE;
        }
        return CropState.GROWING;
    }

    public long getTickTime(int tickRate, int ticks, long requestedTime, String profile) {
        Integer offsetPrecisionMins = (Integer)this.configManager.getConfiguration("timetracking", profile, "farmTickOffsetPrecision", Integer.TYPE);
        Integer offsetTimeMins = (Integer)this.configManager.getConfiguration("timetracking", profile, "farmTickOffset", Integer.TYPE);
        long calculatedOffsetTime = 0L;
        if (offsetPrecisionMins != null && offsetTimeMins != null && (offsetPrecisionMins >= tickRate || offsetPrecisionMins >= 40)) {
            calculatedOffsetTime = (long)(offsetTimeMins % tickRate) * 60L;
        }
        long unixNow = requestedTime + calculatedOffsetTime;
        long timeOfCurrentTick = unixNow - unixNow % ((long)tickRate * 60L);
        long timeOfGoalTick = timeOfCurrentTick + (long)ticks * (long)tickRate * 60L;
        return timeOfGoalTick - calculatedOffsetTime;
    }
}

