/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.mischelpers.allneededitems;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@QuestDescriptor(quest=QuestHelperQuest.CHECK_ITEMS)
public class AllNeededItems
extends ComplexStateQuestHelper {
    DetailedQuestStep step1;

    @Override
    public QuestStep loadStep() {
        LinkedHashMap reqs = new LinkedHashMap();
        this.questHelperPlugin.itemRequirements.forEach((qhQuest, questReqs) -> this.refinedList(qhQuest.getName(), reqs, (List<ItemRequirement>)questReqs));
        this.questHelperPlugin.itemRecommended.forEach((qhQuest, questRecommended) -> this.refinedList(qhQuest.getName(), reqs, (List<ItemRequirement>)questRecommended));
        this.step1 = new DetailedQuestStep((QuestHelper)this, "Get all items you need. You can have items being highlighted that you need without running this helper if you activate it in the Quest Helper settings.", new ArrayList<Requirement>(reqs.values()));
        this.step1.hideRequirements = true;
        this.step1.considerBankForItemHighlight = true;
        this.step1.iconToUseForNeededItems = 776;
        return this.step1;
    }

    private List<ItemRequirement> refinedList(String questName, Map<Integer, ItemRequirement> compressedReqs, List<ItemRequirement> reqs) {
        Iterator<ItemRequirement> iterator = reqs.iterator();
        while (iterator.hasNext()) {
            ItemRequirement req;
            ItemRequirement newReq = req = iterator.next();
            if (req.getId() == -1) continue;
            if (req.getQuantity() == -1) {
                newReq = req.quantity(1);
            }
            if (!compressedReqs.containsKey(newReq.getId())) {
                ItemRequirement freshReq = new ItemRequirement(req.getName(), newReq.getId(), newReq.getQuantity());
                String tip = "Needed for " + questName;
                freshReq.setTooltip(tip);
                compressedReqs.put(newReq.getId(), freshReq);
                continue;
            }
            ItemRequirement currentReq = compressedReqs.get(newReq.getId());
            currentReq.appendToTooltip(questName);
            if (!newReq.isConsumedItem()) continue;
            currentReq.setQuantity(currentReq.getQuantity() + newReq.getQuantity());
        }
        return new ArrayList<ItemRequirement>(compressedReqs.values());
    }

    @Override
    public void setupRequirements() {
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        LinkedHashMap reqs = new LinkedHashMap();
        this.questHelperPlugin.itemRequirements.forEach((qhQuest, questReqs) -> this.refinedList(qhQuest.getName(), reqs, (List<ItemRequirement>)questReqs));
        return new ArrayList<ItemRequirement>(reqs.values());
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        LinkedHashMap reqs = new LinkedHashMap();
        this.questHelperPlugin.itemRecommended.forEach((qhQuest, questRecs) -> this.refinedList(qhQuest.getName(), reqs, (List<ItemRequirement>)questRecs));
        return new ArrayList<ItemRequirement>(reqs.values());
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.step1), new Requirement[0]));
        LinkedHashMap questsReq = new LinkedHashMap();
        LinkedHashMap miniquestsReq = new LinkedHashMap();
        LinkedHashMap diariesReq = new LinkedHashMap();
        LinkedHashMap questsRec = new LinkedHashMap();
        LinkedHashMap miniquestsRec = new LinkedHashMap();
        LinkedHashMap diariesRec = new LinkedHashMap();
        this.questHelperPlugin.itemRequirements.forEach((qhQuest, reqs) -> {
            QuestDetails.Type type = qhQuest.getQuestType();
            if (type == QuestDetails.Type.P2P || type == QuestDetails.Type.F2P) {
                this.refinedList(qhQuest.getName(), questsReq, (List<ItemRequirement>)reqs);
            } else if (type == QuestDetails.Type.MINIQUEST) {
                this.refinedList(qhQuest.getName(), miniquestsReq, (List<ItemRequirement>)reqs);
            } else if (type == QuestDetails.Type.ACHIEVEMENT_DIARY) {
                this.refinedList(qhQuest.getName(), diariesReq, (List<ItemRequirement>)reqs);
            }
        });
        this.questHelperPlugin.itemRecommended.forEach((qhQuest, reqs) -> {
            QuestDetails.Type type = qhQuest.getQuestType();
            if (type == QuestDetails.Type.P2P || type == QuestDetails.Type.F2P) {
                this.refinedList(qhQuest.getName(), questsRec, (List<ItemRequirement>)reqs);
            } else if (type == QuestDetails.Type.MINIQUEST) {
                this.refinedList(qhQuest.getName(), miniquestsRec, (List<ItemRequirement>)reqs);
            } else if (type == QuestDetails.Type.ACHIEVEMENT_DIARY) {
                this.refinedList(qhQuest.getName(), diariesRec, (List<ItemRequirement>)reqs);
            }
        });
        if (questsReq.size() > 0) {
            allSteps.add(new PanelDetails("Quests", Collections.emptyList(), new ArrayList<Requirement>(questsReq.values()), new ArrayList<Requirement>(questsRec.values())));
        }
        if (miniquestsReq.size() > 0) {
            allSteps.add(new PanelDetails("Miniquests", Collections.emptyList(), new ArrayList<Requirement>(miniquestsReq.values()), new ArrayList<Requirement>(miniquestsRec.values())));
        }
        if (diariesReq.size() > 0) {
            allSteps.add(new PanelDetails("Achievement Diaries", Collections.emptyList(), new ArrayList<Requirement>(diariesReq.values()), new ArrayList<Requirement>(diariesRec.values())));
        }
        return allSteps;
    }
}

