/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.themagearenaii;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.miniquests.themagearenaii.MageArenaBossStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_MAGE_ARENA_II)
public class TheMageArenaII
extends BasicQuestHelper {
    ItemRequirement zamorakStaff;
    ItemRequirement guthixStaff;
    ItemRequirement saradominStaff;
    ItemRequirement runesForCasts;
    ItemRequirement magicCombatGear;
    ItemRequirement knife;
    ItemRequirement brews;
    ItemRequirement restores;
    ItemRequirement food;
    ItemRequirement recoils;
    ItemRequirement enchantedSymbol;
    ItemRequirement justicarsHand;
    ItemRequirement demonsHeart;
    ItemRequirement entRoots;
    ItemRequirement godCape;
    Requirement inCavern;
    Requirement givenHand;
    Requirement givenHeart;
    Requirement givenRoots;
    QuestStep enterCavern;
    QuestStep talkToKolodion;
    QuestStep locateFollowerSara;
    QuestStep locateFollowerGuthix;
    QuestStep locateFollowerZammy;
    QuestStep enterCavernWithHand;
    QuestStep enterCavernWithHeart;
    QuestStep enterCavernWithRoots;
    QuestStep giveKolodionHeart;
    QuestStep giveKolodionHand;
    QuestStep giveKolodionRoots;
    QuestStep locateAndKillMinions;
    QuestStep enterCavernAfterMinions;
    QuestStep talkToKolodionAfterMinions;
    QuestStep useGodCapeOnKolidion;
    Zone cavern;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goTalkToKolodion = new ConditionalStep((QuestHelper)this, this.enterCavern, new Requirement[0]);
        goTalkToKolodion.addStep(this.inCavern, this.talkToKolodion);
        steps.put(0, goTalkToKolodion);
        steps.put(1, goTalkToKolodion);
        ConditionalStep goKillMinions = new ConditionalStep((QuestHelper)this, this.locateFollowerSara, new Requirement[0]);
        goKillMinions.addStep(new Conditions(this.inCavern, this.givenRoots, this.givenHand, this.givenHeart), this.talkToKolodionAfterMinions);
        goKillMinions.addStep(new Conditions(this.givenRoots, this.givenHand, this.givenHeart), this.enterCavernAfterMinions);
        goKillMinions.addStep(new Conditions(this.inCavern, this.demonsHeart), this.giveKolodionHeart);
        goKillMinions.addStep(this.demonsHeart, this.enterCavernWithHeart);
        goKillMinions.addStep(new Conditions(this.givenHand, this.givenRoots), this.locateFollowerZammy);
        goKillMinions.addStep(new Conditions(this.inCavern, this.entRoots.alsoCheckBank(this.questBank)), this.giveKolodionRoots);
        goKillMinions.addStep(this.entRoots.alsoCheckBank(this.questBank), this.enterCavernWithRoots);
        goKillMinions.addStep(this.givenHand, this.locateFollowerGuthix);
        goKillMinions.addStep(new Conditions(this.inCavern, this.justicarsHand.alsoCheckBank(this.questBank)), this.giveKolodionHand);
        goKillMinions.addStep(this.justicarsHand.alsoCheckBank(this.questBank), this.enterCavernWithHand);
        steps.put(2, goKillMinions);
        ConditionalStep goImbueCape = new ConditionalStep((QuestHelper)this, this.enterCavernAfterMinions, new Requirement[0]);
        goImbueCape.addStep(this.inCavern, this.useGodCapeOnKolidion);
        steps.put(3, goImbueCape);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.zamorakStaff = new ItemRequirement("Zamorak staff", 2417).isNotConsumed();
        this.zamorakStaff.setTooltip("You can buy one from the Chamber Guardian in the Mage Arena Cavern for 80k");
        this.guthixStaff = new ItemRequirement("Guthix staff", 2416).isNotConsumed();
        this.guthixStaff.setTooltip("You can buy one from the Chamber Guardian in the Mage Arena Cavern for 80k");
        this.saradominStaff = new ItemRequirement("Saradomin staff", 2415).isNotConsumed();
        this.saradominStaff.setTooltip("You can buy one from the Chamber Guardian in the Mage Arena Cavern for 80k");
        this.runesForCasts = new ItemRequirements("Runes for 50+ casts of god spells", new ItemRequirement("Blood runes", 565, -1), new ItemRequirement("Air runes", 556, -1), new ItemRequirement("Fire runes", 554, -1));
        this.magicCombatGear = new ItemRequirement("Magic combat gear", -1, 1).isNotConsumed();
        this.magicCombatGear.setDisplayItemId(BankSlotIcons.getMagicCombatGear());
        this.knife = new ItemRequirement("Knife or sharp weapon to cut through a web", 946).isNotConsumed();
        this.brews = new ItemRequirement("Saradomin brews", ItemCollections.SARADOMIN_BREWS, -1);
        this.restores = new ItemRequirement("Super restores", ItemCollections.SUPER_RESTORE_POTIONS, -1);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.recoils = new ItemRequirement("Rings of recoil", 2550);
        this.enchantedSymbol = new ItemRequirement("Enchanted symbol", 21800);
        this.enchantedSymbol.setTooltip("You can get another from Kolodion in the Mage Arena Cavern.");
        this.justicarsHand = new ItemRequirement("Justicar's hand", 21797);
        this.demonsHeart = new ItemRequirement("Demon's heart", 21799);
        this.entRoots = new ItemRequirement("Ent's roots", 21798);
        this.godCape = new ItemRequirement("God cape", 2414).isNotConsumed();
        this.godCape.addAlternates(2413, 2412);
        this.godCape.setHighlightInInventory(true);
    }

    public void loadZones() {
        this.cavern = new Zone(new WorldPoint(2529, 4709, 0), new WorldPoint(2550, 4725, 0));
    }

    public void setupConditions() {
        this.inCavern = new ZoneRequirement(this.cavern);
        this.givenHand = new VarbitRequirement(6063, 1);
        this.givenRoots = new VarbitRequirement(6064, 1);
        this.givenHeart = new VarbitRequirement(6065, 1);
    }

    public void setupSteps() {
        this.enterCavern = new ObjectStep((QuestHelper)this, 5959, new WorldPoint(3090, 3956, 0), "Pull the lever in the building north of the Mage Arena. This is IN THE WILDERNESS, so don't bring anything you don't want to lose.", this.knife);
        this.talkToKolodion = new NpcStep((QuestHelper)this, 1603, new WorldPoint(2539, 4716, 0), "Talk to Kolodion.", new Requirement[0]);
        this.talkToKolodion.addDialogSteps("Are there any more challenges available?", "Great, I've been waiting for an improvement!");
        this.locateFollowerSara = new MageArenaBossStep((QuestHelper)this, this.saradominStaff, "Saradomin", "If he fires a blue wave at you, move off your tile to avoid it. If you don't, he will pull you into melee distance.", this.enchantedSymbol, this.food);
        this.locateFollowerSara.addDialogStep("Saradomin");
        this.locateFollowerGuthix = new MageArenaBossStep((QuestHelper)this, this.guthixStaff, "Guthix", "If he spawns green orbs, destroy them to stop them healing him.", this.enchantedSymbol, this.food);
        this.locateFollowerGuthix.addDialogStep("Guthix");
        this.locateFollowerZammy = new MageArenaBossStep((QuestHelper)this, this.zamorakStaff, "Zamorak", "If he fires an energy ball at you, move away away from the boss to reduce the damage you take.", this.enchantedSymbol, this.food);
        this.locateFollowerZammy.addDialogStep("Zamorak");
        this.enterCavernWithHand = new ObjectStep((QuestHelper)this, 5959, new WorldPoint(3090, 3956, 0), "Return with the hand to Kolodion.", this.justicarsHand, this.knife);
        this.enterCavernWithRoots = new ObjectStep((QuestHelper)this, 5959, new WorldPoint(3090, 3956, 0), "Return with the roots to Kolodion.", this.entRoots, this.knife);
        this.enterCavernWithHeart = new ObjectStep((QuestHelper)this, 5959, new WorldPoint(3090, 3956, 0), "Return with the heart to Kolodion.", this.demonsHeart, this.knife);
        this.giveKolodionHand = new NpcStep((QuestHelper)this, 1603, new WorldPoint(2539, 4716, 0), "Return with the hand to Kolodion.", this.justicarsHand);
        this.giveKolodionRoots = new NpcStep((QuestHelper)this, 1603, new WorldPoint(2539, 4716, 0), "Return with the roots to Kolodion.", this.entRoots);
        this.giveKolodionHeart = new NpcStep((QuestHelper)this, 1603, new WorldPoint(2539, 4716, 0), "Return with the heart to Kolodion.", this.demonsHeart);
        this.enterCavernAfterMinions = new ObjectStep((QuestHelper)this, 5959, new WorldPoint(3090, 3956, 0), "Pull the lever in the building north of the Mage Arena. This is IN THE WILDERNESS, so don't bring anything you don't want to lose.", this.knife);
        this.talkToKolodionAfterMinions = new NpcStep((QuestHelper)this, 1603, new WorldPoint(2539, 4716, 0), "Talk to Kolodion.", new Requirement[0]);
        this.locateAndKillMinions = new DetailedQuestStep((QuestHelper)this, "Use the Enchanted Symbol to locate the 3 bosses. It's recommended to find where a boss is with just food and the symbol, then once you have the location gear up and come fight it. Fight bosses with their respective god staff and spell, food, potions, and armour you're willing to risk. Protect from Magic, and once you've killed them take their drop to Kolodion.", new Requirement[0]);
        this.locateAndKillMinions.addSubSteps(this.locateFollowerGuthix, this.locateFollowerZammy, this.locateFollowerSara, this.enterCavernWithRoots, this.enterCavernWithHeart, this.enterCavernWithHand, this.giveKolodionHand, this.giveKolodionRoots, this.giveKolodionHeart, this.enterCavernAfterMinions, this.talkToKolodionAfterMinions);
        this.useGodCapeOnKolidion = new NpcStep((QuestHelper)this, 1603, new WorldPoint(2539, 4716, 0), "Use a god cape of your choice on Kolodion to have it imbued.", this.godCape);
        this.useGodCapeOnKolidion.addIcon(2413);
        this.useGodCapeOnKolidion.addDialogStep("Yes.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.knife, this.zamorakStaff, this.guthixStaff, this.saradominStaff, this.runesForCasts);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.magicCombatGear, this.brews, this.restores, this.food, this.recoils);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Porazdir (level 235)", "Justiciar Zachariah (level 348)", "Derwen (level 235)");
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("This miniquest is in deep Wilderness. Don't bring anything you're not willing to risk! It's recommended to turn off player attack options to avoid potentially getting skulled.");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.MAGIC, 75));
        reqs.add(new QuestRequirement(QuestHelperQuest.THE_MAGE_ARENA, QuestState.FINISHED));
        reqs.add(new ItemRequirement("Unlocked all 3 god spells", -1, -1));
        return reqs;
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to upgrade your God Cape"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Upgrading the God Cape", Arrays.asList(this.enterCavern, this.talkToKolodion, this.locateAndKillMinions), this.knife, this.saradominStaff, this.guthixStaff, this.zamorakStaff, this.runesForCasts));
        return allSteps;
    }
}

