/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.themagearenaii;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;

public enum MageArenaTemperature {
    VERY_COLD("is very cold", 200, 5000),
    COLD("is cold", 150, 199),
    HOT("is hot", 70, 149),
    VERY_HOT("is very hot", 30, 69),
    INCREDIBLY_HOT("is incredibly hot", 15, 29),
    SHAKING("is visibly shaking", 0, 14);

    public static final Set<MageArenaTemperature> temperatureSet;
    private final String text;
    private final int minDistance;
    private final int maxDistance;

    @Nullable
    public static MageArenaTemperature getFromTemperatureSet(String message) {
        for (MageArenaTemperature temperature : temperatureSet) {
            if (!message.contains(temperature.getText())) continue;
            return temperature;
        }
        return null;
    }

    private MageArenaTemperature(String text, int minDistance, int maxDistance) {
        this.text = text;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
    }

    public String getText() {
        return this.text;
    }

    public int getMinDistance() {
        return this.minDistance;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    static {
        temperatureSet = Sets.immutableEnumSet((Enum)VERY_COLD, (Enum[])new MageArenaTemperature[]{COLD, HOT, VERY_HOT, INCREDIBLY_HOT, SHAKING});
    }
}

