/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.themagearenaii;

import com.google.inject.Inject;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.helpers.miniquests.themagearenaii.MageArenaSolver;
import com.questhelper.helpers.miniquests.themagearenaii.MageArenaSpawnLocation;
import com.questhelper.helpers.miniquests.themagearenaii.MageArenaTemperature;
import com.questhelper.helpers.miniquests.themagearenaii.MageArenaTemperatureChange;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.DetailedQuestStep;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class MageArenaBossStep
extends DetailedQuestStep {
    @Inject
    ItemManager itemManager;
    static String originalTextStart = "Use the Enchanted Symbol to locate the ";
    static String originalTextEnd = " boss. Only bring food and the symbol for this bit.Make sure to only click to locate the current boss, or the locating functionality won't work.";
    String goFightTextStart = "Gear up with your staff, food, potions and gear you're willing to risk. Go to the location and use the device to spawn the boss. Protect from Magic and defeat it. ";
    final String bossName;
    final String abilityDetail;
    final ItemRequirement staff;
    ItemRequirement[] baseRequirements;
    @Nullable
    private MageArenaSolver mageArenaSolver;
    boolean foundLocation = false;
    int currentVar = 0;
    final int BOSS_MOVING_TIMER_VARBIT = 6062;

    public MageArenaBossStep(QuestHelper questHelper, ItemRequirement staff, String bossName, String abilityDetail, ItemRequirement ... requirements) {
        super(questHelper, originalTextStart + bossName + originalTextEnd, requirements);
        this.bossName = bossName;
        this.abilityDetail = abilityDetail;
        this.staff = staff;
        this.baseRequirements = requirements;
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, QuestHelperPlugin plugin, @NonNull List<String> additionalText, @NonNull List<Requirement> additionalRequirements) {
        if (additionalText == null) {
            throw new NullPointerException("additionalText is marked @NonNull but is null");
        }
        if (additionalRequirements == null) {
            throw new NullPointerException("additionalRequirements is marked @NonNull but is null");
        }
        super.makeOverlayHint(panelComponent, plugin, additionalText, additionalRequirements);
        if (this.mageArenaSolver == null) {
            return;
        }
        Set<MageArenaSpawnLocation> digLocations = this.mageArenaSolver.getPossibleLocations();
        List<String> locations = digLocations.stream().map(MageArenaSpawnLocation::getArea).distinct().collect(Collectors.toList());
        if (digLocations.size() > 1) {
            panelComponent.getChildren().add(LineComponent.builder().left("Possible locations:").build());
        } else if (digLocations.size() < 1) {
            if (!this.foundLocation) {
                this.addRequirement((Requirement)this.staff);
                this.setText(this.goFightTextStart + this.abilityDetail);
            }
            this.foundLocation = true;
            panelComponent.getChildren().add(LineComponent.builder().left("Unable to establish spawn location. Let the Quest Helper team know the location in Discord so we can add it in").build());
        } else {
            if (!this.foundLocation) {
                this.addRequirement((Requirement)this.staff);
                this.setText(this.goFightTextStart + this.abilityDetail);
            }
            this.foundLocation = true;
            panelComponent.getChildren().add(LineComponent.builder().left("Spawn location:").build());
        }
        locations.forEach(location -> panelComponent.getChildren().add(LineComponent.builder().left("- " + location).leftColor(Color.LIGHT_GRAY).build()));
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        super.onVarbitChanged(varbitChanged);
        int newState = this.client.getVarbitValue(6062);
        if (newState > this.currentVar) {
            this.foundLocation = false;
            this.setText("The bosses have changed locations. " + originalTextStart + this.bossName + originalTextEnd);
            this.setRequirements(Arrays.asList(this.baseRequirements));
            this.resetState();
        }
        this.currentVar = newState;
    }

    public void resetState() {
        this.setWorldPoint(null);
        Set<MageArenaSpawnLocation> locations = Arrays.stream(MageArenaSpawnLocation.values()).collect(Collectors.toSet());
        if (this.mageArenaSolver != null) {
            this.mageArenaSolver.resetSolver(locations);
        }
        if (this.mageArenaSolver.getPossibleLocations().size() == 1) {
            this.setWorldPoint(this.mageArenaSolver.getPossibleLocations().iterator().next().getWorldPoint());
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWorldOverlayHint(graphics, plugin);
        if (this.worldPoint == null) {
            return;
        }
        LocalPoint localLocation = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.worldPoint);
        if (localLocation == null) {
            return;
        }
        OverlayUtil.renderTileOverlay((Client)this.client, (Graphics2D)graphics, (LocalPoint)localLocation, (BufferedImage)this.getSymbolLocation(), (Color)this.questHelper.getConfig().targetOverlayColor());
    }

    @Override
    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE) {
            this.update(chatMessage.getMessage());
        }
    }

    public void update(String message) {
        if (this.mageArenaSolver == null) {
            return;
        }
        MageArenaTemperature temperature = MageArenaTemperature.getFromTemperatureSet(message);
        if (temperature == null) {
            return;
        }
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        WorldPoint localWorld = this.client.getLocalPlayer().getWorldLocation();
        if (localWorld == null) {
            return;
        }
        MageArenaTemperatureChange temperatureChange = MageArenaTemperatureChange.of(message);
        this.mageArenaSolver.signal(localWorld, temperature, temperatureChange);
        if (this.mageArenaSolver.getPossibleLocations().size() == 1) {
            this.setWorldPoint(this.mageArenaSolver.getPossibleLocations().iterator().next().getWorldPoint());
        } else {
            this.setWorldPoint(null);
        }
    }

    @Override
    public void startUp() {
        super.startUp();
        this.currentVar = this.client.getVarbitValue(6062);
        Set<MageArenaSpawnLocation> locations = Arrays.stream(MageArenaSpawnLocation.values()).collect(Collectors.toSet());
        this.mageArenaSolver = new MageArenaSolver(locations);
        if (locations.size() == 1) {
            this.setWorldPoint(locations.iterator().next().getWorldPoint());
        }
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.setWorldPoint(null);
    }

    private BufferedImage getSymbolLocation() {
        return this.itemManager.getImage(21800);
    }
}

