/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.themagearenaii;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.miniquests.themagearenaii.MageArenaBossStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.MA2_LOCATOR)
public class MA2Locator
extends ComplexStateQuestHelper {
    ItemRequirement zamorakStaff;
    ItemRequirement guthixStaff;
    ItemRequirement saradominStaff;
    ItemRequirement runesForCasts;
    ItemRequirement magicCombatGear;
    ItemRequirement knife;
    ItemRequirement brews;
    ItemRequirement restores;
    ItemRequirement food;
    ItemRequirement recoils;
    ItemRequirement enchantedSymbol;
    ItemRequirement justicarsHand;
    ItemRequirement demonsHeart;
    ItemRequirement entRoots;
    ItemRequirement godCape;
    QuestStep locateFollowerSara;
    Zone cavern;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        return this.locateFollowerSara;
    }

    @Override
    public void setupRequirements() {
        this.zamorakStaff = new ItemRequirement("Zamorak staff", 2417);
        this.zamorakStaff.setTooltip("You can buy one from the Chamber Guardian in the Mage Arena Cavern for 80k");
        this.guthixStaff = new ItemRequirement("Guthix staff", 2416);
        this.guthixStaff.setTooltip("You can buy one from the Chamber Guardian in the Mage Arena Cavern for 80k");
        this.saradominStaff = new ItemRequirement("Saradomin staff", 2415);
        this.saradominStaff.setTooltip("You can buy one from the Chamber Guardian in the Mage Arena Cavern for 80k");
        this.runesForCasts = new ItemRequirements("Runes for 50+ casts of god spells", new ItemRequirement("Blood runes", 565, -1), new ItemRequirement("Air runes", 556, -1), new ItemRequirement("Fire runes", 554, -1));
        this.magicCombatGear = new ItemRequirement("Magic combat gear", -1, 1);
        this.magicCombatGear.setDisplayItemId(BankSlotIcons.getMagicCombatGear());
        this.knife = new ItemRequirement("Knife or sharp weapon to cut through a web", 946);
        this.brews = new ItemRequirement("Saradomin brews", ItemCollections.SARADOMIN_BREWS, -1);
        this.restores = new ItemRequirement("Super restores", ItemCollections.SUPER_RESTORE_POTIONS, -1);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.recoils = new ItemRequirement("Rings of recoil", 2550);
        this.enchantedSymbol = new ItemRequirement("Enchanted symbol", 21800);
        this.enchantedSymbol.setTooltip("You can get another from Kolodion in the Mage Arena Cavern.");
        this.justicarsHand = new ItemRequirement("Justicar's hand", 21797);
        this.demonsHeart = new ItemRequirement("Demon's heart", 21799);
        this.entRoots = new ItemRequirement("Ent's roots", 21798);
        this.godCape = new ItemRequirement("God cape", 2414);
        this.godCape.addAlternates(2413, 2412);
        this.godCape.setHighlightInInventory(true);
    }

    public void loadZones() {
        this.cavern = new Zone(new WorldPoint(2529, 4709, 0), new WorldPoint(2550, 4725, 0));
    }

    public void setupSteps() {
        this.locateFollowerSara = new MageArenaBossStep((QuestHelper)this, this.saradominStaff, "desired", "", this.enchantedSymbol, this.food);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.knife, this.zamorakStaff, this.guthixStaff, this.saradominStaff, this.runesForCasts);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.magicCombatGear, this.brews, this.restores, this.food, this.recoils);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Porazdir (level 235)", "Justiciar Zachariah (level 348)", "Derwen (level 235)");
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("This is in deep Wilderness. Don't bring anything you're not willing to risk! It's recommended to turn off player attack options to avoid potentially getting skulled.");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new QuestRequirement(QuestHelperQuest.THE_MAGE_ARENA_II, QuestState.FINISHED));
        return reqs;
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Upgrading the God Cape", Collections.singletonList(this.locateFollowerSara), this.knife, this.saradominStaff, this.guthixStaff, this.zamorakStaff, this.runesForCasts));
        return allSteps;
    }
}

