/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.themagearenai;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_MAGE_ARENA)
public class TheMageArenaI
extends BasicQuestHelper {
    ItemRequirement runesForCasts;
    ItemRequirement knife;
    ItemRequirement godCape;
    Requirement inCavern;
    Requirement inStatuesRoom;
    Requirement hasCape;
    QuestStep enterCavern;
    QuestStep talkToKolodion;
    QuestStep fightKolodion;
    QuestStep enterCavernForPool;
    QuestStep enterPool;
    QuestStep prayStatue;
    QuestStep talkToGuardian;
    Zone cavern;
    Zone statuesRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goTalkToKolodion = new ConditionalStep((QuestHelper)this, this.enterCavern, new Requirement[0]);
        goTalkToKolodion.addStep(this.inCavern, this.talkToKolodion);
        steps.put(0, goTalkToKolodion);
        steps.put(1, this.fightKolodion);
        steps.put(2, this.fightKolodion);
        steps.put(3, this.fightKolodion);
        steps.put(4, this.fightKolodion);
        steps.put(5, this.fightKolodion);
        ConditionalStep goClaimCape = new ConditionalStep((QuestHelper)this, this.enterCavernForPool, new Requirement[0]);
        goClaimCape.addStep(this.inStatuesRoom, this.prayStatue);
        goClaimCape.addStep(this.inCavern, this.enterPool);
        steps.put(6, goClaimCape);
        ConditionalStep goGetStaff = new ConditionalStep((QuestHelper)this, this.enterCavernForPool, new Requirement[0]);
        goGetStaff.addStep(new Conditions(this.inStatuesRoom, this.hasCape), this.talkToGuardian);
        goGetStaff.addStep(new Conditions(this.inStatuesRoom), this.prayStatue);
        goGetStaff.addStep(this.inCavern, this.enterPool);
        steps.put(7, goGetStaff);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.runesForCasts = new ItemRequirement("Runes for fighting Kolodion", -1, -1);
        this.runesForCasts.setDisplayItemId(560);
        this.knife = new ItemRequirement("Knife or sharp weapon to cut through a web", 946).isNotConsumed();
        this.godCape = new ItemRequirement("God cape", 2414).isNotConsumed();
        this.godCape.addAlternates(2413, 2412);
    }

    public void loadZones() {
        this.cavern = new Zone(new WorldPoint(2529, 4709, 0), new WorldPoint(2550, 4725, 0));
        this.statuesRoom = new Zone(new WorldPoint(2486, 4683, 0), new WorldPoint(2526, 4736, 0));
    }

    public void setupConditions() {
        this.inCavern = new ZoneRequirement(this.cavern);
        this.inStatuesRoom = new ZoneRequirement(this.statuesRoom);
        this.hasCape = new ItemOnTileRequirement(this.godCape);
    }

    public void setupSteps() {
        this.enterCavern = new ObjectStep((QuestHelper)this, 5959, new WorldPoint(3090, 3956, 0), "Pull the lever in the building north of the Mage Arena. This is IN THE WILDERNESS, so don't bring anything you don't want to lose.", this.knife);
        this.talkToKolodion = new NpcStep((QuestHelper)this, 1603, new WorldPoint(2539, 4716, 0), "Talk to Kolodion, ready for fighting him in the Mage Arena.", this.runesForCasts);
        this.talkToKolodion.addDialogSteps("Can I fight here?", "Yes indeedy.", "Okay, let's fight.");
        this.fightKolodion = new NpcStep((QuestHelper)this, 1604, new WorldPoint(3105, 3934, 0), "Defeat Kolodion's various forms.", new Requirement[0]);
        ((NpcStep)this.fightKolodion).addAlternateNpcs(1605, 1606, 1607, 1608, 1609);
        this.enterCavernForPool = new ObjectStep((QuestHelper)this, 5959, new WorldPoint(3090, 3956, 0), "Pull the lever in the building north of the Mage Arena. This is IN THE WILDERNESS, so don't bring anything you don't want to lose.", this.knife);
        this.enterPool = new ObjectStep((QuestHelper)this, 2878, new WorldPoint(2542, 4720, 0), "Enter the sparkling pool.", new Requirement[0]);
        this.enterPool.addSubSteps(this.enterCavernForPool);
        this.prayStatue = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2507, 4720, 0), "Pray at the statue of the god who's cape you want. Pick up the cape which appears.", new Requirement[0]);
        this.talkToGuardian = new NpcStep((QuestHelper)this, 1602, new WorldPoint(2508, 4695, 0), "Talk to the Chamber Guardian for your staff.", this.godCape);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.knife, this.runesForCasts);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Kolodion in 5 forms, up to level 112");
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("This miniquest is in deep Wilderness. Don't bring anything you're not willing to risk! It's recommended to turn off player attack options to avoid potentially getting skulled.");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.MAGIC, 60));
        return reqs;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("A God Staff", 2417, 1), new ItemReward("A God Cape", 2414, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to unlock 3 new God Spells."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Getting to the Mage Arena", Collections.singletonList(this.enterCavern), this.knife));
        allSteps.add(new PanelDetails("Defeating Kolodion", Arrays.asList(this.talkToKolodion, this.fightKolodion), this.runesForCasts));
        allSteps.add(new PanelDetails("Getting your rewards", Arrays.asList(this.enterPool, this.prayStatue, this.talkToGuardian), new Requirement[0]));
        return allSteps;
    }
}

