/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.thegeneralsshadow;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_GENERALS_SHADOW)
public class TheGeneralsShadow
extends BasicQuestHelper {
    ItemRequirement ghostlyHood;
    ItemRequirement ghostlyBody;
    ItemRequirement ghostlyLegs;
    ItemRequirement ghostlyGloves;
    ItemRequirement ghostlyBoots;
    ItemRequirement ghostlyCloak;
    ItemRequirement ringOfVisibility;
    ItemRequirement ghostspeak;
    ItemRequirement combatGear;
    ItemRequirement coins40;
    ItemRequirement sinSeersNote;
    ItemRequirement ghostlyRobes;
    ItemRequirement serveredLeg;
    ItemRequirement kharidTeleport;
    ItemRequirement gnomeTeleport;
    ItemRequirement rellekkaTeleport;
    ItemRequirement karamjaTeleport;
    ItemRequirement draynorTeleport;
    ItemRequirement camelotTeleport;
    ItemRequirement skillsNecklace;
    Requirement inventorySlot;
    Requirement inGoblinCave;
    Requirement inBouncerCave;
    Requirement inSinRoom;
    Requirement hasNote;
    Requirement givenNote;
    Requirement talkedToGnomeScout;
    Requirement talkedToKaramjaScout;
    Requirement talkedToShantayScout;
    Requirement talkedToFaladorScout;
    QuestStep talkToKhazard;
    QuestStep goUpToSeer;
    QuestStep talkToSeer;
    QuestStep talkToKhazardAfterSeer;
    QuestStep talkToKhazardAfterNote;
    QuestStep talkToKaramjaScout;
    QuestStep talkToGnomeScout;
    QuestStep talkToFaladorScout;
    QuestStep talkToShantayScout;
    QuestStep talkToKhazardAfterScouts;
    QuestStep enterCave;
    QuestStep enterCrack;
    QuestStep killBouncer;
    Zone goblinCave;
    Zone bouncerCave;
    Zone sinRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToKhazard);
        ConditionalStep goGetSin = new ConditionalStep((QuestHelper)this, this.goUpToSeer, new Requirement[0]);
        goGetSin.addStep(this.givenNote, this.talkToKhazardAfterNote);
        goGetSin.addStep(this.hasNote, this.talkToKhazardAfterSeer);
        goGetSin.addStep(this.inSinRoom, this.talkToSeer);
        steps.put(5, goGetSin);
        steps.put(10, this.talkToKhazardAfterNote);
        ConditionalStep goTalkToScouts = new ConditionalStep((QuestHelper)this, this.talkToGnomeScout, new Requirement[0]);
        goTalkToScouts.addStep(new Conditions(this.talkedToGnomeScout, this.talkedToFaladorScout, this.talkedToShantayScout), this.talkToKaramjaScout);
        goTalkToScouts.addStep(new Conditions(this.talkedToGnomeScout, this.talkedToFaladorScout), this.talkToShantayScout);
        goTalkToScouts.addStep(this.talkedToGnomeScout, this.talkToFaladorScout);
        steps.put(15, goTalkToScouts);
        steps.put(20, this.talkToKhazardAfterScouts);
        ConditionalStep goDefeatBouncer = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        goDefeatBouncer.addStep(this.inBouncerCave, this.killBouncer);
        goDefeatBouncer.addStep(this.inGoblinCave, this.enterCrack);
        steps.put(25, goDefeatBouncer);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.ghostlyHood = new ItemRequirement("Ghostly hood", 6109, 1, true).isNotConsumed();
        this.ghostlyBody = new ItemRequirement("Ghostly robe (top)", 6107, 1, true).isNotConsumed();
        this.ghostlyLegs = new ItemRequirement("Ghostly robe (bottom)", 6108, 1, true).isNotConsumed();
        this.ghostlyGloves = new ItemRequirement("Ghostly gloves", 6110, 1, true).isNotConsumed();
        this.ghostlyBoots = new ItemRequirement("Ghostly boots", 6106, 1, true).isNotConsumed();
        this.ghostlyCloak = new ItemRequirement("Ghostly cloak", 6111, 1, true).isNotConsumed();
        this.ghostlyRobes = new ItemRequirements("Ghostly robes", this.ghostlyHood, this.ghostlyBody, this.ghostlyLegs, this.ghostlyGloves, this.ghostlyBoots, this.ghostlyCloak).isNotConsumed();
        this.ringOfVisibility = new ItemRequirement("Ring of visibility", 4657, 1, true).isNotConsumed();
        this.ghostspeak = new ItemRequirement("Ghostspeak amulet", 552, 1, true).isNotConsumed();
        this.ghostspeak.addAlternates(4250);
        this.coins40 = new ItemRequirement("Coins", ItemCollections.COINS, 40);
        this.inventorySlot = new FreeInventorySlotRequirement(1);
        this.kharidTeleport = new ItemRequirement("Teleport to Al Kharid", ItemCollections.AMULET_OF_GLORIES);
        this.gnomeTeleport = new ItemRequirement("Necklace of Passage, or a teleport to Tree Gnome Stronghold", -1);
        this.gnomeTeleport.setDisplayItemId(6063);
        this.gnomeTeleport.addAlternates(ItemCollections.NECKLACE_OF_PASSAGES);
        this.rellekkaTeleport = new ItemRequirement("Teleports to Rellekka", 11744, 3);
        this.karamjaTeleport = new ItemRequirement("Teleport to Tai Bwo Wannai", 12409);
        this.draynorTeleport = new ItemRequirement("Teleport to Draynor Manor", ItemCollections.AMULET_OF_GLORIES);
        this.draynorTeleport.addAlternates(19615, 13126, 13127, 13128);
        this.camelotTeleport = new ItemRequirement("Teleport to Seer's Village", 8010);
        this.skillsNecklace = new ItemRequirement("Teleport to Fishing Guild", ItemCollections.SKILLS_NECKLACES);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.serveredLeg = new ItemRequirement("Severed leg", 10857);
        this.serveredLeg.setTooltip("You can get another from General Khazard");
        this.sinSeersNote = new ItemRequirement("Sin seer's note", 10856);
    }

    public void loadZones() {
        this.sinRoom = new Zone(new WorldPoint(2680, 3460, 1), new WorldPoint(2740, 3490, 1));
        this.goblinCave = new Zone(new WorldPoint(2560, 9792, 0), new WorldPoint(2623, 9855, 0));
        this.bouncerCave = new Zone(new WorldPoint(1756, 4697, 0), new WorldPoint(1767, 4713, 0));
    }

    public void setupConditions() {
        this.inSinRoom = new ZoneRequirement(this.sinRoom);
        this.inGoblinCave = new ZoneRequirement(this.goblinCave);
        this.inBouncerCave = new ZoneRequirement(this.bouncerCave);
        this.hasNote = this.sinSeersNote;
        this.givenNote = new VarbitRequirement(3335, 2);
        this.talkedToGnomeScout = new VarbitRequirement(3332, 1);
        this.talkedToFaladorScout = new VarbitRequirement(3333, 1);
        this.talkedToShantayScout = new VarbitRequirement(3334, 1);
        this.talkedToKaramjaScout = new VarbitRequirement(3331, 1);
    }

    public void setupSteps() {
        this.talkToKhazard = new NpcStep((QuestHelper)this, 3510, new WorldPoint(2718, 3628, 0), "Talk to General Khazard south east of Rellekka.", this.ghostlyHood, this.ghostlyBody, this.ghostlyLegs, this.ghostlyCloak, this.ghostlyBoots, this.ghostlyGloves, this.ringOfVisibility, this.ghostspeak);
        this.talkToKhazard.addDialogSteps("I just have one of those faces.", "I'm a very trustworthy person.");
        this.goUpToSeer = new ObjectStep((QuestHelper)this, 25941, new WorldPoint(2699, 3476, 0), "Talk to the Sin Seer in Seers' Village.", this.coins40, this.inventorySlot);
        this.talkToSeer = new NpcStep((QuestHelper)this, 3515, new WorldPoint(2702, 3473, 1), "Talk to the Sin Seer in Seers' Village.", this.coins40, this.inventorySlot);
        this.talkToSeer.addDialogSteps("Bribe", "Here's the money.");
        this.talkToSeer.addSubSteps(this.goUpToSeer);
        this.talkToKhazardAfterSeer = new NpcStep((QuestHelper)this, 3510, new WorldPoint(2718, 3628, 0), "Return to General Khazard south east of Rellekka.", this.sinSeersNote, this.ghostlyRobes, this.ringOfVisibility, this.ghostspeak);
        this.talkToKhazardAfterNote = new NpcStep((QuestHelper)this, 3510, new WorldPoint(2718, 3628, 0), "Return to General Khazard south east of Rellekka.", this.ghostlyRobes, this.ringOfVisibility, this.ghostspeak);
        this.talkToGnomeScout = new NpcStep((QuestHelper)this, 3512, new WorldPoint(2458, 3358, 0), "Talk to the scout near The Outpost, south of the Tree Gnome Stronghold.", this.ghostlyRobes, this.ringOfVisibility, this.ghostspeak);
        this.talkToFaladorScout = new NpcStep((QuestHelper)this, 3513, new WorldPoint(3073, 3336, 0), "Talk to the scout west of Draynor Manor.", this.ghostlyRobes, this.ringOfVisibility, this.ghostspeak);
        this.talkToShantayScout = new NpcStep((QuestHelper)this, 3514, new WorldPoint(3304, 3084, 0), "Talk to the scout south of the Shantay Pass.", this.ghostlyRobes, this.ringOfVisibility, this.ghostspeak);
        this.talkToKaramjaScout = new NpcStep((QuestHelper)this, 3511, new WorldPoint(2825, 3053, 0), "Talk to the scout south east of Tai Bwo Wannai.", this.ghostlyRobes, this.ringOfVisibility, this.ghostspeak);
        this.talkToKhazardAfterScouts = new NpcStep((QuestHelper)this, 3510, new WorldPoint(2718, 3628, 0), "Return to General Khazard south east of Rellekka.", this.ghostlyRobes, this.ringOfVisibility, this.ghostspeak);
        this.enterCave = new ObjectStep((QuestHelper)this, 2, new WorldPoint(2624, 3393, 0), "Enter the cave south east of the Fishing Guild. Be prepared to fight Bouncer (level 160).", this.combatGear, this.serveredLeg);
        this.enterCrack = new ObjectStep((QuestHelper)this, 21800, new WorldPoint(2617, 9827, 0), "Enter the crack in the north east of the caves.", this.combatGear, this.serveredLeg);
        this.enterCrack.addDialogStep("Yes");
        this.killBouncer = new NpcStep((QuestHelper)this, 3509, new WorldPoint(8969, 2184, 0), "Kill Bouncer. You cannot use prayers.", this.combatGear, this.serveredLeg);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins40, this.ghostlyHood, this.ghostlyBody, this.ghostlyLegs, this.ghostlyGloves, this.ghostlyBoots, this.ghostlyCloak, this.ringOfVisibility, this.ghostspeak, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.rellekkaTeleport, this.gnomeTeleport, this.kharidTeleport, this.karamjaTeleport, this.draynorTeleport, this.camelotTeleport, this.skillsNecklace);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Bouncer (level 160, can't use prayer)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.CURSE_OF_THE_EMPTY_LORD, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.FIGHT_ARENA, QuestState.FINISHED));
        return req;
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.SLAYER, 2000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("The Shadow Sword", 10858, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Proving your Sin", Arrays.asList(this.talkToKhazard, this.talkToSeer, this.talkToKhazardAfterSeer), this.ghostlyRobes, this.ringOfVisibility, this.ghostspeak, this.coins40));
        allSteps.add(new PanelDetails("Finding the Scouts", Arrays.asList(this.talkToGnomeScout, this.talkToFaladorScout, this.talkToShantayScout, this.talkToKaramjaScout, this.talkToKhazardAfterScouts), this.ghostlyRobes, this.ringOfVisibility, this.ghostspeak));
        allSteps.add(new PanelDetails("Defeat Bouncer", Arrays.asList(this.enterCave, this.enterCrack, this.killBouncer), this.combatGear, this.serveredLeg));
        return allSteps;
    }
}

