/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.skippyandthemogres;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.SKIPPY_AND_THE_MOGRES)
public class SkippyAndTheMogres
extends BasicQuestHelper {
    ItemRequirement bucketOfWater;
    ItemRequirement nettleTea;
    ItemRequirement chocolateDust;
    ItemRequirement bucketOfMilk;
    ItemRequirement snapeGrass;
    ItemRequirement chocolateMilk;
    ItemRequirement hangoverCure;
    QuestStep soberSkippy;
    QuestStep useTeaOnSkippy;
    QuestStep useChocolateDustOnMilk;
    QuestStep useSnapeGrassOnMilk;
    QuestStep useHangoverCure;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.soberSkippy);
        steps.put(1, this.useTeaOnSkippy);
        ConditionalStep makeAndUseCure = new ConditionalStep((QuestHelper)this, this.useChocolateDustOnMilk, new Requirement[0]);
        makeAndUseCure.addStep(this.hangoverCure, this.useHangoverCure);
        makeAndUseCure.addStep(this.chocolateMilk, this.useSnapeGrassOnMilk);
        steps.put(2, makeAndUseCure);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.bucketOfMilk = new ItemRequirement("Bucket of milk", 1927);
        this.bucketOfMilk.setHighlightInInventory(true);
        this.bucketOfWater = new ItemRequirement("Bucket of water", 1929);
        this.bucketOfWater.setHighlightInInventory(true);
        this.hangoverCure = new ItemRequirement("Hangover cure", 1504);
        this.hangoverCure.setHighlightInInventory(true);
        this.chocolateDust = new ItemRequirement("Chocolate dust", 1975);
        this.chocolateDust.setHighlightInInventory(true);
        this.nettleTea = new ItemRequirement("Nettle tea", 4239);
        this.nettleTea.setTooltip("You can make this by using nettles on a bowl of water, then cooking it");
        this.snapeGrass = new ItemRequirement("Snape grass", 231);
        this.snapeGrass.setHighlightInInventory(true);
        this.chocolateMilk = new ItemRequirement("Chocolatey milk", 1977);
        this.chocolateMilk.setHighlightInInventory(true);
    }

    public void setupSteps() {
        this.soberSkippy = new NpcStep((QuestHelper)this, 2587, new WorldPoint(2982, 3194, 0), "Right-click 'sober-up' on Skippy south west of Port Sarim.", this.bucketOfWater);
        this.soberSkippy.addIcon(1929);
        this.soberSkippy.addDialogStep("Throw the water!");
        this.useTeaOnSkippy = new NpcStep((QuestHelper)this, 2588, new WorldPoint(2982, 3194, 0), "Talk to Skippy.", this.nettleTea);
        this.useChocolateDustOnMilk = new DetailedQuestStep((QuestHelper)this, "Use some chocolate dust on a bucket of milk.", this.chocolateDust, this.bucketOfMilk);
        this.useSnapeGrassOnMilk = new DetailedQuestStep((QuestHelper)this, "Use some snape grass on the chocolatey milk.", this.snapeGrass, this.chocolateMilk);
        this.useHangoverCure = new NpcStep((QuestHelper)this, 2589, new WorldPoint(2982, 3194, 0), "Use the hangover cure on Skippy.", this.hangoverCure);
        this.useHangoverCure.addIcon(1504);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.bucketOfWater);
        reqs.add(this.nettleTea);
        reqs.add(this.bucketOfMilk);
        reqs.add(this.chocolateDust);
        reqs.add(this.snapeGrass);
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.COOKING, 20));
        return req;
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to kill Mogres"), new UnlockReward("Ability to recieve Mogres as a Slayer task"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Help Skippy", Arrays.asList(this.soberSkippy, this.useTeaOnSkippy, this.useChocolateDustOnMilk, this.useSnapeGrassOnMilk, this.useHangoverCure), this.bucketOfWater, this.nettleTea, this.bucketOfMilk, this.chocolateDust, this.snapeGrass));
        return allSteps;
    }
}

