/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.lairoftarnrazorlor;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.helpers.miniquests.lairoftarnrazorlor.TarnRoute;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.LAIR_OF_TARN_RAZORLOR)
public class LairOfTarnRazorlor
extends BasicQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement diary;
    Requirement inBossRoom;
    Requirement killedTarn;
    Requirement inFinalRoom;
    DetailedQuestStep enterFinalRoom;
    DetailedQuestStep pickUpDiary;
    NpcStep killTarn;
    TarnRoute tarnRoute;
    Zone bossRoom;
    Zone finalRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep fullQuest = new ConditionalStep((QuestHelper)this, (QuestStep)this.tarnRoute, new Requirement[0]);
        fullQuest.addStep(this.inFinalRoom, this.pickUpDiary);
        fullQuest.addStep(new Conditions(this.inBossRoom, this.killedTarn), this.enterFinalRoom);
        fullQuest.addStep(this.inBossRoom, this.killTarn);
        steps.put(0, fullQuest);
        steps.put(1, fullQuest);
        steps.put(2, fullQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.diary = new ItemRequirement("Tarn's diary", 10587);
        this.diary.setHighlightInInventory(true);
    }

    public void loadZones() {
        this.bossRoom = new Zone(new WorldPoint(3176, 4611, 0), new WorldPoint(3196, 4626, 0));
        this.finalRoom = new Zone(new WorldPoint(3181, 4632, 0), new WorldPoint(3191, 4637, 0));
    }

    public void setupConditions() {
        this.inBossRoom = new ZoneRequirement(this.bossRoom);
        this.inFinalRoom = new ZoneRequirement(this.finalRoom);
        this.killedTarn = new VarbitRequirement(3290, 2, Operation.GREATER_EQUAL);
    }

    public void setupSteps() {
        this.tarnRoute = new TarnRoute(this);
        this.killTarn = new NpcStep((QuestHelper)this, 6477, new WorldPoint(3186, 4619, 0), "Kill Mutant and Ghost Tarn.", new Requirement[0]);
        this.killTarn.addAlternateNpcs(6475, 6476);
        this.enterFinalRoom = new ObjectStep((QuestHelper)this, 15774, new WorldPoint(3186, 4627, 0), "Go into the north passageway. If you would like to complete a task for the Morytania Diary, you should kill a Terror Dog now.", new Requirement[0]);
        this.pickUpDiary = new ItemStep((QuestHelper)this, "Pick up Tarn's diary. Quest complete!", this.diary);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.combatGear);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Tarn (level 69) twice");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.HAUNTED_MINE, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.SLAYER, 40));
        return req;
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.SLAYER, 5000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Tarn's Diary", 10587, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("The ability to enchant Salve Amulets."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails fullQuestPanel = new PanelDetails("Traversing the dungeon", this.tarnRoute.getDisplaySteps(), this.combatGear);
        fullQuestPanel.addSteps(this.killTarn, this.enterFinalRoom, this.pickUpDiary);
        allSteps.add(fullQuestPanel);
        return allSteps;
    }
}

