/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.hopespearswill;

import com.google.common.collect.ImmutableList;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.NoItemRequirement;
import com.questhelper.requirements.npc.NpcRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.ItemSlots;
import com.questhelper.requirements.util.LogicHelper;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.HOPESPEARS_WILL)
public class HopespearsWill
extends BasicQuestHelper {
    ItemRequirement ghostspeakAmulet;
    ItemRequirement ringOfVisibility;
    ItemRequirement goblinPotion;
    ItemRequirement dramenStaff;
    ItemRequirement potionsAndFood;
    ItemRequirement combatLevel;
    ItemRequirement plainOfMudSphere;
    Zone goblinCave;
    Zone goblinTemple;
    Zone crypt;
    Zone yubiusk;
    QuestStep goToGoblinCave;
    QuestStep drinkGoblinPotion;
    QuestStep confirmGoblin;
    QuestStep goDownStairs;
    QuestStep openCryptDoor;
    QuestStep talkToGhost;
    QuestStep goToGoblinCaveAfterStart;
    QuestStep goDownStairsAfterStart;
    QuestStep openCryptDoorAfterStart;
    QuestStep sayNameSnothead;
    QuestStep sayNameSnailfeet;
    QuestStep sayNameMosschin;
    QuestStep sayNameRedeyes;
    QuestStep sayNameStrongbones;
    QuestStep defeatSnothead;
    QuestStep defeatSnailfeet;
    QuestStep defeatMosschin;
    QuestStep defeatRedeyes;
    QuestStep defeatStrongbones;
    QuestStep pickUpSnotheadBone;
    QuestStep pickUpSnailfeetBone;
    QuestStep pickUpMosschinBone;
    QuestStep pickUpRedeyesBone;
    QuestStep pickUpStrongbonesBone;
    QuestStep goToYubiusk;
    QuestStep burySnothead;
    QuestStep burySnailfeet;
    QuestStep buryMosschin;
    QuestStep buryRedeyes;
    QuestStep buryStrongbones;
    Requirement inGoblinCave;
    Requirement nothingEquipped;
    Requirement goblinWidgetActive;
    Requirement isAGoblin;
    Requirement inGoblinTemple;
    Requirement isInCrypt;
    Requirement inYubiusk;
    Requirement snotheadAlive;
    Requirement snailfeetAlive;
    Requirement mosschinAlive;
    Requirement redeyesAlive;
    Requirement strongbonesAlive;
    Requirement snotheadBuried;
    Requirement snailfeetBuried;
    Requirement mosschinBuried;
    Requirement redeyesBuried;
    Requirement strongbonesBuried;
    ItemRequirement snotheadBones;
    ItemRequirement snailfeetBones;
    ItemRequirement mosschinBones;
    ItemRequirement redeyesBones;
    ItemRequirement strongbonesBones;
    Conditions hasSnotheadBones;
    Conditions hasSnailfeetBones;
    Conditions hasMosschinBones;
    Conditions hasRedeyesBones;
    Conditions hasStrongbonesBones;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupZones();
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep startQuest = new ConditionalStep((QuestHelper)this, this.goToGoblinCave, new Requirement[0]);
        startQuest.addStep(this.goblinWidgetActive, this.confirmGoblin);
        startQuest.addStep(this.isInCrypt, this.talkToGhost);
        startQuest.addStep(this.inGoblinTemple, this.openCryptDoor);
        startQuest.addStep(new Conditions(this.inGoblinCave, this.isAGoblin), this.goDownStairs);
        startQuest.addStep(this.inGoblinCave, this.drinkGoblinPotion);
        steps.put(0, startQuest);
        Conditions hasAllBones = new Conditions(this.hasSnotheadBones, this.hasSnailfeetBones, this.hasMosschinBones, this.hasRedeyesBones, this.hasStrongbonesBones);
        ConditionalStep defeatGoblins = new ConditionalStep((QuestHelper)this, this.openCryptDoor, new Requirement[0]);
        defeatGoblins.addStep(this.snotheadAlive, this.defeatSnothead);
        defeatGoblins.addStep(this.snailfeetAlive, this.defeatSnailfeet);
        defeatGoblins.addStep(this.mosschinAlive, this.defeatMosschin);
        defeatGoblins.addStep(this.redeyesAlive, this.defeatRedeyes);
        defeatGoblins.addStep(this.strongbonesAlive, this.defeatStrongbones);
        defeatGoblins.addStep(new ItemOnTileRequirement(26589), this.pickUpSnotheadBone);
        defeatGoblins.addStep(new ItemOnTileRequirement(26590), this.pickUpSnailfeetBone);
        defeatGoblins.addStep(new ItemOnTileRequirement(26591), this.pickUpMosschinBone);
        defeatGoblins.addStep(new ItemOnTileRequirement(26592), this.pickUpRedeyesBone);
        defeatGoblins.addStep(new ItemOnTileRequirement(26593), this.pickUpStrongbonesBone);
        defeatGoblins.addStep(LogicHelper.nor(this.hasSnotheadBones), this.sayNameSnothead);
        defeatGoblins.addStep(LogicHelper.nor(this.hasSnailfeetBones), this.sayNameSnailfeet);
        defeatGoblins.addStep(LogicHelper.nor(this.hasMosschinBones), this.sayNameMosschin);
        defeatGoblins.addStep(LogicHelper.nor(this.hasRedeyesBones), this.sayNameRedeyes);
        defeatGoblins.addStep(LogicHelper.nor(this.hasStrongbonesBones), this.sayNameStrongbones);
        ConditionalStep buryBones = new ConditionalStep((QuestHelper)this, this.goToYubiusk, new Requirement[0]);
        buryBones.addStep(LogicHelper.nor(this.snotheadBuried), this.burySnothead);
        buryBones.addStep(LogicHelper.nor(this.snailfeetBuried), this.burySnailfeet);
        buryBones.addStep(LogicHelper.nor(this.mosschinBuried), this.buryMosschin);
        buryBones.addStep(LogicHelper.nor(this.redeyesBuried), this.buryRedeyes);
        buryBones.addStep(LogicHelper.nor(this.strongbonesBuried), this.buryStrongbones);
        ConditionalStep finishQuest = new ConditionalStep((QuestHelper)this, this.goToGoblinCaveAfterStart, new Requirement[0]);
        finishQuest.addStep(new Conditions(this.inYubiusk, hasAllBones), buryBones);
        finishQuest.addStep(hasAllBones, this.goToYubiusk);
        finishQuest.addStep(this.goblinWidgetActive, this.confirmGoblin);
        finishQuest.addStep(this.isInCrypt, defeatGoblins);
        finishQuest.addStep(this.inGoblinTemple, this.openCryptDoorAfterStart);
        finishQuest.addStep(new Conditions(this.inGoblinCave, this.isAGoblin), this.goDownStairsAfterStart);
        finishQuest.addStep(this.inGoblinCave, this.drinkGoblinPotion);
        steps.put(1, finishQuest);
        return steps;
    }

    public void setupZones() {
        this.goblinCave = new Zone(10393);
        this.goblinTemple = new Zone(14915);
        this.crypt = new Zone(14916);
        this.yubiusk = new Zone(14148);
    }

    @Override
    public void setupRequirements() {
        this.ghostspeakAmulet = new ItemRequirement("Ghostspeak amulet", ItemCollections.GHOSTSPEAK);
        this.ghostspeakAmulet.setTooltip("or Morytania legs 2 or greater");
        this.ringOfVisibility = new ItemRequirement("Ring of Visibility", 4657);
        this.ringOfVisibility.setTooltip("Obtain from Rasolo south of Baxtorian Falls");
        this.goblinPotion = new ItemRequirement("Goblin potion", Arrays.asList(26587, 26585, 26583, 26581));
        this.goblinPotion.setTooltip("Made by mixing a toadflax potion (unf) and Pharmakos berries from near the Makeover Mage");
        this.dramenStaff = new ItemRequirement("Dramen or lunar staff", ItemCollections.FAIRY_STAFF);
        this.dramenStaff.setTooltip("For fairy ring access - not required if Lumbridge Elite is complete");
        this.potionsAndFood = new ItemRequirement("Food and potions to defeat 5 enemies without armour, weapons, or magic", -1, -1);
        this.plainOfMudSphere = new ItemRequirement("Plain of mud sphere or charged Skills necklace", ItemCollections.SKILLS_NECKLACES);
        this.plainOfMudSphere.addAlternates(26577);
        this.combatLevel = new ItemRequirement("90+ combat", -1, -1);
        this.snotheadBones = new ItemRequirement("Snothead bones", 26589).alsoCheckBank(this.questBank);
        this.snailfeetBones = new ItemRequirement("Snailfeet bones", 26590).alsoCheckBank(this.questBank);
        this.mosschinBones = new ItemRequirement("Mosschin bones", 26591).alsoCheckBank(this.questBank);
        this.redeyesBones = new ItemRequirement("Redeyes bones", 26592).alsoCheckBank(this.questBank);
        this.strongbonesBones = new ItemRequirement("Strongbones bones", 26593).alsoCheckBank(this.questBank);
        this.inGoblinCave = new ZoneRequirement(this.goblinCave);
        this.nothingEquipped = new NoItemRequirement("No items equipped", ItemSlots.ANY_EQUIPPED);
        this.goblinWidgetActive = new WidgetTextRequirement(739, 2, 1, "Select Your Goblin");
        this.isAGoblin = new VarbitRequirement(13612, 1);
        this.inGoblinTemple = new ZoneRequirement(this.goblinTemple);
        this.isInCrypt = new ZoneRequirement(this.crypt);
        this.inYubiusk = new ZoneRequirement(this.yubiusk);
        this.snotheadAlive = new NpcRequirement("Snothead", 11269);
        this.snailfeetAlive = new NpcRequirement("Snailfeet", 11270);
        this.mosschinAlive = new NpcRequirement("Mosschin", 11271);
        this.redeyesAlive = new NpcRequirement("Redeyes", 11272);
        this.strongbonesAlive = new NpcRequirement("Strongbones", 11273);
        this.snotheadBuried = new VarbitRequirement(13620, 1);
        this.snailfeetBuried = new VarbitRequirement(13621, 1);
        this.mosschinBuried = new VarbitRequirement(13622, 1);
        this.redeyesBuried = new VarbitRequirement(13623, 1);
        this.strongbonesBuried = new VarbitRequirement(13624, 1);
        this.hasSnotheadBones = new Conditions(LogicType.OR, this.snotheadBones, this.snotheadBuried);
        this.hasSnailfeetBones = new Conditions(LogicType.OR, this.snailfeetBones, this.snailfeetBuried);
        this.hasMosschinBones = new Conditions(LogicType.OR, this.mosschinBones, this.mosschinBuried);
        this.hasRedeyesBones = new Conditions(LogicType.OR, this.redeyesBones, this.redeyesBuried);
        this.hasStrongbonesBones = new Conditions(LogicType.OR, this.strongbonesBones, this.strongbonesBuried);
    }

    public void setupSteps() {
        this.goToGoblinCave = new ObjectStep((QuestHelper)this, 2, new WorldPoint(2624, 3393, 0), "Enter the Goblin Cave next to the Fishing Guild. A plain of mud sphere will teleport you inside the cave.", this.goblinPotion, this.ringOfVisibility, this.ghostspeakAmulet, this.potionsAndFood);
        this.drinkGoblinPotion = new DetailedQuestStep((QuestHelper)this, "Drink the goblin potion.", this.goblinPotion.highlighted());
        this.confirmGoblin = new WidgetStep((QuestHelper)this, "Confirm to become a goblin. Your selection doesn't matter.", 739, 31);
        this.goDownStairs = new ObjectStep((QuestHelper)this, 43261, new WorldPoint(2581, 9853, 0), "Go down the stairs to the goblin temple. WARNING: If you equip your items too early, you will turn back to human!", this.ringOfVisibility, this.ghostspeakAmulet);
        this.goDownStairs.addDialogStep("Yes.");
        this.openCryptDoor = new ObjectStep((QuestHelper)this, 43088, new WorldPoint(3744, 4332, 0), "Enter the door to the crypt. Don't equip your items yet!", this.ringOfVisibility, this.ghostspeakAmulet);
        this.talkToGhost = new NpcStep((QuestHelper)this, 11301, new WorldPoint(3742, 4389, 0), "Equip your ring and ghostspeak item and talk to the ghost in the crypt.", this.ringOfVisibility.equipped().highlighted(), this.ghostspeakAmulet.equipped().highlighted());
        this.talkToGhost.addDialogSteps("Why are you here?", "I visited Yu'biusk.", "It was a wasteland.", "What favour?", "Yes.");
        this.goToGoblinCaveAfterStart = new ObjectStep((QuestHelper)this, 2, new WorldPoint(2624, 3393, 0), "Enter the Goblin Cave next to the Fishing Guild. A plain of mud sphere will teleport you inside the cave.", this.goblinPotion, this.potionsAndFood);
        this.goDownStairsAfterStart = new ObjectStep((QuestHelper)this, 43261, new WorldPoint(2581, 9853, 0), "Go down the stairs to the goblin temple.", new Requirement[0]);
        this.openCryptDoorAfterStart = new ObjectStep((QuestHelper)this, 43088, new WorldPoint(3744, 4332, 0), "Enter the door to the crypt.", new Requirement[0]);
        this.sayNameSnothead = new ObjectStep((QuestHelper)this, 43122, new WorldPoint(3738, 4385, 0), "Unequip all weapons and armour (the ring of visibility and ghostspeak amulet can stay on but you MUST unequip Morytania legs). Say Snothead's name at the south-west grave.", new Requirement[0]);
        this.sayNameSnothead.addDialogStep("Snothead.");
        this.sayNameSnailfeet = new ObjectStep((QuestHelper)this, 43123, new WorldPoint(3746, 4385, 0), "Unequip all weapons and armour (the ring of visibility and ghostspeak amulet can stay on but you MUST unequip Morytania legs). Say Snailfeet's name at the south-east grave.", new Requirement[0]);
        this.sayNameSnailfeet.addDialogStep("Snailfeet.");
        this.sayNameMosschin = new ObjectStep((QuestHelper)this, 43124, new WorldPoint(3738, 4389, 0), "Unequip all weapons and armour (the ring of visibility and ghostspeak amulet can stay on but you MUST unequip Morytania legs). Say Mosschin's name at the north-west grave.", new Requirement[0]);
        this.sayNameMosschin.addDialogStep("Mosschin.");
        this.sayNameRedeyes = new ObjectStep((QuestHelper)this, 43125, new WorldPoint(3746, 4389, 0), "Unequip all weapons and armour (the ring of visibility and ghostspeak amulet can stay on but you MUST unequip Morytania legs). Say Redeyes's name at the north-east grave.", new Requirement[0]);
        this.sayNameRedeyes.addDialogStep("Redeyes.");
        this.sayNameStrongbones = new ObjectStep((QuestHelper)this, 43126, new WorldPoint(3742, 4393, 0), "Unequip all weapons and armour (the ring of visibility and ghostspeak amulet can stay on but you MUST unequip Morytania legs). Say Strongbones's name at the north grave.", new Requirement[0]);
        this.sayNameStrongbones.addDialogStep("Strongbones.");
        this.defeatSnothead = new NpcStep((QuestHelper)this, 11269, "Defeat Snothead WITHOUT using weapons, armour, or magic. He attacks using melee.", new Requirement[0]);
        this.defeatSnailfeet = new NpcStep((QuestHelper)this, 11270, "Defeat Snailfeet WITHOUT using weapons, armour, or magic. He attacks using melee and range.", new Requirement[0]);
        this.defeatMosschin = new NpcStep((QuestHelper)this, 11271, "Defeat Mosschin WITHOUT using weapons, armour, or magic. He attacks using melee and magic.", new Requirement[0]);
        this.defeatRedeyes = new NpcStep((QuestHelper)this, 11272, "Defeat Redeyes WITHOUT using weapons, armour, or magic. He attacks using melee and magic, and lowers your attack, strength, and defence.", new Requirement[0]);
        this.defeatStrongbones = new NpcStep((QuestHelper)this, 11273, "Defeat Strongbones WITHOUT using weapons, armour, or magic. He attacks using all 3 combat styles, lowers your attack, strength and defence. Ignore the level 29 Skoblins he spawns.", new Requirement[0]);
        this.pickUpSnotheadBone = new DetailedQuestStep((QuestHelper)this, "Pick up Snothead's bone from the ground.", this.snotheadBones.hideConditioned(this.snotheadBuried));
        this.pickUpSnailfeetBone = new DetailedQuestStep((QuestHelper)this, "Pick up Snailfeet's bone from the ground.", this.snailfeetBones.hideConditioned(this.snailfeetBuried));
        this.pickUpMosschinBone = new DetailedQuestStep((QuestHelper)this, "Pick up Mosschin's bone from the ground.", this.mosschinBones.hideConditioned(this.mosschinBuried));
        this.pickUpRedeyesBone = new DetailedQuestStep((QuestHelper)this, "Pick up Redeyes's bone from the ground.", this.redeyesBones.hideConditioned(this.redeyesBuried));
        this.pickUpStrongbonesBone = new DetailedQuestStep((QuestHelper)this, "Pick up Strongbones's bone from the ground.", this.strongbonesBones.hideConditioned(this.strongbonesBuried));
        this.goToYubiusk = new DetailedQuestStep((QuestHelper)this, "Take all five bones to Yu'Biusk. You must get there via fairy ring BLQ.", this.snotheadBones.hideConditioned(this.snotheadBuried), this.snailfeetBones.hideConditioned(this.snailfeetBuried), this.mosschinBones.hideConditioned(this.mosschinBuried), this.redeyesBones.hideConditioned(this.redeyesBuried), this.strongbonesBones.hideConditioned(this.strongbonesBuried));
        this.burySnothead = new DetailedQuestStep((QuestHelper)this, "Bury Snothead's bone.", this.snotheadBones.highlighted());
        this.burySnailfeet = new DetailedQuestStep((QuestHelper)this, "Bury Snailfeet's bone.", this.snailfeetBones.highlighted());
        this.buryMosschin = new DetailedQuestStep((QuestHelper)this, "Bury Mosschin's bone.", this.mosschinBones.highlighted());
        this.buryRedeyes = new DetailedQuestStep((QuestHelper)this, "Bury Redeyes' bone.", this.redeyesBones.highlighted());
        this.buryStrongbones = new DetailedQuestStep((QuestHelper)this, "Bury Strongbones' bone.", this.strongbonesBones.highlighted());
        this.goToGoblinCave.addSubSteps(this.goToGoblinCaveAfterStart);
        this.drinkGoblinPotion.addSubSteps(this.confirmGoblin);
        this.goDownStairsAfterStart.addSubSteps(this.goDownStairs);
        this.openCryptDoorAfterStart.addSubSteps(this.openCryptDoor);
        this.defeatSnothead.addSubSteps(this.sayNameSnothead, this.pickUpSnotheadBone);
        this.defeatSnailfeet.addSubSteps(this.sayNameSnailfeet, this.pickUpSnailfeetBone);
        this.defeatMosschin.addSubSteps(this.sayNameMosschin, this.pickUpMosschinBone);
        this.defeatRedeyes.addSubSteps(this.sayNameRedeyes, this.pickUpRedeyesBone);
        this.defeatStrongbones.addSubSteps(this.sayNameStrongbones, this.pickUpStrongbonesBone);
    }

    public ArrayList<ItemRequirement> getItemRequirements() {
        return new ArrayList<ItemRequirement>(Arrays.asList(this.ghostspeakAmulet, this.ringOfVisibility, this.goblinPotion, this.dramenStaff, this.potionsAndFood));
    }

    public ArrayList<ItemRequirement> getItemRecommended() {
        return new ArrayList<ItemRequirement>(Arrays.asList(this.plainOfMudSphere, this.combatLevel));
    }

    public ArrayList<String> getCombatRequirements() {
        return new ArrayList<String>((Collection<String>)ImmutableList.of((Object)"Snothead (level 32)", (Object)"Snailfeet (level 56)", (Object)"Mosschin (level 88)", (Object)"Redeyes (level 121)", (Object)"Strongbones (level 184)"));
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.THE_RESTLESS_GHOST, QuestState.IN_PROGRESS));
        req.add(new QuestRequirement(QuestHelperQuest.DESERT_TREASURE, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.FAIRYTALE_II__CURE_A_QUEEN, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.LAND_OF_THE_GOBLINS, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.PRAYER, 50, false));
        return req;
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.PRAYER, 38750));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> panels = new ArrayList<PanelDetails>();
        panels.add(new PanelDetails("Obtaining the Goblin Bones", Arrays.asList(this.goToGoblinCave, this.drinkGoblinPotion, this.goDownStairsAfterStart, this.openCryptDoorAfterStart, this.talkToGhost, this.defeatSnothead, this.defeatSnailfeet, this.defeatMosschin, this.defeatRedeyes, this.defeatStrongbones), Arrays.asList(this.goblinPotion, this.ringOfVisibility, this.ghostspeakAmulet, this.potionsAndFood), Arrays.asList(this.plainOfMudSphere)));
        panels.add(new PanelDetails("Freeing the Goblin Souls", Arrays.asList(this.goToYubiusk, this.burySnothead, this.burySnailfeet, this.buryMosschin, this.buryRedeyes, this.buryStrongbones), Arrays.asList(this.dramenStaff, this.snotheadBones, this.snailfeetBones, this.mosschinBones, this.redeyesBones, this.strongbonesBones)));
        return panels;
    }
}

