/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.hisfaithfulservants;

import com.questhelper.helpers.miniquests.hisfaithfulservants.BarrowsDoors;
import com.questhelper.helpers.miniquests.hisfaithfulservants.BarrowsRooms;
import com.questhelper.requirements.zone.Zone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;

public class BarrowsRouteCalculator {
    private static int lastStartRoom = -1;
    static final BarrowsRooms GOAL_ROOM = BarrowsRooms.C;

    public static List<WorldPoint> startDelving(Client client) {
        WorldPoint currentPos = client.getLocalPlayer().getWorldLocation();
        BarrowsRooms startRoom = null;
        block0: for (BarrowsRooms room : BarrowsRooms.values()) {
            for (Zone zone : room.getArea()) {
                if (!zone.contains(currentPos)) continue;
                startRoom = room;
                continue block0;
            }
        }
        if (startRoom == null) {
            return null;
        }
        if (startRoom == GOAL_ROOM) {
            return new ArrayList<WorldPoint>();
        }
        if (lastStartRoom == startRoom.getId()) {
            return null;
        }
        lastStartRoom = startRoom.getId();
        ArrayList<BarrowsDoors> route = BarrowsRouteCalculator.createRoute(client, startRoom, new ArrayList<Integer>(), new ArrayList<BarrowsDoors>(), 0);
        ArrayList<WorldPoint> points = new ArrayList<WorldPoint>();
        BarrowsRooms currentRoomInLoop = startRoom;
        if (route == null || route.size() == 0) {
            return null;
        }
        for (BarrowsDoors barrowsDoors : route) {
            if (barrowsDoors.getStartRoom() == currentRoomInLoop.getId()) {
                points.addAll(barrowsDoors.getPath());
                currentRoomInLoop = BarrowsRooms.getRoomById(barrowsDoors.getEndRoom());
                continue;
            }
            ArrayList<WorldPoint> newPath = new ArrayList<WorldPoint>(barrowsDoors.getPath());
            Collections.reverse(newPath);
            points.addAll(newPath);
            currentRoomInLoop = BarrowsRooms.getRoomById(barrowsDoors.getStartRoom());
        }
        return points;
    }

    public static ArrayList<BarrowsDoors> createRoute(Client client, BarrowsRooms currentRoom, List<Integer> previousRooms, ArrayList<BarrowsDoors> pastRoute, int depth) {
        ArrayList<BarrowsDoors> bestRoute = new ArrayList<BarrowsDoors>();
        int MAX_DEPTH = 8;
        if (depth > MAX_DEPTH) {
            return null;
        }
        for (BarrowsDoors path : currentRoom.getPaths()) {
            BarrowsRooms nextRoom = path.getEndRoom() == currentRoom.getId() ? BarrowsRooms.getRoomById(path.getStartRoom()) : BarrowsRooms.getRoomById(path.getEndRoom());
            if (client.getVarbitValue(path.getVarbit()) != 0 || previousRooms.contains(nextRoom.getId())) continue;
            if (nextRoom == GOAL_ROOM) {
                pastRoute.add(path);
                return pastRoute;
            }
            ArrayList<Integer> newPreviousRooms = new ArrayList<Integer>(previousRooms);
            newPreviousRooms.add(currentRoom.getId());
            ArrayList<BarrowsDoors> nextPath = new ArrayList<BarrowsDoors>(pastRoute);
            nextPath.add(path);
            ArrayList<BarrowsDoors> fullRoute = BarrowsRouteCalculator.createRoute(client, nextRoom, newPreviousRooms, nextPath, depth + 1);
            if ((fullRoute == null || fullRoute.size() <= 0 || fullRoute.size() >= bestRoute.size()) && bestRoute.size() != 0) continue;
            bestRoute = fullRoute;
        }
        return bestRoute;
    }
}

