/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.hisfaithfulservants;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.helpers.miniquests.hisfaithfulservants.BarrowsRouteCalculator;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ManualRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.NpcInteractingRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.DigStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.ChatMessageType;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

@QuestDescriptor(quest=QuestHelperQuest.BARROWS_HELPER)
public class BarrowsHelper
extends ComplexStateQuestHelper {
    static final int CHATBOX_MESSAGES_MESSAGE_LIST = 229;
    ItemRequirement combatGear;
    ItemRequirement spade;
    ItemRequirement barrowsTeleport;
    ItemRequirement strangeOldLockpick;
    ItemRequirement ghommalHilt2;
    Requirement inAhrim;
    Requirement inDharok;
    Requirement inVerac;
    Requirement inTorag;
    Requirement inKaril;
    Requirement inGuthan;
    Requirement inCrypt;
    QuestStep enterAhrim;
    QuestStep killAhrim;
    QuestStep leaveAhrim;
    QuestStep enterDharok;
    QuestStep killDharok;
    QuestStep leaveDharok;
    QuestStep enterKaril;
    QuestStep killKaril;
    QuestStep leaveKaril;
    QuestStep enterVerac;
    QuestStep killVerac;
    QuestStep leaveVerac;
    QuestStep enterTorag;
    QuestStep killTorag;
    QuestStep leaveTorag;
    QuestStep enterGuthan;
    QuestStep killGuthan;
    QuestStep leaveGuthan;
    QuestStep searchAhrimSarc;
    QuestStep searchDharokSarc;
    QuestStep searchKarilSarc;
    QuestStep searchVeracSarc;
    QuestStep searchToragSarc;
    QuestStep searchGuthanSarc;
    QuestStep enterAhrim2;
    QuestStep enterDharok2;
    QuestStep enterGuthan2;
    QuestStep enterKaril2;
    QuestStep enterTorag2;
    QuestStep enterVerac2;
    QuestStep enterAhrimSarc;
    QuestStep enterDharokSarc;
    QuestStep enterKarilSarc;
    QuestStep enterVeracSarc;
    QuestStep enterToragSarc;
    QuestStep enterGuthanSarc;
    QuestStep enterSarc;
    DetailedQuestStep openChest;
    DetailedQuestStep searchChest;
    DetailedQuestStep killFinalBrother;
    DetailedQuestStep leaveBarrows;
    Zone ahrimRoom;
    Zone dharokRoom;
    Zone veracRoom;
    Zone toragRoom;
    Zone karilRoom;
    Zone guthanRoom;
    Zone crypt;
    NpcInteractingRequirement dharokAttacking;
    NpcInteractingRequirement ahrimAttacking;
    NpcInteractingRequirement karilAttacking;
    NpcInteractingRequirement guthanAttacking;
    NpcInteractingRequirement toragAttacking;
    NpcInteractingRequirement veracAttacking;
    Requirement brotherAttacking;
    Requirement killedDharok;
    Requirement killedVerac;
    Requirement killedAhrim;
    Requirement killedGuthan;
    Requirement killedTorag;
    Requirement killedKaril;
    Requirement killedAllSix;
    ManualRequirement isDharokTunnel;
    ManualRequirement isVeracTunnel;
    ManualRequirement isAhrimTunnel;
    ManualRequirement isGuthanTunnel;
    ManualRequirement isToragTunnel;
    ManualRequirement isKarilTunnel;
    Requirement doneWithDharok;
    Requirement doneWithVerac;
    Requirement doneWithAhrim;
    Requirement doneWithGuthan;
    Requirement doneWithTorag;
    Requirement doneWithKaril;
    Requirement doneWithAll;
    ManualRequirement escapeCrypt;
    int lastKc = -1;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        ConditionalStep killingDharok = new ConditionalStep((QuestHelper)this, this.enterDharok, new Requirement[0]);
        killingDharok.addStep(this.dharokAttacking, this.killDharok);
        killingDharok.addStep(this.inDharok, this.searchDharokSarc);
        ConditionalStep killingAhrim = new ConditionalStep((QuestHelper)this, this.enterAhrim, new Requirement[0]);
        killingAhrim.addStep(this.ahrimAttacking, this.killAhrim);
        killingAhrim.addStep(this.inAhrim, this.searchAhrimSarc);
        ConditionalStep killingKaril = new ConditionalStep((QuestHelper)this, this.enterKaril, new Requirement[0]);
        killingKaril.addStep(this.karilAttacking, this.killKaril);
        killingKaril.addStep(this.inKaril, this.searchKarilSarc);
        ConditionalStep killingGuthan = new ConditionalStep((QuestHelper)this, this.enterGuthan, new Requirement[0]);
        killingGuthan.addStep(this.guthanAttacking, this.killGuthan);
        killingGuthan.addStep(this.inGuthan, this.searchGuthanSarc);
        ConditionalStep killingTorag = new ConditionalStep((QuestHelper)this, this.enterTorag, new Requirement[0]);
        killingTorag.addStep(this.toragAttacking, this.killTorag);
        killingTorag.addStep(this.inTorag, this.searchToragSarc);
        ConditionalStep killingVerac = new ConditionalStep((QuestHelper)this, this.enterVerac, new Requirement[0]);
        killingVerac.addStep(this.veracAttacking, this.killVerac);
        killingVerac.addStep(this.inVerac, this.searchVeracSarc);
        ConditionalStep finishingTheRun = new ConditionalStep((QuestHelper)this, this.enterDharok2, new Requirement[0]);
        finishingTheRun.addStep(new Conditions(this.inCrypt, this.killedAllSix), this.searchChest);
        finishingTheRun.addStep(new Conditions(this.inCrypt, this.brotherAttacking), this.killFinalBrother);
        finishingTheRun.addStep(this.inCrypt, this.openChest);
        finishingTheRun.addStep(new Conditions(this.isAhrimTunnel, this.inAhrim), this.enterAhrimSarc);
        finishingTheRun.addStep(this.isAhrimTunnel, this.enterAhrim2);
        finishingTheRun.addStep(new Conditions(this.isVeracTunnel, this.inVerac), this.enterVeracSarc);
        finishingTheRun.addStep(this.isVeracTunnel, this.enterVerac2);
        finishingTheRun.addStep(new Conditions(this.isGuthanTunnel, this.inGuthan), this.enterGuthanSarc);
        finishingTheRun.addStep(this.isGuthanTunnel, this.enterGuthan2);
        finishingTheRun.addStep(new Conditions(this.isToragTunnel, this.inTorag), this.enterToragSarc);
        finishingTheRun.addStep(this.isToragTunnel, this.enterTorag2);
        finishingTheRun.addStep(new Conditions(this.isKarilTunnel, this.inKaril), this.enterKarilSarc);
        finishingTheRun.addStep(this.isKarilTunnel, this.enterKaril2);
        finishingTheRun.addStep(new Conditions(this.isDharokTunnel, this.inDharok), this.enterDharokSarc);
        ConditionalStep doingBarrows = new ConditionalStep((QuestHelper)this, this.enterVerac, new Requirement[0]);
        doingBarrows.addStep(new Conditions(this.escapeCrypt, this.inCrypt), this.leaveBarrows);
        doingBarrows.addStep(this.escapeCrypt, this.enterDharok);
        doingBarrows.addStep(this.doneWithAll, finishingTheRun);
        doingBarrows.addStep(new Conditions(this.doneWithDharok, this.inDharok), this.leaveDharok);
        doingBarrows.addStep(new Conditions(this.doneWithAhrim, this.inAhrim), this.leaveAhrim);
        doingBarrows.addStep(new Conditions(this.doneWithKaril, this.inKaril), this.leaveKaril);
        doingBarrows.addStep(new Conditions(this.doneWithGuthan, this.inGuthan), this.leaveGuthan);
        doingBarrows.addStep(new Conditions(this.doneWithTorag, this.inTorag), this.leaveTorag);
        doingBarrows.addStep(new Conditions(this.doneWithVerac, this.inVerac), this.leaveVerac);
        doingBarrows.addStep(new Conditions(LogicType.NOR, this.doneWithDharok), killingDharok);
        doingBarrows.addStep(new Conditions(LogicType.NOR, this.doneWithAhrim), killingAhrim);
        doingBarrows.addStep(new Conditions(LogicType.NOR, this.doneWithKaril), killingKaril);
        doingBarrows.addStep(new Conditions(LogicType.NOR, this.doneWithGuthan), killingGuthan);
        doingBarrows.addStep(new Conditions(LogicType.NOR, this.doneWithTorag), killingTorag);
        doingBarrows.addStep(new Conditions(LogicType.NOR, this.doneWithVerac), killingVerac);
        return doingBarrows;
    }

    @Override
    public void setupRequirements() {
        this.combatGear = new ItemRequirement("Combat gear to kill all 6 Barrows Brothers", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.spade = new ItemRequirement("Spade", 952);
        this.barrowsTeleport = new ItemRequirement("Barrows teleport", 19629);
        this.strangeOldLockpick = new ItemRequirement("Strange old lockpick", 24738);
        this.strangeOldLockpick.addAlternates(24740);
        this.ghommalHilt2 = new ItemRequirement("Ghommal's hilt 2 or higher to remove prayer drain in crypts", 25928);
        this.ghommalHilt2.addAlternates(25930, 25932, 25934, 25936, 27550, 27551, 27552, 27553);
    }

    public void loadZones() {
        this.ahrimRoom = new Zone(new WorldPoint(3549, 9693, 3), new WorldPoint(3562, 9705, 3));
        this.dharokRoom = new Zone(new WorldPoint(3547, 9709, 3), new WorldPoint(3560, 9719, 3));
        this.guthanRoom = new Zone(new WorldPoint(3533, 9698, 3), new WorldPoint(3548, 9711, 3));
        this.karilRoom = new Zone(new WorldPoint(3544, 9678, 3), new WorldPoint(3559, 9690, 3));
        this.toragRoom = new Zone(new WorldPoint(3563, 9682, 3), new WorldPoint(3577, 9694, 3));
        this.veracRoom = new Zone(new WorldPoint(3567, 9701, 3), new WorldPoint(3580, 9712, 3));
        this.crypt = new Zone(new WorldPoint(3520, 9660, 0), new WorldPoint(3597, 9733, 0));
    }

    public void setupConditions() {
        this.inAhrim = new ZoneRequirement(this.ahrimRoom);
        this.inDharok = new ZoneRequirement(this.dharokRoom);
        this.inGuthan = new ZoneRequirement(this.guthanRoom);
        this.inKaril = new ZoneRequirement(this.karilRoom);
        this.inTorag = new ZoneRequirement(this.toragRoom);
        this.inVerac = new ZoneRequirement(this.veracRoom);
        this.inCrypt = new ZoneRequirement(this.crypt);
        this.killedAhrim = new VarbitRequirement(457, 1);
        this.killedDharok = new VarbitRequirement(458, 1);
        this.killedGuthan = new VarbitRequirement(459, 1);
        this.killedKaril = new VarbitRequirement(460, 1);
        this.killedTorag = new VarbitRequirement(461, 1);
        this.killedVerac = new VarbitRequirement(462, 1);
        this.killedAllSix = new Conditions(this.killedAhrim, this.killedDharok, this.killedGuthan, this.killedKaril, this.killedTorag, this.killedVerac);
        this.dharokAttacking = new NpcInteractingRequirement(1673);
        this.ahrimAttacking = new NpcInteractingRequirement(1672);
        this.karilAttacking = new NpcInteractingRequirement(1675);
        this.guthanAttacking = new NpcInteractingRequirement(1674);
        this.toragAttacking = new NpcInteractingRequirement(1676);
        this.veracAttacking = new NpcInteractingRequirement(1677);
        this.brotherAttacking = new Conditions(LogicType.OR, this.dharokAttacking, this.ahrimAttacking, this.karilAttacking, this.guthanAttacking, this.toragAttacking, this.veracAttacking);
        this.isDharokTunnel = new ManualRequirement();
        this.isAhrimTunnel = new ManualRequirement();
        this.isKarilTunnel = new ManualRequirement();
        this.isGuthanTunnel = new ManualRequirement();
        this.isToragTunnel = new ManualRequirement();
        this.isVeracTunnel = new ManualRequirement();
        this.doneWithDharok = new Conditions(LogicType.OR, this.killedDharok, this.isDharokTunnel);
        this.doneWithAhrim = new Conditions(LogicType.OR, this.killedAhrim, this.isAhrimTunnel);
        this.doneWithKaril = new Conditions(LogicType.OR, this.killedKaril, this.isKarilTunnel);
        this.doneWithTorag = new Conditions(LogicType.OR, this.killedTorag, this.isToragTunnel);
        this.doneWithVerac = new Conditions(LogicType.OR, this.killedVerac, this.isVeracTunnel);
        this.doneWithGuthan = new Conditions(LogicType.OR, this.killedGuthan, this.isGuthanTunnel);
        this.doneWithAll = new Conditions(this.doneWithDharok, this.doneWithAhrim, this.doneWithKaril, this.doneWithTorag, this.doneWithVerac, this.doneWithGuthan);
        this.escapeCrypt = new ManualRequirement();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarbitId() == 464 && event.getValue() == 0) {
            this.isAhrimTunnel.setShouldPass(false);
            this.isDharokTunnel.setShouldPass(false);
            this.isVeracTunnel.setShouldPass(false);
            this.isGuthanTunnel.setShouldPass(false);
            this.isKarilTunnel.setShouldPass(false);
            this.isToragTunnel.setShouldPass(false);
            this.escapeCrypt.setShouldPass(false);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Widget textOption;
        if (this.inCrypt.check(this.client)) {
            int currentKc = this.client.getVarpValue(1502);
            if (this.lastKc == -1) {
                this.lastKc = currentKc;
            } else if (this.lastKc != currentKc) {
                this.escapeCrypt.setShouldPass(true);
            }
            List<WorldPoint> barrowsRoute = BarrowsRouteCalculator.startDelving(this.client);
            if (barrowsRoute != null) {
                this.searchChest.setLinePoints(barrowsRoute);
                this.openChest.setLinePoints(barrowsRoute);
            }
        }
        if ((textOption = this.client.getWidget(229, 1)) == null) {
            return;
        }
        if (textOption.getText().equals("You've found a hidden tunnel, do you want to enter?")) {
            this.updateTunnel();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.MESBOX) {
            return;
        }
        if (chatMessage.getMessage().equals("You've found a hidden tunnel, do you want to enter?")) {
            this.updateTunnel();
        }
    }

    private void updateTunnel() {
        if (this.inAhrim.check(this.client)) {
            this.isAhrimTunnel.setShouldPass(true);
        }
        if (this.inDharok.check(this.client)) {
            this.isDharokTunnel.setShouldPass(true);
        }
        if (this.inVerac.check(this.client)) {
            this.isVeracTunnel.setShouldPass(true);
        }
        if (this.inGuthan.check(this.client)) {
            this.isGuthanTunnel.setShouldPass(true);
        }
        if (this.inKaril.check(this.client)) {
            this.isKarilTunnel.setShouldPass(true);
        }
        if (this.inTorag.check(this.client)) {
            this.isToragTunnel.setShouldPass(true);
        }
    }

    public void setupSteps() {
        this.enterAhrim = new DigStep((QuestHelper)this, new WorldPoint(3564, 3291, 0), "Dig on Ahrim's Barrow to enter it.", this.combatGear);
        this.enterDharok = new DigStep((QuestHelper)this, new WorldPoint(3575, 3299, 0), "Dig on Dharok's Barrow to enter it.", this.combatGear);
        this.enterGuthan = new DigStep((QuestHelper)this, new WorldPoint(3578, 3281, 0), "Dig on Guthan's Barrow to enter it.", this.combatGear);
        this.enterKaril = new DigStep((QuestHelper)this, new WorldPoint(3567, 3274, 0), "Dig on Karil's Barrow to enter it.", this.combatGear);
        this.enterTorag = new DigStep((QuestHelper)this, new WorldPoint(3553, 3281, 0), "Dig on Torag's Barrow to enter it.", this.combatGear);
        this.enterVerac = new DigStep((QuestHelper)this, new WorldPoint(3556, 3297, 0), "Dig on Verac's Barrow to enter it.", this.combatGear);
        this.searchAhrimSarc = new ObjectStep((QuestHelper)this, 20770, new WorldPoint(3555, 9699, 3), "Search Ahrim's Sarcophagus, ready to fight them. They use magic and are weak to ranged attacks.", this.combatGear);
        this.searchDharokSarc = new ObjectStep((QuestHelper)this, 20720, new WorldPoint(3555, 9714, 3), "Search Dharok's Sarcophagus, ready to fight them. They use melee and are weak to magic attacks. Be careful as they hit VERY hard at low health.", this.combatGear);
        this.searchGuthanSarc = new ObjectStep((QuestHelper)this, 20722, new WorldPoint(3539, 9703, 3), "Search Guthan's Sarcophagus, ready to fight them. hey use melee and are weak to magic attacks.", this.combatGear);
        this.searchToragSarc = new ObjectStep((QuestHelper)this, 20721, new WorldPoint(3569, 9686, 3), "Search Ahrim's Sarcophagus, ready to fight them. hey use melee and are weak to magic attacks.", this.combatGear);
        this.searchKarilSarc = new ObjectStep((QuestHelper)this, 20771, new WorldPoint(3550, 9683, 3), "Search Karil's Sarcophagus, ready to fight them. They use ranged and are weak to melee attacks.", this.combatGear);
        this.searchVeracSarc = new ObjectStep((QuestHelper)this, 20772, new WorldPoint(3573, 9706, 3), "Search Ahrim's Sarcophagus, ready to fight them. hey use melee and are weak to magic attacks.", this.combatGear);
        this.killAhrim = new NpcStep((QuestHelper)this, 1672, "Defeat Ahrim.", new Requirement[0]);
        ((NpcStep)this.killAhrim).setMustBeFocused(true);
        this.killDharok = new NpcStep((QuestHelper)this, 1673, "Defeat Dharok.", new Requirement[0]);
        ((NpcStep)this.killDharok).setMustBeFocused(true);
        this.killGuthan = new NpcStep((QuestHelper)this, 1674, "Defeat Guthan.", new Requirement[0]);
        ((NpcStep)this.killGuthan).setMustBeFocused(true);
        this.killKaril = new NpcStep((QuestHelper)this, 1675, "Defeat Karil.", new Requirement[0]);
        ((NpcStep)this.killKaril).setMustBeFocused(true);
        this.killTorag = new NpcStep((QuestHelper)this, 1676, "Defeat Torag.", new Requirement[0]);
        ((NpcStep)this.killTorag).setMustBeFocused(true);
        this.killVerac = new NpcStep((QuestHelper)this, 1677, "Defeat Verac.", new Requirement[0]);
        ((NpcStep)this.killVerac).setMustBeFocused(true);
        this.leaveAhrim = new ObjectStep((QuestHelper)this, 20667, new WorldPoint(3559, 9703, 3), "Leave the barrow.", new Requirement[0]);
        this.leaveDharok = new ObjectStep((QuestHelper)this, 20668, new WorldPoint(3558, 9718, 3), "Leave the barrow.", new Requirement[0]);
        this.leaveGuthan = new ObjectStep((QuestHelper)this, 20669, new WorldPoint(3534, 9706, 3), "Leave the barrow.", new Requirement[0]);
        this.leaveKaril = new ObjectStep((QuestHelper)this, 20670, new WorldPoint(3546, 9686, 3), "Leave the barrow.", new Requirement[0]);
        this.leaveTorag = new ObjectStep((QuestHelper)this, 20671, new WorldPoint(3566, 9683, 3), "Leave the barrow.", new Requirement[0]);
        this.leaveVerac = new ObjectStep((QuestHelper)this, 20672, new WorldPoint(3578, 9704, 3), "Leave the barrow.", new Requirement[0]);
        this.killAhrim.addSubSteps(this.enterAhrim, this.searchAhrimSarc, this.leaveAhrim);
        this.killDharok.addSubSteps(this.enterDharok, this.searchDharokSarc, this.leaveDharok);
        this.killGuthan.addSubSteps(this.enterGuthan, this.searchGuthanSarc, this.leaveGuthan);
        this.killKaril.addSubSteps(this.enterKaril, this.searchKarilSarc, this.leaveKaril);
        this.killTorag.addSubSteps(this.enterTorag, this.searchToragSarc, this.leaveTorag);
        this.killVerac.addSubSteps(this.enterVerac, this.searchVeracSarc, this.leaveVerac);
        this.enterAhrim2 = new DigStep((QuestHelper)this, new WorldPoint(3564, 3291, 0), "Dig on Ahrim's Barrow to enter it.", this.combatGear);
        this.enterDharok2 = new DigStep((QuestHelper)this, new WorldPoint(3575, 3299, 0), "Dig on Dharok's Barrow to enter it.", this.combatGear);
        this.enterGuthan2 = new DigStep((QuestHelper)this, new WorldPoint(3578, 3281, 0), "Dig on Guthan's Barrow to enter it.", this.combatGear);
        this.enterKaril2 = new DigStep((QuestHelper)this, new WorldPoint(3567, 3274, 0), "Dig on Karil's Barrow to enter it.", this.combatGear);
        this.enterTorag2 = new DigStep((QuestHelper)this, new WorldPoint(3553, 3281, 0), "Dig on Torag's Barrow to enter it.", this.combatGear);
        this.enterVerac2 = new DigStep((QuestHelper)this, new WorldPoint(3556, 3297, 0), "Dig on Verac's Barrow to enter it.", this.combatGear);
        this.enterAhrimSarc = new ObjectStep((QuestHelper)this, 20770, new WorldPoint(3555, 9699, 3), "Search Ahrim's Sarcophagus to enter it.", this.combatGear);
        this.enterAhrimSarc.addDialogStep("Yeah I'm fearless!");
        this.enterDharokSarc = new ObjectStep((QuestHelper)this, 20720, new WorldPoint(3555, 9714, 3), "Search Dharok's Sarcophagusto enter it.", this.combatGear);
        this.enterDharokSarc.addDialogStep("Yeah I'm fearless!");
        this.enterGuthanSarc = new ObjectStep((QuestHelper)this, 20722, new WorldPoint(3539, 9703, 3), "Search Guthan's Sarcophagus to enter it.", this.combatGear);
        this.enterGuthanSarc.addDialogStep("Yeah I'm fearless!");
        this.enterToragSarc = new ObjectStep((QuestHelper)this, 20721, new WorldPoint(3569, 9686, 3), "Search Torag's Sarcophagus to enter it.", this.combatGear);
        this.enterToragSarc.addDialogStep("Yeah I'm fearless!");
        this.enterKarilSarc = new ObjectStep((QuestHelper)this, 20771, new WorldPoint(3550, 9683, 3), "Search Karil's Sarcophagus to enter it.", this.combatGear);
        this.enterKarilSarc.addDialogStep("Yeah I'm fearless!");
        this.enterVeracSarc = new ObjectStep((QuestHelper)this, 20772, new WorldPoint(3573, 9706, 3), "Search Verac's Sarcophagus to enter it.", this.combatGear);
        this.enterVeracSarc.addDialogStep("Yeah I'm fearless!");
        this.enterSarc = new DetailedQuestStep((QuestHelper)this, "Enter the sarcophagus that was empty to enter the crypt.", new Requirement[0]);
        this.enterSarc.addSubSteps(this.enterAhrimSarc, this.enterDharokSarc, this.enterGuthanSarc, this.enterToragSarc, this.enterKarilSarc, this.enterVeracSarc, this.enterVerac2, this.enterDharok2, this.enterAhrim2, this.enterKaril2, this.enterTorag2, this.enterGuthan2);
        this.openChest = new ObjectStep((QuestHelper)this, 20723, new WorldPoint(3551, 9695, 0), "Open the chest in the middle of the crypt. DO NOT SEARCH IT until you've killed the 6th brother.", new Requirement[0]);
        this.killFinalBrother = new NpcStep((QuestHelper)this, 1672, "Kill the final brother.", new Requirement[0]);
        ((NpcStep)this.killFinalBrother).addAlternateNpcs(1673, 1675, 1674, 1676, 1677);
        ((NpcStep)this.killFinalBrother).setMustBeFocused(true);
        this.searchChest = new ObjectStep((QuestHelper)this, 20723, new WorldPoint(3551, 9695, 0), "Search the chest in the middle of the crypt for the strange icon.", new Requirement[0]);
        ((ObjectStep)this.searchChest).addAlternateObjects(20724);
        this.leaveBarrows = new ObjectStep((QuestHelper)this, 20667, "Escape back to the surface.", true, new Requirement[0]);
        ((ObjectStep)this.leaveBarrows).addAlternateObjects(20668, 20669, 20670, 20671, 20672, 20676);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.spade);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.barrowsTeleport, this.strangeOldLockpick, this.ghommalHilt2);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Ahrim the Blighted (level 98)", "Dharok the Wretched (level 115)", "Guthan the Infested (level 115)", "Karil the Tainted (level 98)", "Torag the Corrupted (level 115)", "Verac the Defiled (level 115)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.PRIEST_IN_PERIL, QuestState.FINISHED));
        return req;
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.PRAYER, 20000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Crypt map, used to dispell minimap hiding in Barrows", 28133, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Barrows Run", Arrays.asList(this.killDharok, this.killAhrim, this.killKaril, this.killGuthan, this.killTorag, this.killVerac, this.enterSarc, this.openChest, this.killFinalBrother, this.searchChest, this.leaveBarrows), Arrays.asList(this.combatGear, this.spade), Arrays.asList(this.barrowsTeleport, this.strangeOldLockpick, this.ghommalHilt2)));
        return allSteps;
    }
}

