/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.familypest;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.FAMILY_PEST)
public class FamilyPest
extends BasicQuestHelper {
    ItemRequirement coins;
    ItemRequirement dueling;
    ItemRequirement camelotTele;
    ItemRequirement varrockTele;
    ItemRequirement lumberTele;
    QuestStep talkToDimintheis;
    QuestStep talkToAvan;
    QuestStep talkToCaleb;
    QuestStep talkToJohnathon;
    QuestStep talkToDimintheis2;
    QuestStep goUpstairs;
    Zone upstairsJollyBoar;
    Requirement upJollyBoar;
    Requirement talkedToAvan;
    Requirement talkedToCaleb;
    Requirement talkedToJohnathon;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToDimintheis);
        ConditionalStep talkToBrothers = new ConditionalStep((QuestHelper)this, this.talkToAvan, new Requirement[0]);
        talkToBrothers.addStep(new Conditions(this.talkedToCaleb, this.talkedToAvan, this.talkedToJohnathon), this.talkToDimintheis2);
        talkToBrothers.addStep(new Conditions(this.upJollyBoar, this.talkedToCaleb), this.talkToJohnathon);
        talkToBrothers.addStep(this.talkedToCaleb, this.goUpstairs);
        talkToBrothers.addStep(this.talkedToAvan, this.talkToCaleb);
        steps.put(1, talkToBrothers);
        steps.put(2, talkToBrothers);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.dueling = new ItemRequirement("Ring of Dueling", -1, -1);
        this.camelotTele = new ItemRequirement("Camelot Teleports", -1, -1);
        this.varrockTele = new ItemRequirement("Varrock Teleports", -1, -1);
        this.lumberTele = new ItemRequirement("Lumberyard Teleport", -1, -1);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS, 500000);
    }

    public void setupSteps() {
        this.talkToDimintheis = new NpcStep((QuestHelper)this, 4984, new WorldPoint(3280, 3404, 0), "Talk to Dimintheis (Southeast of Varrock.", new Requirement[0]);
        this.talkToDimintheis.addDialogSteps("Have you got any quests for me?", "Oh come on, however menial, I want to help!");
        this.talkToAvan = new NpcStep((QuestHelper)this, 387, new WorldPoint(3294, 3282, 0), "Talk to Avan (Entrance to the Al Kharid Mine).", new Requirement[0]);
        this.talkToAvan.addDialogStep("Family Pest");
        this.talkToCaleb = new NpcStep((QuestHelper)this, 5433, new WorldPoint(2819, 3453, 0), "Talk to Caleb (Northeast of Catherby bank).", new Requirement[0]);
        this.talkToCaleb.addDialogStep("Family Pest");
        this.talkToJohnathon = new NpcStep((QuestHelper)this, 5445, new WorldPoint(3281, 3505, 1), "Talk to Johnathon.", new Requirement[0]);
        this.talkToJohnathon.addDialogStep("Family Pest");
        this.goUpstairs = new ObjectStep((QuestHelper)this, 11797, new WorldPoint(3286, 3494, 0), "Go upstairs in the Jolly Boar Inn (Northeast of Varrock) and talk to Johnathon.", new Requirement[0]);
        this.goUpstairs.addSubSteps(this.talkToJohnathon);
        this.talkToDimintheis2 = new NpcStep((QuestHelper)this, 4984, new WorldPoint(3280, 3404, 0), "Return to Dimintheis and pay him 500k.", new Requirement[0]);
        this.talkToDimintheis2.addDialogSteps("Family Pest", "Yes");
    }

    public void setupConditions() {
        this.upJollyBoar = new ZoneRequirement(this.upstairsJollyBoar);
        this.talkedToCaleb = new VarbitRequirement(5348, 1);
        this.talkedToAvan = new VarbitRequirement(5349, 1);
        this.talkedToJohnathon = new VarbitRequirement(5350, 1);
    }

    public void loadZones() {
        this.upstairsJollyBoar = new Zone(new WorldPoint(3273, 3485, 1), new WorldPoint(3287, 3509, 1));
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Collections.singletonList(this.coins);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.dueling, this.camelotTele, this.varrockTele, this.lumberTele);
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to own all three Steel Gauntlets simultaneously"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Talk to the Brothers", Arrays.asList(this.talkToDimintheis, this.talkToAvan, this.talkToCaleb, this.goUpstairs, this.talkToDimintheis2), this.coins));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.FAMILY_CREST, QuestState.FINISHED));
        return req;
    }
}

