/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.enchantedkey;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;

public enum EnchantedKeyTemperature {
    FREEZING("It's freezing", 500, 5000),
    COLD("It's cold", 120, 499),
    WARM("It's warm", 60, 119),
    VERY_HOT("It's very hot", 30, 59),
    BURNING("Ouch! It's burning hot", 5, 29),
    STEAMING("The key is steaming.", 0, 4);

    public static final Set<EnchantedKeyTemperature> temperatureSet;
    private final String text;
    private final int minDistance;
    private final int maxDistance;

    @Nullable
    public static EnchantedKeyTemperature getFromTemperatureSet(String message) {
        for (EnchantedKeyTemperature temperature : temperatureSet) {
            if (!message.contains(temperature.getText())) continue;
            return temperature;
        }
        return null;
    }

    private EnchantedKeyTemperature(String text, int minDistance, int maxDistance) {
        this.text = text;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
    }

    public String getText() {
        return this.text;
    }

    public int getMinDistance() {
        return this.minDistance;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    static {
        temperatureSet = Sets.immutableEnumSet((Enum)FREEZING, (Enum[])new EnchantedKeyTemperature[]{COLD, WARM, VERY_HOT, BURNING, STEAMING});
    }
}

