/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.enchantedkey;

import com.google.common.annotations.VisibleForTesting;
import com.questhelper.helpers.miniquests.enchantedkey.EnchantedKeyDigLocation;
import com.questhelper.helpers.miniquests.enchantedkey.EnchantedKeyTemperature;
import com.questhelper.helpers.miniquests.enchantedkey.EnchantedKeyTemperatureChange;
import java.awt.Rectangle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.runelite.api.coords.WorldPoint;

public class EnchantedKeySolver {
    private Set<EnchantedKeyDigLocation> possibleLocations;
    @Nullable
    private WorldPoint lastWorldPoint;

    public EnchantedKeySolver(Set<EnchantedKeyDigLocation> possibleLocations) {
        this.possibleLocations = possibleLocations;
    }

    public Set<EnchantedKeyDigLocation> signal(@Nonnull WorldPoint worldPoint, @Nonnull EnchantedKeyTemperature temperature, @Nullable EnchantedKeyTemperatureChange temperatureChange) {
        int maxSquaresAway = temperature.getMaxDistance();
        int minSquaresAway = temperature.getMinDistance();
        Rectangle maxDistanceArea = new Rectangle(worldPoint.getX() - maxSquaresAway, worldPoint.getY() - maxSquaresAway, 2 * maxSquaresAway + 1, 2 * maxSquaresAway + 1);
        Rectangle minDistanceArea = new Rectangle(worldPoint.getX() - minSquaresAway, worldPoint.getY() - minSquaresAway, 2 * minSquaresAway + 1, 2 * minSquaresAway + 1);
        this.possibleLocations.removeIf(entry -> minDistanceArea.contains(entry.getRect()) || !maxDistanceArea.intersects(entry.getRect()));
        if (this.lastWorldPoint != null && temperatureChange != null) {
            switch (temperatureChange) {
                case COLDER: {
                    this.possibleLocations.removeIf(entry -> EnchantedKeySolver.isFirstPointCloserRect(worldPoint, this.lastWorldPoint, entry.getRect()));
                    break;
                }
                case WARMER: {
                    this.possibleLocations.removeIf(entry -> EnchantedKeySolver.isFirstPointCloserRect(this.lastWorldPoint, worldPoint, entry.getRect()));
                    break;
                }
                case SAME: {
                    this.possibleLocations.removeIf(entry -> EnchantedKeySolver.isFirstPointCloserRect(worldPoint, this.lastWorldPoint, entry.getRect()) || EnchantedKeySolver.isFirstPointCloserRect(this.lastWorldPoint, worldPoint, entry.getRect()));
                }
            }
        }
        this.lastWorldPoint = worldPoint;
        return this.getPossibleLocations();
    }

    public void resetSolver(Set<EnchantedKeyDigLocation> possibleLocations) {
        this.lastWorldPoint = null;
        this.possibleLocations = possibleLocations;
    }

    @VisibleForTesting
    static boolean isFirstPointCloserRect(WorldPoint firstPoint, WorldPoint secondPoint, Rectangle rect) {
        WorldPoint nePoint = new WorldPoint(rect.x + rect.width, rect.y + rect.height, 0);
        if (!EnchantedKeySolver.isFirstPointCloser(firstPoint, secondPoint, nePoint)) {
            return false;
        }
        WorldPoint sePoint = new WorldPoint(rect.x + rect.width, rect.y, 0);
        if (!EnchantedKeySolver.isFirstPointCloser(firstPoint, secondPoint, sePoint)) {
            return false;
        }
        WorldPoint nwPoint = new WorldPoint(rect.x, rect.y + rect.height, 0);
        if (!EnchantedKeySolver.isFirstPointCloser(firstPoint, secondPoint, nwPoint)) {
            return false;
        }
        WorldPoint swPoint = new WorldPoint(rect.x, rect.y, 0);
        return EnchantedKeySolver.isFirstPointCloser(firstPoint, secondPoint, swPoint);
    }

    @VisibleForTesting
    static boolean isFirstPointCloser(WorldPoint firstPoint, WorldPoint secondPoint, WorldPoint worldPoint) {
        return firstPoint.distanceTo2D(worldPoint) < secondPoint.distanceTo2D(worldPoint);
    }

    public Set<EnchantedKeyDigLocation> getPossibleLocations() {
        return this.possibleLocations;
    }

    @Nullable
    public WorldPoint getLastWorldPoint() {
        return this.lastWorldPoint;
    }

    public void setPossibleLocations(Set<EnchantedKeyDigLocation> possibleLocations) {
        this.possibleLocations = possibleLocations;
    }
}

