/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.enchantedkey;

import com.google.inject.Inject;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.helpers.miniquests.enchantedkey.EnchantedKeyDigLocation;
import com.questhelper.helpers.miniquests.enchantedkey.EnchantedKeySolver;
import com.questhelper.helpers.miniquests.enchantedkey.EnchantedKeyTemperature;
import com.questhelper.helpers.miniquests.enchantedkey.EnchantedKeyTemperatureChange;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.DetailedQuestStep;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class EnchantedKeyDigStep
extends DetailedQuestStep {
    @Inject
    ItemManager itemManager;
    @Nullable
    private EnchantedKeySolver enchantedKeySolver;
    int currentVar = 0;

    public EnchantedKeyDigStep(QuestHelper questHelper, ItemRequirement ... requirements) {
        super(questHelper, "Use the Enchanted Key to locate treasure.", requirements);
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, QuestHelperPlugin plugin, @NonNull List<String> additionalText, @NonNull List<Requirement> additionalRequirements) {
        if (additionalText == null) {
            throw new NullPointerException("additionalText is marked @NonNull but is null");
        }
        if (additionalRequirements == null) {
            throw new NullPointerException("additionalRequirements is marked @NonNull but is null");
        }
        super.makeOverlayHint(panelComponent, plugin, additionalText, additionalRequirements);
        if (this.enchantedKeySolver == null) {
            return;
        }
        Set<EnchantedKeyDigLocation> digLocations = this.enchantedKeySolver.getPossibleLocations();
        if (digLocations.size() > 1) {
            panelComponent.getChildren().add(LineComponent.builder().left("Possible locations:").build());
        } else if (digLocations.size() < 1) {
            panelComponent.getChildren().add(LineComponent.builder().left("Unable to establish dig location").build());
        }
        panelComponent.getChildren().add(LineComponent.builder().left("Dig location:").build());
        for (EnchantedKeyDigLocation enchantedKeyDigLocation : digLocations) {
            panelComponent.getChildren().add(LineComponent.builder().left("- " + enchantedKeyDigLocation.getArea()).leftColor(Color.LIGHT_GRAY).build());
        }
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        super.onVarbitChanged(varbitChanged);
        if (this.questHelper.getVar() != this.currentVar) {
            this.currentVar = this.questHelper.getVar();
            this.resetState();
        }
    }

    public void resetState() {
        this.setWorldPoint(null);
        int locationStates = this.client.getVarbitValue(1391);
        Set<EnchantedKeyDigLocation> locations = Arrays.stream(EnchantedKeyDigLocation.values()).filter(p -> (locationStates >> p.getBit() & 1) == 0).collect(Collectors.toSet());
        if (this.enchantedKeySolver != null) {
            this.enchantedKeySolver.resetSolver(locations);
        }
        if (this.enchantedKeySolver.getPossibleLocations().size() == 1) {
            this.setWorldPoint(this.enchantedKeySolver.getPossibleLocations().iterator().next().getWorldPoint());
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWorldOverlayHint(graphics, plugin);
        if (this.worldPoint == null) {
            return;
        }
        LocalPoint localLocation = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.worldPoint);
        if (localLocation == null) {
            return;
        }
        OverlayUtil.renderTileOverlay((Client)this.client, (Graphics2D)graphics, (LocalPoint)localLocation, (BufferedImage)this.getSpadeImage(), (Color)this.questHelper.getConfig().targetOverlayColor());
    }

    @Override
    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE) {
            this.update(chatMessage.getMessage());
        }
    }

    public boolean update(String message) {
        if (this.enchantedKeySolver == null) {
            return false;
        }
        EnchantedKeyTemperature temperature = EnchantedKeyTemperature.getFromTemperatureSet(message);
        if (temperature == null) {
            return false;
        }
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return false;
        }
        WorldPoint localWorld = player.getWorldLocation();
        if (localWorld == null) {
            return false;
        }
        EnchantedKeyTemperatureChange temperatureChange = EnchantedKeyTemperatureChange.of(message);
        this.enchantedKeySolver.signal(localWorld, temperature, temperatureChange);
        if (this.enchantedKeySolver.getPossibleLocations().size() == 1) {
            this.setWorldPoint(this.enchantedKeySolver.getPossibleLocations().iterator().next().getWorldPoint());
        } else {
            this.setWorldPoint(null);
        }
        return true;
    }

    @Override
    public void startUp() {
        super.startUp();
        this.currentVar = this.questHelper.getVar();
        Set<EnchantedKeyDigLocation> locations = Arrays.stream(EnchantedKeyDigLocation.values()).filter(p -> (this.currentVar >> p.getBit() & 1) == 0).collect(Collectors.toSet());
        this.enchantedKeySolver = new EnchantedKeySolver(locations);
        if (locations.size() == 1) {
            this.setWorldPoint(locations.iterator().next().getWorldPoint());
        }
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.setWorldPoint(null);
    }

    private BufferedImage getSpadeImage() {
        return this.itemManager.getImage(952);
    }
}

