/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.enchantedkey;

import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.helpers.miniquests.enchantedkey.EnchantedKeyDigStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;

@QuestDescriptor(quest=QuestHelperQuest.ENCHANTED_KEY)
public class EnchantedKey
extends BasicQuestHelper {
    ItemRequirement spade;
    ItemRequirement key;
    ItemRequirement rellekkaTeleports;
    ItemRequirement varrockTeleports;
    ItemRequirement ardougneTeleports;
    ItemRequirement lumbridgeTeleports;
    ItemRequirement passage;
    QuestStep solvePuzzle;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        for (int i = 0; i < 2047; ++i) {
            steps.put(i, this.solvePuzzle);
        }
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.key = new KeyringRequirement("Enchanted key", this.configManager, KeyringCollection.ENCHANTED_KEY);
        this.varrockTeleports = new ItemRequirement("Varrock teleports", 8007);
        this.ardougneTeleports = new ItemRequirement("Ardougne teleports", 8011);
        this.rellekkaTeleports = new ItemRequirement("Rellekka teleport", 11744);
        this.lumbridgeTeleports = new ItemRequirement("Lumbridge teleports", 8008);
        this.passage = new ItemRequirement("Necklace of passage", ItemCollections.NECKLACE_OF_PASSAGES);
    }

    private void setupSteps() {
        this.solvePuzzle = new EnchantedKeyDigStep((QuestHelper)this, this.key, this.spade);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.key, this.spade);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.rellekkaTeleports, this.varrockTeleports, this.ardougneTeleports, this.lumbridgeTeleports, this.passage);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Saradomin Mjolnir", 6762, 1), new ItemReward("Guthix Mjolnir", 6760, 1), new ItemReward("Zamorak Mjolnir", 6764, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Dig for treasure", Collections.singletonList(this.solvePuzzle), this.key, this.spade));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.MAKING_HISTORY, QuestState.FINISHED));
        return req;
    }
}

