/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.curseoftheemptylord;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;

@QuestDescriptor(quest=QuestHelperQuest.CURSE_OF_THE_EMPTY_LORD)
public class CurseOfTheEmptyLord
extends BasicQuestHelper {
    private final int PATH_VARBIT = 815;
    private int currentPath = 0;
    ItemRequirement ringOfVis;
    ItemRequirement ghostspeakItems;
    ItemRequirement ghostspeak;
    ItemRequirement knife;
    Requirement talkedToValdez;
    Requirement talkedToRennard;
    Requirement talkedToKharrim;
    Requirement talkedToLennissa;
    Requirement talkedToDhalak;
    Requirement talkedToViggora;
    Requirement inRoguesCastle;
    Requirement inEdgevilleDungeon;
    Requirement inSlayerTower;
    Requirement inEdgevilleMonastery;
    Requirement inPartyRoom;
    Requirement onPath1;
    Requirement onPath2;
    Requirement onPath3;
    DetailedQuestStep talkToValdez;
    DetailedQuestStep talkToRennard;
    DetailedQuestStep talkToKharrim;
    DetailedQuestStep talkToLennissa;
    DetailedQuestStep talkToDhalak;
    DetailedQuestStep talkToViggora;
    DetailedQuestStep goUpstairsRoguesCastle;
    DetailedQuestStep goUpstairsSlayerTower;
    DetailedQuestStep goUpstairsMonastery;
    DetailedQuestStep goUpstairsPartyRoom;
    ObjectStep goDownIntoEdgevilleDungeon;
    Zone roguesCastleFirstFloor;
    Zone edgevilleDungeon;
    Zone slayerTowerFirstFloor;
    Zone edgevilleMonastery;
    Zone partyRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep dhalakSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToDhalak, new Requirement[0]);
        dhalakSteps.addStep(new Conditions(this.onPath3, this.inPartyRoom), this.talkToDhalak);
        dhalakSteps.addStep(this.onPath3, this.goUpstairsPartyRoom);
        dhalakSteps.addStep(new Conditions(this.onPath2, this.inEdgevilleMonastery), this.talkToDhalak);
        dhalakSteps.addStep(this.onPath2, this.goUpstairsMonastery);
        ConditionalStep viggoraSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToViggora, new Requirement[0]);
        viggoraSteps.addStep(new Conditions(this.onPath3, this.inEdgevilleDungeon), this.talkToViggora);
        viggoraSteps.addStep(this.onPath3, this.goDownIntoEdgevilleDungeon);
        viggoraSteps.addStep(new Conditions(this.onPath2, this.inSlayerTower), this.talkToViggora);
        viggoraSteps.addStep(this.onPath2, this.goUpstairsSlayerTower);
        viggoraSteps.addStep(new Conditions(this.onPath1, this.inRoguesCastle), this.talkToViggora);
        viggoraSteps.addStep(this.onPath1, this.goUpstairsRoguesCastle);
        ConditionalStep questSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToValdez, new Requirement[0]);
        questSteps.addStep(this.talkedToDhalak, viggoraSteps);
        questSteps.addStep(this.talkedToLennissa, dhalakSteps);
        questSteps.addStep(this.talkedToKharrim, this.talkToLennissa);
        questSteps.addStep(this.talkedToRennard, this.talkToKharrim);
        questSteps.addStep(this.talkedToValdez, this.talkToRennard);
        steps.put(0, questSteps);
        return steps;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        int newPath;
        if (this.currentPath == 0 && (newPath = this.client.getVarbitValue(815)) != 0) {
            this.currentPath = newPath;
            this.updateSteps(newPath);
        }
    }

    @Override
    public void setupRequirements() {
        this.ringOfVis = new ItemRequirement("Ring of visibility", 4657, 1, true).isNotConsumed();
        this.ghostspeak = new ItemRequirement("Ghostspeak amulet", 552, 1, true).isNotConsumed();
        this.ghostspeakItems = new ItemRequirement("Ghostspeak amulet or Morytania legs 2 or better", 552, 1, true).isNotConsumed();
        this.ghostspeakItems.addAlternates(13113, 13114, 13115);
        this.knife = new ItemRequirement("Knife", 946).showConditioned(new VarbitRequirement(815, 3)).isNotConsumed();
    }

    public void setupConditions() {
        this.talkedToValdez = new VarbitRequirement(816, 1);
        this.talkedToRennard = new VarbitRequirement(817, 1);
        this.talkedToKharrim = new VarbitRequirement(818, 1);
        this.talkedToLennissa = new VarbitRequirement(819, 1);
        this.talkedToDhalak = new VarbitRequirement(820, 1);
        this.talkedToViggora = new VarbitRequirement(821, 1);
        this.inEdgevilleDungeon = new ZoneRequirement(this.edgevilleDungeon);
        this.inRoguesCastle = new ZoneRequirement(this.roguesCastleFirstFloor);
        this.inSlayerTower = new ZoneRequirement(this.slayerTowerFirstFloor);
        this.inEdgevilleMonastery = new ZoneRequirement(this.edgevilleMonastery);
        this.inPartyRoom = new ZoneRequirement(this.partyRoom);
        this.onPath1 = new VarbitRequirement(815, 1);
        this.onPath2 = new VarbitRequirement(815, 2);
        this.onPath3 = new VarbitRequirement(815, 3);
    }

    public void loadZones() {
        this.edgevilleDungeon = new Zone(new WorldPoint(3086, 9821, 0), new WorldPoint(3829, 10001, 0));
        this.roguesCastleFirstFloor = new Zone(new WorldPoint(3274, 3924, 1), new WorldPoint(3297, 3942, 1));
        this.slayerTowerFirstFloor = new Zone(new WorldPoint(3403, 3529, 1), new WorldPoint(3453, 3581, 1));
        this.edgevilleMonastery = new Zone(new WorldPoint(3043, 3481, 1), new WorldPoint(3060, 3499, 1));
        this.partyRoom = new Zone(new WorldPoint(3035, 3370, 1), new WorldPoint(3057, 3387, 1));
    }

    public void setupSteps() {
        int pathID = this.client.getVarbitValue(815);
        this.talkToValdez = new NpcStep((QuestHelper)this, 3452, new WorldPoint(2556, 3445, 0), "Talk to the Mysterious Ghost outside Glarial's Tomb.", this.ghostspeakItems, this.ringOfVis);
        this.talkToValdez.addDialogStep("Tell me your story");
        this.talkToRennard = new NpcStep((QuestHelper)this, 3450, new WorldPoint(2556, 3445, 0), "Talk to the Mysterious Ghost Rennard.", this.ghostspeakItems, this.ringOfVis);
        this.talkToRennard.addDialogStep("Tell me your story");
        this.talkToKharrim = new NpcStep((QuestHelper)this, 3453, new WorldPoint(2556, 3445, 0), "Talk to the Mysterious Ghost Kharrim.", this.ghostspeakItems, this.ringOfVis);
        this.talkToKharrim.addDialogStep("Tell me your story");
        this.talkToLennissa = new NpcStep((QuestHelper)this, 3454, new WorldPoint(2556, 3445, 0), "Talk to the Mysterious Ghost Lennissa.", this.ghostspeakItems, this.ringOfVis);
        this.talkToLennissa.addDialogStep("Tell me your story");
        this.talkToDhalak = new NpcStep((QuestHelper)this, 3451, new WorldPoint(2556, 3445, 0), "Talk to the Mysterious Ghost Dhalak.", this.ghostspeakItems, this.ringOfVis);
        this.talkToDhalak.addDialogStep("Tell me your story");
        this.talkToViggora = new NpcStep((QuestHelper)this, 3455, new WorldPoint(2556, 3445, 0), "Talk to the Mysterious Ghost Viggora.", this.ghostspeakItems, this.ringOfVis);
        this.talkToViggora.addDialogStep("Tell me your story");
        this.goUpstairsMonastery = new ObjectStep((QuestHelper)this, 2641, new WorldPoint(3057, 3483, 0), "Talk to the Mysterious Ghost upstairs in the Edgeville Monastery.", new Requirement[0]);
        this.goUpstairsSlayerTower = new ObjectStep((QuestHelper)this, 2114, new WorldPoint(3436, 3538, 0), "Talk to the Mysterious Ghost upstairs in the Slayer Tower, near the Infernal Mages.", new Requirement[0]);
        this.goDownIntoEdgevilleDungeon = new ObjectStep((QuestHelper)this, 1579, new WorldPoint(3097, 3468, 0), "Talk to the Mysterious Ghost in the Edgeville Wilderness Dungeon, near the Earth Warriors.", new Requirement[0]);
        this.goDownIntoEdgevilleDungeon.addAlternateObjects(1581);
        this.goUpstairsRoguesCastle = new ObjectStep((QuestHelper)this, 14735, new WorldPoint(3281, 3937, 0), "Talk to the Mysterious Ghost Viggora upstairs in the Rogues' Castle in 54 Wilderness.", new Requirement[0]);
        this.goUpstairsPartyRoom = new ObjectStep((QuestHelper)this, 24249, new WorldPoint(3054, 3384, 0), "Talk to the Mysterious Ghost upstairs in the Falador Party Room.", new Requirement[0]);
        this.updateSteps(pathID);
    }

    public void updateSteps(int pathID) {
        if (pathID == 1) {
            this.talkToRennard.setText("Talk to the Mysterious Ghost near the shipwrecked ship near the Wilderness Agility Course in 52 Wilderness.");
            this.talkToRennard.setWorldPoint(3019, 3946, 0);
            this.talkToKharrim.setText("Talk to the Mysterious Ghost at the Chaos Temple in 38 Wilderness.");
            this.talkToKharrim.setWorldPoint(2954, 3821, 0);
            this.talkToLennissa.setText("Talk to the Mysterious Ghost in the church on Entrana.");
            this.talkToLennissa.setRequirements(Arrays.asList(this.ghostspeak, this.ringOfVis));
            this.talkToLennissa.setWorldPoint(2846, 3349, 0);
            this.talkToDhalak.setText("Talk to the Mysterious Ghost in the Wizard's Tower ground floor.");
            this.talkToDhalak.setWorldPoint(3109, 3163, 0);
            this.talkToViggora.setText("Talk to the Mysterious Ghost Viggora upstairs in the Rogues' Castle in 54 Wilderness.");
            this.talkToViggora.setWorldPoint(3295, 3934, 1);
            this.talkToViggora.addSubSteps(this.goUpstairsRoguesCastle);
        } else if (pathID == 2) {
            this.talkToRennard.setText("Talk to the Mysterious Ghost in the Bandit Camp in the Wilderness.");
            this.talkToRennard.setWorldPoint(3031, 3703, 0);
            this.talkToKharrim.setText("Talk to the Mysterious Ghost in the Graveyard of Shadows in the Wilderness.");
            this.talkToKharrim.setWorldPoint(3160, 3670, 0);
            this.talkToLennissa.setText("Talk to the Mysterious Ghost on the south of the Port Sarim dock.");
            this.talkToLennissa.setWorldPoint(3041, 3203, 0);
            this.talkToDhalak.setText("Talk to the Mysterious Ghost upstairs in the Edgeville Monastery.");
            this.talkToDhalak.setWorldPoint(3052, 3497, 1);
            this.talkToDhalak.addSubSteps(this.goUpstairsMonastery);
            this.talkToViggora.setText("Talk to the Mysterious Ghost upstairs in the Slayer Tower, near the Infernal Mages.");
            this.talkToViggora.setWorldPoint(3447, 3547, 1);
            this.talkToViggora.addSubSteps(this.goUpstairsSlayerTower);
        } else if (pathID == 3) {
            this.talkToRennard.setText("Talk to the Mysterious Ghost in the Bandit Camp in the desert.");
            this.talkToRennard.setWorldPoint(3163, 2981, 0);
            this.talkToKharrim.setText("Talk to the Mysterious Ghost in the centre of the Lava Maze.");
            this.talkToKharrim.addItemRequirements(Collections.singletonList(this.knife));
            this.talkToKharrim.setWorldPoint(3076, 3861, 0);
            this.talkToLennissa.setText("Talk to the Mysterious Ghost in the west of the Tree Gnome Stronghold.");
            this.talkToLennissa.setWorldPoint(2396, 3476, 0);
            this.talkToDhalak.setText("Talk to the Mysterious Ghost upstairs in the Falador Party Room.");
            this.talkToDhalak.setWorldPoint(3052, 3378, 1);
            this.talkToDhalak.addSubSteps(this.goUpstairsPartyRoom);
            this.talkToViggora.setText("Talk to the Mysterious Ghost in the Edgeville Wilderness Dungeon, near the Earth Warriors.");
            this.talkToViggora.setWorldPoint(3121, 9995, 0);
            this.talkToViggora.addSubSteps(this.goDownIntoEdgevilleDungeon);
        }
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.ringOfVis, this.ghostspeakItems, this.knife);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("10,000 Experience Lamp (Any skill over level 50).", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("A Set of Ghostly Robes"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Learn about the Empty Lord", Arrays.asList(this.talkToValdez, this.talkToRennard, this.talkToKharrim, this.talkToLennissa, this.talkToDhalak, this.talkToViggora), this.ghostspeakItems, this.ringOfVis, this.knife));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.DESERT_TREASURE, QuestState.IN_PROGRESS));
        req.add(new QuestRequirement(QuestHelperQuest.THE_RESTLESS_GHOST, QuestState.IN_PROGRESS));
        return req;
    }
}

