/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.miniquests.architecturalalliance;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.Favour;
import com.questhelper.requirements.player.FavourRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ARCHITECTURAL_ALLIANCE)
public class ArchitecturalAlliance
extends BasicQuestHelper {
    Requirement talkedToHosaStart;
    Requirement talkedToHosa;
    Requirement talkedToArcis;
    Requirement talkedToLovada;
    Requirement talkedToPiliar;
    Requirement talkedToShayda;
    ItemRequirement kharedstsMemoirs;
    DetailedQuestStep talkToHosa;
    DetailedQuestStep talkToHosaAsArchitect;
    DetailedQuestStep talkToArcis;
    DetailedQuestStep talkToLovada;
    DetailedQuestStep talkToPiliar;
    DetailedQuestStep talkToShayda;
    DetailedQuestStep talkToHosaToFinish;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep repairStatue = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToHosa, new Requirement[0]);
        repairStatue.addStep(new Conditions(this.talkedToHosa, this.talkedToArcis, this.talkedToPiliar, this.talkedToLovada, this.talkedToShayda), this.talkToHosaToFinish);
        repairStatue.addStep(new Conditions(this.talkedToHosa, this.talkedToArcis, this.talkedToPiliar, this.talkedToLovada), this.talkToShayda);
        repairStatue.addStep(new Conditions(this.talkedToHosa, this.talkedToArcis, this.talkedToPiliar), this.talkToLovada);
        repairStatue.addStep(new Conditions(this.talkedToHosa, this.talkedToArcis), this.talkToPiliar);
        repairStatue.addStep(this.talkedToHosa, this.talkToArcis);
        repairStatue.addStep(this.talkedToHosaStart, this.talkToHosaAsArchitect);
        steps.put(0, repairStatue);
        steps.put(1, this.talkToHosaAsArchitect);
        steps.put(2, this.talkToHosaAsArchitect);
        steps.put(3, this.talkToHosaAsArchitect);
        steps.put(4, this.talkToHosaAsArchitect);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.kharedstsMemoirs = new ItemRequirement("Kharedst's Memoirs", 21760).isNotConsumed();
        this.kharedstsMemoirs.setTooltip("Make sure to have memories available. Xeric's Talisman + Fairy Rings can be used instead.");
    }

    public void setupConditions() {
        this.talkedToArcis = new VarbitRequirement(4971, 1);
        this.talkedToHosa = new VarbitRequirement(4972, 1);
        this.talkedToLovada = new VarbitRequirement(4973, 1);
        this.talkedToPiliar = new VarbitRequirement(4974, 1);
        this.talkedToShayda = new VarbitRequirement(4975, 1);
        this.talkedToHosaStart = new VarbitRequirement(4976, 1);
    }

    public void setupSteps() {
        this.talkToHosa = new NpcStep((QuestHelper)this, 6785, new WorldPoint(1636, 3670, 0), "Talk to Hosa outside the Kourend Castle.", new Requirement[0]);
        this.talkToHosa.addDialogStep("Can I help?");
        this.talkToHosaAsArchitect = new NpcStep((QuestHelper)this, 6785, new WorldPoint(1636, 3670, 0), "Talk to Hosa outside the Kourend Castle again.", new Requirement[0]);
        this.talkToHosa.addSubSteps(this.talkToHosaAsArchitect);
        this.talkToHosaToFinish = new NpcStep((QuestHelper)this, 6785, new WorldPoint(1636, 3670, 0), "Talk to Hosa outside the Kourend Castle to finish the miniquest.", new Requirement[0]);
        this.talkToArcis = new NpcStep((QuestHelper)this, 6770, new WorldPoint(1652, 3754, 0), "Talk to Arcis in the house east of Arceuus's bank.", new Requirement[0]);
        this.talkToPiliar = new NpcStep((QuestHelper)this, 6780, new WorldPoint(1794, 3737, 0), "Talk to Piliar in the house north west of the Piscarilius general store.", new Requirement[0]);
        this.talkToLovada = new NpcStep((QuestHelper)this, 6772, new WorldPoint(1485, 3834, 0), "Talk to Lovada in their home just south of the Blast Mine in Lovakengj.", new Requirement[0]);
        this.talkToShayda = new NpcStep((QuestHelper)this, 6781, new WorldPoint(1532, 3544, 0), "Talk to Shayda in their home just south of the Shayzien Administration building", new Requirement[0]);
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Repairing the statue", Arrays.asList(this.talkToHosa, this.talkToArcis, this.talkToPiliar, this.talkToLovada, this.talkToShayda, this.talkToHosaToFinish), new Requirement[0]));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new FavourRequirement(Favour.LOVAKENGJ, 100));
        req.add(new FavourRequirement(Favour.ARCEUUS, 100));
        req.add(new FavourRequirement(Favour.HOSIDIUS, 100));
        req.add(new FavourRequirement(Favour.PISCARILIUS, 100));
        req.add(new FavourRequirement(Favour.SHAYZIEN, 100));
        return req;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("10,000 Experience Lamp (Any skill over level 40).", 21262, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Xeric's Heart Teleport on Xeric's Talisman."));
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> req = new ArrayList<ItemRequirement>();
        req.add(this.kharedstsMemoirs);
        return req;
    }

    @Override
    public QuestState getState(Client client) {
        int questState = client.getVarbitValue(QuestVarbits.QUEST_ARCHITECTURAL_ALLIANCE.getId());
        if (questState == 0) {
            return QuestState.NOT_STARTED;
        }
        if (questState < 5) {
            return QuestState.IN_PROGRESS;
        }
        return QuestState.FINISHED;
    }

    @Override
    public boolean isCompleted() {
        return this.client.getVarbitValue(QuestVarbits.QUEST_ARCHITECTURAL_ALLIANCE.getId()) >= 5;
    }
}

