/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.wilderness;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.WILDERNESS_MEDIUM)
public class WildernessMedium
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement pickaxe;
    ItemRequirement runeAxe;
    ItemRequirement antiDragonShield;
    ItemRequirement unpoweredOrb;
    ItemRequirement cosmicRune;
    ItemRequirement earthRune;
    ItemRequirement coins;
    ItemRequirement goldBar;
    ItemRequirement goldOre;
    ItemRequirement hammer;
    ItemRequirement muddyKey;
    ItemRequirement godEquip;
    ItemRequirement knife;
    ItemRequirement goldHelmet;
    ItemRequirement barsOrPick;
    Requirement enterGodwars;
    ItemRequirement food;
    ItemRequirement burningAmulet;
    ItemRequirement gamesNeck;
    Requirement betweenARock;
    Requirement notMineMith;
    Requirement notEntYew;
    Requirement notWildyGodWars;
    Requirement notWildyAgi;
    Requirement notKillGreenDrag;
    Requirement notKillAnkou;
    Requirement notWildyGWBloodveld;
    Requirement notEmblemTrader;
    Requirement notGoldHelm;
    Requirement notMuddyChest;
    Requirement notEarthOrb;
    QuestStep claimReward;
    QuestStep mineMith;
    QuestStep wildyAgi;
    QuestStep killAnkou;
    QuestStep wildyGWBloodveld;
    QuestStep emblemTrader;
    QuestStep goldHelm;
    QuestStep muddyChest;
    QuestStep earthOrb;
    QuestStep moveToResource;
    QuestStep moveToGodWars1;
    QuestStep moveToGodWars2;
    QuestStep mineGoldOre;
    QuestStep smeltGoldOre;
    QuestStep moveToEdge;
    QuestStep moveToSlayer1;
    QuestStep moveToSlayer2;
    QuestStep wildyGodwars;
    NpcStep entYew;
    NpcStep killGreenDrag;
    Zone resource;
    Zone godWars1;
    Zone godWars2;
    Zone slayer;
    Zone edge;
    ZoneRequirement inResource;
    ZoneRequirement inGodWars1;
    ZoneRequirement inGodWars2;
    ZoneRequirement inSlayer;
    ZoneRequirement inEdge;
    ConditionalStep mineMithTask;
    ConditionalStep entYewTask;
    ConditionalStep wildyGodWarsTask;
    ConditionalStep wildyAgiTask;
    ConditionalStep killGreenDragTask;
    ConditionalStep killAnkouTask;
    ConditionalStep wildyGWBloodveldTask;
    ConditionalStep emblemTraderTask;
    ConditionalStep goldHelmTask;
    ConditionalStep muddyChestTask;
    ConditionalStep earthOrbTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doMedium = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.entYewTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.entYew, new Requirement[0]);
        doMedium.addStep(this.notEntYew, this.entYewTask);
        this.killAnkouTask = new ConditionalStep((QuestHelper)this, this.moveToSlayer1, new Requirement[0]);
        this.killAnkouTask.addStep(this.inSlayer, this.killAnkou);
        doMedium.addStep(this.notKillAnkou, this.killAnkouTask);
        this.killGreenDragTask = new ConditionalStep((QuestHelper)this, this.moveToSlayer2, new Requirement[0]);
        this.killGreenDragTask.addStep(this.inSlayer, this.killGreenDrag);
        doMedium.addStep(this.notKillGreenDrag, this.killGreenDragTask);
        this.wildyGodWarsTask = new ConditionalStep((QuestHelper)this, this.moveToGodWars1, new Requirement[0]);
        this.wildyGodWarsTask.addStep(this.inGodWars1, this.wildyGodwars);
        doMedium.addStep(this.notWildyGodWars, this.wildyGodWarsTask);
        this.wildyGWBloodveldTask = new ConditionalStep((QuestHelper)this, this.moveToGodWars2, new Requirement[0]);
        this.wildyGWBloodveldTask.addStep(this.inGodWars1, this.wildyGodwars);
        this.wildyGWBloodveldTask.addStep(this.inGodWars2, this.wildyGWBloodveld);
        doMedium.addStep(this.notWildyGWBloodveld, this.wildyGWBloodveldTask);
        this.emblemTraderTask = new ConditionalStep((QuestHelper)this, this.emblemTrader, new Requirement[0]);
        doMedium.addStep(this.notEmblemTrader, this.emblemTraderTask);
        this.earthOrbTask = new ConditionalStep((QuestHelper)this, this.moveToEdge, new Requirement[0]);
        this.earthOrbTask.addStep(this.inEdge, this.earthOrb);
        doMedium.addStep(this.notEarthOrb, this.earthOrbTask);
        this.mineMithTask = new ConditionalStep((QuestHelper)this, this.mineMith, new Requirement[0]);
        doMedium.addStep(this.notMineMith, this.mineMithTask);
        this.wildyAgiTask = new ConditionalStep((QuestHelper)this, this.wildyAgi, new Requirement[0]);
        doMedium.addStep(this.notWildyAgi, this.wildyAgiTask);
        this.goldHelmTask = new ConditionalStep((QuestHelper)this, this.moveToResource, new Requirement[0]);
        this.goldHelmTask.addStep(this.inResource, this.mineGoldOre);
        this.goldHelmTask.addStep(new Conditions(this.inResource, this.goldOre.quantity(3)), this.smeltGoldOre);
        this.goldHelmTask.addStep(new Conditions(this.inResource, this.goldBar.quantity(3).alsoCheckBank(this.questBank)), this.goldHelm);
        doMedium.addStep(this.notGoldHelm, this.goldHelmTask);
        this.muddyChestTask = new ConditionalStep((QuestHelper)this, this.muddyChest, new Requirement[0]);
        doMedium.addStep(this.notMuddyChest, this.muddyChestTask);
        return doMedium;
    }

    @Override
    public void setupRequirements() {
        this.notMineMith = new VarplayerRequirement(1192, false, 13);
        this.notEntYew = new VarplayerRequirement(1192, false, 14);
        this.notWildyGodWars = new VarplayerRequirement(1192, false, 15);
        this.notWildyAgi = new VarplayerRequirement(1192, false, 16);
        this.notKillGreenDrag = new VarplayerRequirement(1192, false, 18);
        this.notKillAnkou = new VarplayerRequirement(1192, false, 19);
        this.notEarthOrb = new VarplayerRequirement(1192, false, 20);
        this.notWildyGWBloodveld = new VarplayerRequirement(1192, false, 21);
        this.notEmblemTrader = new VarplayerRequirement(1192, false, 22);
        this.notGoldHelm = new VarplayerRequirement(1192, false, 23);
        this.notMuddyChest = new VarplayerRequirement(1192, false, 24);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1);
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.runeAxe = new ItemRequirement("Rune axe or better", ItemCollections.RUNE_AXE_BETTER).showConditioned(this.notEntYew).isNotConsumed();
        this.antiDragonShield = new ItemRequirement("Anti-dragon shield", ItemCollections.ANTIFIRE_SHIELDS).showConditioned(this.notKillGreenDrag).isNotConsumed();
        this.godEquip = new ItemRequirement("Various god equipment (1 of each god suggested)", -1, -1).showConditioned(this.notWildyGWBloodveld).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notMineMith).isNotConsumed();
        this.unpoweredOrb = new ItemRequirement("Unpowered orb", 567).showConditioned(this.notEarthOrb);
        this.cosmicRune = new ItemRequirement("Cosmic rune", 564).showConditioned(this.notEarthOrb);
        this.earthRune = new ItemRequirement("Earth rune", 557).showConditioned(this.notEarthOrb);
        this.knife = new ItemRequirement("Knife or slashing weapon", -1, -1).isNotConsumed();
        this.muddyKey = new ItemRequirement("Muddy key", 991).showConditioned(this.notMuddyChest);
        this.goldHelmet = new ItemRequirement("Golden helmet not in inventory or bank (make sure this is red)", 4567).showConditioned(this.notGoldHelm).isNotConsumed();
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(this.notGoldHelm);
        this.goldBar = new ItemRequirement("Gold bar", 2357).showConditioned(this.notGoldHelm);
        this.goldOre = new ItemRequirement("Gold ore", 444);
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(this.notGoldHelm).isNotConsumed();
        this.barsOrPick = new ItemRequirements(LogicType.OR, "3 gold bars or a pickaxe", this.goldBar.quantity(3), this.pickaxe);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.burningAmulet = new ItemRequirement("Burning amulet", ItemCollections.BURNING_AMULETS);
        this.gamesNeck = new ItemRequirement("Games necklace", ItemCollections.GAMES_NECKLACES);
        this.enterGodwars = new ComplexRequirement(LogicType.OR, "60 Agility or Strength", new SkillRequirement(Skill.AGILITY, 60), new SkillRequirement(Skill.STRENGTH, 60));
        this.inEdge = new ZoneRequirement(this.edge);
        this.inResource = new ZoneRequirement(this.resource);
        this.inGodWars1 = new ZoneRequirement(this.godWars1);
        this.inGodWars2 = new ZoneRequirement(this.godWars2);
        this.inSlayer = new ZoneRequirement(this.slayer);
        this.betweenARock = new QuestRequirement(QuestHelperQuest.BETWEEN_A_ROCK, QuestState.IN_PROGRESS, "Schematic to make gold helmet in Between a Rock");
    }

    public void loadZones() {
        this.resource = new Zone(new WorldPoint(3174, 3944, 0), new WorldPoint(3196, 3924, 0));
        this.godWars1 = new Zone(new WorldPoint(3046, 10177, 3), new WorldPoint(3076, 10138, 3));
        this.godWars2 = new Zone(new WorldPoint(3014, 10168, 0), new WorldPoint(3069, 10115, 0));
        this.slayer = new Zone(new WorldPoint(3327, 10165, 0), new WorldPoint(3456, 10043, 0));
        this.edge = new Zone(new WorldPoint(3067, 10000, 0), new WorldPoint(3288, 9821, 0));
    }

    public void setupSteps() {
        this.entYew = new NpcStep((QuestHelper)this, 6594, new WorldPoint(3227, 3666, 0), "Kill an Ent in the wilderness and cut yew logs from its trunk after killing it.", this.combatGear, this.runeAxe);
        this.entYew.addAlternateNpcs(9474);
        this.moveToSlayer1 = new ObjectStep((QuestHelper)this, 40388, new WorldPoint(3260, 3665, 0), "Enter the Wilderness Slayer Cave.", this.combatGear, this.food);
        this.killAnkou = new NpcStep((QuestHelper)this, 7864, new WorldPoint(3373, 10073, 0), "Kill an Ankou in the Wilderness Slayer Cave.", true, this.combatGear, this.food);
        this.moveToSlayer2 = new ObjectStep((QuestHelper)this, 40388, new WorldPoint(3260, 3665, 0), "Enter the Wilderness Slayer Cave.", this.combatGear, this.food, this.antiDragonShield);
        this.killGreenDrag = new NpcStep((QuestHelper)this, 7868, new WorldPoint(3412, 10066, 0), "Kill a Green dragon in the Wilderness Slayer Cave.", true, this.combatGear, this.food, this.antiDragonShield);
        this.killGreenDrag.addAlternateNpcs(7869, 7870);
        this.moveToGodWars1 = new ObjectStep((QuestHelper)this, 26766, new WorldPoint(3017, 3738, 0), "Enter the Wilderness God Wars Dungeon.", this.combatGear, this.food, this.godEquip);
        this.moveToGodWars2 = new ObjectStep((QuestHelper)this, 26766, new WorldPoint(3017, 3738, 0), "Enter the Wilderness God Wars Dungeon.", this.combatGear, this.food, this.godEquip);
        this.wildyGodwars = new ObjectStep((QuestHelper)this, 26767, new WorldPoint(3066, 10142, 3), "Use the crevice to enter the Wilderness God Wars Dungeon. The Strength entrance is to the West.", this.combatGear, this.food, this.godEquip);
        this.wildyGWBloodveld = new NpcStep((QuestHelper)this, 3138, new WorldPoint(3050, 10131, 0), "Kill a Bloodveld in the Wilderness God Wars Dungeon.", this.combatGear, this.food, this.godEquip);
        this.mineMith = new ObjectStep((QuestHelper)this, 11373, new WorldPoint(3057, 3944, 0), "Mine mithril in the Wilderness.", this.pickaxe);
        this.wildyAgi = new ObjectStep((QuestHelper)this, 23555, new WorldPoint(2998, 3917, 0), "Complete a lap of the Wilderness Agility Course.", new Requirement[0]);
        this.moveToEdge = new ObjectStep((QuestHelper)this, 1581, new WorldPoint(3097, 3468, 0), "Enter to the Edgeville Dungeon.", new Requirement[0]);
        this.earthOrb = new ObjectStep((QuestHelper)this, 2150, new WorldPoint(3087, 9933, 0), "Cast charge earth orb on the Obelisk of Earth.", this.unpoweredOrb, this.earthRune.quantity(30), this.cosmicRune.quantity(3));
        this.emblemTrader = new NpcStep((QuestHelper)this, 308, new WorldPoint(3097, 3504, 0), "Speak with the Emblem Trader.", new Requirement[0]);
        this.goldHelm = new ObjectStep((QuestHelper)this, 2097, new WorldPoint(3190, 3938, 0), "Smith the gold helmet in the Resource Area. ", this.hammer, this.goldBar.quantity(3));
        this.moveToResource = new ObjectStep((QuestHelper)this, 26760, new WorldPoint(3184, 3944, 0), "Enter the Wilderness Resource Area. Check your bank to make sure you DO NOT have a gold helmet.", this.coins.quantity(7500), this.hammer, this.barsOrPick, this.goldHelmet);
        this.smeltGoldOre = new ObjectStep((QuestHelper)this, 26300, new WorldPoint(3191, 3936, 0), "Smelt the gold ore into gold bars.", this.hammer, this.goldOre.quantity(3));
        this.mineGoldOre = new ObjectStep((QuestHelper)this, 11370, new WorldPoint(3184, 3941, 0), "Mine gold ore.", true, this.hammer, this.pickaxe);
        this.muddyChest = new ObjectStep((QuestHelper)this, 170, new WorldPoint(3089, 3859, 0), "Use a Muddy key on the chest in the Lava Maze.", this.muddyKey, this.knife);
        this.claimReward = new NpcStep((QuestHelper)this, 5514, new WorldPoint(3121, 3518, 0), "Talk to Lesser Fanatic in Edgeville to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.unpoweredOrb, this.cosmicRune.quantity(3), this.earthRune.quantity(30), this.pickaxe, this.antiDragonShield, this.runeAxe, this.combatGear, this.barsOrPick, this.hammer, this.coins.quantity(7500), this.knife, this.muddyKey);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.gamesNeck, this.burningAmulet);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(this.enterGodwars);
        reqs.add(new SkillRequirement(Skill.AGILITY, 52));
        reqs.add(new SkillRequirement(Skill.MAGIC, 60));
        reqs.add(new SkillRequirement(Skill.MINING, 55));
        reqs.add(new SkillRequirement(Skill.SLAYER, 50));
        reqs.add(new SkillRequirement(Skill.SMITHING, 50));
        reqs.add(new SkillRequirement(Skill.WOODCUTTING, 61));
        reqs.add(this.betweenARock);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Bloodveld (lvl 81)", "Green dragon (lvl 88)", "Ankou (lvl 98)", "Ent (lvl 101)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Wilderness Sword 2", 13109), new ItemReward("7,500 Exp. Lamp (Any skill over 40)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Increases the chance of a successful yield from ents by 15%"), new UnlockReward("20% off entry to Resource Area (6000gp)"), new UnlockReward("Can have 4 ecumenical keys at a time"), new UnlockReward("20 random free runes from Lundail once per day"), new UnlockReward("Access to the shortcut in the Deep Wilderness Dungeon (requires Agility 46 )"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails entSteps = new PanelDetails("Ent Yew", Collections.singletonList(this.entYew), new SkillRequirement(Skill.WOODCUTTING, 61), this.combatGear, this.food, this.runeAxe);
        entSteps.setDisplayCondition(this.notEntYew);
        entSteps.setLockingStep(this.entYewTask);
        allSteps.add(entSteps);
        PanelDetails ankouSteps = new PanelDetails("Kill Ankou", Arrays.asList(this.moveToSlayer1, this.killAnkou), this.combatGear, this.food);
        ankouSteps.setDisplayCondition(this.notKillAnkou);
        ankouSteps.setLockingStep(this.killAnkouTask);
        allSteps.add(ankouSteps);
        PanelDetails greenDragSteps = new PanelDetails("Kill Green Dragon", Arrays.asList(this.moveToSlayer2, this.killGreenDrag), this.combatGear, this.food, this.antiDragonShield);
        greenDragSteps.setDisplayCondition(this.notKillGreenDrag);
        greenDragSteps.setLockingStep(this.killGreenDragTask);
        allSteps.add(greenDragSteps);
        PanelDetails godWarsSteps = new PanelDetails("Enter Wilderness God Wars", Arrays.asList(this.moveToGodWars1, this.wildyGodwars), new Requirement[0]);
        godWarsSteps.setDisplayCondition(this.notWildyGodWars);
        godWarsSteps.setLockingStep(this.wildyGodWarsTask);
        allSteps.add(godWarsSteps);
        PanelDetails bloodveldSteps = new PanelDetails("Kill Bloodveld in God Wars Dungeon", Arrays.asList(this.moveToGodWars2, this.wildyGodwars, this.wildyGWBloodveld), new SkillRequirement(Skill.SLAYER, 50), this.enterGodwars, this.combatGear, this.food, this.godEquip);
        bloodveldSteps.setDisplayCondition(this.notWildyGWBloodveld);
        bloodveldSteps.setLockingStep(this.wildyGWBloodveldTask);
        allSteps.add(bloodveldSteps);
        PanelDetails emblemSteps = new PanelDetails("Emblem Trader", Collections.singletonList(this.emblemTrader), new Requirement[0]);
        emblemSteps.setDisplayCondition(this.notEmblemTrader);
        emblemSteps.setLockingStep(this.emblemTraderTask);
        allSteps.add(emblemSteps);
        PanelDetails earthOrbSteps = new PanelDetails("Earth Orb", Arrays.asList(this.moveToEdge, this.earthOrb), new SkillRequirement(Skill.MAGIC, 60), this.unpoweredOrb, this.earthRune.quantity(30), this.cosmicRune.quantity(3));
        earthOrbSteps.setDisplayCondition(this.notEarthOrb);
        earthOrbSteps.setLockingStep(this.earthOrbTask);
        allSteps.add(earthOrbSteps);
        PanelDetails mithSteps = new PanelDetails("Mine Mithril", Collections.singletonList(this.mineMith), new SkillRequirement(Skill.MINING, 55), this.pickaxe, this.knife);
        mithSteps.setDisplayCondition(this.notMineMith);
        mithSteps.setLockingStep(this.mineMithTask);
        allSteps.add(mithSteps);
        PanelDetails wildyAgiSteps = new PanelDetails("Wilderness Agility Course", Collections.singletonList(this.wildyAgi), new SkillRequirement(Skill.AGILITY, 52), this.knife);
        wildyAgiSteps.setDisplayCondition(this.notWildyAgi);
        wildyAgiSteps.setLockingStep(this.wildyAgiTask);
        allSteps.add(wildyAgiSteps);
        PanelDetails goldHelmSteps = new PanelDetails("Gold Helmet in Resource Area", Arrays.asList(this.moveToResource, this.mineGoldOre, this.smeltGoldOre, this.goldHelm), new SkillRequirement(Skill.SMITHING, 50), this.betweenARock, this.coins.quantity(7500), this.barsOrPick, this.hammer, this.knife);
        goldHelmSteps.setDisplayCondition(this.notGoldHelm);
        goldHelmSteps.setLockingStep(this.goldHelmTask);
        allSteps.add(goldHelmSteps);
        PanelDetails chestSteps = new PanelDetails("Muddy Chest", Collections.singletonList(this.muddyChest), this.muddyKey, this.knife);
        chestSteps.setDisplayCondition(this.notMuddyChest);
        chestSteps.setLockingStep(this.muddyChestTask);
        allSteps.add(chestSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

