/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.wilderness;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.WILDERNESS_HARD)
public class WildernessHard
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement godRunes;
    ItemRequirement godStaff;
    ItemRequirement unpoweredOrb;
    ItemRequirement airRune;
    ItemRequirement cosmicRune;
    ItemRequirement smallFishingNet;
    ItemRequirement rope;
    ItemRequirement knife;
    ItemRequirement oilyRod;
    ItemRequirement fishingBait;
    ItemRequirement godEquip;
    ItemRequirement pickaxe;
    ItemRequirement coins;
    ItemRequirement addyBar;
    ItemRequirement addyOre;
    ItemRequirement barsOrPick;
    ItemRequirement hammer;
    ItemRequirement lavaDragonBones;
    ItemRequirement food;
    ItemRequirement burningAmulet;
    Requirement mageArena;
    Requirement deathPlateau;
    Requirement normalBook;
    Requirement notGodSpells;
    Requirement notAirOrb;
    Requirement notBlackSally;
    Requirement notAddyScim;
    Requirement notLavaDrag;
    Requirement notChaosEle;
    Requirement notThreeBosses;
    Requirement notTrollWildy;
    Requirement notSprirtualWarrior;
    Requirement notRawLavaEel;
    Requirement enterGodwars;
    QuestStep claimReward;
    QuestStep godSpells;
    QuestStep airOrb;
    QuestStep blackSally;
    QuestStep addyScim;
    QuestStep lavaDrag;
    QuestStep trollWildy;
    QuestStep rawLavaEel;
    QuestStep moveToEdge;
    QuestStep moveToAir;
    QuestStep moveToResource;
    QuestStep moveToGodWars1;
    QuestStep moveToGodWars2;
    QuestStep buryBone;
    NpcStep threeBosses;
    NpcStep chaosEle;
    NpcStep sprirtualWarrior;
    Zone edge;
    Zone air;
    Zone resource;
    Zone godWars1;
    Zone godWars2;
    Zone scorpCave;
    ZoneRequirement inEdge;
    ZoneRequirement inAir;
    ZoneRequirement inResource;
    ZoneRequirement inGodWars1;
    ZoneRequirement inGodWars2;
    ZoneRequirement inScorpCave;
    ConditionalStep godSpellsTask;
    ConditionalStep airOrbTask;
    ConditionalStep blackSallyTask;
    ConditionalStep addyScimTask;
    ConditionalStep lavaDragTask;
    ConditionalStep chaosEleTask;
    ConditionalStep threeBossesTask;
    ConditionalStep trollWildyTask;
    ConditionalStep sprirtualWarriorTask;
    ConditionalStep rawLavaEelTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doHard = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.airOrbTask = new ConditionalStep((QuestHelper)this, this.moveToEdge, new Requirement[0]);
        this.airOrbTask.addStep(this.inEdge, this.moveToAir);
        this.airOrbTask.addStep(this.inAir, this.airOrb);
        doHard.addStep(this.notAirOrb, this.airOrbTask);
        this.blackSallyTask = new ConditionalStep((QuestHelper)this, this.blackSally, new Requirement[0]);
        doHard.addStep(this.notBlackSally, this.blackSallyTask);
        this.lavaDragTask = new ConditionalStep((QuestHelper)this, this.lavaDrag, new Requirement[0]);
        this.lavaDragTask.addStep(this.lavaDragonBones, this.buryBone);
        doHard.addStep(this.notLavaDrag, this.lavaDragTask);
        this.rawLavaEelTask = new ConditionalStep((QuestHelper)this, this.rawLavaEel, new Requirement[0]);
        doHard.addStep(this.notRawLavaEel, this.rawLavaEelTask);
        this.sprirtualWarriorTask = new ConditionalStep((QuestHelper)this, this.moveToGodWars1, new Requirement[0]);
        this.sprirtualWarriorTask.addStep(this.inGodWars1, this.moveToGodWars2);
        this.sprirtualWarriorTask.addStep(this.inGodWars2, this.sprirtualWarrior);
        doHard.addStep(this.notSprirtualWarrior, this.sprirtualWarriorTask);
        this.trollWildyTask = new ConditionalStep((QuestHelper)this, this.trollWildy, new Requirement[0]);
        doHard.addStep(this.notTrollWildy, this.trollWildyTask);
        this.addyScimTask = new ConditionalStep((QuestHelper)this, this.moveToResource, new Requirement[0]);
        this.addyScimTask.addStep(this.inResource, this.addyScim);
        doHard.addStep(this.notAddyScim, this.addyScimTask);
        this.chaosEleTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.chaosEle, new Requirement[0]);
        doHard.addStep(this.notChaosEle, this.chaosEleTask);
        this.threeBossesTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.threeBosses, new Requirement[0]);
        doHard.addStep(this.notThreeBosses, this.threeBossesTask);
        this.godSpellsTask = new ConditionalStep((QuestHelper)this, this.godSpells, new Requirement[0]);
        doHard.addStep(this.notGodSpells, this.godSpellsTask);
        return doHard;
    }

    @Override
    public void setupRequirements() {
        this.notGodSpells = new VarplayerRequirement(1192, false, 25);
        this.notAirOrb = new VarplayerRequirement(1192, false, 26);
        this.notBlackSally = new VarplayerRequirement(1192, false, 27);
        this.notAddyScim = new VarplayerRequirement(1192, false, 28);
        this.notLavaDrag = new VarplayerRequirement(1192, false, 29);
        this.notChaosEle = new VarplayerRequirement(1192, false, 30);
        this.notThreeBosses = new VarplayerRequirement(1192, false, 31);
        this.notTrollWildy = new VarplayerRequirement(1193, false, 0);
        this.notSprirtualWarrior = new VarplayerRequirement(1193, false, 1);
        this.notRawLavaEel = new VarplayerRequirement(1193, false, 2);
        this.normalBook = new SpellbookRequirement(Spellbook.NORMAL);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.godRunes = new ItemRequirement("Runes for a god spell that correspond with your god staff", -1, -1).showConditioned(this.notGodSpells);
        this.godStaff = new ItemRequirement("Any god staff", ItemCollections.GOD_STAFF).showConditioned(this.notGodSpells).isNotConsumed();
        this.unpoweredOrb = new ItemRequirement("Unpowered orb", 567).showConditioned(this.notAirOrb);
        this.cosmicRune = new ItemRequirement("Cosmic rune", 564).showConditioned(this.notAirOrb);
        this.airRune = new ItemRequirement("Air rune", 556).showConditioned(this.notAirOrb);
        this.smallFishingNet = new ItemRequirement("Small fishing net", 303).showConditioned(this.notBlackSally).isNotConsumed();
        this.rope = new ItemRequirement("Rope", 954).showConditioned(this.notBlackSally).isNotConsumed();
        this.knife = new ItemRequirement("Knife or slashing weapon", -1, -1).showConditioned(this.notRawLavaEel).isNotConsumed();
        this.oilyRod = new ItemRequirement("Oily fishing rod", 1585).showConditioned(this.notRawLavaEel).isNotConsumed();
        this.fishingBait = new ItemRequirement("Fishing bait", 313).showConditioned(this.notRawLavaEel).isNotConsumed();
        this.godEquip = new ItemRequirement("Various god equipment (1 of each god suggested)", -1, -1).showConditioned(this.notSprirtualWarrior).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notAddyScim).isNotConsumed();
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(this.notAddyScim);
        this.addyBar = new ItemRequirement("Adamantite bar", 2361, 2).showConditioned(this.notAddyScim);
        this.addyOre = new ItemRequirement("Adamantite ore", 449);
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(this.notAddyScim).isNotConsumed();
        this.barsOrPick = new ItemRequirements(LogicType.OR, "2 Adamantite bars or a pickaxe", this.addyBar, this.pickaxe);
        this.lavaDragonBones = new ItemRequirement("Lava Dragon Bones", 11943);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.burningAmulet = new ItemRequirement("Burning amulet", ItemCollections.BURNING_AMULETS);
        this.enterGodwars = new ComplexRequirement(LogicType.OR, "60 Agility or Strength", new SkillRequirement(Skill.AGILITY, 60), new SkillRequirement(Skill.STRENGTH, 60));
        this.inEdge = new ZoneRequirement(this.edge);
        this.inAir = new ZoneRequirement(this.air);
        this.inResource = new ZoneRequirement(this.resource);
        this.inGodWars1 = new ZoneRequirement(this.godWars1);
        this.inGodWars2 = new ZoneRequirement(this.godWars2);
        this.inScorpCave = new ZoneRequirement(this.scorpCave);
        this.mageArena = new QuestRequirement(QuestHelperQuest.THE_MAGE_ARENA, QuestState.FINISHED);
        this.deathPlateau = new QuestRequirement(QuestHelperQuest.DEATH_PLATEAU, QuestState.IN_PROGRESS);
    }

    public void loadZones() {
        this.edge = new Zone(new WorldPoint(3067, 10000, 0), new WorldPoint(3288, 9821, 0));
        this.air = new Zone(new WorldPoint(3081, 3576, 0), new WorldPoint(3094, 3564, 0));
        this.resource = new Zone(new WorldPoint(3174, 3944, 0), new WorldPoint(3196, 3924, 0));
        this.godWars1 = new Zone(new WorldPoint(3046, 10177, 3), new WorldPoint(3076, 10138, 3));
        this.godWars2 = new Zone(new WorldPoint(3014, 10168, 0), new WorldPoint(3069, 10115, 0));
        this.scorpCave = new Zone(new WorldPoint(3217, 10354, 0), new WorldPoint(3249, 10329, 0));
    }

    public void setupSteps() {
        this.godSpells = new DetailedQuestStep((QuestHelper)this, "Cast one of the 3 god spells against another player in the Wilderness. Splashing will not count.", this.godStaff.equipped(), this.godRunes);
        this.moveToEdge = new ObjectStep((QuestHelper)this, 1581, new WorldPoint(3097, 3468, 0), "Enter to the Edgeville dungeon.", this.airRune.quantity(30), this.cosmicRune.quantity(3), this.unpoweredOrb);
        this.moveToAir = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(3088, 9971, 0), "Climb the ladder that leads to the Obelisk of Air.", this.airRune.quantity(30), this.cosmicRune.quantity(3), this.unpoweredOrb);
        this.airOrb = new ObjectStep((QuestHelper)this, 2152, new WorldPoint(3088, 3569, 0), "Cast charge air orb on the Obelisk of Air.", this.airRune.quantity(30), this.cosmicRune.quantity(3), this.unpoweredOrb);
        this.chaosEle = new NpcStep((QuestHelper)this, 2054, new WorldPoint(3263, 3918, 0), "Kill the Chaos Elemental.", this.combatGear, this.food);
        this.chaosEle.addAlternateNpcs(6505);
        this.blackSally = new ObjectStep((QuestHelper)this, 9000, new WorldPoint(3296, 3671, 0), "Set a trap and catch a Black salamander in the Wilderness.", true, new Requirement[0]);
        this.lavaDrag = new NpcStep((QuestHelper)this, 6593, new WorldPoint(3209, 3848, 0), "Kill a Lava dragon and bury the bones on Lava Dragon Isle.", true, this.combatGear, this.food);
        this.buryBone = new ItemStep((QuestHelper)this, "Bury the dragon bones", this.lavaDragonBones.highlighted());
        this.rawLavaEel = new NpcStep((QuestHelper)this, 6784, new WorldPoint(3071, 3839, 0), "Fish a raw lava eel in the Lava Maze.", this.knife, this.oilyRod, this.fishingBait);
        this.addyScim = new ObjectStep((QuestHelper)this, 2097, new WorldPoint(3190, 3938, 0), "Smith an Adamant scimitar in the Resource Area.", this.hammer, this.addyBar);
        this.moveToResource = new ObjectStep((QuestHelper)this, 26760, new WorldPoint(3184, 3944, 0), "Enter the Wilderness Resource Area.", this.coins.quantity(6000), this.hammer, this.addyBar);
        this.moveToGodWars1 = new ObjectStep((QuestHelper)this, 26766, new WorldPoint(3017, 3738, 0), "Enter the Wilderness God Wars Dungeon.", this.combatGear, this.food, this.godEquip);
        this.moveToGodWars2 = new ObjectStep((QuestHelper)this, 26767, new WorldPoint(3066, 10142, 3), "Use the crevice to enter the Wilderness God Wars Dungeon. The Strength entrance is to the West.", this.combatGear, this.food, this.godEquip);
        this.sprirtualWarrior = new NpcStep((QuestHelper)this, 2210, new WorldPoint(3050, 10131, 0), "Kill a Spiritual Warrior in the Wilderness God Wars Dungeon.", this.combatGear, this.food, this.godEquip);
        this.sprirtualWarrior.addAlternateNpcs(2243, 3159, 3166);
        this.threeBosses = new NpcStep((QuestHelper)this, 6618, new WorldPoint(3947, 3706, 0), "Kill Crazy archaeologist, Chaos Fanatic, and Scorpia. You must complete this task fully before continuing the other tasks.", this.combatGear, this.food);
        this.threeBosses.addAlternateNpcs(6615, 6619);
        this.trollWildy = new ObjectStep((QuestHelper)this, 16545, new WorldPoint(2916, 3672, 0), "Take the agility shortcut from Trollheim to the Wilderness.", new Requirement[0]);
        this.claimReward = new NpcStep((QuestHelper)this, 5514, new WorldPoint(3121, 3518, 0), "Talk to Lesser Fanatic in Edgeville to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.godStaff, this.godRunes, this.airRune.quantity(30), this.cosmicRune.quantity(3), this.unpoweredOrb, this.knife, this.oilyRod, this.fishingBait, this.coins.quantity(6000), this.hammer, this.barsOrPick, this.godEquip);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.burningAmulet);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(this.enterGodwars);
        reqs.add(new SkillRequirement(Skill.AGILITY, 64));
        reqs.add(new SkillRequirement(Skill.FISHING, 53));
        reqs.add(new SkillRequirement(Skill.HUNTER, 67));
        reqs.add(new SkillRequirement(Skill.MAGIC, 66));
        reqs.add(new SkillRequirement(Skill.SLAYER, 68));
        reqs.add(new SkillRequirement(Skill.SMITHING, 75));
        reqs.add(this.deathPlateau);
        reqs.add(this.mageArena);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Chaos Elemental (lvl 305)", "Crazy archaeologist (lvl 204)", "Chaos Fanatic (lvl 202)", "Lava dragon (lvl 252)", "Scorpia (lvl 225)", "Spiritual warrior (lvl 115-134)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Wilderness Sword 3", 13110), new ItemReward("15,000 Exp. Lamp (Any skill over 50)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("One free teleport to the Fountain of Rune daily on the Wilderness Sword 3"), new UnlockReward("50% more lava shards per lava scale"), new UnlockReward("Access to a shortcut to the Lava Dragon Isle (requires Agility 74 )"), new UnlockReward("Access to a shortcut to the Lava Maze (requires Agility 82 )"), new UnlockReward("Can have 5 ecumenical keys at a time"), new UnlockReward("30 random free runes from Lundail once per day"), new UnlockReward("Able to choose your destination when teleporting through the Ancient Obelisks"), new UnlockReward("50% off entry to Resource Area (3,750gp)"), new UnlockReward("Wine of zamorak found in the Chaos Temple (hut) and Deep Wilderness Dungeon will be received in noted form"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails airSteps = new PanelDetails("Air Orb", Arrays.asList(this.moveToEdge, this.moveToAir, this.airOrb), new SkillRequirement(Skill.MAGIC, 60), this.airRune.quantity(30), this.cosmicRune.quantity(3), this.unpoweredOrb);
        airSteps.setDisplayCondition(this.notAirOrb);
        airSteps.setLockingStep(this.airOrbTask);
        allSteps.add(airSteps);
        PanelDetails sallySteps = new PanelDetails("Black Salamander", Collections.singletonList(this.blackSally), new SkillRequirement(Skill.HUNTER, 67), this.smallFishingNet, this.rope);
        sallySteps.setDisplayCondition(this.notBlackSally);
        sallySteps.setLockingStep(this.blackSallyTask);
        allSteps.add(sallySteps);
        PanelDetails lavaSteps = new PanelDetails("Lava Dragon and Bury", Collections.singletonList(this.lavaDrag), this.combatGear, this.food);
        lavaSteps.setDisplayCondition(this.notLavaDrag);
        lavaSteps.setLockingStep(this.lavaDragTask);
        allSteps.add(lavaSteps);
        PanelDetails rawLavaEelSteps = new PanelDetails("Fishing a Raw Lava Eel", Collections.singletonList(this.rawLavaEel), new SkillRequirement(Skill.FISHING, 53), this.oilyRod, this.fishingBait, this.knife);
        rawLavaEelSteps.setDisplayCondition(this.notRawLavaEel);
        rawLavaEelSteps.setLockingStep(this.rawLavaEelTask);
        allSteps.add(rawLavaEelSteps);
        PanelDetails warrSteps = new PanelDetails("Spiritual Warrior", Arrays.asList(this.moveToGodWars1, this.moveToGodWars2, this.sprirtualWarrior), this.enterGodwars, new SkillRequirement(Skill.SLAYER, 68), this.combatGear, this.food, this.godEquip);
        warrSteps.setDisplayCondition(this.notSprirtualWarrior);
        warrSteps.setLockingStep(this.sprirtualWarriorTask);
        allSteps.add(warrSteps);
        PanelDetails trollSteps = new PanelDetails("Agility Shortcut", Collections.singletonList(this.trollWildy), new SkillRequirement(Skill.AGILITY, 64), this.deathPlateau);
        trollSteps.setDisplayCondition(this.notTrollWildy);
        trollSteps.setLockingStep(this.trollWildyTask);
        allSteps.add(trollSteps);
        PanelDetails scimSteps = new PanelDetails("Adamant Scimitar in Resource Area", Arrays.asList(this.moveToResource, this.addyScim), new SkillRequirement(Skill.SMITHING, 75), this.barsOrPick);
        scimSteps.setDisplayCondition(this.notAddyScim);
        scimSteps.setLockingStep(this.addyScimTask);
        allSteps.add(scimSteps);
        PanelDetails chaosSteps = new PanelDetails("Chaos Elemental", Collections.singletonList(this.chaosEle), this.combatGear, this.food);
        chaosSteps.setDisplayCondition(this.notChaosEle);
        chaosSteps.setLockingStep(this.chaosEleTask);
        allSteps.add(chaosSteps);
        PanelDetails bossesSteps = new PanelDetails("Three Bosses", Collections.singletonList(this.threeBosses), this.combatGear, this.food);
        bossesSteps.setDisplayCondition(this.notThreeBosses);
        bossesSteps.setLockingStep(this.threeBossesTask);
        allSteps.add(bossesSteps);
        PanelDetails godSpellSteps = new PanelDetails("God Spell on Player", Collections.singletonList(this.godSpells), new SkillRequirement(Skill.MAGIC, 60), this.godStaff, this.godRunes);
        godSpellSteps.setDisplayCondition(this.notGodSpells);
        godSpellSteps.setLockingStep(this.godSpellsTask);
        allSteps.add(godSpellSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

