/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.wilderness;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.WILDERNESS_ELITE)
public class WildernessElite
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement hammer;
    ItemRequirement lawRune;
    ItemRequirement waterRune;
    ItemRequirement lobsterPot;
    ItemRequirement darkFishingBait;
    ItemRequirement coins;
    ItemRequirement pickaxe;
    ItemRequirement axe;
    ItemRequirement tinderbox;
    ItemRequirement godEquip;
    ItemRequirement coal;
    ItemRequirement runeOre;
    ItemRequirement magicLog;
    ItemRequirement runeBar;
    ItemRequirement rawDarkCrab;
    ItemRequirement food;
    Requirement desertTreasure;
    Requirement enterGodwars;
    Requirement ancientBook;
    Requirement gatheredLogs;
    Requirement caughtCrab;
    Requirement runiteFromGolems;
    Requirement barsSmelted;
    Requirement notThreeBosses;
    Requirement notTPGhorrock;
    Requirement notDarkCrab;
    Requirement notRuneScim;
    Requirement notRoguesChest;
    Requirement notSpiritMage;
    Requirement notMagicLogs;
    QuestStep claimReward;
    QuestStep tPGhorrock;
    QuestStep darkCrab;
    QuestStep cookDarkCrab;
    QuestStep runeScim;
    QuestStep roguesChest;
    QuestStep magicLogs;
    QuestStep burnLogs;
    QuestStep moveToResource1;
    QuestStep moveToResource2;
    QuestStep moveToResource3;
    QuestStep smeltBar;
    QuestStep moveToGodWars1;
    QuestStep moveToGodWars2;
    NpcStep threeBosses;
    NpcStep spiritMage;
    NpcStep runiteGolem;
    Zone resource;
    Zone godWars1;
    Zone godWars2;
    ZoneRequirement inResource;
    ZoneRequirement inGodWars2;
    ZoneRequirement inGodWars1;
    ConditionalStep threeBossesTask;
    ConditionalStep tpGhorrockTask;
    ConditionalStep darkCrabTask;
    ConditionalStep runeScimTask;
    ConditionalStep roguesChestTask;
    ConditionalStep spiritMageTask;
    ConditionalStep magicLogsTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doElite = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.tpGhorrockTask = new ConditionalStep((QuestHelper)this, this.tPGhorrock, new Requirement[0]);
        doElite.addStep(this.notTPGhorrock, this.tpGhorrockTask);
        this.magicLogsTask = new ConditionalStep((QuestHelper)this, this.moveToResource1, new Requirement[0]);
        this.magicLogsTask.addStep(this.inResource, this.magicLogs);
        this.magicLogsTask.addStep(new Conditions(this.inResource, this.gatheredLogs, this.magicLog), this.burnLogs);
        doElite.addStep(this.notMagicLogs, this.magicLogsTask);
        this.runeScimTask = new ConditionalStep((QuestHelper)this, this.moveToResource2, new Requirement[0]);
        this.runeScimTask.addStep(this.inResource, this.runiteGolem);
        this.runeScimTask.addStep(new Conditions(this.inResource, this.runeOre.quantity(2), this.coal.quantity(16), this.runiteFromGolems), this.smeltBar);
        this.runeScimTask.addStep(new Conditions(this.inResource, this.runeBar.quantity(2), this.barsSmelted), this.runeScim);
        doElite.addStep(this.notRuneScim, this.runeScimTask);
        this.darkCrabTask = new ConditionalStep((QuestHelper)this, this.moveToResource3, new Requirement[0]);
        this.darkCrabTask.addStep(this.inResource, this.darkCrab);
        this.darkCrabTask.addStep(new Conditions(this.inResource, this.caughtCrab, this.rawDarkCrab), this.cookDarkCrab);
        doElite.addStep(this.notDarkCrab, this.darkCrabTask);
        this.roguesChestTask = new ConditionalStep((QuestHelper)this, this.roguesChest, new Requirement[0]);
        doElite.addStep(this.notRoguesChest, this.roguesChestTask);
        this.spiritMageTask = new ConditionalStep((QuestHelper)this, this.moveToGodWars1, new Requirement[0]);
        this.spiritMageTask.addStep(this.inGodWars1, this.moveToGodWars2);
        this.spiritMageTask.addStep(this.inGodWars2, this.spiritMage);
        doElite.addStep(this.notSpiritMage, this.spiritMageTask);
        this.threeBossesTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.threeBosses, new Requirement[0]);
        doElite.addStep(this.notThreeBosses, this.threeBossesTask);
        return doElite;
    }

    @Override
    public void setupRequirements() {
        this.notThreeBosses = new VarplayerRequirement(1193, false, 3);
        this.notTPGhorrock = new VarplayerRequirement(1193, false, 5);
        this.notDarkCrab = new VarplayerRequirement(1193, false, 7);
        this.notRuneScim = new VarplayerRequirement(1193, false, 8);
        this.notRoguesChest = new VarplayerRequirement(1193, false, 9);
        this.notSpiritMage = new VarplayerRequirement(1193, false, 10);
        this.notMagicLogs = new VarplayerRequirement(1193, false, 11);
        this.ancientBook = new SpellbookRequirement(Spellbook.ANCIENT);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(this.notRuneScim).isNotConsumed();
        this.lawRune = new ItemRequirement("Law rune", 563).showConditioned(this.notTPGhorrock);
        this.waterRune = new ItemRequirement("Water rune", 555).showConditioned(this.notTPGhorrock);
        this.lobsterPot = new ItemRequirement("Lobster pot", 301).showConditioned(this.notDarkCrab).isNotConsumed();
        this.darkFishingBait = new ItemRequirement("Dark fish bait", 11940).showConditioned(this.notDarkCrab);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(new Conditions(LogicType.OR, this.notDarkCrab, this.notMagicLogs, this.notRuneScim));
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notRuneScim).isNotConsumed();
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(this.notMagicLogs).isNotConsumed();
        this.tinderbox = new ItemRequirement("Tinderbox", 590).showConditioned(this.notMagicLogs).isNotConsumed();
        this.godEquip = new ItemRequirement("Various god equipment (1 of each god suggested)", -1, -1).showConditioned(this.notSpiritMage).isNotConsumed();
        this.coal = new ItemRequirement("Coal", 453).showConditioned(this.notRuneScim);
        this.runeOre = new ItemRequirement("Runite ore", 451);
        this.runeBar = new ItemRequirement("Runite bar", 2363);
        this.magicLog = new ItemRequirement("Magic logs", 1513);
        this.rawDarkCrab = new ItemRequirement("Raw dark crab", 11934);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.enterGodwars = new ItemRequirement("60 Strength or Agility", -1, -1);
        this.inResource = new ZoneRequirement(this.resource);
        this.inGodWars1 = new ZoneRequirement(this.godWars1);
        this.inGodWars2 = new ZoneRequirement(this.godWars2);
        this.gatheredLogs = new ChatMessageRequirement(this.inResource, "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.gatheredLogs).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inResource), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
        this.caughtCrab = new ChatMessageRequirement(this.inResource, "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.caughtCrab).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inResource), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
        this.barsSmelted = new ChatMessageRequirement(this.inResource, "<col=0040ff>Achievement Diary Stage Task - Current stage: 4.</col>");
        ((ChatMessageRequirement)this.caughtCrab).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inResource), "<col=0040ff>Achievement Diary Stage Task - Current stage: 4.</col>"));
        this.runiteFromGolems = new ChatMessageRequirement(this.inResource, "<col=0040ff>Achievement Diary Stage Task - Current stage: 2.</col>");
        ((ChatMessageRequirement)this.caughtCrab).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inResource), "<col=0040ff>Achievement Diary Stage Task - Current stage: 2.</col>"));
        this.desertTreasure = new QuestRequirement(QuestHelperQuest.DESERT_TREASURE, QuestState.FINISHED);
    }

    public void loadZones() {
        this.resource = new Zone(new WorldPoint(3174, 3944, 0), new WorldPoint(3196, 3924, 0));
        this.godWars1 = new Zone(new WorldPoint(3046, 10177, 3), new WorldPoint(3076, 10138, 3));
        this.godWars2 = new Zone(new WorldPoint(3014, 10168, 0), new WorldPoint(3069, 10115, 0));
    }

    public void setupSteps() {
        this.moveToResource1 = new ObjectStep((QuestHelper)this, 26760, new WorldPoint(3184, 3944, 0), "Enter the Wilderness Resource Area.", this.coins.quantity(6000), this.axe, this.tinderbox);
        this.magicLogs = new ObjectStep((QuestHelper)this, 10834, new WorldPoint(3190, 3926, 0), "Chop some magic logs.", true, this.axe, this.tinderbox);
        this.burnLogs = new ItemStep((QuestHelper)this, "Burn the magic logs in the Resource Area.", this.tinderbox.highlighted(), this.magicLog.highlighted());
        this.moveToResource2 = new ObjectStep((QuestHelper)this, 26760, new WorldPoint(3184, 3944, 0), "Enter the Wilderness Resource Area.", this.coins.quantity(6000), this.combatGear, this.food, this.pickaxe, this.coal.quantity(16), this.hammer);
        this.runiteGolem = new NpcStep((QuestHelper)this, 6600, new WorldPoint(3189, 3938, 0), "Kill and mine the Runite Golems in the Resource Area.", true, this.combatGear, this.food, this.pickaxe, this.coal.quantity(16), this.hammer);
        this.runiteGolem.addAlternateNpcs(6601);
        this.smeltBar = new ObjectStep((QuestHelper)this, 26300, new WorldPoint(3191, 3936, 0), "Smelt the ore into runite bars.", this.hammer, this.runeOre.quantity(2), this.coal.quantity(16), this.hammer);
        this.runeScim = new ObjectStep((QuestHelper)this, 2097, new WorldPoint(3190, 3938, 0), "Smith a runite scimitar in the Resource Area.", this.hammer, this.runeBar.quantity(2));
        this.moveToResource3 = new ObjectStep((QuestHelper)this, 26760, new WorldPoint(3184, 3944, 0), "Enter the Wilderness Resource Area.", this.coins.quantity(6000), this.lobsterPot, this.darkFishingBait);
        this.darkCrab = new NpcStep((QuestHelper)this, 1536, new WorldPoint(3187, 3927, 0), "Fish a dark crab in the Resource Area.", this.lobsterPot, this.darkFishingBait);
        this.cookDarkCrab = new ObjectStep((QuestHelper)this, 26185, new WorldPoint(3188, 3930, 0), "Cook the raw dark crab on the nearby fire.", this.rawDarkCrab);
        this.tPGhorrock = new DetailedQuestStep((QuestHelper)this, "Teleport to Ghorrock.", this.ancientBook, this.lawRune.quantity(2), this.waterRune.quantity(8));
        this.moveToGodWars1 = new ObjectStep((QuestHelper)this, 26766, new WorldPoint(3018, 3739, 0), "Enter the Wilderness God Wars Dungeon.", this.combatGear, this.food, this.godEquip);
        this.moveToGodWars2 = new ObjectStep((QuestHelper)this, 26767, new WorldPoint(3066, 10142, 0), "Use the crevice to enter the Wilderness God Wars Dungeon. The Strength entrance is to the west.", this.combatGear, this.food, this.godEquip);
        this.spiritMage = new NpcStep((QuestHelper)this, 2212, new WorldPoint(3050, 10131, 0), "Kill a Spiritual Mage in the Wilderness God Wars Dungeon.", this.combatGear, this.food, this.godEquip);
        this.spiritMage.addAlternateNpcs(2244, 3161, 3168);
        this.threeBosses = new NpcStep((QuestHelper)this, 6503, new WorldPoint(3291, 3844, 0), "Kill Callisto, Venenatis, and Vet'ion. You must complete this task fully before continuing the other tasks.", this.combatGear, this.food);
        this.threeBosses.addAlternateNpcs(6611, 6504);
        this.roguesChest = new ObjectStep((QuestHelper)this, 26757, new WorldPoint(3297, 3940, 0), "Steal from the chest in Rogues' Castle.", new Requirement[0]);
        this.claimReward = new NpcStep((QuestHelper)this, 5514, new WorldPoint(3121, 3518, 0), "Talk to Lesser Fanatic in Edgeville to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.hammer, this.lawRune.quantity(2), this.waterRune.quantity(8), this.coins.quantity(3750), this.axe, this.tinderbox, this.pickaxe, this.coal.quantity(16), this.lobsterPot, this.darkFishingBait, this.godEquip);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.food);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(this.enterGodwars);
        reqs.add(new SkillRequirement(Skill.COOKING, 90));
        reqs.add(new SkillRequirement(Skill.FIREMAKING, 75));
        reqs.add(new SkillRequirement(Skill.FISHING, 85));
        reqs.add(new SkillRequirement(Skill.MAGIC, 96));
        reqs.add(new SkillRequirement(Skill.MINING, 85));
        reqs.add(new SkillRequirement(Skill.SLAYER, 83));
        reqs.add(new SkillRequirement(Skill.SMITHING, 90));
        reqs.add(new SkillRequirement(Skill.THIEVING, 84));
        reqs.add(new SkillRequirement(Skill.WOODCUTTING, 75));
        reqs.add(this.desertTreasure);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Callisto (lvl 470)", "Venenatis (lvl 464)", "Vet'ion (lvl 454)", "Runite Golem (lvl 178)", "Spiritual Mage (lvl 121)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Wilderness Sword 4", 13111), new ItemReward("50,000 Exp. Lamp (Any skill over 70)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Unlimited free teleports to the Fountain of Rune on the Wilderness Sword 4"), new UnlockReward("Free entry to the Resource Area"), new UnlockReward("All dragon bones drops in the Wilderness are noted. (Note: This does not include the King Black Dragon, as his lair is not Wilderness affected.)"), new UnlockReward("\tNoted lava dragon bones can be toggled by speaking to the Lesser Fanatic."), new UnlockReward("50 random free runes from Lundail once per day"), new UnlockReward("Increased dark crab catch rate"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails tpSteps = new PanelDetails("Teleport to Ghorrock", Collections.singletonList(this.tPGhorrock), new SkillRequirement(Skill.MAGIC, 96), this.desertTreasure, this.ancientBook, this.lawRune.quantity(2), this.waterRune.quantity(8));
        tpSteps.setDisplayCondition(this.notTPGhorrock);
        tpSteps.setLockingStep(this.tpGhorrockTask);
        allSteps.add(tpSteps);
        PanelDetails magicSteps = new PanelDetails("Chop and Burn Magic Logs", Arrays.asList(this.moveToResource1, this.magicLogs, this.burnLogs), new SkillRequirement(Skill.FIREMAKING, 75), new SkillRequirement(Skill.WOODCUTTING, 75), this.coins.quantity(6000), this.axe, this.tinderbox);
        magicSteps.setDisplayCondition(this.notMagicLogs);
        magicSteps.setLockingStep(this.magicLogsTask);
        allSteps.add(magicSteps);
        PanelDetails scimSteps = new PanelDetails("Rune Scimitar in Resource Area", Arrays.asList(this.moveToResource2, this.runiteGolem, this.smeltBar, this.runeScim), new SkillRequirement(Skill.MINING, 85), new SkillRequirement(Skill.SMITHING, 90), this.coins.quantity(6000), this.combatGear, this.food, this.pickaxe, this.coal.quantity(16), this.hammer);
        scimSteps.setDisplayCondition(this.notRuneScim);
        scimSteps.setLockingStep(this.runeScimTask);
        allSteps.add(scimSteps);
        PanelDetails crabSteps = new PanelDetails("Dark Crab in Resource Area", Arrays.asList(this.moveToResource3, this.darkCrab, this.cookDarkCrab), new SkillRequirement(Skill.COOKING, 90), new SkillRequirement(Skill.FISHING, 85), this.coins.quantity(6000), this.lobsterPot, this.darkFishingBait);
        crabSteps.setDisplayCondition(this.notDarkCrab);
        crabSteps.setLockingStep(this.darkCrabTask);
        allSteps.add(crabSteps);
        PanelDetails chestSteps = new PanelDetails("Rogues' Castle Chest", Collections.singletonList(this.roguesChest), new Requirement[0]);
        chestSteps.setDisplayCondition(this.notRoguesChest);
        chestSteps.setLockingStep(this.roguesChestTask);
        allSteps.add(chestSteps);
        PanelDetails mageSteps = new PanelDetails("Spiritual Mage", Arrays.asList(this.moveToGodWars1, this.moveToGodWars2, this.spiritMage), this.enterGodwars, this.combatGear, this.food, this.godEquip);
        mageSteps.setDisplayCondition(this.notSpiritMage);
        mageSteps.setLockingStep(this.spiritMageTask);
        allSteps.add(mageSteps);
        PanelDetails bossSteps = new PanelDetails("Three bosses", Collections.singletonList(this.threeBosses), this.combatGear, this.food);
        bossSteps.setDisplayCondition(this.notThreeBosses);
        bossSteps.setLockingStep(this.threeBossesTask);
        allSteps.add(bossSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

