/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.wilderness;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.WILDERNESS_EASY)
public class WildernessEasy
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement chaosAccess;
    ItemRequirement pickaxe;
    ItemRequirement teamCape;
    ItemRequirement redSpiderEggs;
    ItemRequirement alchable;
    ItemRequirement food;
    ItemRequirement burningAmulet;
    ItemRequirement oneClick;
    Requirement enterTheAbyss;
    Requirement firstTimeAbyss;
    Requirement notKillMammoth;
    Requirement notChaosAltar;
    Requirement notLowAlch;
    Requirement notChaosTemple;
    Requirement notWildyLever;
    Requirement notEarthWarrior;
    Requirement notDemonicPrayer;
    Requirement notEnterKBDLair;
    Requirement notSpiderEggs;
    Requirement notEnterAbyss;
    Requirement notIronOre;
    Requirement notEquipTeamCape;
    Requirement normalBook;
    QuestStep claimReward;
    QuestStep killMammoth;
    QuestStep chaosAltar;
    QuestStep lowAlch;
    QuestStep chaosTemple;
    QuestStep wildyLever;
    QuestStep earthWarrior;
    QuestStep demonicPrayer;
    QuestStep enterKBDLair;
    QuestStep spiderEggs;
    QuestStep enterAbyss;
    QuestStep ironOre;
    QuestStep equipTeamCape;
    QuestStep moveToWildy;
    QuestStep moveToFount;
    QuestStep moveToEdgeSpider;
    QuestStep moveToEdgeEarth;
    QuestStep abyssEnable;
    QuestStep enterKBDLair2;
    Zone wildy;
    Zone fount;
    Zone edge;
    Zone eggs;
    Zone kbd;
    ZoneRequirement inWildy;
    ZoneRequirement inFount;
    ZoneRequirement inEdge;
    ZoneRequirement inEggs;
    ZoneRequirement inKbd;
    ConditionalStep killMammothTask;
    ConditionalStep chaosAltarTask;
    ConditionalStep lowAlchTask;
    ConditionalStep chaosTempleTask;
    ConditionalStep wildyLeverTask;
    ConditionalStep earthWarriorTask;
    ConditionalStep demonicPrayerTask;
    ConditionalStep enterKBDLairTask;
    ConditionalStep spiderEggsTask;
    ConditionalStep enterAbyssTask;
    ConditionalStep ironOreTask;
    ConditionalStep equipTeamCapeTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doEasy = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.equipTeamCapeTask = new ConditionalStep((QuestHelper)this, this.moveToWildy, new Requirement[0]);
        this.equipTeamCapeTask.addStep(this.inWildy, this.equipTeamCape);
        doEasy.addStep(this.notEquipTeamCape, this.equipTeamCapeTask);
        this.spiderEggsTask = new ConditionalStep((QuestHelper)this, this.moveToEdgeSpider, new Requirement[0]);
        this.spiderEggsTask.addStep(new Conditions(LogicType.OR, this.inEdge, this.inEggs), this.spiderEggs);
        doEasy.addStep(this.notSpiderEggs, this.spiderEggsTask);
        this.earthWarriorTask = new ConditionalStep((QuestHelper)this, this.moveToEdgeEarth, new Requirement[0]);
        this.earthWarriorTask.addStep(this.inEdge, this.earthWarrior);
        doEasy.addStep(this.notEarthWarrior, this.earthWarriorTask);
        this.wildyLeverTask = new ConditionalStep((QuestHelper)this, this.wildyLever, new Requirement[0]);
        doEasy.addStep(this.notWildyLever, this.wildyLeverTask);
        this.ironOreTask = new ConditionalStep((QuestHelper)this, this.ironOre, new Requirement[0]);
        doEasy.addStep(this.notIronOre, this.ironOreTask);
        this.killMammothTask = new ConditionalStep((QuestHelper)this, this.killMammoth, new Requirement[0]);
        doEasy.addStep(this.notKillMammoth, this.killMammothTask);
        this.chaosTempleTask = new ConditionalStep((QuestHelper)this, this.chaosTemple, new Requirement[0]);
        doEasy.addStep(this.notChaosTemple, this.chaosTempleTask);
        this.lowAlchTask = new ConditionalStep((QuestHelper)this, this.moveToFount, new Requirement[0]);
        this.lowAlchTask.addStep(this.inFount, this.lowAlch);
        doEasy.addStep(this.notLowAlch, this.lowAlchTask);
        this.demonicPrayerTask = new ConditionalStep((QuestHelper)this, this.demonicPrayer, new Requirement[0]);
        doEasy.addStep(this.notDemonicPrayer, this.demonicPrayerTask);
        this.chaosAltarTask = new ConditionalStep((QuestHelper)this, this.chaosAltar, new Requirement[0]);
        doEasy.addStep(this.notChaosAltar, this.chaosAltarTask);
        this.enterKBDLairTask = new ConditionalStep((QuestHelper)this, this.enterKBDLair, new Requirement[0]);
        this.enterKBDLairTask.addStep(this.inKbd, this.enterKBDLair2);
        doEasy.addStep(this.notEnterKBDLair, this.enterKBDLairTask);
        this.enterAbyssTask = new ConditionalStep((QuestHelper)this, this.abyssEnable, new Requirement[0]);
        this.enterAbyssTask.addStep(this.firstTimeAbyss, this.enterAbyss);
        doEasy.addStep(this.notEnterAbyss, this.enterAbyssTask);
        return doEasy;
    }

    @Override
    public void setupRequirements() {
        this.notLowAlch = new VarplayerRequirement(1192, false, 1);
        this.notWildyLever = new VarplayerRequirement(1192, false, 2);
        this.notChaosAltar = new VarplayerRequirement(1192, false, 3);
        this.notChaosTemple = new VarplayerRequirement(1192, false, 4);
        this.notKillMammoth = new VarplayerRequirement(1192, false, 5);
        this.notEarthWarrior = new VarplayerRequirement(1192, false, 6);
        this.notDemonicPrayer = new VarplayerRequirement(1192, false, 7);
        this.notEnterKBDLair = new VarplayerRequirement(1192, false, 8);
        this.notSpiderEggs = new VarplayerRequirement(1192, false, 9);
        this.notIronOre = new VarplayerRequirement(1192, false, 10);
        this.notEnterAbyss = new VarplayerRequirement(1192, false, 11);
        this.notEquipTeamCape = new VarplayerRequirement(1192, false, 12);
        this.firstTimeAbyss = new VarbitRequirement(626, 1);
        this.normalBook = new SpellbookRequirement(Spellbook.NORMAL);
        this.chaosAccess = new ItemRequirement("Access to Chaos altar, or travel through abyss", ItemCollections.CHAOS_ALTAR).showConditioned(this.notChaosTemple).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notIronOre).isNotConsumed();
        this.teamCape = new ItemRequirement("Any team cape", ItemCollections.TEAM_CAPE).showConditioned(this.notEquipTeamCape).isNotConsumed();
        this.redSpiderEggs = new ItemRequirement("Red spider eggs", 223).showConditioned(this.notSpiderEggs);
        this.alchable = new ItemRequirement("Any item that is alch-able", 1, -1);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.burningAmulet = new ItemRequirement("Burning amulet", ItemCollections.BURNING_AMULETS);
        this.oneClick = new ItemRequirement("A one click teleport or accept imminent death", 1, -1).showConditioned(this.notEnterKBDLair);
        this.inWildy = new ZoneRequirement(this.wildy);
        this.inEdge = new ZoneRequirement(this.edge);
        this.inFount = new ZoneRequirement(this.fount);
        this.inEggs = new ZoneRequirement(this.eggs);
        this.inKbd = new ZoneRequirement(this.kbd);
        this.enterTheAbyss = new QuestRequirement(QuestHelperQuest.ENTER_THE_ABYSS, QuestState.FINISHED);
    }

    public void loadZones() {
        this.wildy = new Zone(new WorldPoint(2943, 3978, 0), new WorldPoint(3393, 3522, 0));
        this.edge = new Zone(new WorldPoint(3067, 10000, 0), new WorldPoint(3288, 9821, 0));
        this.fount = new Zone(new WorldPoint(3366, 3902, 0), new WorldPoint(3380, 3890, 0));
        this.eggs = new Zone(new WorldPoint(3113, 9962, 0), new WorldPoint(3132, 9946, 0));
        this.kbd = new Zone(new WorldPoint(3008, 10293, 0), new WorldPoint(3075, 10238, 0));
    }

    public void setupSteps() {
        this.killMammoth = new NpcStep((QuestHelper)this, 6604, new WorldPoint(3164, 3593, 0), "Kill a Mammoth in the Wilderness.", this.combatGear);
        this.moveToEdgeSpider = new ObjectStep((QuestHelper)this, 1581, new WorldPoint(3097, 3468, 0), "Enter the Edgeville dungeon.", this.food);
        this.moveToEdgeEarth = new ObjectStep((QuestHelper)this, 1581, new WorldPoint(3097, 3468, 0), "Enter the Edgeville dungeon.", this.combatGear, this.food);
        this.moveToWildy = new DetailedQuestStep((QuestHelper)this, "Enter the Wilderness.", this.teamCape);
        this.equipTeamCape = new DetailedQuestStep((QuestHelper)this, "Equip a team cape. If you already have one on, re-equip it.", this.teamCape.equipped());
        this.chaosTemple = new ObjectStep((QuestHelper)this, 34822, new WorldPoint(3060, 3591, 0), "Enter the chaos altar north of Edgeville with a chaos talisman/tiara, or enter it through the Abyss.", new Requirement[0]);
        this.chaosTemple.addIcon(1452);
        this.moveToFount = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3374, 3893, 0), "Go to the Fountain of Rune with an item you can cast Low Alchemy on.", new Requirement[0]);
        this.lowAlch = new ObjectStep((QuestHelper)this, 31941, new WorldPoint(3374, 3893, 0), "Cast Low Alchemy on anything.", new Requirement[0]);
        this.abyssEnable = new NpcStep((QuestHelper)this, 2582, new WorldPoint(3259, 3385, 0), "Speak with the Mage of Zamorak in Varrock and ask him about the Abyss.", new Requirement[0]);
        this.enterAbyss = new NpcStep((QuestHelper)this, 2581, new WorldPoint(3105, 3556, 0), "Speak with the Mage of Zamorak in the Wilderness to teleport to the Abyss.", new Requirement[0]);
        this.ironOre = new ObjectStep((QuestHelper)this, 11364, new WorldPoint(3104, 3570, 0), "Mine iron in the Wilderness.", this.pickaxe);
        this.spiderEggs = new ItemStep((QuestHelper)this, new WorldPoint(3122, 9953, 0), "Pickup 5 red spider eggs in the Edgeville Wilderness Dungeon.", this.redSpiderEggs);
        this.earthWarrior = new NpcStep((QuestHelper)this, 2840, new WorldPoint(3121, 9972, 0), "Kill an Earth warrior in the north of the Edgeville Wilderness Dungeon.", this.combatGear, this.food);
        this.wildyLever = new ObjectStep((QuestHelper)this, 26761, new WorldPoint(3090, 3475, 0), "Pull the Lever in Edgeville. This will take you to DEEP Wilderness, bank anything you aren't willing to lose.", new Requirement[0]);
        this.demonicPrayer = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3288, 3886, 0), "Stand in the Demonic Ruins until the ruins automatically restore a prayer point for you. You must be at less than your max prayer points.", new Requirement[0]);
        this.chaosAltar = new ObjectStep((QuestHelper)this, 411, new WorldPoint(2947, 3821, 0), "Pray at the Chaos Altar.", new Requirement[0]);
        this.enterKBDLair = new ObjectStep((QuestHelper)this, 18987, new WorldPoint(3017, 3849, 0), "Climb down the ladder that leads to the King Black Dragon Lair.", this.oneClick);
        this.enterKBDLair2 = new ObjectStep((QuestHelper)this, 1816, new WorldPoint(3067, 10253, 0), "Pull the lever to enter the King Black Dragon lair.", this.oneClick);
        this.claimReward = new NpcStep((QuestHelper)this, 5514, new WorldPoint(3121, 3518, 0), "Talk to the Lesser Fanatic in Edgeville to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.pickaxe, this.teamCape, this.chaosAccess, this.alchable);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.burningAmulet, this.oneClick);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.AGILITY, 15));
        reqs.add(new SkillRequirement(Skill.MAGIC, 21, true));
        reqs.add(new SkillRequirement(Skill.MINING, 15, true));
        reqs.add(this.enterTheAbyss);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Kill an Earth Warrior (lvl 51) and a Mammoth (lvl 80).");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Wilderness Sword 1", 13108), new ItemReward("2,500 Exp. Lamp (Any skill over 30)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Wilderness lever can teleport you to either Edgeville or Ardougne"), new UnlockReward("10 random free runes from Lundail once per day"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails teamCapeSteps = new PanelDetails("Team Cape", Arrays.asList(this.moveToWildy, this.equipTeamCape), this.teamCape);
        teamCapeSteps.setDisplayCondition(this.notEquipTeamCape);
        teamCapeSteps.setLockingStep(this.equipTeamCapeTask);
        allSteps.add(teamCapeSteps);
        PanelDetails eggsSteps = new PanelDetails("Spider Eggs", Arrays.asList(this.moveToEdgeSpider, this.spiderEggs), this.food);
        eggsSteps.setDisplayCondition(this.notSpiderEggs);
        eggsSteps.setLockingStep(this.spiderEggsTask);
        allSteps.add(eggsSteps);
        PanelDetails earthWarriorSteps = new PanelDetails("Earth Warrior", Arrays.asList(this.moveToEdgeEarth, this.earthWarrior), new SkillRequirement(Skill.AGILITY, 15), this.combatGear, this.food);
        earthWarriorSteps.setDisplayCondition(this.notEarthWarrior);
        earthWarriorSteps.setLockingStep(this.earthWarriorTask);
        allSteps.add(earthWarriorSteps);
        PanelDetails leverSteps = new PanelDetails("Wilderness Lever", Collections.singletonList(this.wildyLever), new Requirement[0]);
        leverSteps.setDisplayCondition(this.notWildyLever);
        leverSteps.setLockingStep(this.wildyLeverTask);
        allSteps.add(leverSteps);
        PanelDetails ironOreSteps = new PanelDetails("Iron Ore", Collections.singletonList(this.ironOre), new SkillRequirement(Skill.MINING, 15), this.pickaxe);
        ironOreSteps.setDisplayCondition(this.notIronOre);
        ironOreSteps.setLockingStep(this.ironOreTask);
        allSteps.add(ironOreSteps);
        PanelDetails mammothSteps = new PanelDetails("Mammoth", Collections.singletonList(this.killMammoth), this.combatGear, this.food);
        mammothSteps.setDisplayCondition(this.notKillMammoth);
        mammothSteps.setLockingStep(this.killMammothTask);
        allSteps.add(mammothSteps);
        PanelDetails chaosSteps = new PanelDetails("Chaos RC Altar", Collections.singletonList(this.chaosTemple), this.chaosAccess);
        chaosSteps.setDisplayCondition(this.notChaosTemple);
        chaosSteps.setLockingStep(this.chaosTempleTask);
        allSteps.add(chaosSteps);
        PanelDetails alchSteps = new PanelDetails("Free Low Alchemy", Arrays.asList(this.moveToFount, this.lowAlch), new SkillRequirement(Skill.MAGIC, 21), this.normalBook, this.alchable);
        alchSteps.setDisplayCondition(this.notLowAlch);
        alchSteps.setLockingStep(this.lowAlchTask);
        allSteps.add(alchSteps);
        PanelDetails ruinsSteps = new PanelDetails("Demonic Ruins", Collections.singletonList(this.demonicPrayer), new Requirement[0]);
        ruinsSteps.setDisplayCondition(this.notDemonicPrayer);
        ruinsSteps.setLockingStep(this.demonicPrayerTask);
        allSteps.add(ruinsSteps);
        PanelDetails altarSteps = new PanelDetails("Pray at Chaos Altar", Collections.singletonList(this.chaosAltar), new Requirement[0]);
        altarSteps.setDisplayCondition(this.notChaosAltar);
        altarSteps.setLockingStep(this.chaosAltarTask);
        allSteps.add(altarSteps);
        PanelDetails kbdSteps = new PanelDetails("The Lair", Arrays.asList(this.enterKBDLair, this.enterKBDLair2), this.oneClick);
        kbdSteps.setDisplayCondition(this.notEnterKBDLair);
        kbdSteps.setLockingStep(this.enterKBDLairTask);
        allSteps.add(kbdSteps);
        PanelDetails abyssSteps = new PanelDetails("Enter the Abyss", Arrays.asList(this.abyssEnable, this.enterAbyss), this.enterTheAbyss);
        abyssSteps.setDisplayCondition(this.notEnterAbyss);
        abyssSteps.setLockingStep(this.enterAbyssTask);
        allSteps.add(abyssSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

