/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.westernprovinces;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.CombatLevelRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.WESTERN_ELITE)
public class WesternElite
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement magicLongU;
    ItemRequirement bowString;
    ItemRequirement magicSapling;
    ItemRequirement coconuts25;
    ItemRequirement ogreBellows;
    ItemRequirement ogreBow;
    ItemRequirement ogreArrows;
    ItemRequirement mouthProtection;
    ItemRequirement rake;
    ItemRequirement spade;
    ItemRequirement voidTop;
    ItemRequirement voidRobe;
    ItemRequirement voidGloves;
    ItemRequirement voidHelm;
    ItemRequirement food;
    ItemRequirement tpCrystal;
    Requirement regicide;
    Requirement mourningsEndPartI;
    Requirement bigChompy;
    Requirement undergroundPass;
    Requirement base42CombatSkills;
    Requirement notMagicLong;
    Requirement notKillThermy;
    Requirement notPrissyScilla;
    Requirement notAdvancedAgi;
    Requirement notFullVoid;
    Requirement notChompyHat;
    Requirement notPickpocketElf;
    QuestStep claimReward;
    QuestStep magicLong;
    QuestStep killThermy;
    QuestStep prissyScilla;
    QuestStep advancedAgi;
    QuestStep fullVoid;
    QuestStep chompyHat;
    QuestStep pickpocketElf;
    QuestStep moveToSmoke;
    QuestStep moveToThermy;
    QuestStep moveToTirannwn;
    Zone tirannwn;
    Zone smokeDungeon;
    Zone thermyArena;
    ZoneRequirement inTirannwn;
    ZoneRequirement inSmokeDungeon;
    ZoneRequirement inThermyArena;
    ConditionalStep magicLongTask;
    ConditionalStep killThermyTask;
    ConditionalStep prissyScillaTask;
    ConditionalStep advancedAgiTask;
    ConditionalStep fullVoidTask;
    ConditionalStep chompyHatTask;
    ConditionalStep pickpocketElfTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doElite = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.prissyScillaTask = new ConditionalStep((QuestHelper)this, this.prissyScilla, new Requirement[0]);
        doElite.addStep(this.notPrissyScilla, this.prissyScillaTask);
        this.advancedAgiTask = new ConditionalStep((QuestHelper)this, this.advancedAgi, new Requirement[0]);
        doElite.addStep(this.notAdvancedAgi, this.advancedAgiTask);
        this.magicLongTask = new ConditionalStep((QuestHelper)this, this.moveToTirannwn, new Requirement[0]);
        this.magicLongTask.addStep(this.inTirannwn, this.magicLong);
        doElite.addStep(this.notMagicLong, this.magicLongTask);
        this.killThermyTask = new ConditionalStep((QuestHelper)this, this.moveToSmoke, new Requirement[0]);
        this.killThermyTask.addStep(this.inSmokeDungeon, this.moveToThermy);
        this.killThermyTask.addStep(this.inThermyArena, this.killThermy);
        doElite.addStep(this.notKillThermy, this.killThermyTask);
        this.pickpocketElfTask = new ConditionalStep((QuestHelper)this, this.pickpocketElf, new Requirement[0]);
        doElite.addStep(this.notPickpocketElf, this.pickpocketElfTask);
        this.fullVoidTask = new ConditionalStep((QuestHelper)this, this.fullVoid, new Requirement[0]);
        doElite.addStep(this.notFullVoid, this.fullVoidTask);
        this.chompyHatTask = new ConditionalStep((QuestHelper)this, this.chompyHat, new Requirement[0]);
        doElite.addStep(this.notChompyHat, this.chompyHatTask);
        return doElite;
    }

    @Override
    public void setupRequirements() {
        this.notMagicLong = new VarplayerRequirement(1183, false, 6);
        this.notKillThermy = new VarplayerRequirement(1183, false, 7);
        this.notPrissyScilla = new VarplayerRequirement(1183, false, 8);
        this.notAdvancedAgi = new VarplayerRequirement(1183, false, 9);
        this.notFullVoid = new VarplayerRequirement(1183, false, 12);
        this.notChompyHat = new VarplayerRequirement(1183, false, 13);
        this.notPickpocketElf = new VarplayerRequirement(1183, false, 14);
        this.base42CombatSkills = new ComplexRequirement(LogicType.AND, "Base 42s in all combat skills and 22 prayer", new SkillRequirement(Skill.ATTACK, 42), new SkillRequirement(Skill.STRENGTH, 42), new SkillRequirement(Skill.DEFENCE, 42), new SkillRequirement(Skill.HITPOINTS, 42), new SkillRequirement(Skill.RANGED, 42), new SkillRequirement(Skill.MAGIC, 42), new SkillRequirement(Skill.PRAYER, 22));
        this.magicLongU = new ItemRequirement("Magic longbow (u)", 70).showConditioned(this.notMagicLong);
        this.bowString = new ItemRequirement("Bow string", 1777).showConditioned(this.notMagicLong);
        this.mouthProtection = new ItemRequirement("Mouth protection", ItemCollections.MOUTH_PROTECTION).showConditioned(this.notKillThermy).isNotConsumed();
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(this.notPrissyScilla).isNotConsumed();
        this.magicSapling = new ItemRequirement("Magic sapling", 5374).showConditioned(this.notPrissyScilla);
        this.coconuts25 = new ItemRequirement("Coconuts", 5974, 25).showConditioned(this.notPrissyScilla);
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notPrissyScilla).isNotConsumed();
        this.voidHelm = new ItemRequirement("Any void knight helm", ItemCollections.VOID_HELM).showConditioned(this.notFullVoid).isNotConsumed();
        this.voidTop = new ItemRequirement("Void knight top", ItemCollections.VOID_TOP).showConditioned(this.notFullVoid).isNotConsumed();
        this.voidRobe = new ItemRequirement("Void knight robe", ItemCollections.VOID_ROBE).showConditioned(this.notFullVoid).isNotConsumed();
        this.voidGloves = new ItemRequirement("Void knight gloves", 8842).showConditioned(this.notFullVoid).isNotConsumed();
        this.ogreBellows = new ItemRequirement("Ogre bellows", ItemCollections.OGRE_BELLOWS).showConditioned(this.notChompyHat).isNotConsumed();
        this.ogreBow = new ItemRequirement("Ogre bow", ItemCollections.OGRE_BOW).showConditioned(this.notChompyHat).isNotConsumed();
        this.ogreArrows = new ItemRequirement("Ogre / brutal arrows", ItemCollections.OGRE_BRUTAL_ARROWS).showConditioned(this.notChompyHat);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.tpCrystal = new ItemRequirement("Teleport Crystal", ItemCollections.TELEPORT_CRYSTAL);
        this.inTirannwn = new ZoneRequirement(this.tirannwn);
        this.inSmokeDungeon = new ZoneRequirement(this.smokeDungeon);
        this.inThermyArena = new ZoneRequirement(this.thermyArena);
        this.bigChompy = new QuestRequirement(QuestHelperQuest.BIG_CHOMPY_BIRD_HUNTING, QuestState.FINISHED);
        this.regicide = new QuestRequirement(QuestHelperQuest.REGICIDE, QuestState.IN_PROGRESS);
        this.mourningsEndPartI = new QuestRequirement(QuestHelperQuest.MOURNINGS_END_PART_I, QuestState.IN_PROGRESS);
        this.undergroundPass = new QuestRequirement(QuestHelperQuest.UNDERGROUND_PASS, QuestState.FINISHED);
    }

    public void loadZones() {
        this.tirannwn = new Zone(new WorldPoint(2142, 3272, 0), new WorldPoint(2317, 3032, 0));
        this.smokeDungeon = new Zone(new WorldPoint(2378, 9473, 0), new WorldPoint(2432, 9408, 0));
        this.thermyArena = new Zone(new WorldPoint(2347, 9462, 0), new WorldPoint(2378, 9437, 0));
    }

    public void setupSteps() {
        this.moveToTirannwn = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2230, 3166, 0), "Enter Tirannwn.", this.magicLongU, this.bowString);
        this.magicLong = new DetailedQuestStep((QuestHelper)this, "Fletch a magic longbow in Tirannwn.", this.magicLongU.highlighted(), this.bowString.highlighted());
        this.prissyScilla = new NpcStep((QuestHelper)this, 2687, new WorldPoint(2437, 3419, 0), "Have Prissy Scilla protect your magic tree.", this.magicSapling, this.spade, this.rake, this.coconuts25);
        this.moveToSmoke = new ObjectStep((QuestHelper)this, 30176, new WorldPoint(2412, 3061, 0), "Enter the Smoke Devil Dungeon.", this.combatGear, this.food, this.mouthProtection);
        this.moveToThermy = new ObjectStep((QuestHelper)this, 534, new WorldPoint(2378, 9452, 0), "Enter the boss area of the Thermonuclear smoke devil.", this.combatGear, this.food, this.mouthProtection);
        this.killThermy = new NpcStep((QuestHelper)this, 499, new WorldPoint(2356, 9456, 0), "Defeat the Thermonuclear smoke devil. You are allowed one kill off-task for the diary.", this.combatGear, this.food, this.mouthProtection);
        this.advancedAgi = new ObjectStep((QuestHelper)this, 16515, new WorldPoint(2337, 3253, 0), "Use the advanced elven overpass cliffside shortcut.", new Requirement[0]);
        this.fullVoid = new DetailedQuestStep((QuestHelper)this, "Equip any complete void set.", this.voidHelm.equipped(), this.voidTop.equipped(), this.voidRobe.equipped(), this.voidGloves.equipped());
        this.pickpocketElf = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2333, 3171, 0), "Pickpocket an elf.", new Requirement[0]);
        this.chompyHat = new NpcStep((QuestHelper)this, 1470, new WorldPoint(2628, 2979, 0), "Claim any Chompy bird hat from Rantz. Kill chompy birds until you have 1000 kills. \n \nYou can check your kill count by right clicking selecting 'Check Kills' on an ogre bow.", this.ogreBow, this.ogreArrows, this.ogreBellows);
        this.chompyHat.addDialogStep("Can I have a hat please?");
        this.claimReward = new NpcStep((QuestHelper)this, 5518, new WorldPoint(2466, 3460, 0), "Talk to the Elder gnome child in Gnome Stronghold to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.magicLongU, this.bowString, this.magicSapling, this.coconuts25, this.ogreBellows, this.ogreBow, this.ogreArrows, this.mouthProtection, this.rake, this.spade, this.voidHelm, this.voidTop, this.voidRobe, this.voidGloves);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.tpCrystal);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new CombatLevelRequirement(40));
        reqs.add(new SkillRequirement(Skill.AGILITY, 85, true));
        reqs.add(new SkillRequirement(Skill.FARMING, 75, true));
        reqs.add(new SkillRequirement(Skill.FLETCHING, 85, true));
        reqs.add(new SkillRequirement(Skill.SLAYER, 93, false));
        reqs.add(new SkillRequirement(Skill.THIEVING, 85, true));
        reqs.add(this.base42CombatSkills);
        reqs.add(this.bigChompy);
        reqs.add(this.mourningsEndPartI);
        reqs.add(this.regicide);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Thermonuclear smoke devil (lvl 301)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Western banner 4", 13144), new ItemReward("50,000 Exp. Lamp (Any skill over 70)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Unlimited teleports to the Piscatoris Fishing Colony from Western banner 4"), new UnlockReward("2 chompy birds will always appear when Chompy bird hunting"), new UnlockReward("Chance of receiving a chompy chick pet when chompy bird hunting"), new UnlockReward("Slayer point rewards from tasks assigned by Nieve/Steve are increased to match those of Duradel"), new UnlockReward("150 free ogre arrows every day from Rantz"), new UnlockReward("One free resurrection per day when fighting Zulrah"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails prissySteps = new PanelDetails("Prissy Scilla's Protection", Collections.singletonList(this.prissyScilla), new SkillRequirement(Skill.FARMING, 75), this.magicSapling, this.coconuts25, this.rake, this.spade);
        prissySteps.setDisplayCondition(this.notPrissyScilla);
        prissySteps.setLockingStep(this.prissyScillaTask);
        allSteps.add(prissySteps);
        PanelDetails agiSteps = new PanelDetails("Advanced Elven Shortcut", Collections.singletonList(this.advancedAgi), this.undergroundPass, new SkillRequirement(Skill.AGILITY, 85));
        agiSteps.setDisplayCondition(this.notAdvancedAgi);
        agiSteps.setLockingStep(this.advancedAgiTask);
        allSteps.add(agiSteps);
        PanelDetails magicSteps = new PanelDetails("Magic Longbow In Tirannwn", Arrays.asList(this.moveToTirannwn, this.magicLong), new SkillRequirement(Skill.FLETCHING, 85), this.regicide, this.magicLongU, this.bowString);
        magicSteps.setDisplayCondition(this.notMagicLong);
        magicSteps.setLockingStep(this.magicLongTask);
        allSteps.add(magicSteps);
        PanelDetails thermySteps = new PanelDetails("Thermonuclear Smoke Devil", Arrays.asList(this.moveToSmoke, this.moveToThermy, this.killThermy), new SkillRequirement(Skill.SLAYER, 93, false), this.combatGear, this.food, this.mouthProtection);
        thermySteps.setDisplayCondition(this.notKillThermy);
        thermySteps.setLockingStep(this.killThermyTask);
        allSteps.add(thermySteps);
        PanelDetails elfSteps = new PanelDetails("Pickpocket An Elf", Collections.singletonList(this.pickpocketElf), new SkillRequirement(Skill.THIEVING, 85), this.mourningsEndPartI);
        elfSteps.setDisplayCondition(this.notPickpocketElf);
        elfSteps.setLockingStep(this.pickpocketElfTask);
        allSteps.add(elfSteps);
        PanelDetails voidSteps = new PanelDetails("Equip Full Void Set", Collections.singletonList(this.fullVoid), this.base42CombatSkills, this.voidHelm, this.voidTop, this.voidRobe, this.voidGloves);
        voidSteps.setDisplayCondition(this.notFullVoid);
        voidSteps.setLockingStep(this.fullVoidTask);
        allSteps.add(voidSteps);
        PanelDetails hatSteps = new PanelDetails("Chompy Bird Hat", Collections.singletonList(this.chompyHat), new SkillRequirement(Skill.RANGED, 30), this.bigChompy, this.ogreBellows, this.ogreBow, this.ogreArrows);
        hatSteps.setDisplayCondition(this.notChompyHat);
        hatSteps.setLockingStep(this.chompyHatTask);
        allSteps.add(hatSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

