/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.westernprovinces;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.CombatLevelRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.WESTERN_EASY)
public class WesternEasy
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement birdSnare;
    ItemRequirement pickaxe;
    ItemRequirement oakShortU;
    ItemRequirement bowString;
    ItemRequirement ogreBellows;
    ItemRequirement ogreBow;
    ItemRequirement ogreArrows;
    ItemRequirement swampToad;
    ItemRequirement food;
    ItemRequirement fairyAccess;
    Requirement bigChompy;
    Requirement runeMysteries;
    Requirement notCopperLongtail;
    Requirement notNovicePest;
    Requirement notMineIron;
    Requirement notGnomeAgi;
    Requirement notGnomeBall;
    Requirement notChompyHat;
    Requirement notTPPest;
    Requirement notSwampToadCollect;
    Requirement notBrimstailEssence;
    Requirement notOakShortbow;
    Requirement notTerrorbird;
    QuestStep copperLongtail;
    QuestStep novicePest;
    QuestStep gnomeAgi;
    QuestStep gnomeBall;
    QuestStep chompyHat;
    QuestStep tpPest;
    QuestStep swampToadCollect;
    QuestStep brimstailEssence;
    QuestStep oakShortbow;
    QuestStep claimReward;
    QuestStep moveToBrim;
    QuestStep moveToPest;
    QuestStep moveToStronghold;
    ObjectStep mineIron;
    NpcStep terrorbird;
    Zone brimstailCave;
    Zone stronghold;
    Zone pest;
    ZoneRequirement inBrimstailCave;
    ZoneRequirement inStronghold;
    ZoneRequirement inPest;
    ConditionalStep copperLongtailTask;
    ConditionalStep novicePestTask;
    ConditionalStep gnomeAgiTask;
    ConditionalStep gnomeBallTask;
    ConditionalStep chompyHatTask;
    ConditionalStep tpPestTask;
    ConditionalStep swampToadCollectTask;
    ConditionalStep brimstailEssenceTask;
    ConditionalStep oakShortbowTask;
    ConditionalStep terrorbirdTask;
    ConditionalStep mineIronTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doEasy = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.gnomeAgiTask = new ConditionalStep((QuestHelper)this, this.gnomeAgi, new Requirement[0]);
        doEasy.addStep(this.notGnomeAgi, this.gnomeAgiTask);
        this.oakShortbowTask = new ConditionalStep((QuestHelper)this, this.moveToStronghold, new Requirement[0]);
        this.oakShortbowTask.addStep(this.inStronghold, this.oakShortbow);
        doEasy.addStep(this.notOakShortbow, this.oakShortbowTask);
        this.brimstailEssenceTask = new ConditionalStep((QuestHelper)this, this.moveToBrim, new Requirement[0]);
        this.brimstailEssenceTask.addStep(this.inBrimstailCave, this.brimstailEssence);
        doEasy.addStep(this.notBrimstailEssence, this.brimstailEssenceTask);
        this.terrorbirdTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.terrorbird, new Requirement[0]);
        doEasy.addStep(this.notTerrorbird, this.terrorbirdTask);
        this.gnomeBallTask = new ConditionalStep((QuestHelper)this, this.gnomeBall, new Requirement[0]);
        doEasy.addStep(this.notGnomeBall, this.gnomeBallTask);
        this.swampToadCollectTask = new ConditionalStep((QuestHelper)this, this.swampToadCollect, new Requirement[0]);
        doEasy.addStep(this.notSwampToadCollect, this.swampToadCollectTask);
        this.copperLongtailTask = new ConditionalStep((QuestHelper)this, this.copperLongtail, new Requirement[0]);
        doEasy.addStep(this.notCopperLongtail, this.copperLongtailTask);
        this.mineIronTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.mineIron, new Requirement[0]);
        doEasy.addStep(this.notMineIron, this.mineIronTask);
        this.tpPestTask = new ConditionalStep((QuestHelper)this, this.tpPest, new Requirement[0]);
        doEasy.addStep(this.notTPPest, this.tpPestTask);
        this.novicePestTask = new ConditionalStep((QuestHelper)this, this.moveToPest, new Requirement[0]);
        this.novicePestTask.addStep(this.inPest, this.novicePest);
        doEasy.addStep(this.notNovicePest, this.novicePestTask);
        this.chompyHatTask = new ConditionalStep((QuestHelper)this, this.chompyHat, new Requirement[0]);
        doEasy.addStep(this.notChompyHat, this.chompyHatTask);
        return doEasy;
    }

    @Override
    public void setupRequirements() {
        this.notCopperLongtail = new VarplayerRequirement(1182, false, 1);
        this.notNovicePest = new VarplayerRequirement(1182, false, 2);
        this.notMineIron = new VarplayerRequirement(1182, false, 3);
        this.notGnomeAgi = new VarplayerRequirement(1182, false, 4);
        this.notGnomeBall = new VarplayerRequirement(1182, false, 5);
        this.notChompyHat = new VarplayerRequirement(1182, false, 6);
        this.notTPPest = new VarplayerRequirement(1182, false, 7);
        this.notSwampToadCollect = new VarplayerRequirement(1182, false, 8);
        this.notBrimstailEssence = new VarplayerRequirement(1182, false, 9);
        this.notOakShortbow = new VarplayerRequirement(1182, false, 10);
        this.notTerrorbird = new VarplayerRequirement(1182, false, 11);
        this.birdSnare = new ItemRequirement("Bird snare", 10006).showConditioned(this.notCopperLongtail).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notMineIron).isNotConsumed();
        this.oakShortU = new ItemRequirement("Oak shortbow (u)", 54).showConditioned(this.notOakShortbow);
        this.bowString = new ItemRequirement("Bow string", 1777).showConditioned(this.notOakShortbow);
        this.ogreBellows = new ItemRequirement("Ogre bellows", ItemCollections.OGRE_BELLOWS).showConditioned(this.notChompyHat).isNotConsumed();
        this.ogreBow = new ItemRequirement("Ogre bow", ItemCollections.OGRE_BOW).showConditioned(this.notChompyHat).isNotConsumed();
        this.ogreArrows = new ItemRequirement("Ogre / brutal arrows", ItemCollections.OGRE_BRUTAL_ARROWS).showConditioned(this.notChompyHat);
        this.swampToad = new ItemRequirement("Swamp toad", 2150);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.fairyAccess = new ItemRequirement("Dramen or Lunar staff", ItemCollections.FAIRY_STAFF).isNotConsumed();
        this.inBrimstailCave = new ZoneRequirement(this.brimstailCave);
        this.inPest = new ZoneRequirement(this.pest);
        this.inStronghold = new ZoneRequirement(this.stronghold);
        this.bigChompy = new QuestRequirement(QuestHelperQuest.BIG_CHOMPY_BIRD_HUNTING, QuestState.FINISHED);
        this.runeMysteries = new QuestRequirement(QuestHelperQuest.RUNE_MYSTERIES, QuestState.FINISHED);
    }

    public void loadZones() {
        this.stronghold = new Zone(new WorldPoint(2376, 3523, 0), new WorldPoint(2498, 3391, 0));
        this.pest = new Zone(new WorldPoint(2631, 2681, 0), new WorldPoint(2683, 2626, 0));
        this.brimstailCave = new Zone(new WorldPoint(2376, 9835, 0), new WorldPoint(2416, 9802, 0));
    }

    public void setupSteps() {
        this.gnomeAgi = new ObjectStep((QuestHelper)this, 23145, new WorldPoint(2474, 3435, 0), "Complete a lap of the Gnome Agility Course.", new Requirement[0]);
        this.moveToStronghold = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2450, 3433, 0), "Enter the Gnome Stronghold.", new Requirement[0]);
        this.oakShortbow = new DetailedQuestStep((QuestHelper)this, "Fletch an oak shortbow in the Gnome Stronghold.", this.oakShortU.highlighted(), this.bowString.highlighted());
        this.moveToBrim = new ObjectStep((QuestHelper)this, 17209, new WorldPoint(2403, 3419, 0), "Enter Brimstail's cave.", new Requirement[0]);
        this.brimstailEssence = new NpcStep((QuestHelper)this, new int[]{4914, 11431}, new WorldPoint(2409, 9817, 0), "Have Brimstail teleport you to the Essence mine", new Requirement[0]);
        this.brimstailEssence.addDialogStep("I need to mine some rune essence.");
        this.terrorbird = new NpcStep((QuestHelper)this, 2064, new WorldPoint(2379, 3432, 0), "Kill a terrorbird in the terrorbird enclosure.", true, this.combatGear);
        this.terrorbird.addAlternateNpcs(2065, 2066);
        this.gnomeBall = new NpcStep((QuestHelper)this, 3157, new WorldPoint(2385, 3487, 0), "Score a goal in a Gnome Ball match. Talk to the Referee to start the match.", new Requirement[0]);
        this.gnomeBall.addDialogStep("Okay then, I'll have a go.");
        this.swampToadCollect = new ItemStep((QuestHelper)this, new WorldPoint(2422, 3507, 0), "Collect a swamp toad at the Gnome Stronghold.", this.swampToad.highlighted());
        this.mineIron = new ObjectStep((QuestHelper)this, 11364, new WorldPoint(2338, 3640, 0), "Mine some iron ore near Piscatoris.", true, this.pickaxe);
        this.mineIron.addAlternateObjects(11365);
        this.copperLongtail = new ObjectStep((QuestHelper)this, 9379, new WorldPoint(2341, 3598, 0), "Catch a copper longtail.", true, this.birdSnare.highlighted());
        this.chompyHat = new NpcStep((QuestHelper)this, 1470, new WorldPoint(2628, 2979, 0), "Claim any Chompy bird hat from Rantz. Kill chompy birds until you have 30 kills. \n \nYou can check your kill count by right-clicking 'Check Kills' on an ogre bow.", this.ogreBow, this.ogreArrows, this.ogreBellows);
        this.chompyHat.addDialogStep("Can I have a hat please?");
        this.tpPest = new DetailedQuestStep((QuestHelper)this, "Teleport to Pest Control using the minigame teleport.", new Requirement[0]);
        this.moveToPest = new NpcStep((QuestHelper)this, 1770, new WorldPoint(3041, 3202, 0), "Talk to the squire in Port Sarim to travel to the Void Knights' Outpost. Alternatively, use the pest control minigame teleport.", new Requirement[0]);
        this.moveToPest.addDialogStep("I'd like to go to your outpost.");
        this.novicePest = new ObjectStep((QuestHelper)this, 14315, new WorldPoint(2658, 2639, 0), "Complete a novice game of Pest Control.", new Requirement[0]);
        this.claimReward = new NpcStep((QuestHelper)this, 5518, new WorldPoint(2466, 3460, 0), "Talk to the Elder gnome child in Gnome Stronghold to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.birdSnare, this.pickaxe, this.oakShortU, this.bowString, this.ogreBellows, this.ogreBow, this.ogreArrows, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.fairyAccess);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new CombatLevelRequirement(40));
        reqs.add(new SkillRequirement(Skill.FLETCHING, 20));
        reqs.add(new SkillRequirement(Skill.HUNTER, 9));
        reqs.add(new SkillRequirement(Skill.MINING, 15));
        reqs.add(this.bigChompy);
        reqs.add(this.runeMysteries);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Terror bird (lvl 28)", "Complete a Novice Pest Control game");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Western Banner 1", 13141), new ItemReward("2,500 Exp. Lamp (Any skill over 30)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("25% chance of 2 chompy birds appearing when Chompy bird hunting"), new UnlockReward("25 free ogre arrows every day from Rantz"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails agiSteps = new PanelDetails("Gnome Agility Course", Collections.singletonList(this.gnomeAgi), new Requirement[0]);
        agiSteps.setDisplayCondition(this.notGnomeAgi);
        agiSteps.setLockingStep(this.gnomeAgiTask);
        allSteps.add(agiSteps);
        PanelDetails shortbowSteps = new PanelDetails("Fletch Oak Shortbow in Gnome Stronghold", Arrays.asList(this.moveToStronghold, this.oakShortbow), new SkillRequirement(Skill.FLETCHING, 20), this.oakShortU, this.bowString);
        shortbowSteps.setDisplayCondition(this.notOakShortbow);
        shortbowSteps.setLockingStep(this.oakShortbowTask);
        allSteps.add(shortbowSteps);
        PanelDetails essSteps = new PanelDetails("Brimstail Essence Teleport", Arrays.asList(this.moveToBrim, this.brimstailEssence), this.runeMysteries);
        essSteps.setDisplayCondition(this.notBrimstailEssence);
        essSteps.setLockingStep(this.brimstailEssenceTask);
        allSteps.add(essSteps);
        PanelDetails birdSteps = new PanelDetails("Kill Terrorbird", Collections.singletonList(this.terrorbird), this.combatGear, this.food);
        birdSteps.setDisplayCondition(this.notTerrorbird);
        birdSteps.setLockingStep(this.terrorbirdTask);
        allSteps.add(birdSteps);
        PanelDetails ballSteps = new PanelDetails("Gnome Ball Goal", Collections.singletonList(this.gnomeBall), new Requirement[0]);
        ballSteps.setDisplayCondition(this.notGnomeBall);
        ballSteps.setLockingStep(this.gnomeBallTask);
        allSteps.add(ballSteps);
        PanelDetails toadSteps = new PanelDetails("Collect Swamp Toad", Collections.singletonList(this.swampToadCollect), new Requirement[0]);
        toadSteps.setDisplayCondition(this.notSwampToadCollect);
        toadSteps.setLockingStep(this.swampToadCollectTask);
        allSteps.add(toadSteps);
        PanelDetails copperSteps = new PanelDetails("Copper Longtail", Collections.singletonList(this.copperLongtail), new SkillRequirement(Skill.HUNTER, 9), this.birdSnare);
        copperSteps.setDisplayCondition(this.notCopperLongtail);
        copperSteps.setLockingStep(this.copperLongtailTask);
        allSteps.add(copperSteps);
        PanelDetails ironSteps = new PanelDetails("Mine Iron", Collections.singletonList(this.mineIron), new SkillRequirement(Skill.MINING, 15), this.pickaxe);
        ironSteps.setDisplayCondition(this.notMineIron);
        ironSteps.setLockingStep(this.mineIronTask);
        allSteps.add(ironSteps);
        PanelDetails tpSteps = new PanelDetails("Teleport to Pest Control", Collections.singletonList(this.tpPest), new CombatLevelRequirement(40));
        tpSteps.setDisplayCondition(this.notTPPest);
        tpSteps.setLockingStep(this.tpPestTask);
        allSteps.add(tpSteps);
        PanelDetails pestSteps = new PanelDetails("Novice Pest Control", Arrays.asList(this.moveToPest, this.novicePest), new CombatLevelRequirement(40), this.combatGear);
        pestSteps.setDisplayCondition(this.notNovicePest);
        pestSteps.setLockingStep(this.novicePestTask);
        allSteps.add(pestSteps);
        PanelDetails hatSteps = new PanelDetails("Chompy Bird Hat", Collections.singletonList(this.chompyHat), new SkillRequirement(Skill.RANGED, 30), this.bigChompy, this.ogreBellows, this.ogreBow, this.ogreArrows);
        hatSteps.setDisplayCondition(this.notChompyHat);
        hatSteps.setLockingStep(this.chompyHatTask);
        allSteps.add(hatSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

