/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.varrock;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.PrayerRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Prayer;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.VARROCK_HARD)
public class VarrockHard
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement botSceptre;
    ItemRequirement topSceptre;
    ItemRequirement rightSkull;
    ItemRequirement leftSkull;
    ItemRequirement strangeSkull;
    ItemRequirement runedSceptre;
    ItemRequirement combinedSkullSceptre;
    ItemRequirement dashingKeb;
    ItemRequirement coins;
    ItemRequirement cape;
    ItemRequirement axe;
    ItemRequirement airRune;
    ItemRequirement lawRune;
    ItemRequirement fireRune;
    ItemRequirement yewLog;
    ItemRequirement tinderBox;
    ItemRequirement yewSap;
    ItemRequirement rake;
    ItemRequirement spade;
    ItemRequirement food;
    Requirement desertTreasure;
    Requirement ancientBook;
    Requirement notSpottyCape;
    Requirement not153Kudos;
    Requirement notWakkaEdge;
    Requirement notPaddewwaTP;
    Requirement notSkullSceptre;
    Requirement notYewChurch;
    Requirement notFancyStone;
    Requirement notYewRoots;
    Requirement notSmiteAltar;
    Requirement notPipe;
    Requirement atleast153Kudos;
    Requirement yewNotChecked;
    Requirement yewChecked;
    Requirement yewStump;
    Requirement smiteActive;
    Requirement cutYewTree;
    Requirement boughtSpotterCape;
    QuestStep claimReward;
    QuestStep moveToStronghold;
    QuestStep moveToStronghold2;
    QuestStep moveToStronghold3;
    QuestStep moveToStronghold4;
    QuestStep makeSceptre;
    QuestStep makeSkull;
    QuestStep skullSceptre;
    QuestStep makeSkullSceptre;
    QuestStep getCape;
    QuestStep spottyCape;
    QuestStep getKudos;
    QuestStep wakkaEdge;
    QuestStep moveToBasement;
    QuestStep kudos;
    QuestStep paddewwaTP;
    QuestStep cutYew;
    QuestStep goUp1;
    QuestStep goUp2;
    QuestStep goUp3;
    QuestStep burnLogs;
    QuestStep fancyStone;
    QuestStep growYew;
    QuestStep chopYew;
    QuestStep digUpYewRoots;
    QuestStep moveToUpstairs;
    QuestStep prayAtAltar;
    QuestStep obsPipe;
    QuestStep moveToEdge;
    NpcStep killMino;
    NpcStep killFlesh;
    NpcStep killCatablepon;
    NpcStep killAnkou;
    Zone stronghold1;
    Zone stronghold2;
    Zone stronghold3;
    Zone stronghold4;
    Zone basement;
    Zone church2;
    Zone church3;
    Zone church4;
    Zone upstairs;
    Zone sewer;
    ZoneRequirement inStronghold1;
    ZoneRequirement inStronghold2;
    ZoneRequirement inStronghold3;
    ZoneRequirement inStronghold4;
    ZoneRequirement inBasement;
    ZoneRequirement inChurch2;
    ZoneRequirement inChurch3;
    ZoneRequirement inChurch4;
    ZoneRequirement inUpstairs;
    ZoneRequirement inSewer;
    ZoneRequirement inAsyffShop;
    ZoneRequirement inYewZone;
    ConditionalStep spottyCapeTask;
    ConditionalStep kudosTask;
    ConditionalStep wakkaEdgeTask;
    ConditionalStep paddewwaTPTask;
    ConditionalStep skullSceptreTask;
    ConditionalStep yewChurchTask;
    ConditionalStep fancyStoneTask;
    ConditionalStep yewRootsTask;
    ConditionalStep smiteAltarTask;
    ConditionalStep pipeTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doHard = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.yewRootsTask = new ConditionalStep((QuestHelper)this, this.growYew, new Requirement[0]);
        this.yewRootsTask.addStep(new Conditions(this.notYewRoots, this.yewNotChecked), this.chopYew);
        this.yewRootsTask.addStep(new Conditions(this.notYewRoots, this.yewChecked), this.chopYew);
        this.yewRootsTask.addStep(new Conditions(this.notYewRoots, this.yewStump), this.digUpYewRoots);
        doHard.addStep(this.notYewRoots, this.yewRootsTask);
        this.spottyCapeTask = new ConditionalStep((QuestHelper)this, this.getCape, new Requirement[0]);
        this.spottyCapeTask.addStep(new Conditions(this.notSpottyCape, this.boughtSpotterCape), this.spottyCape);
        doHard.addStep(this.notSpottyCape, this.spottyCapeTask);
        this.kudosTask = new ConditionalStep((QuestHelper)this, this.getKudos, new Requirement[0]);
        this.kudosTask.addStep(new Conditions(this.not153Kudos, this.atleast153Kudos), this.moveToBasement);
        this.kudosTask.addStep(new Conditions(this.not153Kudos, this.inBasement, this.atleast153Kudos), this.kudos);
        doHard.addStep(this.not153Kudos, this.kudosTask);
        this.yewChurchTask = new ConditionalStep((QuestHelper)this, this.cutYew, new Requirement[0]);
        this.yewChurchTask.addStep(new Conditions(this.notYewChurch, this.cutYewTree), this.goUp1);
        this.yewChurchTask.addStep(new Conditions(this.notYewChurch, this.inChurch2, this.cutYewTree), this.goUp2);
        this.yewChurchTask.addStep(new Conditions(this.notYewChurch, this.inChurch3, this.cutYewTree), this.goUp3);
        this.yewChurchTask.addStep(new Conditions(this.notYewChurch, this.inChurch4, this.cutYewTree), this.burnLogs);
        doHard.addStep(this.notYewChurch, this.yewChurchTask);
        this.fancyStoneTask = new ConditionalStep((QuestHelper)this, this.fancyStone, new Requirement[0]);
        doHard.addStep(this.notFancyStone, this.fancyStoneTask);
        this.smiteAltarTask = new ConditionalStep((QuestHelper)this, this.moveToUpstairs, new Requirement[0]);
        this.smiteAltarTask.addStep(new Conditions(this.notSmiteAltar, this.inUpstairs), this.prayAtAltar);
        doHard.addStep(this.notSmiteAltar, this.smiteAltarTask);
        this.wakkaEdgeTask = new ConditionalStep((QuestHelper)this, this.wakkaEdge, new Requirement[0]);
        doHard.addStep(this.notWakkaEdge, this.wakkaEdgeTask);
        this.paddewwaTPTask = new ConditionalStep((QuestHelper)this, this.paddewwaTP, new Requirement[0]);
        doHard.addStep(this.notPaddewwaTP, this.paddewwaTPTask);
        this.pipeTask = new ConditionalStep((QuestHelper)this, this.moveToEdge, new Requirement[0]);
        this.pipeTask.addStep(new Conditions(this.notPipe, this.inSewer), this.obsPipe);
        doHard.addStep(this.notPipe, this.pipeTask);
        this.skullSceptreTask = new ConditionalStep((QuestHelper)this, this.moveToStronghold, new Requirement[0]);
        this.skullSceptreTask.addStep(new Conditions(this.notSkullSceptre, this.inStronghold1, new Conditions(LogicType.NOR, this.rightSkull.alsoCheckBank(this.questBank), this.strangeSkull.alsoCheckBank(this.questBank))), this.killMino);
        this.skullSceptreTask.addStep(new Conditions(new Conditions(LogicType.OR, this.rightSkull.alsoCheckBank(this.questBank), this.strangeSkull.alsoCheckBank(this.questBank)), this.notSkullSceptre, this.inStronghold1), this.moveToStronghold2);
        this.skullSceptreTask.addStep(new Conditions(this.notSkullSceptre, this.inStronghold2, new Conditions(LogicType.NOR, this.botSceptre.alsoCheckBank(this.questBank), this.runedSceptre.alsoCheckBank(this.questBank))), this.killFlesh);
        this.skullSceptreTask.addStep(new Conditions(new Conditions(LogicType.OR, this.botSceptre.alsoCheckBank(this.questBank), this.runedSceptre.alsoCheckBank(this.questBank)), this.notSkullSceptre, this.inStronghold2), this.moveToStronghold3);
        this.skullSceptreTask.addStep(new Conditions(this.notSkullSceptre, this.inStronghold3, new Conditions(LogicType.NOR, this.topSceptre.alsoCheckBank(this.questBank), this.runedSceptre.alsoCheckBank(this.questBank))), this.killCatablepon);
        this.skullSceptreTask.addStep(new Conditions(new Conditions(LogicType.OR, this.topSceptre.alsoCheckBank(this.questBank), this.runedSceptre.alsoCheckBank(this.questBank)), this.notSkullSceptre, this.inStronghold3), this.moveToStronghold4);
        this.skullSceptreTask.addStep(new Conditions(this.notSkullSceptre, this.inStronghold4, new Conditions(LogicType.NOR, this.leftSkull.alsoCheckBank(this.questBank), this.strangeSkull.alsoCheckBank(this.questBank), this.combinedSkullSceptre.alsoCheckBank(this.questBank))), this.killAnkou);
        this.skullSceptreTask.addStep(new Conditions(this.notSkullSceptre, this.leftSkull.alsoCheckBank(this.questBank), this.rightSkull.alsoCheckBank(this.questBank)), this.makeSkull);
        this.skullSceptreTask.addStep(new Conditions(this.notSkullSceptre, this.botSceptre.alsoCheckBank(this.questBank), this.topSceptre.alsoCheckBank(this.questBank)), this.makeSceptre);
        this.skullSceptreTask.addStep(new Conditions(this.notSkullSceptre, this.runedSceptre.alsoCheckBank(this.questBank), this.strangeSkull.alsoCheckBank(this.questBank)), this.makeSkullSceptre);
        this.skullSceptreTask.addStep(new Conditions(this.notSkullSceptre, this.combinedSkullSceptre.alsoCheckBank(this.questBank)), this.skullSceptre);
        doHard.addStep(this.notSkullSceptre, this.skullSceptreTask);
        return doHard;
    }

    @Override
    public void setupRequirements() {
        this.notSpottyCape = new VarplayerRequirement(1176, false, 29);
        this.not153Kudos = new VarplayerRequirement(1176, false, 30);
        this.notWakkaEdge = new VarplayerRequirement(1176, false, 31);
        this.notPaddewwaTP = new VarplayerRequirement(1177, false, 0);
        this.notSkullSceptre = new VarplayerRequirement(1177, false, 1);
        this.notYewChurch = new VarplayerRequirement(1177, false, 2);
        this.notFancyStone = new VarplayerRequirement(1177, false, 3);
        this.notYewRoots = new VarplayerRequirement(1177, false, 4);
        this.notSmiteAltar = new VarplayerRequirement(1177, false, 5);
        this.notPipe = new VarplayerRequirement(1177, false, 6);
        this.atleast153Kudos = new VarbitRequirement(3637, Operation.GREATER_EQUAL, 153, "153+ Kudos");
        this.smiteActive = new PrayerRequirement("Smite", Prayer.SMITE);
        this.ancientBook = new SpellbookRequirement(Spellbook.ANCIENT);
        this.yewNotChecked = new VarbitRequirement(4771, 45);
        this.yewChecked = new VarbitRequirement(4771, 46);
        this.yewStump = new VarbitRequirement(4771, 47);
        this.botSceptre = new ItemRequirement("Bottom of sceptre", 9011).showConditioned(this.notSkullSceptre);
        this.topSceptre = new ItemRequirement("Top of sceptre", 9010).showConditioned(this.notSkullSceptre);
        this.leftSkull = new ItemRequirement("Left skull half", 9008).showConditioned(this.notSkullSceptre);
        this.rightSkull = new ItemRequirement("Right skull half", 9007).showConditioned(this.notSkullSceptre);
        this.strangeSkull = new ItemRequirement("Strange skull", 9009).showConditioned(this.notSkullSceptre);
        this.runedSceptre = new ItemRequirement("Runed sceptre", 9012).showConditioned(this.notSkullSceptre);
        this.combinedSkullSceptre = new ItemRequirement("Skull sceptre", 9013).showConditioned(this.notSkullSceptre);
        this.dashingKeb = new ItemRequirement("Dashing kebbit fur", 10127).showConditioned(this.notSpottyCape);
        this.dashingKeb.setTooltip("Requires 69 hunter to obtain.");
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(new Conditions(LogicType.OR, this.notSpottyCape, this.notFancyStone));
        this.cape = new ItemRequirement("Spottier cape", 10071).showConditioned(this.notSpottyCape).isNotConsumed();
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(new Conditions(LogicType.OR, this.notWakkaEdge, this.notYewChurch, this.notYewRoots)).isNotConsumed();
        this.lawRune = new ItemRequirement("Law rune", 563).showConditioned(this.notPaddewwaTP);
        this.airRune = new ItemRequirement("Air rune", 556).showConditioned(this.notPaddewwaTP);
        this.fireRune = new ItemRequirement("Fire rune", 554).showConditioned(this.notPaddewwaTP);
        this.yewLog = new ItemRequirement("Yew log", 1515);
        this.tinderBox = new ItemRequirement("Tinderbox", 590).showConditioned(this.notYewChurch).isNotConsumed();
        this.yewSap = new ItemRequirement("Yew sapling", 5373).showConditioned(this.notYewRoots);
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(this.notYewRoots).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notYewRoots).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.inStronghold1 = new ZoneRequirement(this.stronghold1);
        this.inStronghold2 = new ZoneRequirement(this.stronghold2);
        this.inStronghold3 = new ZoneRequirement(this.stronghold3);
        this.inStronghold4 = new ZoneRequirement(this.stronghold4);
        this.inBasement = new ZoneRequirement(this.basement);
        this.inChurch2 = new ZoneRequirement(this.church2);
        this.inChurch3 = new ZoneRequirement(this.church3);
        this.inChurch4 = new ZoneRequirement(this.church4);
        this.inUpstairs = new ZoneRequirement(this.upstairs);
        this.inSewer = new ZoneRequirement(this.sewer);
        this.desertTreasure = new QuestRequirement(QuestHelperQuest.DESERT_TREASURE, QuestState.FINISHED);
        this.inAsyffShop = new ZoneRequirement(new Zone(new WorldPoint(3278, 3394, 0), new WorldPoint(3283, 3400, 0)));
        this.boughtSpotterCape = new ChatMessageRequirement(this.inAsyffShop, "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.boughtSpotterCape).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inAsyffShop), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
        this.inYewZone = new ZoneRequirement(new Zone(new WorldPoint(3225, 3456, 0), new WorldPoint(3254, 3478, 0)));
        this.cutYewTree = new ChatMessageRequirement(this.inYewZone, "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.cutYewTree).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inYewZone), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
    }

    public void loadZones() {
        this.stronghold1 = new Zone(new WorldPoint(1854, 5248, 0), new WorldPoint(1918, 5183, 0));
        this.stronghold2 = new Zone(new WorldPoint(1983, 5248, 0), new WorldPoint(2049, 5183, 0));
        this.stronghold3 = new Zone(new WorldPoint(2113, 5313, 0), new WorldPoint(2177, 5246, 0));
        this.stronghold4 = new Zone(new WorldPoint(2302, 5250, 0), new WorldPoint(2369, 5183, 0));
        this.basement = new Zone(new WorldPoint(1728, 4989, 0), new WorldPoint(1792, 4931, 0));
        this.church2 = new Zone(new WorldPoint(3249, 3489, 1), new WorldPoint(3262, 3469, 1));
        this.church3 = new Zone(new WorldPoint(3249, 3489, 2), new WorldPoint(3262, 3469, 2));
        this.church4 = new Zone(new WorldPoint(3249, 3489, 3), new WorldPoint(3262, 3469, 3));
        this.upstairs = new Zone(new WorldPoint(3199, 3501, 1), new WorldPoint(3227, 3466, 1));
        this.sewer = new Zone(new WorldPoint(3066, 10001, 0), new WorldPoint(3289, 9820, 0));
    }

    public void setupSteps() {
        this.moveToStronghold = new ObjectStep((QuestHelper)this, 20790, new WorldPoint(3081, 3420, 0), "Enter the Security Stronghold.", this.combatGear, this.food);
        this.killMino = new NpcStep((QuestHelper)this, 2481, new WorldPoint(1888, 5220, 0), "Kill Minotaurs until you receive a right skull half.", this.rightSkull, this.combatGear, this.food);
        this.killMino.addAlternateNpcs(2482);
        this.killMino.addAlternateNpcs(2483);
        this.moveToStronghold2 = new ObjectStep((QuestHelper)this, 20785, new WorldPoint(1902, 5222, 0), "Go to the 2nd floor of the stronghold.", this.combatGear, this.food);
        this.killFlesh = new NpcStep((QuestHelper)this, 2498, new WorldPoint(2019, 5215, 0), "Kill Flesh crawlers until you receive a bottom of sceptre.", this.combatGear, this.food, this.botSceptre);
        this.killFlesh.addAlternateNpcs(2499);
        this.killFlesh.addAlternateNpcs(2500);
        this.moveToStronghold3 = new ObjectStep((QuestHelper)this, 19004, new WorldPoint(2026, 5218, 0), "Go to the 3rd floor of the stronghold.", this.combatGear, this.food);
        this.killCatablepon = new NpcStep((QuestHelper)this, 2474, new WorldPoint(2144, 5281, 0), "Kill Catablepons until you receive a top of sceptre.", this.combatGear, this.food, this.topSceptre);
        this.killCatablepon.addAlternateNpcs(2475);
        this.killCatablepon.addAlternateNpcs(2476);
        this.moveToStronghold4 = new ObjectStep((QuestHelper)this, 23706, new WorldPoint(2148, 5284, 0), "Go to the 4th floor of the stronghold.", this.combatGear, this.food);
        this.killAnkou = new NpcStep((QuestHelper)this, 2514, new WorldPoint(2344, 5213, 0), "Kill Ankous until you receive a left skull half.", this.combatGear, this.food, this.leftSkull);
        this.killAnkou.addAlternateNpcs(2515);
        this.killAnkou.addAlternateNpcs(2516);
        this.makeSkull = new ItemStep((QuestHelper)this, "Use both skull halves together.", this.leftSkull.highlighted(), this.rightSkull.highlighted());
        this.makeSceptre = new ItemStep((QuestHelper)this, "Use the sceptre pieces together.", this.botSceptre.highlighted(), this.topSceptre.highlighted());
        this.makeSkullSceptre = new ItemStep((QuestHelper)this, "Use the runed sceptre and strange skull together.", this.runedSceptre.highlighted(), this.strangeSkull.highlighted());
        this.skullSceptre = new DetailedQuestStep((QuestHelper)this, "Right-click on the Skull sceptre and select 'Invoke' to teleport to the stronghold.", this.combinedSkullSceptre.highlighted());
        this.getCape = new NpcStep((QuestHelper)this, 2887, new WorldPoint(3281, 3398, 0), "Have Asyff make a spottier cape.", this.dashingKeb.quantity(2), this.coins.quantity(800));
        this.getCape.addDialogStep("Could you make anything out of this fur that I got from hunting?");
        this.spottyCape = new ItemStep((QuestHelper)this, "Equip the spottier cape.", this.cape.highlighted());
        this.moveToBasement = new ObjectStep((QuestHelper)this, 24428, new WorldPoint(3256, 3452, 0), "Climb down the Varrock Museum stairs.", new Requirement[0]);
        this.kudos = new NpcStep((QuestHelper)this, 6001, new WorldPoint(1759, 4955, 0), "Speak with Orlando.", new Requirement[0]);
        this.getKudos = new DetailedQuestStep((QuestHelper)this, "Complete more quests and tasks for kudos. Check out the kudos wiki page for more details.", new Requirement[0]);
        this.wakkaEdge = new ObjectStep((QuestHelper)this, 12166, new WorldPoint(3131, 3510, 0), "Make a Waka at the canoe station in Edgeville.", this.axe);
        this.paddewwaTP = new DetailedQuestStep((QuestHelper)this, "Cast teleport to Paddewwa.", this.ancientBook, this.lawRune.quantity(2), this.airRune.quantity(1), this.fireRune.quantity(1));
        this.cutYew = new ObjectStep((QuestHelper)this, 10823, new WorldPoint(3249, 3473, 0), "Cut a yew tree until you get a log.", this.axe);
        this.goUp1 = new ObjectStep((QuestHelper)this, 11790, new WorldPoint(3259, 3488, 0), "Climb to the top of the Varrock Church.", this.yewLog, this.tinderBox);
        this.goUp2 = new ObjectStep((QuestHelper)this, 11792, new WorldPoint(3259, 3488, 1), "Climb the stairs.", this.yewLog, this.tinderBox);
        this.goUp3 = new ObjectStep((QuestHelper)this, 11792, new WorldPoint(3259, 3488, 2), "Climb the stairs.", this.yewLog, this.tinderBox);
        this.goUp1.addSubSteps(this.goUp2, this.goUp3);
        this.burnLogs = new ItemStep((QuestHelper)this, "Burn the yew logs on top of the church.", this.tinderBox.highlighted(), this.yewLog.highlighted());
        this.fancyStone = new NpcStep((QuestHelper)this, 3097, new WorldPoint(3240, 3475, 0), "TALK to the estate agent to redecorate your house to fancy stone. Must be done through dialog, NOT right-click.", this.coins.quantity(25000));
        this.fancyStone.addDialogStep("Can you redecorate my house please?");
        this.growYew = new ObjectStep((QuestHelper)this, 8513, new WorldPoint(3229, 3459, 0), "Grow and check the health of a yew tree in front of Varrock palace. Afterwards, dig up the stump to get the yew roots. If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", this.yewSap, this.rake, this.spade);
        this.chopYew = new ObjectStep((QuestHelper)this, 8513, new WorldPoint(3229, 3459, 0), "Chop the yew tree that you grew in front of Varrock palace. Afterwards, dig up the stump to get the Yew roots.", this.axe, this.spade);
        this.digUpYewRoots = new ObjectStep((QuestHelper)this, 8514, new WorldPoint(3229, 3459, 0), "Dig up the stump to get the Yew roots.", this.spade);
        this.moveToUpstairs = new ObjectStep((QuestHelper)this, 11789, new WorldPoint(3219, 3497, 0), "Climb the stairs in the back of the Varrock palace.", new Requirement[0]);
        this.prayAtAltar = new ObjectStep((QuestHelper)this, 409, new WorldPoint(3208, 3495, 1), "Pray at altar with Smite active.", this.smiteActive);
        this.moveToEdge = new ObjectStep((QuestHelper)this, 1581, new WorldPoint(3097, 3468, 0), "Enter the Edgeville dungeon.", new Requirement[0]);
        this.obsPipe = new ObjectStep((QuestHelper)this, 16511, new WorldPoint(3150, 9906, 0), "Climb through the pipe shortcut near Vannaka.", new Requirement[0]);
        this.claimReward = new NpcStep((QuestHelper)this, 5525, new WorldPoint(3225, 3415, 0), "Talk to Toby in Varrock to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins.quantity(25800), this.dashingKeb.quantity(2), this.axe, this.lawRune.quantity(2), this.fireRune, this.airRune, this.tinderBox, this.yewSap, this.spade);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.food);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.AGILITY, 51));
        reqs.add(new SkillRequirement(Skill.CONSTRUCTION, 50));
        reqs.add(new SkillRequirement(Skill.FARMING, 68, true));
        reqs.add(new SkillRequirement(Skill.FIREMAKING, 60));
        reqs.add(new SkillRequirement(Skill.HUNTER, 66));
        reqs.add(new SkillRequirement(Skill.MAGIC, 54));
        reqs.add(new SkillRequirement(Skill.PRAYER, 52));
        reqs.add(new SkillRequirement(Skill.WOODCUTTING, 60));
        reqs.add(this.atleast153Kudos);
        reqs.add(this.ancientBook);
        reqs.add(this.desertTreasure);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Kill various monsters in the stronghold of security (levels 13-86)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Varrock Armor (3)", 13106, 1), new ItemReward("15,000 Exp. Lamp (Any skill over 50)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("10% Chance to mine 2 ores at once up to adamantite ore"), new UnlockReward("10% Chance of smelting 2 bars at once up to adamantite when using the Edgeville furnace"), new UnlockReward("Zaff will sell 60 Battlestaves per day for 7,000 Coins each"), new UnlockReward("The Skull sceptre will now hold 22 charges"), new UnlockReward("Access to the Cooks' Guild bank"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails yewRootsSteps = new PanelDetails("Yew Roots", Arrays.asList(this.growYew, this.chopYew, this.digUpYewRoots), new SkillRequirement(Skill.FARMING, 68, true), new SkillRequirement(Skill.WOODCUTTING, 60), this.axe, this.spade, this.rake, this.yewSap);
        yewRootsSteps.setDisplayCondition(this.notYewRoots);
        yewRootsSteps.setLockingStep(this.yewRootsTask);
        allSteps.add(yewRootsSteps);
        PanelDetails spottierCapeSteps = new PanelDetails("Trade for A Spottier Cape", Arrays.asList(this.getCape, this.spottyCape), new SkillRequirement(Skill.HUNTER, 66), this.dashingKeb.quantity(2), this.coins.quantity(800));
        spottierCapeSteps.setDisplayCondition(this.notSpottyCape);
        spottierCapeSteps.setLockingStep(this.spottyCapeTask);
        allSteps.add(spottierCapeSteps);
        PanelDetails kudosSteps = new PanelDetails("Speak with Orlando With 153+ Kudos", Arrays.asList(this.getKudos, this.moveToBasement, this.kudos), this.atleast153Kudos);
        kudosSteps.setDisplayCondition(this.not153Kudos);
        kudosSteps.setLockingStep(this.kudosTask);
        allSteps.add(kudosSteps);
        PanelDetails yewChurchSteps = new PanelDetails("Cut and Burn Yew Logs Atop the Church", Arrays.asList(this.cutYew, this.goUp1, this.burnLogs), new SkillRequirement(Skill.FIREMAKING, 60), new SkillRequirement(Skill.WOODCUTTING, 60), this.axe, this.tinderBox);
        yewChurchSteps.setDisplayCondition(this.notYewChurch);
        yewChurchSteps.setLockingStep(this.yewChurchTask);
        allSteps.add(yewChurchSteps);
        PanelDetails fancyStoneSteps = new PanelDetails("Fancy Stone", Collections.singletonList(this.fancyStone), new SkillRequirement(Skill.CONSTRUCTION, 50), this.coins.quantity(25000));
        fancyStoneSteps.setDisplayCondition(this.notFancyStone);
        fancyStoneSteps.setLockingStep(this.fancyStoneTask);
        allSteps.add(fancyStoneSteps);
        PanelDetails smitedSteps = new PanelDetails("Altar Smited", Arrays.asList(this.moveToUpstairs, this.prayAtAltar), new SkillRequirement(Skill.PRAYER, 52));
        smitedSteps.setDisplayCondition(this.notSmiteAltar);
        smitedSteps.setLockingStep(this.smiteAltarTask);
        allSteps.add(smitedSteps);
        PanelDetails edgevilleWakkaSteps = new PanelDetails("Edgeville Wakka", Collections.singletonList(this.wakkaEdge), new SkillRequirement(Skill.WOODCUTTING, 57), this.axe);
        edgevilleWakkaSteps.setDisplayCondition(this.notWakkaEdge);
        edgevilleWakkaSteps.setLockingStep(this.wakkaEdgeTask);
        allSteps.add(edgevilleWakkaSteps);
        PanelDetails paddewwaSteps = new PanelDetails("Teleport to Paddewwa", Collections.singletonList(this.paddewwaTP), new SkillRequirement(Skill.MAGIC, 54), this.desertTreasure, this.ancientBook, this.lawRune.quantity(2), this.airRune.quantity(1), this.fireRune.quantity(1));
        paddewwaSteps.setDisplayCondition(this.notPaddewwaTP);
        paddewwaSteps.setLockingStep(this.paddewwaTPTask);
        allSteps.add(paddewwaSteps);
        PanelDetails obstaclePipeSteps = new PanelDetails("Obstacle Pipe", Arrays.asList(this.moveToEdge, this.obsPipe), new SkillRequirement(Skill.AGILITY, 51));
        obstaclePipeSteps.setDisplayCondition(this.notPipe);
        obstaclePipeSteps.setLockingStep(this.pipeTask);
        allSteps.add(obstaclePipeSteps);
        PanelDetails skullSceptreSteps = new PanelDetails("Teleport with Skull Sceptre", Arrays.asList(this.moveToStronghold, this.killMino, this.moveToStronghold2, this.killFlesh, this.moveToStronghold3, this.killCatablepon, this.moveToStronghold4, this.killAnkou, this.makeSkull, this.makeSceptre, this.makeSkullSceptre, this.skullSceptre), this.combatGear, this.food);
        skullSceptreSteps.setDisplayCondition(this.notSkullSceptre);
        skullSceptreSteps.setLockingStep(this.skullSceptreTask);
        allSteps.add(skullSceptreSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

