/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.varrock;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.VARROCK_ELITE)
public class VarrockElite
extends ComplexStateQuestHelper {
    ItemRequirement sAtk4;
    ItemRequirement sStr4;
    ItemRequirement sDef4;
    ItemRequirement torstol;
    ItemRequirement natureRune;
    ItemRequirement astralRune;
    ItemRequirement earthRune;
    ItemRequirement coins;
    ItemRequirement mahoganyLog;
    ItemRequirement cookingGuild;
    ItemRequirement rawPie;
    ItemRequirement runeBar;
    ItemRequirement feather;
    ItemRequirement hammer;
    ItemRequirement essence;
    ItemRequirement earthTali;
    ItemRequirement runeDartTip;
    Requirement dreamMentor;
    Requirement runeMyster;
    Requirement touristTrap;
    Requirement notSuperCombat;
    Requirement notPlankMake;
    Requirement notSummerPie;
    Requirement notRuneDart;
    Requirement not100Earth;
    Requirement madeTips;
    Requirement lunarBook;
    QuestStep claimReward;
    QuestStep moveToBank;
    QuestStep superCombat;
    QuestStep moveToLumb;
    QuestStep plankMake;
    QuestStep moveToCookingGuild;
    QuestStep summerPie;
    QuestStep moveToEarthRune;
    QuestStep earthRune100;
    QuestStep dartTip;
    QuestStep runeDart;
    QuestStep moveToAnvil;
    Zone bank;
    Zone lumb;
    Zone cGuild;
    Zone earth;
    Zone anvil;
    ZoneRequirement inBank;
    ZoneRequirement inLumb;
    ZoneRequirement inCookingGuild;
    ZoneRequirement inEarth;
    ZoneRequirement inAnvil;
    ConditionalStep superCombatTask;
    ConditionalStep summerPieTask;
    ConditionalStep runeDartTask;
    ConditionalStep plankMakeTask;
    ConditionalStep earthRuneTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doElite = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.superCombatTask = new ConditionalStep((QuestHelper)this, this.moveToBank, new Requirement[0]);
        this.superCombatTask.addStep(this.inBank, this.superCombat);
        doElite.addStep(this.notSuperCombat, this.superCombatTask);
        this.summerPieTask = new ConditionalStep((QuestHelper)this, this.moveToCookingGuild, new Requirement[0]);
        this.summerPieTask.addStep(this.inCookingGuild, this.summerPie);
        doElite.addStep(this.notSummerPie, this.summerPieTask);
        this.runeDartTask = new ConditionalStep((QuestHelper)this, this.moveToAnvil, new Requirement[0]);
        this.runeDartTask.addStep(this.inAnvil, this.dartTip);
        this.runeDartTask.addStep(new Conditions(this.runeDartTip, this.madeTips), this.runeDart);
        doElite.addStep(this.notRuneDart, this.runeDartTask);
        this.plankMakeTask = new ConditionalStep((QuestHelper)this, this.moveToLumb, new Requirement[0]);
        this.plankMakeTask.addStep(this.inLumb, this.plankMake);
        doElite.addStep(this.notPlankMake, this.plankMakeTask);
        this.earthRuneTask = new ConditionalStep((QuestHelper)this, this.moveToEarthRune, new Requirement[0]);
        this.earthRuneTask.addStep(this.inEarth, this.earthRune100);
        doElite.addStep(this.not100Earth, this.earthRuneTask);
        return doElite;
    }

    @Override
    public void setupRequirements() {
        this.notSuperCombat = new VarplayerRequirement(1177, false, 7);
        this.notPlankMake = new VarplayerRequirement(1177, false, 8);
        this.notSummerPie = new VarplayerRequirement(1177, false, 9);
        this.notRuneDart = new VarplayerRequirement(1177, false, 10);
        this.not100Earth = new VarplayerRequirement(1177, false, 11);
        this.lunarBook = new SpellbookRequirement(Spellbook.LUNAR);
        this.sAtk4 = new ItemRequirement("Super attack(4)", 2436).showConditioned(this.notSuperCombat);
        this.sStr4 = new ItemRequirement("Super strength(4)", 2440).showConditioned(this.notSuperCombat);
        this.sDef4 = new ItemRequirement("Super defense(4)", 2442).showConditioned(this.notSuperCombat);
        this.torstol = new ItemRequirement("Torstol", 269).showConditioned(this.notSuperCombat);
        this.natureRune = new ItemRequirement("Nature rune", 561).showConditioned(this.notPlankMake);
        this.astralRune = new ItemRequirement("Astral rune", 9075).showConditioned(this.notPlankMake);
        this.earthRune = new ItemRequirement("Earth rune", 557).showConditioned(this.notPlankMake);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(this.notPlankMake);
        this.mahoganyLog = new ItemRequirement("Mahogany logs", 6332).showConditioned(this.notPlankMake);
        this.cookingGuild = new ItemRequirement("Access to cooking guild", ItemCollections.COOKING_GUILD).showConditioned(this.notSummerPie).isNotConsumed();
        this.cookingGuild.setTooltip("A chef's hat, Varrock Armour 3, or Cooking Cape");
        this.rawPie = new ItemRequirement("Raw summer pie", 7216).showConditioned(this.notSummerPie);
        this.feather = new ItemRequirement("Feather", 314, 10).showConditioned(this.notRuneDart);
        this.runeBar = new ItemRequirement("Runite bar", 2363).showConditioned(this.notRuneDart);
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(this.notRuneDart).isNotConsumed();
        this.runeDartTip = new ItemRequirement("Rune dart tip", 824);
        this.essence = new ItemRequirement("Essence", ItemCollections.ESSENCE_LOW).showConditioned(this.not100Earth);
        this.earthTali = new ItemRequirement("Access to Earth altar, or travel through abyss", ItemCollections.EARTH_ALTAR).showConditioned(this.not100Earth).isNotConsumed();
        this.earthTali.setTooltip("Earth talisman or tiara");
        this.inBank = new ZoneRequirement(this.bank);
        this.inLumb = new ZoneRequirement(this.lumb);
        this.inCookingGuild = new ZoneRequirement(this.cGuild);
        this.inAnvil = new ZoneRequirement(this.anvil);
        this.inEarth = new ZoneRequirement(this.earth);
        this.madeTips = new ChatMessageRequirement(this.inAnvil, "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.madeTips).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inAnvil), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
        this.dreamMentor = new QuestRequirement(QuestHelperQuest.DREAM_MENTOR, QuestState.FINISHED);
        this.runeMyster = new QuestRequirement(QuestHelperQuest.RUNE_MYSTERIES, QuestState.FINISHED);
        this.touristTrap = new QuestRequirement(QuestHelperQuest.THE_TOURIST_TRAP, QuestState.FINISHED);
    }

    public void loadZones() {
        this.bank = new Zone(new WorldPoint(3179, 3448, 0), new WorldPoint(3191, 3432, 0));
        this.lumb = new Zone(new WorldPoint(3300, 3501, 0), new WorldPoint(3313, 3493, 0));
        this.cGuild = new Zone(new WorldPoint(3138, 3453, 0), new WorldPoint(3148, 3444, 0));
        this.earth = new Zone(new WorldPoint(2624, 4863, 0), new WorldPoint(2687, 4800, 0));
        this.anvil = new Zone(new WorldPoint(3185, 3427, 0), new WorldPoint(3190, 3420, 0));
    }

    public void setupSteps() {
        this.moveToBank = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3183, 3440, 0), "Move to the west Varrock bank.", new Requirement[0]);
        this.superCombat = new ItemStep((QuestHelper)this, "Create a super combat potion.", this.sAtk4.highlighted(), this.sStr4.highlighted(), this.sDef4.highlighted(), this.torstol.highlighted());
        this.moveToLumb = new ObjectStep((QuestHelper)this, 2618, new WorldPoint(3308, 3492, 0), "Climb the fence to enter the lumber yard.", this.natureRune.quantity(20), this.astralRune.quantity(40), this.earthRune.quantity(300), this.coins.quantity(21000), this.mahoganyLog.quantity(20));
        this.plankMake = new DetailedQuestStep((QuestHelper)this, "Cast plank make until you've made 20 mahogany planks.", this.natureRune.quantity(20), this.astralRune.quantity(40), this.earthRune.quantity(300), this.coins.quantity(21000), this.mahoganyLog.quantity(20));
        this.moveToCookingGuild = new ObjectStep((QuestHelper)this, 24958, new WorldPoint(3143, 3443, 0), "Enter the cooking guild.", this.cookingGuild.equipped());
        this.summerPie = new ObjectStep((QuestHelper)this, 7183, new WorldPoint(3146, 3453, 0), "Cook the summer pie.", this.rawPie);
        this.moveToEarthRune = new ObjectStep((QuestHelper)this, 34816, new WorldPoint(3306, 3474, 0), "Travel to the earth altar or go through the abyss.", this.earthTali, this.essence.quantity(25));
        this.earthRune100 = new ObjectStep((QuestHelper)this, 34763, new WorldPoint(2658, 4841, 0), "Craft the earth runes.", this.essence.quantity(25));
        this.moveToAnvil = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3188, 3426, 0), "Go to the anvil beside the west Varrock bank.", this.runeBar, this.feather, this.hammer);
        this.dartTip = new ObjectStep((QuestHelper)this, 2097, new WorldPoint(3188, 3426, 0), "Make rune dart tips on the anvil in west Varrock.", this.runeBar);
        this.runeDart = new ItemStep((QuestHelper)this, "Use feathers on the rune dart tips.", this.runeDartTip.highlighted(), this.feather.highlighted());
        this.claimReward = new NpcStep((QuestHelper)this, 5525, new WorldPoint(3225, 3415, 0), "Talk to Toby in Varrock to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.sAtk4, this.sStr4, this.sDef4, this.torstol, this.natureRune.quantity(20), this.astralRune.quantity(40), this.earthRune.quantity(300), this.coins.quantity(21000), this.mahoganyLog.quantity(20), this.cookingGuild, this.rawPie, this.runeBar, this.feather, this.hammer, this.essence.quantity(25), this.earthTali);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.COOKING, 95));
        reqs.add(new SkillRequirement(Skill.FLETCHING, 81));
        reqs.add(new SkillRequirement(Skill.HERBLORE, 90));
        reqs.add(new SkillRequirement(Skill.MAGIC, 86));
        reqs.add(new ComplexRequirement(LogicType.OR, "78 Runecraft or 52 with Raiments of the Eye set", new SkillRequirement(Skill.RUNECRAFT, 78, true, "78 Runecraft"), new ItemRequirements("52 with Raiments of the Eye set", new ItemRequirement("Hat", ItemCollections.EYE_HAT), new ItemRequirement("Top", ItemCollections.EYE_TOP), new ItemRequirement("Bottom", ItemCollections.EYE_BOTTOM), new ItemRequirement("Boot", 26856))));
        reqs.add(new SkillRequirement(Skill.SMITHING, 89));
        reqs.add(this.dreamMentor);
        reqs.add(this.touristTrap);
        reqs.add(this.runeMyster);
        return reqs;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Varrock Armor (4)", 13107, 1), new ItemReward("50,000 Exp. Lamp (Any skill over 70)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("10% Chance to mine 2 ores at once, up to and including Amethyst"), new UnlockReward("10% Chance of smelting 2 bars at once when using the Edgeville furnace"), new UnlockReward("Zaff will sell 120 Battlestaves per day for 7,000 Coins each"), new UnlockReward("The Skull sceptre will now hold 26 charges"), new UnlockReward("Acts as a prospector jacket for experience bonus and clues"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails superCombatSteps = new PanelDetails("Make Super Combat", Arrays.asList(this.moveToBank, this.superCombat), new SkillRequirement(Skill.HERBLORE, 90), this.sAtk4, this.sStr4, this.sDef4, this.torstol);
        superCombatSteps.setDisplayCondition(this.notSuperCombat);
        superCombatSteps.setLockingStep(this.superCombatTask);
        allSteps.add(superCombatSteps);
        PanelDetails summerPieSteps = new PanelDetails("Summer Pie", Arrays.asList(this.moveToCookingGuild, this.summerPie), new SkillRequirement(Skill.COOKING, 95), this.cookingGuild, this.rawPie);
        summerPieSteps.setDisplayCondition(this.notSummerPie);
        summerPieSteps.setLockingStep(this.summerPieTask);
        allSteps.add(summerPieSteps);
        PanelDetails runeDartsSteps = new PanelDetails("Smith and Fletch 10 Rune Darts", Arrays.asList(this.moveToAnvil, this.dartTip, this.runeDart), new SkillRequirement(Skill.FLETCHING, 81), new SkillRequirement(Skill.SMITHING, 89), this.touristTrap, this.runeBar, this.feather, this.hammer);
        runeDartsSteps.setDisplayCondition(this.notRuneDart);
        runeDartsSteps.setLockingStep(this.runeDartTask);
        allSteps.add(runeDartsSteps);
        PanelDetails plankMakeSteps = new PanelDetails("Plank Make", Arrays.asList(this.moveToLumb, this.plankMake), new SkillRequirement(Skill.MAGIC, 86), this.lunarBook, this.dreamMentor, this.natureRune.quantity(20), this.astralRune.quantity(40), this.earthRune.quantity(300), this.coins.quantity(21000), this.mahoganyLog.quantity(20));
        plankMakeSteps.setDisplayCondition(this.notPlankMake);
        plankMakeSteps.setLockingStep(this.plankMakeTask);
        allSteps.add(plankMakeSteps);
        PanelDetails earth100Steps = new PanelDetails("Craft 100 Earth runes", Arrays.asList(this.moveToEarthRune, this.earthRune100), new SkillRequirement(Skill.RUNECRAFT, 78), this.essence.quantity(25), this.earthTali);
        earth100Steps.setDisplayCondition(this.not100Earth);
        earth100Steps.setLockingStep(this.earthRuneTask);
        allSteps.add(earth100Steps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

