/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.varrock;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.VARROCK_EASY)
public class VarrockEasy
extends ComplexStateQuestHelper {
    ItemRequirement coins;
    ItemRequirement pickaxe;
    ItemRequirement log;
    ItemRequirement axe;
    ItemRequirement bone;
    ItemRequirement softClay;
    ItemRequirement earthTali;
    ItemRequirement essence;
    ItemRequirement flyRod;
    ItemRequirement feathers;
    ItemRequirement unfiredBowl;
    ItemRequirement food;
    Requirement runeMysteries;
    Requirement notThessalia;
    Requirement notAubury;
    Requirement notIron;
    Requirement notPlank;
    Requirement notStrongholdSecond;
    Requirement notFence;
    Requirement notNews;
    Requirement notDyingTree;
    Requirement notDogBone;
    Requirement notBowl;
    Requirement notKudos;
    Requirement notTrout;
    Requirement notTeaStall;
    Requirement notEarthRune;
    Requirement notMoreKudos;
    Requirement madeBowl;
    QuestStep claimReward;
    QuestStep thessalia;
    QuestStep aubury;
    QuestStep iron;
    QuestStep plank;
    QuestStep moveToStronghold1;
    QuestStep moveToStronghold2;
    QuestStep fence;
    QuestStep dyingTree;
    QuestStep news;
    QuestStep dogBone;
    QuestStep potteryWheel;
    QuestStep bowl;
    QuestStep kudos;
    QuestStep moreKudos;
    QuestStep moveToEarthRune;
    QuestStep earthRune;
    QuestStep trout;
    QuestStep teaStall;
    Zone stronghold1;
    Zone earth;
    Zone potteryRoom;
    ZoneRequirement inStronghold1;
    ZoneRequirement inEarth;
    ZoneRequirement inPotteryRoom;
    ConditionalStep thessaliaTask;
    ConditionalStep auburyTask;
    ConditionalStep ironTask;
    ConditionalStep plankTask;
    ConditionalStep strongholdSecondTask;
    ConditionalStep fenceTask;
    ConditionalStep newsTask;
    ConditionalStep dyingTreeTask;
    ConditionalStep dogBoneTask;
    ConditionalStep bowlTask;
    ConditionalStep kudosTask;
    ConditionalStep troutTask;
    ConditionalStep teaStallTask;
    ConditionalStep earthRuneTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doEasy = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.thessaliaTask = new ConditionalStep((QuestHelper)this, this.thessalia, new Requirement[0]);
        doEasy.addStep(this.notThessalia, this.thessaliaTask);
        this.newsTask = new ConditionalStep((QuestHelper)this, this.news, new Requirement[0]);
        doEasy.addStep(this.notNews, this.newsTask);
        this.dogBoneTask = new ConditionalStep((QuestHelper)this, this.dogBone, new Requirement[0]);
        doEasy.addStep(this.notDogBone, this.dogBoneTask);
        this.kudosTask = new ConditionalStep((QuestHelper)this, this.moreKudos, new Requirement[0]);
        this.kudosTask.addStep(new Conditions(this.notKudos, this.notMoreKudos), this.kudos);
        doEasy.addStep(this.notKudos, this.kudosTask);
        this.auburyTask = new ConditionalStep((QuestHelper)this, this.aubury, new Requirement[0]);
        doEasy.addStep(this.notAubury, this.auburyTask);
        this.teaStallTask = new ConditionalStep((QuestHelper)this, this.teaStall, new Requirement[0]);
        doEasy.addStep(this.notTeaStall, this.teaStallTask);
        this.plankTask = new ConditionalStep((QuestHelper)this, this.plank, new Requirement[0]);
        doEasy.addStep(this.notPlank, this.plankTask);
        this.dyingTreeTask = new ConditionalStep((QuestHelper)this, this.dyingTree, new Requirement[0]);
        doEasy.addStep(this.notDyingTree, this.dyingTreeTask);
        this.earthRuneTask = new ConditionalStep((QuestHelper)this, this.moveToEarthRune, new Requirement[0]);
        this.earthRuneTask.addStep(new Conditions(this.notEarthRune, this.inEarth), this.earthRune);
        doEasy.addStep(this.notEarthRune, this.earthRuneTask);
        this.ironTask = new ConditionalStep((QuestHelper)this, this.iron, new Requirement[0]);
        doEasy.addStep(this.notIron, this.ironTask);
        this.fenceTask = new ConditionalStep((QuestHelper)this, this.fence, new Requirement[0]);
        doEasy.addStep(this.notFence, this.fenceTask);
        this.troutTask = new ConditionalStep((QuestHelper)this, this.trout, new Requirement[0]);
        doEasy.addStep(this.notTrout, this.troutTask);
        this.bowlTask = new ConditionalStep((QuestHelper)this, this.potteryWheel, new Requirement[0]);
        this.bowlTask.addStep(new Conditions(this.notBowl, this.madeBowl), this.bowl);
        doEasy.addStep(this.notBowl, this.bowlTask);
        this.strongholdSecondTask = new ConditionalStep((QuestHelper)this, this.moveToStronghold1, new Requirement[0]);
        this.strongholdSecondTask.addStep(new Conditions(LogicType.OR, this.notStrongholdSecond, this.inStronghold1), this.moveToStronghold2);
        doEasy.addStep(this.notStrongholdSecond, this.strongholdSecondTask);
        return doEasy;
    }

    @Override
    public void setupRequirements() {
        this.notThessalia = new VarplayerRequirement(1176, false, 1);
        this.notAubury = new VarplayerRequirement(1176, false, 2);
        this.notIron = new VarplayerRequirement(1176, false, 3);
        this.notPlank = new VarplayerRequirement(1176, false, 4);
        this.notStrongholdSecond = new VarplayerRequirement(1176, false, 5);
        this.notFence = new VarplayerRequirement(1176, false, 6);
        this.notDyingTree = new VarplayerRequirement(1176, false, 7);
        this.notNews = new VarplayerRequirement(1176, false, 8);
        this.notDogBone = new VarplayerRequirement(1176, false, 9);
        this.notBowl = new VarplayerRequirement(1176, false, 10);
        this.notKudos = new VarplayerRequirement(1176, false, 11);
        this.notEarthRune = new VarplayerRequirement(1176, false, 12);
        this.notTrout = new VarplayerRequirement(1176, false, 13);
        this.notTeaStall = new VarplayerRequirement(1176, false, 14);
        this.notMoreKudos = new VarbitRequirement(3637, Operation.GREATER_EQUAL, 50, "50+ Kudos");
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS, 150).showConditioned(new Conditions(LogicType.OR, this.notNews, this.notPlank));
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notIron).isNotConsumed();
        this.log = new ItemRequirement("Logs", 1511).showConditioned(this.notPlank);
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(this.notDyingTree).isNotConsumed();
        this.bone = new ItemRequirement("Bones", ItemCollections.BONES).showConditioned(this.notDogBone);
        this.softClay = new ItemRequirement("Soft clay", 1761).showConditioned(this.notBowl);
        this.earthTali = new ItemRequirement("Access to Earth altar, or travel through abyss", ItemCollections.EARTH_ALTAR).showConditioned(this.notEarthRune).isNotConsumed();
        this.earthTali.setTooltip("Earth talisman or tiara");
        this.essence = new ItemRequirement("Essence", ItemCollections.ESSENCE_LOW).showConditioned(this.notEarthRune);
        this.flyRod = new ItemRequirement("Fly fishing rod", 309).showConditioned(this.notTrout).isNotConsumed();
        this.feathers = new ItemRequirement("Feather", 314, 10).showConditioned(this.notTrout);
        this.unfiredBowl = new ItemRequirement("Unfired bowl", 1791);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.runeMysteries = new QuestRequirement(QuestHelperQuest.RUNE_MYSTERIES, QuestState.FINISHED);
        this.inStronghold1 = new ZoneRequirement(this.stronghold1);
        this.inEarth = new ZoneRequirement(this.earth);
        this.inPotteryRoom = new ZoneRequirement(this.potteryRoom);
        this.madeBowl = new ChatMessageRequirement(this.inPotteryRoom, "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.madeBowl).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inPotteryRoom), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
    }

    public void loadZones() {
        this.stronghold1 = new Zone(new WorldPoint(1854, 5248, 0), new WorldPoint(1918, 5183, 0));
        this.earth = new Zone(new WorldPoint(2624, 4863, 0), new WorldPoint(2687, 4800, 0));
        this.potteryRoom = new Zone(new WorldPoint(3082, 3407, 0), new WorldPoint(3087, 3411, 0));
    }

    public void setupSteps() {
        this.thessalia = new NpcStep((QuestHelper)this, 10477, new WorldPoint(3206, 3417, 0), "Browse Thessalia's store.", new Requirement[0]);
        this.aubury = new NpcStep((QuestHelper)this, 10681, new WorldPoint(3253, 3401, 0), "Teleport to the essence mine via Aubury.", new Requirement[0]);
        this.iron = new ObjectStep((QuestHelper)this, 11365, new WorldPoint(3288, 3370, 0), "Mine iron south-east of Varrock.", this.pickaxe);
        this.plank = new NpcStep((QuestHelper)this, 3101, new WorldPoint(3302, 3492, 0), "Make a regular plank at the sawmill.", this.log);
        this.plank.addWidgetHighlightWithItemIdRequirement(270, 13, 1511, true);
        this.moveToStronghold1 = new ObjectStep((QuestHelper)this, 20790, new WorldPoint(3081, 3420, 0), "Enter the Stronghold of Security.", new Requirement[0]);
        this.moveToStronghold2 = new ObjectStep((QuestHelper)this, 20785, new WorldPoint(1902, 5222, 0), "Go to the 2nd floor of the Stronghold of Security.", new Requirement[0]);
        this.fence = new ObjectStep((QuestHelper)this, 16518, new WorldPoint(3240, 3335, 0), "Jump the fence south of Varrock.", new Requirement[0]);
        this.dyingTree = new ObjectStep((QuestHelper)this, 3648, new WorldPoint(3308, 3495, 0), "Chop down a dying tree in the sawmill area.", this.axe);
        this.news = new NpcStep((QuestHelper)this, 5216, new WorldPoint(3219, 3431, 0), "Speak with Benny in the Varrock Square to purchase a newspaper.", this.coins.quantity(50));
        this.news.addDialogSteps("Can I have a newspaper, please?", "Sure, here you go...");
        this.dogBone = new NpcStep((QuestHelper)this, 2922, new WorldPoint(3184, 3431, 0), "Give the stray dog a bone. If the dog isn't nearby consider changing worlds.", this.bone.highlighted());
        this.dogBone.addIcon(526);
        this.potteryWheel = new ObjectStep((QuestHelper)this, 14887, new WorldPoint(3087, 3410, 0), "Use the potters wheel in Barbarian Village to make an unfired bowl.", this.softClay);
        this.potteryWheel.addWidgetHighlightWithItemIdRequirement(270, 13, 1791, true);
        this.bowl = new ObjectStep((QuestHelper)this, 11601, new WorldPoint(3085, 3407, 0), "Put the unfired bowl in the oven.", this.unfiredBowl);
        this.bowl.addIcon(1791);
        this.bowl.addWidgetHighlightWithItemIdRequirement(270, 13, 1791, true);
        this.moreKudos = new DetailedQuestStep((QuestHelper)this, "Get more kudos from either quests, miniquests, or turning in fossils.", new Requirement[0]);
        this.kudos = new NpcStep((QuestHelper)this, 5214, new WorldPoint(3258, 3449, 0), "Speak to Curator Haig Halen.", this.notMoreKudos);
        this.moveToEarthRune = new ObjectStep((QuestHelper)this, 34816, new WorldPoint(3306, 3474, 0), "Travel to the earth altar or go through the abyss.", this.earthTali.highlighted(), this.essence);
        this.moveToEarthRune.addIcon(1440);
        this.earthRune = new ObjectStep((QuestHelper)this, 34763, new WorldPoint(2658, 4841, 0), "Craft an earth rune.", this.essence);
        this.trout = new NpcStep((QuestHelper)this, 1526, new WorldPoint(3106, 3428, 0), "Fish a trout in the River Lum.", this.flyRod, this.feathers);
        this.teaStall = new ObjectStep((QuestHelper)this, 635, new WorldPoint(3270, 3411, 0), "Steal from the tea stall in Varrock.", new Requirement[0]);
        this.claimReward = new NpcStep((QuestHelper)this, 5525, new WorldPoint(3225, 3415, 0), "Talk to Toby in Varrock to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins.quantity(150), this.pickaxe, this.log, this.axe, this.bone, this.softClay, this.earthTali, this.essence, this.flyRod, this.feathers);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.food);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.AGILITY, 13));
        reqs.add(new SkillRequirement(Skill.CRAFTING, 8));
        reqs.add(new SkillRequirement(Skill.FISHING, 20));
        reqs.add(new SkillRequirement(Skill.MINING, 15));
        reqs.add(new SkillRequirement(Skill.RUNECRAFT, 9));
        reqs.add(new SkillRequirement(Skill.THIEVING, 5));
        reqs.add(this.runeMysteries);
        return reqs;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Varrock Armor (1)", 13104, 1), new ItemReward("2,500 Exp. Lamp (Any skill over 30)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("10% Chance to mine 2 ores at once up to gold ore"), new UnlockReward("10% Chance of smelting 2 bars at once up to Steel when using the Edgeville furnace"), new UnlockReward("Zaff will sell 15 Battlestaves per day for 7,000 Coins each"), new UnlockReward("The Skull sceptre will now hold 14 charges"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails thessaliaSteps = new PanelDetails("Browse Thessalia's Store", Collections.singletonList(this.thessalia), new Requirement[0]);
        thessaliaSteps.setDisplayCondition(this.notThessalia);
        thessaliaSteps.setLockingStep(this.thessaliaTask);
        allSteps.add(thessaliaSteps);
        PanelDetails newsSteps = new PanelDetails("Buy Newspaper", Collections.singletonList(this.news), this.coins.quantity(50));
        newsSteps.setDisplayCondition(this.notNews);
        newsSteps.setLockingStep(this.newsTask);
        allSteps.add(newsSteps);
        PanelDetails dogBoneSteps = new PanelDetails("Give a Dog a Bone", Collections.singletonList(this.dogBone), this.bone);
        dogBoneSteps.setDisplayCondition(this.notDogBone);
        dogBoneSteps.setLockingStep(this.dogBoneTask);
        allSteps.add(dogBoneSteps);
        PanelDetails kudosSteps = new PanelDetails("Speak to Haig Halen", Arrays.asList(this.moreKudos, this.kudos), this.notMoreKudos);
        kudosSteps.setDisplayCondition(this.notKudos);
        kudosSteps.setLockingStep(this.kudosTask);
        allSteps.add(kudosSteps);
        PanelDetails auburySteps = new PanelDetails("Teleport to Essence Mine", Collections.singletonList(this.aubury), this.runeMysteries);
        auburySteps.setDisplayCondition(this.notAubury);
        auburySteps.setLockingStep(this.auburyTask);
        allSteps.add(auburySteps);
        PanelDetails teaStallSteps = new PanelDetails("Steal from the Tea Stall", Collections.singletonList(this.teaStall), new SkillRequirement(Skill.THIEVING, 5));
        teaStallSteps.setDisplayCondition(this.notTeaStall);
        teaStallSteps.setLockingStep(this.teaStallTask);
        allSteps.add(teaStallSteps);
        PanelDetails plankSteps = new PanelDetails("Make Plank", Collections.singletonList(this.plank), this.coins.quantity(100), this.log);
        plankSteps.setDisplayCondition(this.notPlank);
        plankSteps.setLockingStep(this.plankTask);
        allSteps.add(plankSteps);
        PanelDetails dyingTreeSteps = new PanelDetails("Chop Down Dying Tree", Collections.singletonList(this.dyingTree), this.axe);
        dyingTreeSteps.setDisplayCondition(this.notDyingTree);
        dyingTreeSteps.setLockingStep(this.dyingTreeTask);
        allSteps.add(dyingTreeSteps);
        PanelDetails earthRuneSteps = new PanelDetails("Craft an Earth Rune", Arrays.asList(this.moveToEarthRune, this.earthRune), new SkillRequirement(Skill.RUNECRAFT, 9), this.essence, this.earthTali);
        earthRuneSteps.setDisplayCondition(this.notEarthRune);
        earthRuneSteps.setLockingStep(this.earthRuneTask);
        allSteps.add(earthRuneSteps);
        PanelDetails ironSteps = new PanelDetails("Mine Iron South East", Collections.singletonList(this.iron), new SkillRequirement(Skill.MINING, 15), this.pickaxe);
        ironSteps.setDisplayCondition(this.notIron);
        ironSteps.setLockingStep(this.ironTask);
        allSteps.add(ironSteps);
        PanelDetails fenceSteps = new PanelDetails("Jump the Fence", Collections.singletonList(this.fence), new SkillRequirement(Skill.AGILITY, 13));
        fenceSteps.setDisplayCondition(this.notFence);
        fenceSteps.setLockingStep(this.fenceTask);
        allSteps.add(fenceSteps);
        PanelDetails troutSteps = new PanelDetails("Fish a Trout", Collections.singletonList(this.trout), new SkillRequirement(Skill.FISHING, 20), this.flyRod, this.feathers);
        troutSteps.setDisplayCondition(this.notTrout);
        troutSteps.setLockingStep(this.troutTask);
        allSteps.add(troutSteps);
        PanelDetails bowlSteps = new PanelDetails("Spin a Bowl in Barbarian Village", Arrays.asList(this.potteryWheel, this.bowl), new SkillRequirement(Skill.CRAFTING, 8), this.softClay);
        bowlSteps.setDisplayCondition(this.notBowl);
        bowlSteps.setLockingStep(this.bowlTask);
        allSteps.add(bowlSteps);
        PanelDetails strongholdSecondFloorSteps = new PanelDetails("Stronghold Second Floor", Arrays.asList(this.moveToStronghold1, this.moveToStronghold2), this.food);
        strongholdSecondFloorSteps.setDisplayCondition(this.notStrongholdSecond);
        strongholdSecondFloorSteps.setLockingStep(this.strongholdSecondTask);
        allSteps.add(strongholdSecondFloorSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

