/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.morytania;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.MORYTANIA_ELITE)
public class MorytaniaElite
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement magicRedwoodPyreLogs;
    ItemRequirement shadeRemains;
    ItemRequirement tinderbox;
    ItemRequirement earthRune;
    ItemRequirement astralRune;
    ItemRequirement natureRune;
    ItemRequirement blackLeather;
    ItemRequirement needle;
    ItemRequirement thread;
    ItemRequirement barrowsSet;
    ItemRequirement ahrimSet;
    ItemRequirement karilSet;
    ItemRequirement guthanSet;
    ItemRequirement veracSet;
    ItemRequirement dharokSet;
    ItemRequirement toragSet;
    ItemRequirement food;
    ItemRequirement barrowsTab;
    ItemRequirement slayerRing;
    ItemRequirement ectophial;
    ItemRequirement mortTP;
    ItemRequirement spade;
    Requirement inAidOfTheMyreque;
    Requirement shadesOfMorton;
    Requirement lunarDiplomacy;
    Requirement lunarBook;
    Requirement bareHandBarb;
    Requirement notBareHandShark;
    Requirement notCremateShade;
    Requirement notFertilizeHerb;
    Requirement notCraftBlackDhideBody;
    Requirement notAbyssalDemon;
    Requirement notBarrowsChest;
    QuestStep claimReward;
    QuestStep bareHandShark;
    QuestStep fertilizeHerb;
    QuestStep craftBlackDhideBody;
    QuestStep abyssalDemon;
    QuestStep barrowsChest;
    QuestStep moveToCanifisBank;
    QuestStep moveToSlayer2;
    QuestStep moveToSlayer3;
    QuestStep moveToBarrows;
    ObjectStep cremateShade;
    Zone canifisBank;
    Zone slayer2;
    Zone slayer3;
    Zone barrows;
    ZoneRequirement inCanifisBank;
    ZoneRequirement inSlayer2;
    ZoneRequirement inSlayer3;
    ZoneRequirement inBarrows;
    ConditionalStep bareHandSharkTask;
    ConditionalStep cremateShadeTask;
    ConditionalStep fertilizeHerbTask;
    ConditionalStep craftBlackDhideBodyTask;
    ConditionalStep abyssalDemonTask;
    ConditionalStep barrowsChestTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doElite = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.bareHandSharkTask = new ConditionalStep((QuestHelper)this, this.bareHandShark, new Requirement[0]);
        doElite.addStep(this.notBareHandShark, this.bareHandSharkTask);
        this.cremateShadeTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.cremateShade, new Requirement[0]);
        doElite.addStep(this.notCremateShade, this.cremateShadeTask);
        this.barrowsChestTask = new ConditionalStep((QuestHelper)this, this.moveToBarrows, new Requirement[0]);
        this.barrowsChestTask.addStep(this.inBarrows, this.barrowsChest);
        doElite.addStep(this.notBarrowsChest, this.barrowsChestTask);
        this.abyssalDemonTask = new ConditionalStep((QuestHelper)this, this.moveToSlayer2, new Requirement[0]);
        this.abyssalDemonTask.addStep(this.inSlayer2, this.moveToSlayer3);
        this.abyssalDemonTask.addStep(this.inSlayer3, this.abyssalDemon);
        doElite.addStep(this.notAbyssalDemon, this.abyssalDemonTask);
        this.craftBlackDhideBodyTask = new ConditionalStep((QuestHelper)this, this.moveToCanifisBank, new Requirement[0]);
        this.craftBlackDhideBodyTask.addStep(this.inCanifisBank, this.craftBlackDhideBody);
        doElite.addStep(this.notCraftBlackDhideBody, this.craftBlackDhideBodyTask);
        this.fertilizeHerbTask = new ConditionalStep((QuestHelper)this, this.fertilizeHerb, new Requirement[0]);
        doElite.addStep(this.notFertilizeHerb, this.fertilizeHerbTask);
        return doElite;
    }

    @Override
    public void setupRequirements() {
        this.notBareHandShark = new VarplayerRequirement(1181, false, 3);
        this.notCremateShade = new VarplayerRequirement(1181, false, 4);
        this.notFertilizeHerb = new VarplayerRequirement(1181, false, 5);
        this.notCraftBlackDhideBody = new VarplayerRequirement(1181, false, 6);
        this.notAbyssalDemon = new VarplayerRequirement(1181, false, 7);
        this.notBarrowsChest = new VarplayerRequirement(1181, false, 8);
        this.magicRedwoodPyreLogs = new ItemRequirement("Magic / Redwood pyrelogs", ItemCollections.ELITE_PYRE_LOGS).showConditioned(this.notCremateShade);
        this.magicRedwoodPyreLogs.setTooltip("Can be created by using sacred oil on magic / redwood logs");
        this.shadeRemains = new ItemRequirement("Shade remains", ItemCollections.SHADE_REMAINS).showConditioned(this.notCremateShade);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).showConditioned(this.notCremateShade);
        this.earthRune = new ItemRequirement("Earth rune", 557).showConditioned(this.notFertilizeHerb);
        this.astralRune = new ItemRequirement("Astral rune", 9075).showConditioned(this.notFertilizeHerb);
        this.natureRune = new ItemRequirement("Nature rune", 561).showConditioned(this.notFertilizeHerb);
        this.blackLeather = new ItemRequirement("Black dragon leather", 2509).showConditioned(this.notCraftBlackDhideBody);
        this.needle = new ItemRequirement("Needle", 1733).showConditioned(this.notCraftBlackDhideBody);
        this.thread = new ItemRequirement("Thread", 1734).showConditioned(this.notCraftBlackDhideBody);
        this.ahrimSet = new ItemRequirements("Ahrim Set", new ItemRequirement("Hood", ItemCollections.AHRIM_HOOD), new ItemRequirement("Staff", ItemCollections.AHRIM_STAFF), new ItemRequirement("Top", ItemCollections.AHRIM_ROBETOP), new ItemRequirement("Skirt", ItemCollections.AHRIM_ROBESKIRT)).isNotConsumed();
        this.karilSet = new ItemRequirements("Karil Set", new ItemRequirement("Crossbow", ItemCollections.KARIL_CROSSBOW), new ItemRequirement("Coif", ItemCollections.KARIL_COIF), new ItemRequirement("Top", ItemCollections.KARIL_TOP), new ItemRequirement("Skirt", ItemCollections.KARIL_SKIRT)).isNotConsumed();
        this.guthanSet = new ItemRequirements("Guthan Set", new ItemRequirement("Helm", ItemCollections.GUTHAN_HELM), new ItemRequirement("Spear", ItemCollections.GUTHAN_WARSPEAR), new ItemRequirement("Body", ItemCollections.GUTHAN_BODY), new ItemRequirement("Skirt", ItemCollections.GUTHAN_SKIRT)).isNotConsumed();
        this.veracSet = new ItemRequirements("Verac Set", new ItemRequirement("Helm", ItemCollections.VERAC_HELM), new ItemRequirement("Flail", ItemCollections.VERAC_FLAIL), new ItemRequirement("Brassard", ItemCollections.VERAC_BRASSARD), new ItemRequirement("Skirt", ItemCollections.VERAC_SKIRT)).isNotConsumed();
        this.dharokSet = new ItemRequirements("Dharok Set", new ItemRequirement("Helm", ItemCollections.DHAROK_HELM), new ItemRequirement("Axe", ItemCollections.DHAROK_AXE), new ItemRequirement("Body", ItemCollections.DHAROK_BODY), new ItemRequirement("Legs", ItemCollections.DHAROK_LEGS)).isNotConsumed();
        this.toragSet = new ItemRequirements("Torag Set", new ItemRequirement("Helm", ItemCollections.TORAG_HELM), new ItemRequirement("Hammers", ItemCollections.TORAG_HAMMERS), new ItemRequirement("Body", ItemCollections.TORAG_BODY), new ItemRequirement("legs", ItemCollections.TORAG_LEGS)).isNotConsumed();
        this.barrowsSet = new ItemRequirements(LogicType.OR, "Any complete barrows set", this.ahrimSet, this.karilSet, this.guthanSet, this.veracSet, this.dharokSet, this.toragSet).showConditioned(this.notBarrowsChest).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.barrowsTab = new ItemRequirement("Barrows teleport", 19629);
        this.slayerRing = new ItemRequirement("Slayer ring", ItemCollections.SLAYER_RINGS);
        this.ectophial = new ItemRequirement("Ectophial", 4251).isNotConsumed();
        this.mortTP = new ItemRequirement("Mort'ton Teleport", 12406);
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notBarrowsChest).isNotConsumed();
        this.lunarBook = new SpellbookRequirement(Spellbook.LUNAR);
        this.inCanifisBank = new ZoneRequirement(this.canifisBank);
        this.inSlayer2 = new ZoneRequirement(this.slayer2);
        this.inSlayer3 = new ZoneRequirement(this.slayer3);
        this.inBarrows = new ZoneRequirement(this.barrows);
        this.inAidOfTheMyreque = new QuestRequirement(QuestHelperQuest.IN_AID_OF_THE_MYREQUE, QuestState.FINISHED);
        this.shadesOfMorton = new QuestRequirement(QuestHelperQuest.SHADES_OF_MORTTON, QuestState.FINISHED);
        this.lunarDiplomacy = new QuestRequirement(QuestHelperQuest.LUNAR_DIPLOMACY, QuestState.FINISHED);
        this.bareHandBarb = new ItemRequirement("Completed the Barbarian bare-handed fishing", 1, -1);
    }

    public void loadZones() {
        this.canifisBank = new Zone(new WorldPoint(3509, 3483, 0), new WorldPoint(3514, 3476, 0));
        this.slayer2 = new Zone(new WorldPoint(3404, 3580, 1), new WorldPoint(3453, 3530, 1));
        this.slayer3 = new Zone(new WorldPoint(3404, 3580, 2), new WorldPoint(3453, 3530, 2));
        this.barrows = new Zone(new WorldPoint(3521, 9724, 0), new WorldPoint(3581, 9665, 0));
    }

    public void setupSteps() {
        this.moveToBarrows = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3566, 3299, 0), "Dig at the top of the mounds and search the Sarcophagi until you find the hidden tunnel. A spade can be found in a shed at the entrance.", this.spade, this.barrowsSet, this.food);
        this.barrowsChest = new ObjectStep((QuestHelper)this, 20973, new WorldPoint(3552, 9696, 0), "Loot the chest wearing a complete set of barrows gear.", this.barrowsSet.equipped());
        this.cremateShade = new ObjectStep((QuestHelper)this, 4093, new WorldPoint(3500, 3266, 0), "Place the pyre logs and shade remains on the funeral pyre and light them with a tinderbox", this.tinderbox, this.shadeRemains, this.magicRedwoodPyreLogs);
        this.cremateShade.addAlternateObjects(28865, 4099);
        this.bareHandShark = new NpcStep((QuestHelper)this, 4476, new WorldPoint(3479, 3189, 0), "Bare hand fish a shark in Burgh de Rott.", new Requirement[0]);
        this.moveToSlayer2 = new ObjectStep((QuestHelper)this, 2114, new WorldPoint(3436, 3538, 0), "Climb the stairs or the Spikey chains in the Slayer tower to ascend to the higher level.", this.combatGear, this.food);
        this.moveToSlayer3 = new ObjectStep((QuestHelper)this, 2119, new WorldPoint(3415, 3541, 1), "Climb the stairs or the Spikey chains in the Slayer tower to ascend to the higher level.", this.combatGear, this.food);
        this.abyssalDemon = new NpcStep((QuestHelper)this, 415, new WorldPoint(3420, 3569, 2), "Kill an Abyssal demon.", this.combatGear, this.food);
        this.moveToCanifisBank = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3511, 3480, 0), "Move to the bank in Canifis.", this.blackLeather.quantity(3).highlighted(), this.needle.highlighted(), this.thread);
        this.craftBlackDhideBody = new DetailedQuestStep((QuestHelper)this, "Craft a black dragon hide body.", this.blackLeather.quantity(3).highlighted(), this.needle.highlighted(), this.thread);
        this.fertilizeHerb = new ObjectStep((QuestHelper)this, 8153, new WorldPoint(3606, 3530, 0), "Cast Fertile Soil on the herb patch in Morytania.", this.lunarBook, this.earthRune.quantity(15), this.astralRune.quantity(3), this.natureRune.quantity(2));
        this.fertilizeHerb.addIcon(553);
        this.claimReward = new NpcStep((QuestHelper)this, 5521, new WorldPoint(3464, 3480, 0), "Talk to Le-Sabre near Canifis to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.magicRedwoodPyreLogs, this.shadeRemains, this.tinderbox, this.barrowsSet, this.blackLeather.quantity(3), this.needle, this.thread, this.earthRune.quantity(15), this.astralRune.quantity(3), this.natureRune.quantity(2));
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.barrowsTab, this.slayerRing, this.ectophial, this.mortTP, this.spade);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.ATTACK, 70));
        reqs.add(new SkillRequirement(Skill.CRAFTING, 84, true));
        reqs.add(new SkillRequirement(Skill.DEFENCE, 70));
        reqs.add(new SkillRequirement(Skill.FIREMAKING, 80, true));
        reqs.add(new SkillRequirement(Skill.FISHING, 96, true));
        reqs.add(new SkillRequirement(Skill.MAGIC, 83, true));
        reqs.add(new SkillRequirement(Skill.RANGED, 70));
        reqs.add(new SkillRequirement(Skill.SLAYER, 85, true));
        reqs.add(new SkillRequirement(Skill.STRENGTH, 76));
        reqs.add(this.inAidOfTheMyreque);
        reqs.add(this.shadesOfMorton);
        reqs.add(this.lunarDiplomacy);
        reqs.add(this.bareHandBarb);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("One Abyssal Demon (lvl 124)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Morytania legs 4", 13115), new ItemReward("50,000 Exp. Lamp (Any skill over 30)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Unlimited teleports to the slime pit beneath the Ectofuntus from Morytania legs"), new UnlockReward("Robin offers 39 free buckets of slime and 39 pots of bonemeal in exchange for bones each day"), new UnlockReward("50% more Firemaking experience when burning shade remains"), new UnlockReward("Bones buried from the Bonecrusher grant full Prayer experience"), new UnlockReward("Access to the herb patch on Harmony Island"), new UnlockReward("10% more Slayer experience in the Slayer Tower while on a Slayer task"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails grabSharkSteps = new PanelDetails("Grab Shark", Collections.singletonList(this.bareHandShark), new SkillRequirement(Skill.FISHING, 96, true), new SkillRequirement(Skill.STRENGTH, 76), this.inAidOfTheMyreque, this.bareHandBarb);
        grabSharkSteps.setDisplayCondition(this.notBareHandShark);
        grabSharkSteps.setLockingStep(this.bareHandSharkTask);
        allSteps.add(grabSharkSteps);
        PanelDetails cremateSteps = new PanelDetails("Cremate Shade Remains", Collections.singletonList(this.cremateShade), new SkillRequirement(Skill.FIREMAKING, 80), this.shadesOfMorton, this.magicRedwoodPyreLogs, this.shadeRemains, this.tinderbox);
        cremateSteps.setDisplayCondition(this.notCremateShade);
        cremateSteps.setLockingStep(this.cremateShadeTask);
        allSteps.add(cremateSteps);
        PanelDetails barrowsSteps = new PanelDetails("Barrows Looting", Arrays.asList(this.moveToBarrows, this.barrowsChest), new SkillRequirement(Skill.DEFENCE, 70, false, "70 Defense and one of the following:"), new SkillRequirement(Skill.ATTACK, 70), new SkillRequirement(Skill.MAGIC, 70), new SkillRequirement(Skill.RANGED, 70), new SkillRequirement(Skill.STRENGTH, 70), this.barrowsSet);
        barrowsSteps.setDisplayCondition(this.notBarrowsChest);
        barrowsSteps.setLockingStep(this.barrowsChestTask);
        allSteps.add(barrowsSteps);
        PanelDetails abyssalDemonSteps = new PanelDetails("Kill Abyssal Demon", Arrays.asList(this.moveToSlayer2, this.moveToSlayer3, this.abyssalDemon), new SkillRequirement(Skill.SLAYER, 85, true), this.combatGear, this.food);
        abyssalDemonSteps.setDisplayCondition(this.notAbyssalDemon);
        abyssalDemonSteps.setLockingStep(this.abyssalDemonTask);
        allSteps.add(abyssalDemonSteps);
        PanelDetails craftSteps = new PanelDetails("Craft Black D'hide Body", Arrays.asList(this.moveToCanifisBank, this.craftBlackDhideBody), new SkillRequirement(Skill.CRAFTING, 84, true), this.blackLeather.quantity(3), this.needle, this.thread);
        craftSteps.setDisplayCondition(this.notCraftBlackDhideBody);
        craftSteps.setLockingStep(this.craftBlackDhideBodyTask);
        allSteps.add(craftSteps);
        PanelDetails fertSteps = new PanelDetails("Fertilize Herb Patch", Collections.singletonList(this.fertilizeHerb), new SkillRequirement(Skill.MAGIC, 83, true), this.lunarDiplomacy, this.lunarBook, this.earthRune.quantity(15), this.astralRune.quantity(3), this.natureRune.quantity(2));
        fertSteps.setDisplayCondition(this.notFertilizeHerb);
        fertSteps.setLockingStep(this.fertilizeHerbTask);
        allSteps.add(fertSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

