/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.morytania;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.CombatLevelRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.TileStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.MORYTANIA_EASY)
public class MorytaniaEasy
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement chisel;
    ItemRequirement snailShell;
    ItemRequirement thinSnail;
    ItemRequirement tannableHide;
    ItemRequirement coins;
    ItemRequirement scarecrow;
    ItemRequirement bonemeal;
    ItemRequirement bucketOfSlime;
    ItemRequirement wolfbane;
    ItemRequirement bones;
    ItemRequirement pot;
    ItemRequirement bucket;
    ItemRequirement haySack;
    ItemRequirement emptySack;
    ItemRequirement bronzeSpear;
    ItemRequirement watermelon;
    ItemRequirement sack;
    ItemRequirement scarecrowStep2;
    ItemRequirement food;
    ItemRequirement earProtection;
    ItemRequirement ectoToken;
    ItemRequirement ghostSpeak;
    ItemRequirement rake;
    ItemRequirements scarecrowItems;
    Requirement natureSpirit;
    Requirement ghostsAhoy;
    Requirement notCraftSnelm;
    Requirement notCookSnail;
    Requirement notKillBanshee;
    Requirement notSbottTan;
    Requirement notEnterSwamp;
    Requirement notKillGhoul;
    Requirement notPlaceScarecrow;
    Requirement notOfferBonemeal;
    Requirement notKillWerewolf;
    Requirement notRestorePrayer;
    Requirement notMazchna;
    QuestStep claimReward;
    QuestStep craftSnelm;
    QuestStep cookSnail;
    QuestStep killBanshee;
    QuestStep sbottTan;
    QuestStep enterSwamp;
    QuestStep killGhoul;
    QuestStep placeScarecrow;
    QuestStep killWerewolf;
    QuestStep restorePrayer;
    QuestStep mazchna;
    QuestStep moveToGrotto;
    QuestStep moveToBonemeal;
    QuestStep makeBonemeal;
    QuestStep getSlime;
    QuestStep useSackOnSpear;
    QuestStep useWatermelonOnSack;
    QuestStep fillSack;
    ObjectStep offerBonemeal;
    ObjectStep moveToSlime;
    Zone grotto;
    Zone bonezone;
    Zone slimezone;
    ZoneRequirement inGrotto;
    ZoneRequirement inBonezone;
    ZoneRequirement inSlimezone;
    ConditionalStep craftSnelmTask;
    ConditionalStep cookSnailTask;
    ConditionalStep killBansheeTask;
    ConditionalStep sbottTanTask;
    ConditionalStep enterSwampTask;
    ConditionalStep killGhoulTask;
    ConditionalStep placeScarecrowTask;
    ConditionalStep offerBonemealTask;
    ConditionalStep killWerewolfTask;
    ConditionalStep restorePrayerTask;
    ConditionalStep mazchnaTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doEasy = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.killGhoulTask = new ConditionalStep((QuestHelper)this, this.killGhoul, new Requirement[0]);
        doEasy.addStep(this.notKillGhoul, this.killGhoulTask);
        this.enterSwampTask = new ConditionalStep((QuestHelper)this, this.enterSwamp, new Requirement[0]);
        doEasy.addStep(this.notEnterSwamp, this.enterSwampTask);
        this.craftSnelmTask = new ConditionalStep((QuestHelper)this, this.craftSnelm, new Requirement[0]);
        doEasy.addStep(this.notCraftSnelm, this.craftSnelmTask);
        this.restorePrayerTask = new ConditionalStep((QuestHelper)this, this.moveToGrotto, new Requirement[0]);
        this.restorePrayerTask.addStep(this.inGrotto, this.restorePrayer);
        doEasy.addStep(this.notRestorePrayer, this.restorePrayerTask);
        this.killBansheeTask = new ConditionalStep((QuestHelper)this, this.killBanshee, new Requirement[0]);
        doEasy.addStep(this.notKillBanshee, this.killBansheeTask);
        this.sbottTanTask = new ConditionalStep((QuestHelper)this, this.sbottTan, new Requirement[0]);
        doEasy.addStep(this.notSbottTan, this.sbottTanTask);
        this.killWerewolfTask = new ConditionalStep((QuestHelper)this, this.killWerewolf, new Requirement[0]);
        doEasy.addStep(this.notKillWerewolf, this.killWerewolfTask);
        this.mazchnaTask = new ConditionalStep((QuestHelper)this, this.mazchna, new Requirement[0]);
        doEasy.addStep(this.notMazchna, this.mazchnaTask);
        this.placeScarecrowTask = new ConditionalStep((QuestHelper)this, this.fillSack, new Requirement[0]);
        this.placeScarecrowTask.addStep(this.haySack, this.useSackOnSpear);
        this.placeScarecrowTask.addStep(this.scarecrowStep2, this.useWatermelonOnSack);
        this.placeScarecrowTask.addStep(this.scarecrow, this.placeScarecrow);
        doEasy.addStep(this.notPlaceScarecrow, this.placeScarecrowTask);
        this.offerBonemealTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.moveToSlime, new Requirement[0]);
        this.offerBonemealTask.addStep(this.inSlimezone, this.getSlime);
        this.offerBonemealTask.addStep(this.bucketOfSlime, this.moveToBonemeal);
        this.offerBonemealTask.addStep(this.inBonezone, this.makeBonemeal);
        this.offerBonemealTask.addStep(new Conditions(this.bonemeal, this.bucketOfSlime), this.offerBonemeal);
        doEasy.addStep(this.notOfferBonemeal, this.offerBonemealTask);
        this.cookSnailTask = new ConditionalStep((QuestHelper)this, this.cookSnail, new Requirement[0]);
        doEasy.addStep(this.notCookSnail, this.cookSnailTask);
        return doEasy;
    }

    @Override
    public void setupRequirements() {
        this.notCraftSnelm = new VarplayerRequirement(1180, false, 1);
        this.notCookSnail = new VarplayerRequirement(1180, false, 2);
        this.notMazchna = new VarplayerRequirement(1180, false, 3);
        this.notKillBanshee = new VarplayerRequirement(1180, false, 4);
        this.notSbottTan = new VarplayerRequirement(1180, false, 5);
        this.notEnterSwamp = new VarplayerRequirement(1180, false, 6);
        this.notKillGhoul = new VarplayerRequirement(1180, false, 7);
        this.notPlaceScarecrow = new VarplayerRequirement(1180, false, 8);
        this.notOfferBonemeal = new VarplayerRequirement(1180, false, 9);
        this.notKillWerewolf = new VarplayerRequirement(1180, false, 10);
        this.notRestorePrayer = new VarplayerRequirement(1180, false, 11);
        this.chisel = new ItemRequirement("Chisel", 1755).showConditioned(this.notCraftSnelm).isNotConsumed();
        this.snailShell = new ItemRequirement("Blamish snail shell", ItemCollections.SNAIL_SHELLS).showConditioned(this.notCraftSnelm);
        this.thinSnail = new ItemRequirement("Thin snail", 3363).showConditioned(this.notCookSnail);
        this.tannableHide = new ItemRequirement("Tannable hide", ItemCollections.TANNABLE_HIDE).showConditioned(this.notSbottTan);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(this.notSbottTan);
        this.scarecrow = new ItemRequirement("Scarecrow", 6059).showConditioned(this.notPlaceScarecrow);
        this.haySack = new ItemRequirement("Hay Sack", 6057);
        this.bronzeSpear = new ItemRequirement("Bronze Spear", 1237);
        this.watermelon = new ItemRequirement("Watermelon", 5982);
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(this.notPlaceScarecrow).isNotConsumed();
        this.emptySack = new ItemRequirement("Empty Sack", 5418);
        this.sack = new ItemRequirements(LogicType.OR, this.emptySack, this.haySack);
        this.scarecrowItems = new ItemRequirements(LogicType.OR, "1 x Scarecrow", this.scarecrow, new ItemRequirements(this.sack, this.watermelon, this.bronzeSpear));
        this.scarecrowItems.setTooltip("Created by combining a bronze spear, watermelon, and hay sack (empty sack filled at a hay bale, nearest is North-West of Lumbridge)");
        this.scarecrowStep2 = new ItemRequirement("Hay Sack", 6058);
        this.bonemeal = new ItemRequirement("Bonemeal", ItemCollections.BONEMEAL).showConditioned(this.notOfferBonemeal);
        this.bucketOfSlime = new ItemRequirement("Bucket of slime", 4286).showConditioned(this.notOfferBonemeal);
        this.wolfbane = new ItemRequirement("Wolfbane dagger", 2952).showConditioned(this.notKillWerewolf).isNotConsumed();
        this.bones = new ItemRequirement("Bones", ItemCollections.BONES).showConditioned(this.notOfferBonemeal);
        this.pot = new ItemRequirement("Pot", 1931).showConditioned(this.notOfferBonemeal);
        this.bucket = new ItemRequirement("Bucket", 1925).showConditioned(this.notOfferBonemeal);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.earProtection = new ItemRequirement("Ear protection", ItemCollections.EAR_PROTECTION).showConditioned(this.notKillBanshee).isNotConsumed();
        this.ectoToken = new ItemRequirement("Ecto-Token", 4278).showConditioned(this.notCookSnail);
        this.ghostSpeak = new ItemRequirement("Ghostspeak amulet", 552).showConditioned(this.notCookSnail).isNotConsumed();
        this.inGrotto = new ZoneRequirement(this.grotto);
        this.inBonezone = new ZoneRequirement(this.bonezone);
        this.inSlimezone = new ZoneRequirement(this.slimezone);
        this.natureSpirit = new QuestRequirement(QuestHelperQuest.NATURE_SPIRIT, QuestState.FINISHED);
        this.ghostsAhoy = new QuestRequirement(QuestHelperQuest.GHOSTS_AHOY, QuestState.IN_PROGRESS);
    }

    public void loadZones() {
        this.grotto = new Zone(new WorldPoint(3434, 9746, 0), new WorldPoint(3449, 9731, 1));
        this.bonezone = new Zone(new WorldPoint(3650, 3528, 1), new WorldPoint(3669, 3511, 1));
        this.slimezone = new Zone(new WorldPoint(3666, 9905, 0), new WorldPoint(3695, 9868, 3));
    }

    public void setupSteps() {
        this.killGhoul = new NpcStep((QuestHelper)this, 289, new WorldPoint(3434, 3461, 0), "Kill a ghoul in Morytania.", this.combatGear);
        this.enterSwamp = new ObjectStep((QuestHelper)this, 3507, new WorldPoint(3443, 3458, 0), "Enter the Mort Myre Swamp.", new Requirement[0]);
        this.craftSnelm = new ItemStep((QuestHelper)this, "Craft a snelm in Morytania. Note: Do not be in the swamp when completing this task", this.chisel.highlighted(), this.snailShell.highlighted());
        this.moveToGrotto = new ObjectStep((QuestHelper)this, 3516, new WorldPoint(3440, 3337, 0), "Enter the grotto tree in Mort Myre Swamp.", new Requirement[0]);
        this.restorePrayer = new ObjectStep((QuestHelper)this, 3521, new WorldPoint(3442, 9741, 1), "Pray at the altar.", new Requirement[0]);
        this.killBanshee = new NpcStep((QuestHelper)this, 414, new WorldPoint(3436, 3550, 0), "Kill a banshee.", true, this.earProtection.equipped(), this.combatGear);
        this.killWerewolf = new NpcStep((QuestHelper)this, 2631, new WorldPoint(3501, 3488, 0), "Kill any attackable NPC in Canifis with the wolfbane dagger.", this.wolfbane.equipped());
        this.mazchna = new NpcStep((QuestHelper)this, 402, new WorldPoint(3513, 3510, 0), "Get a slayer task from Mazchna.", new Requirement[0]);
        this.sbottTan = new NpcStep((QuestHelper)this, 6526, new WorldPoint(3490, 3501, 0), "Tan a hide using Sbott's services.", this.tannableHide, this.coins.quantity(45));
        this.fillSack = new ObjectStep((QuestHelper)this, 8713, new WorldPoint(3019, 3297, 0), "Use the empty sack on the hay bale to fill it, you can buy an empty sack from Sarah for 1gp.", new Requirement[0]);
        this.fillSack.addIcon(5418);
        this.useSackOnSpear = new DetailedQuestStep((QuestHelper)this, "Use the Hay sack on the Bronze Spear.", this.haySack.highlighted(), this.bronzeSpear.highlighted());
        this.useWatermelonOnSack = new DetailedQuestStep((QuestHelper)this, "Use the watermelon on the Hay Sack to make the Scarecrow.", this.scarecrowStep2.highlighted(), this.watermelon.highlighted());
        this.placeScarecrow = new ObjectStep((QuestHelper)this, 7850, new WorldPoint(3602, 3526, 0), "Place a scarecrow at the Morytania flower patch, West of Port Phasmatys.", this.scarecrow.highlighted());
        this.placeScarecrow.addIcon(6059);
        this.moveToBonemeal = new ObjectStep((QuestHelper)this, 16646, new WorldPoint(3667, 3520, 0), "Head upstairs above the ectofuntus to grind some bones into bonemeal.", this.bones, this.pot);
        this.moveToSlime = new ObjectStep((QuestHelper)this, 16114, new WorldPoint(3653, 3519, 0), "Head downstairs at the ectofuntus to gather some slime.", this.bucket);
        this.moveToSlime.addAlternateObjects(16113);
        this.getSlime = new TileStep((QuestHelper)this, new WorldPoint(3682, 9888, 0), "Keep heading down and use your bucket on the slime. Afterwards head back up.", this.bucket);
        this.getSlime.addIcon(1925);
        this.makeBonemeal = new ObjectStep((QuestHelper)this, 16654, new WorldPoint(3660, 3526, 1), "Use your bones on the loader and grind them to make bonemeal. Afterwards head back down.", this.bones, this.pot);
        this.offerBonemeal = new ObjectStep((QuestHelper)this, 16648, new WorldPoint(3660, 3520, 0), "Worship the ectofuntus.", this.bonemeal, this.bucketOfSlime);
        this.offerBonemeal.addAlternateObjects(16649);
        this.cookSnail = new ObjectStep((QuestHelper)this, 16641, new WorldPoint(3676, 3468, 0), "Cook a thin snail in Port Phasmatys.", this.thinSnail);
        this.claimReward = new NpcStep((QuestHelper)this, 5521, new WorldPoint(3464, 3480, 0), "Talk to Le-Sabre near Canifis to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.chisel, this.snailShell, this.thinSnail, this.tannableHide, this.coins.quantity(45), this.scarecrowItems, this.rake, this.bonemeal, this.bucketOfSlime, this.wolfbane, this.bones, this.pot, this.bucket, this.earProtection);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.ghostSpeak, this.ectoToken.quantity(2));
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new CombatLevelRequirement(20));
        reqs.add(new SkillRequirement(Skill.COOKING, 12));
        reqs.add(new SkillRequirement(Skill.CRAFTING, 15));
        reqs.add(new SkillRequirement(Skill.FARMING, 23));
        reqs.add(new SkillRequirement(Skill.SLAYER, 15));
        reqs.add(this.ghostsAhoy);
        reqs.add(this.natureSpirit);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Ghoul (lvl 42)", "Banshee (lvl 23)", "Werewolf in human form (lvl 24)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Morytania legs 1", 13112), new ItemReward("2,500 Exp. Lamp (Any skill over 30)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("2 daily teleports to the Slime Pit beneath the Ectofuntus from Morytania legs"), new UnlockReward("50% chance of a ghast ignoring you rather than attacking"), new UnlockReward("2.5% more Slayer experience in the Slayer Tower while on a Slayer task"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails killGhoulSteps = new PanelDetails("Kill Ghoul", Collections.singletonList(this.killGhoul), this.combatGear, this.food);
        killGhoulSteps.setDisplayCondition(this.notKillGhoul);
        killGhoulSteps.setLockingStep(this.killGhoulTask);
        allSteps.add(killGhoulSteps);
        PanelDetails enterSwampSteps = new PanelDetails("Enter Mort Myre Swamp", Collections.singletonList(this.enterSwamp), new Requirement[0]);
        enterSwampSteps.setDisplayCondition(this.notEnterSwamp);
        enterSwampSteps.setLockingStep(this.enterSwampTask);
        allSteps.add(enterSwampSteps);
        PanelDetails craftSnelmSteps = new PanelDetails("Craft Snelm", Collections.singletonList(this.craftSnelm), new SkillRequirement(Skill.CRAFTING, 15), this.snailShell, this.chisel);
        craftSnelmSteps.setDisplayCondition(this.notCraftSnelm);
        craftSnelmSteps.setLockingStep(this.craftSnelmTask);
        allSteps.add(craftSnelmSteps);
        PanelDetails restorePrayerSteps = new PanelDetails("Restore Prayer", Arrays.asList(this.moveToGrotto, this.restorePrayer), this.natureSpirit);
        restorePrayerSteps.setDisplayCondition(this.notRestorePrayer);
        restorePrayerSteps.setLockingStep(this.restorePrayerTask);
        allSteps.add(restorePrayerSteps);
        PanelDetails killBansheeSteps = new PanelDetails("Kill Banshee", Collections.singletonList(this.killBanshee), new SkillRequirement(Skill.SLAYER, 15), this.combatGear, this.food, this.earProtection);
        killBansheeSteps.setDisplayCondition(this.notKillBanshee);
        killBansheeSteps.setLockingStep(this.killBansheeTask);
        allSteps.add(killBansheeSteps);
        PanelDetails sbottTanningHideSteps = new PanelDetails("Sbott Tanning Hide", Collections.singletonList(this.sbottTan), this.tannableHide, this.coins.quantity(45));
        sbottTanningHideSteps.setDisplayCondition(this.notSbottTan);
        sbottTanningHideSteps.setLockingStep(this.sbottTanTask);
        allSteps.add(sbottTanningHideSteps);
        PanelDetails werewolfSteps = new PanelDetails("Kill Werewolf in Human Form", Collections.singletonList(this.killWerewolf), this.wolfbane, this.combatGear, this.food);
        werewolfSteps.setDisplayCondition(this.notKillWerewolf);
        werewolfSteps.setLockingStep(this.killWerewolfTask);
        allSteps.add(werewolfSteps);
        PanelDetails mazchnaSteps = new PanelDetails("Mazchna Slayer Task", Collections.singletonList(this.mazchna), new CombatLevelRequirement(20));
        mazchnaSteps.setDisplayCondition(this.notMazchna);
        mazchnaSteps.setLockingStep(this.mazchnaTask);
        allSteps.add(mazchnaSteps);
        PanelDetails placeScarecrowSteps = new PanelDetails("Place Scarecrow", Arrays.asList(this.fillSack, this.useSackOnSpear, this.useWatermelonOnSack, this.placeScarecrow), new SkillRequirement(Skill.FARMING, 23), this.scarecrowItems, this.rake);
        placeScarecrowSteps.setDisplayCondition(this.notPlaceScarecrow);
        placeScarecrowSteps.setLockingStep(this.placeScarecrowTask);
        allSteps.add(placeScarecrowSteps);
        PanelDetails offerBonemealSteps = new PanelDetails("Offer Bonemeal", Arrays.asList(this.moveToSlime, this.getSlime, this.moveToBonemeal, this.makeBonemeal, this.offerBonemeal), this.bones, this.pot, this.bucket);
        offerBonemealSteps.setDisplayCondition(this.notOfferBonemeal);
        offerBonemealSteps.setLockingStep(this.offerBonemealTask);
        allSteps.add(offerBonemealSteps);
        PanelDetails cookSnailSteps = new PanelDetails("Cook Thin Snail", Collections.singletonList(this.cookSnail), new SkillRequirement(Skill.COOKING, 12), this.thinSnail);
        cookSnailSteps.setDisplayCondition(this.notCookSnail);
        cookSnailSteps.setLockingStep(this.cookSnailTask);
        allSteps.add(cookSnailSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

