/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.lumbridgeanddraynor;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.CombatLevelRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.TileStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.LUMBRIDGE_MEDIUM)
public class LumbridgeMedium
extends ComplexStateQuestHelper {
    ItemRequirement crossbow;
    ItemRequirement mithGrap;
    ItemRequirement steelArrows;
    ItemRequirement avasAttractor;
    ItemRequirement coins;
    ItemRequirement fairyAccess;
    ItemRequirement earthRune;
    ItemRequirement airRune;
    ItemRequirement lawRune;
    ItemRequirement earthTali;
    ItemRequirement fireAccess;
    ItemRequirement flyFishingRod;
    ItemRequirement feathers;
    ItemRequirement leather;
    ItemRequirement needle;
    ItemRequirement thread;
    ItemRequirement axe;
    ItemRequirement butterflyNet;
    ItemRequirement implingJar;
    ItemRequirement essence;
    ItemRequirement bindingNeck;
    ItemRequirements avasAccumulator;
    Requirement animalMagnetism;
    Requirement fairyTaleII;
    Requirement lostCity;
    Requirement notAlKharidRooftop;
    Requirement notGrappleLum;
    Requirement notUpgradeDevice;
    Requirement notWizardFairy;
    Requirement notTPlumb;
    Requirement notCatchSalmon;
    Requirement notCraftCoif;
    Requirement notChopWillow;
    Requirement notPickGardener;
    Requirement notChaeldarTask;
    Requirement notPuroImp;
    Requirement notCraftLava;
    QuestStep claimReward;
    QuestStep moveToCowPen;
    QuestStep moveToZanarisChaeldar;
    QuestStep moveToZanarisPuro;
    QuestStep moveToPuro;
    QuestStep moveToLavaAltar;
    QuestStep alKharidRooftop;
    QuestStep grappleLum;
    QuestStep upgradeDevice;
    QuestStep wizardFairy;
    QuestStep tpLumb;
    QuestStep catchSalmon;
    QuestStep craftCoif;
    QuestStep chopWillow;
    QuestStep pickGardener;
    QuestStep chaeldarTask;
    QuestStep craftLava;
    NpcStep puroImp;
    Zone puroPuro;
    Zone cowPen;
    Zone zanaris;
    Zone lavaAltar;
    ZoneRequirement inPuroPuro;
    ZoneRequirement inCowPen;
    ZoneRequirement inZanaris;
    ZoneRequirement inLavaAltar;
    ConditionalStep alKharidRooftopTask;
    ConditionalStep grappleLumTask;
    ConditionalStep upgradeDeviceTask;
    ConditionalStep wizardFairyTask;
    ConditionalStep tplumbTask;
    ConditionalStep catchSalmonTask;
    ConditionalStep craftCoifTask;
    ConditionalStep chopWillowTask;
    ConditionalStep pickGardenerTask;
    ConditionalStep chaeldarTaskTask;
    ConditionalStep puroImpTask;
    ConditionalStep craftLavaTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doMedium = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.chaeldarTaskTask = new ConditionalStep((QuestHelper)this, this.moveToZanarisChaeldar, new Requirement[0]);
        this.chaeldarTaskTask.addStep(this.inZanaris, this.chaeldarTask);
        doMedium.addStep(this.notChaeldarTask, this.chaeldarTaskTask);
        this.puroImpTask = new ConditionalStep((QuestHelper)this, this.moveToZanarisPuro, new Requirement[0]);
        this.puroImpTask.addStep(this.inZanaris, this.moveToPuro);
        this.puroImpTask.addStep(this.inPuroPuro, this.puroImp);
        doMedium.addStep(this.notPuroImp, this.puroImpTask);
        this.wizardFairyTask = new ConditionalStep((QuestHelper)this, this.wizardFairy, new Requirement[0]);
        doMedium.addStep(this.notWizardFairy, this.wizardFairyTask);
        this.chopWillowTask = new ConditionalStep((QuestHelper)this, this.chopWillow, new Requirement[0]);
        doMedium.addStep(this.notChopWillow, this.chopWillowTask);
        this.pickGardenerTask = new ConditionalStep((QuestHelper)this, this.pickGardener, new Requirement[0]);
        doMedium.addStep(this.notPickGardener, this.pickGardenerTask);
        this.upgradeDeviceTask = new ConditionalStep((QuestHelper)this, this.upgradeDevice, new Requirement[0]);
        doMedium.addStep(this.notUpgradeDevice, this.upgradeDeviceTask);
        this.tplumbTask = new ConditionalStep((QuestHelper)this, this.tpLumb, new Requirement[0]);
        doMedium.addStep(this.notTPlumb, this.tplumbTask);
        this.catchSalmonTask = new ConditionalStep((QuestHelper)this, this.catchSalmon, new Requirement[0]);
        doMedium.addStep(this.notCatchSalmon, this.catchSalmonTask);
        this.craftCoifTask = new ConditionalStep((QuestHelper)this, this.moveToCowPen, new Requirement[0]);
        this.craftCoifTask.addStep(this.inCowPen, this.craftCoif);
        doMedium.addStep(this.notCraftCoif, this.craftCoifTask);
        this.alKharidRooftopTask = new ConditionalStep((QuestHelper)this, this.alKharidRooftop, new Requirement[0]);
        doMedium.addStep(this.notAlKharidRooftop, this.alKharidRooftopTask);
        this.grappleLumTask = new ConditionalStep((QuestHelper)this, this.grappleLum, new Requirement[0]);
        doMedium.addStep(this.notGrappleLum, this.grappleLumTask);
        this.craftLavaTask = new ConditionalStep((QuestHelper)this, this.moveToLavaAltar, new Requirement[0]);
        this.craftLavaTask.addStep(this.inLavaAltar, this.craftLava);
        doMedium.addStep(this.notCraftLava, this.craftLavaTask);
        return doMedium;
    }

    @Override
    public void setupRequirements() {
        this.notAlKharidRooftop = new VarplayerRequirement(1194, false, 13);
        this.notGrappleLum = new VarplayerRequirement(1194, false, 14);
        this.notUpgradeDevice = new VarplayerRequirement(1194, false, 15);
        this.notWizardFairy = new VarplayerRequirement(1194, false, 16);
        this.notTPlumb = new VarplayerRequirement(1194, false, 17);
        this.notCatchSalmon = new VarplayerRequirement(1194, false, 18);
        this.notCraftCoif = new VarplayerRequirement(1194, false, 19);
        this.notChopWillow = new VarplayerRequirement(1194, false, 20);
        this.notPickGardener = new VarplayerRequirement(1194, false, 21);
        this.notChaeldarTask = new VarplayerRequirement(1194, false, 22);
        this.notPuroImp = new VarplayerRequirement(1194, false, 23);
        this.notCraftLava = new VarplayerRequirement(1194, false, 24);
        this.crossbow = new ItemRequirement("A crossbow", ItemCollections.CROSSBOWS).showConditioned(this.notGrappleLum).isNotConsumed();
        this.mithGrap = new ItemRequirement("Mith grapple", 9419).showConditioned(this.notGrappleLum).isNotConsumed();
        this.earthTali = new ItemRequirement("Earth talisman", 1440).showConditioned(this.notCraftLava);
        this.fireAccess = new ItemRequirement("Access to fire altar", ItemCollections.FIRE_ALTAR).showConditioned(this.notCraftLava).isNotConsumed();
        this.fireAccess.setTooltip("Fire talisman or tiara");
        this.earthRune = new ItemRequirement("Earth rune", 557).showConditioned(new Conditions(LogicType.OR, this.notCraftLava, this.notTPlumb));
        this.essence = new ItemRequirement("Pure essence", ItemCollections.ESSENCE_HIGH).showConditioned(this.notCraftLava);
        this.bindingNeck = new ItemRequirement("Binding necklace", 5521).showConditioned(this.notCraftLava);
        this.feathers = new ItemRequirement("Feathers", 314).showConditioned(this.notCatchSalmon);
        this.flyFishingRod = new ItemRequirement("Fly fishing rod", 309).showConditioned(this.notCatchSalmon).isNotConsumed();
        this.needle = new ItemRequirement("Needle", 1733).showConditioned(this.notCraftCoif).isNotConsumed();
        this.thread = new ItemRequirement("Thread", 1734).showConditioned(this.notCraftCoif).isNotConsumed();
        this.leather = new ItemRequirement("Leather", 1741).showConditioned(this.notCraftCoif);
        this.lawRune = new ItemRequirement("Law rune", 563).showConditioned(this.notTPlumb);
        this.airRune = new ItemRequirement("Air rune", 556).showConditioned(this.notTPlumb);
        this.steelArrows = new ItemRequirement("Steel arrows", 886).showConditioned(this.notUpgradeDevice);
        this.coins = new ItemRequirement("999 Coins", ItemCollections.COINS).showConditioned(this.notUpgradeDevice);
        this.avasAttractor = new ItemRequirement("Ava's Attractor", 10498).showConditioned(this.notUpgradeDevice);
        this.avasAccumulator = new ItemRequirements(LogicType.OR, "999 Coins or Ava's Attractor", this.coins.quantity(999), this.avasAttractor);
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(this.notChopWillow).isNotConsumed();
        this.fairyAccess = new ItemRequirement("Lunar or Dramen staff", ItemCollections.FAIRY_STAFF).showConditioned(new Conditions(LogicType.OR, this.notChaeldarTask, this.notPuroImp, this.notWizardFairy)).isNotConsumed();
        this.butterflyNet = new ItemRequirement("Butterfly net", 10010).showConditioned(this.notPuroImp).isNotConsumed();
        this.implingJar = new ItemRequirement("Impling jar", 11260).showConditioned(this.notPuroImp).isNotConsumed();
        this.inLavaAltar = new ZoneRequirement(this.lavaAltar);
        this.inPuroPuro = new ZoneRequirement(this.puroPuro);
        this.inCowPen = new ZoneRequirement(this.cowPen);
        this.inZanaris = new ZoneRequirement(this.zanaris);
        this.fairyTaleII = new VarbitRequirement(QuestVarbits.QUEST_FAIRYTALE_II_CURE_A_QUEEN.getId(), Operation.GREATER_EQUAL, 40, "Partial completion of Fairytale II for access to fairy rings");
        this.animalMagnetism = new QuestRequirement(QuestHelperQuest.ANIMAL_MAGNETISM, QuestState.FINISHED);
        this.lostCity = new QuestRequirement(QuestHelperQuest.LOST_CITY, QuestState.FINISHED);
    }

    public void loadZones() {
        this.lavaAltar = new Zone(new WorldPoint(2553, 4863, 0), new WorldPoint(2623, 4802, 0));
        this.puroPuro = new Zone(new WorldPoint(2561, 4350, 0), new WorldPoint(2623, 4289, 0));
        this.cowPen = new Zone(new WorldPoint(3253, 3298, 0), new WorldPoint(3265, 3255, 0));
        this.zanaris = new Zone(new WorldPoint(2369, 4481, 0), new WorldPoint(2497, 4352, 0));
    }

    public void setupSteps() {
        this.alKharidRooftop = new ObjectStep((QuestHelper)this, 11633, new WorldPoint(3273, 3195, 0), "Complete the Al Kharid Rooftop Course.", new Requirement[0]);
        this.grappleLum = new ObjectStep((QuestHelper)this, 17068, new WorldPoint(3252, 3179, 0), "Grapple across the River Lum.", this.mithGrap.equipped(), this.crossbow.equipped());
        this.moveToLavaAltar = new ObjectStep((QuestHelper)this, 34817, new WorldPoint(3313, 3255, 0), "Enter the fire altar north of Al Kharid.", this.fireAccess);
        this.craftLava = new ObjectStep((QuestHelper)this, 34764, new WorldPoint(2585, 4838, 0), "Use an earth talisman on the fire altar.", this.earthTali.highlighted(), this.essence, this.earthRune);
        this.craftLava.addIcon(1440);
        this.catchSalmon = new NpcStep((QuestHelper)this, 1527, new WorldPoint(3241, 3248, 0), "Catch a salmon in the River Lum.", this.feathers.quantity(10), this.flyFishingRod);
        this.moveToCowPen = new TileStep((QuestHelper)this, new WorldPoint(3257, 3267, 0), "Enter the cow pen in Lumbridge.", this.thread, this.needle, this.leather);
        this.craftCoif = new ItemStep((QuestHelper)this, "Craft a coif.", this.thread, this.needle.highlighted(), this.leather.highlighted());
        this.tpLumb = new DetailedQuestStep((QuestHelper)this, "Cast the Teleport to Lumbridge spell.", this.airRune.quantity(3), this.earthRune.quantity(1), this.lawRune.quantity(1));
        this.upgradeDevice = new NpcStep((QuestHelper)this, 4407, new WorldPoint(3093, 3357, 0), "Buy an Ava's Accumulator from Ava in the Draynor Manor.", this.avasAccumulator, this.steelArrows.quantity(75));
        this.pickGardener = new NpcStep((QuestHelper)this, 5832, new WorldPoint(3077, 3263, 0), "Pickpocket Martin the Master Gardener in Draynor Village.", new Requirement[0]);
        this.chopWillow = new ObjectStep((QuestHelper)this, 10819, new WorldPoint(3089, 3235, 0), "Chop some Willow logs in Draynor Village.", this.axe);
        this.moveToZanarisChaeldar = new ObjectStep((QuestHelper)this, 2406, new WorldPoint(3202, 3169, 0), "Go to Zanaris through the shed in Lumbridge swamp or any fairy ring in the world if you've partially completed Fairytale II.", this.fairyAccess.equipped());
        this.chaeldarTask = new NpcStep((QuestHelper)this, 404, new WorldPoint(2446, 4430, 0), "Get a slayer task from Chaeldar in Zanaris.", new Requirement[0]);
        this.moveToZanarisPuro = new ObjectStep((QuestHelper)this, 2406, new WorldPoint(3202, 3169, 0), "Go to Zanaris through the shed in Lumbridge swamp or any fairy ring in the world if you've partially completed Fairytale II.", this.fairyAccess.equipped(), this.butterflyNet, this.implingJar);
        this.moveToPuro = new ObjectStep((QuestHelper)this, 24991, new WorldPoint(2427, 4446, 0), "Enter the centre of the crop circle in Zanaris.", new Requirement[0]);
        this.puroImp = new NpcStep((QuestHelper)this, 1639, new WorldPoint(2592, 4322, 0), "Catch an essence or eclectic impling in Puro-Puro.", true, this.butterflyNet, this.implingJar);
        this.puroImp.addAlternateNpcs(1649, 1640, 1650);
        this.wizardFairy = new ObjectStep((QuestHelper)this, 29560, new WorldPoint(2412, 4434, 0), "Take the nearest fairy ring and travel to the Wizards' Tower (DIS).", this.fairyAccess.equipped());
        this.claimReward = new NpcStep((QuestHelper)this, 5523, new WorldPoint(3235, 3213, 0), "Talk to Hatius Cosaintus in Lumbridge to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.crossbow, this.mithGrap, this.earthTali, this.fireAccess, this.earthRune.quantity(2), this.essence, this.feathers.quantity(10), this.flyFishingRod, this.needle, this.thread, this.leather, this.lawRune.quantity(1), this.airRune.quantity(3), this.steelArrows.quantity(75), this.avasAccumulator, this.axe, this.fairyAccess, this.butterflyNet, this.implingJar);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.bindingNeck);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new CombatLevelRequirement(70));
        reqs.add(new SkillRequirement(Skill.AGILITY, 20));
        reqs.add(new SkillRequirement(Skill.CRAFTING, 38));
        reqs.add(new SkillRequirement(Skill.FISHING, 30));
        reqs.add(new SkillRequirement(Skill.HUNTER, 42));
        reqs.add(new SkillRequirement(Skill.MAGIC, 31));
        reqs.add(new SkillRequirement(Skill.RANGED, 50));
        reqs.add(new SkillRequirement(Skill.RUNECRAFT, 23));
        reqs.add(new SkillRequirement(Skill.STRENGTH, 19));
        reqs.add(new SkillRequirement(Skill.THIEVING, 38));
        reqs.add(new SkillRequirement(Skill.WOODCUTTING, 30));
        reqs.add(this.fairyTaleII);
        reqs.add(this.animalMagnetism);
        return reqs;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Explorer's ring 2", 13126), new ItemReward("7,500 Exp. Lamp (Any skill over 40)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("50% run energy replenish 3 times a day from Explorer's ring"), new UnlockReward("Three daily teleports to cabbage patch near Falador farm for Explorer's ring"), new UnlockReward("Access to Draynor Village wall shortcut"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails chaeldarSteps = new PanelDetails("Slayer Task from Chaeldar", Arrays.asList(this.moveToZanarisChaeldar, this.chaeldarTask), new CombatLevelRequirement(70), this.fairyAccess);
        chaeldarSteps.setDisplayCondition(this.notChaeldarTask);
        chaeldarSteps.setLockingStep(this.chaeldarTaskTask);
        allSteps.add(chaeldarSteps);
        PanelDetails puroImpSteps = new PanelDetails("Catch Essence or Eclectic Imp", Arrays.asList(this.moveToZanarisPuro, this.moveToPuro, this.puroImp), new SkillRequirement(Skill.HUNTER, 42), this.lostCity, this.fairyAccess, this.butterflyNet, this.implingJar);
        puroImpSteps.setDisplayCondition(this.notPuroImp);
        puroImpSteps.setLockingStep(this.puroImpTask);
        allSteps.add(puroImpSteps);
        PanelDetails wizardsTowerSteps = new PanelDetails("Travel to Wizards' Tower by Fairy Ring", Collections.singletonList(this.wizardFairy), this.fairyTaleII, this.fairyAccess);
        wizardsTowerSteps.setDisplayCondition(this.notWizardFairy);
        wizardsTowerSteps.setLockingStep(this.wizardFairyTask);
        allSteps.add(wizardsTowerSteps);
        PanelDetails chopWillowSteps = new PanelDetails("Chop Willow", Collections.singletonList(this.chopWillow), new SkillRequirement(Skill.WOODCUTTING, 30), this.axe);
        chopWillowSteps.setDisplayCondition(this.notChopWillow);
        chopWillowSteps.setLockingStep(this.chopWillowTask);
        allSteps.add(chopWillowSteps);
        PanelDetails pickpocketMasterGardenerSteps = new PanelDetails("Pickpocket Master Gardener", Collections.singletonList(this.pickGardener), new SkillRequirement(Skill.THIEVING, 38));
        pickpocketMasterGardenerSteps.setDisplayCondition(this.notPickGardener);
        pickpocketMasterGardenerSteps.setLockingStep(this.pickGardenerTask);
        allSteps.add(pickpocketMasterGardenerSteps);
        PanelDetails upgradeSteps = new PanelDetails("Ava's Accumulator", Collections.singletonList(this.upgradeDevice), new SkillRequirement(Skill.RANGED, 50), this.animalMagnetism, this.avasAccumulator, this.steelArrows.quantity(75));
        upgradeSteps.setDisplayCondition(this.notUpgradeDevice);
        upgradeSteps.setLockingStep(this.upgradeDeviceTask);
        allSteps.add(upgradeSteps);
        PanelDetails tpLumbSteps = new PanelDetails("Teleport to Lumbridge", Collections.singletonList(this.tpLumb), this.airRune, this.earthRune, this.lawRune);
        tpLumbSteps.setDisplayCondition(this.notTPlumb);
        tpLumbSteps.setLockingStep(this.tplumbTask);
        allSteps.add(tpLumbSteps);
        PanelDetails catchSalmonSteps = new PanelDetails("Catch Salmon", Collections.singletonList(this.catchSalmon), new SkillRequirement(Skill.FISHING, 30), this.feathers, this.flyFishingRod);
        catchSalmonSteps.setDisplayCondition(this.notCatchSalmon);
        catchSalmonSteps.setLockingStep(this.catchSalmonTask);
        allSteps.add(catchSalmonSteps);
        PanelDetails craftACoifSteps = new PanelDetails("Craft a coif", Arrays.asList(this.moveToCowPen, this.craftCoif), new SkillRequirement(Skill.CRAFTING, 38), this.leather, this.needle, this.thread);
        craftACoifSteps.setDisplayCondition(this.notCraftCoif);
        craftACoifSteps.setLockingStep(this.craftCoifTask);
        allSteps.add(craftACoifSteps);
        PanelDetails alKharidRooftopCourseSteps = new PanelDetails("Al Kharid Rooftop Course", Collections.singletonList(this.alKharidRooftop), new SkillRequirement(Skill.AGILITY, 20));
        alKharidRooftopCourseSteps.setDisplayCondition(this.notAlKharidRooftop);
        alKharidRooftopCourseSteps.setLockingStep(this.alKharidRooftopTask);
        allSteps.add(alKharidRooftopCourseSteps);
        PanelDetails grappleRiverLumSteps = new PanelDetails("Grapple River Lum", Collections.singletonList(this.grappleLum), new SkillRequirement(Skill.AGILITY, 8), new SkillRequirement(Skill.STRENGTH, 19), new SkillRequirement(Skill.RANGED, 37), this.crossbow, this.mithGrap);
        grappleRiverLumSteps.setDisplayCondition(this.notGrappleLum);
        grappleRiverLumSteps.setLockingStep(this.grappleLumTask);
        allSteps.add(grappleRiverLumSteps);
        PanelDetails lavaRunesSteps = new PanelDetails("Craft Lava Runes", Arrays.asList(this.moveToLavaAltar, this.craftLava), new SkillRequirement(Skill.RUNECRAFT, 23), this.fireAccess, this.earthTali, this.earthRune, this.essence);
        lavaRunesSteps.setDisplayCondition(this.notCraftLava);
        lavaRunesSteps.setLockingStep(this.craftLavaTask);
        allSteps.add(lavaRunesSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

