/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.lumbridgeanddraynor;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.PrayerRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.TileStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Prayer;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.LUMBRIDGE_HARD)
public class LumbridgeHard
extends ComplexStateQuestHelper {
    ItemRequirement bones;
    ItemRequirement earthRune4;
    ItemRequirement earthRune10;
    ItemRequirement earthRune14;
    ItemRequirement waterRune;
    ItemRequirement natureRune;
    ItemRequirement fairyAccess;
    ItemRequirement axe;
    ItemRequirement goldBar;
    ItemRequirement cutDiamond;
    ItemRequirement amuletMould;
    ItemRequirement ballOfWool;
    ItemRequirement cosmicRune;
    ItemRequirement diamondAmuletU;
    ItemRequirement diamondAmulet;
    ItemRequirement miningHelm;
    ItemRequirement tinderbox;
    ItemRequirement coins;
    ItemRequirement essence;
    ItemRequirement cosmicAccessOrAbyss;
    ItemRequirement bellaSeed;
    ItemRequirement seedDib;
    ItemRequirement spade;
    ItemRequirement rake;
    ItemRequirement gloves;
    ItemRequirement earthRune;
    ItemRequirement ringOfDueling;
    ItemRequirement gamesNeck;
    ItemRequirement dorgSphere;
    ItemRequirement lightsource;
    Requirement tearOfGuth;
    Requirement anotherSliceOfHAM;
    Requirement recipeForDisaster;
    Requirement lostCity;
    Requirement madeAmuletU;
    Requirement bonesToPeaches;
    Requirement notBonesToPeachesPalace;
    Requirement notJuttingWall;
    Requirement notCosmics;
    Requirement notWakaToEdge;
    Requirement notHundredTears;
    Requirement notTrainToKeld;
    Requirement notBarrowsGloves;
    Requirement notBelladonna;
    Requirement notLightMiningHelm;
    Requirement notSmiteAltar;
    Requirement notPowerAmmy;
    Requirement smiteActive;
    Requirement bothEarth;
    QuestStep claimReward;
    QuestStep moveToBasementForHelm;
    QuestStep moveToBasementForTears;
    QuestStep moveToBasementForTrain;
    QuestStep moveToZanarisForWall;
    QuestStep moveToZanarisForCosmics;
    QuestStep moveToPalace;
    QuestStep moveToLumby;
    QuestStep moveToDorg;
    QuestStep bonesToPeachesPalace;
    QuestStep moveToBasementForGloves;
    QuestStep juttingWall;
    QuestStep cosmics;
    QuestStep wakaToEdge;
    QuestStep hundredTears;
    QuestStep trainToKeld;
    QuestStep barrowsGloves;
    QuestStep belladonna;
    QuestStep lightMiningHelm;
    QuestStep smiteAltar;
    QuestStep powerAmmy;
    QuestStep smeltAmmy;
    QuestStep stringAmmy;
    QuestStep dorgStairs;
    QuestStep stationDoor;
    QuestStep moveToCosmic;
    QuestStep unlockBonesToPeaches;
    Zone zanaris;
    Zone basement;
    Zone palace;
    Zone lumby;
    Zone underground;
    Zone dorg1;
    Zone dorg2;
    Zone cosmicAltar;
    Zone station;
    ZoneRequirement inZanaris;
    ZoneRequirement inBasement;
    ZoneRequirement inPalace;
    ZoneRequirement inLumby;
    ZoneRequirement inUnderground;
    ZoneRequirement inDorg1;
    ZoneRequirement inDorg2;
    ZoneRequirement inCosmicAltar;
    ZoneRequirement inStation;
    ConditionalStep bonesToPeachesPalaceTask;
    ConditionalStep juttingWallTask;
    ConditionalStep cosmicsTask;
    ConditionalStep wakaToEdgeTask;
    ConditionalStep hundredTearsTask;
    ConditionalStep trainToKeldTask;
    ConditionalStep barrowsGlovesTask;
    ConditionalStep belladonnaTask;
    ConditionalStep lightMiningHelmTask;
    ConditionalStep smiteAltarTask;
    ConditionalStep powerAmmyTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doHard = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.belladonnaTask = new ConditionalStep((QuestHelper)this, this.belladonna, new Requirement[0]);
        doHard.addStep(this.notBelladonna, this.belladonnaTask);
        this.smiteAltarTask = new ConditionalStep((QuestHelper)this, this.smiteAltar, new Requirement[0]);
        doHard.addStep(this.notSmiteAltar, this.smiteAltarTask);
        this.bonesToPeachesPalaceTask = new ConditionalStep((QuestHelper)this, this.unlockBonesToPeaches, new Requirement[0]);
        this.bonesToPeachesPalaceTask.addStep(this.bonesToPeaches, this.moveToPalace);
        this.bonesToPeachesPalaceTask.addStep(new Conditions(this.bonesToPeaches, this.inPalace), this.bonesToPeachesPalace);
        doHard.addStep(this.notBonesToPeachesPalace, this.bonesToPeachesPalaceTask);
        this.wakaToEdgeTask = new ConditionalStep((QuestHelper)this, this.wakaToEdge, new Requirement[0]);
        doHard.addStep(this.notWakaToEdge, this.wakaToEdgeTask);
        this.powerAmmyTask = new ConditionalStep((QuestHelper)this, this.moveToLumby, new Requirement[0]);
        this.powerAmmyTask.addStep(this.inLumby, this.smeltAmmy);
        this.powerAmmyTask.addStep(new Conditions(this.inLumby, this.madeAmuletU, this.diamondAmuletU), this.stringAmmy);
        this.powerAmmyTask.addStep(new Conditions(this.inLumby, this.madeAmuletU, this.diamondAmulet), this.powerAmmy);
        doHard.addStep(this.notPowerAmmy, this.powerAmmyTask);
        this.lightMiningHelmTask = new ConditionalStep((QuestHelper)this, this.moveToBasementForHelm, new Requirement[0]);
        this.lightMiningHelmTask.addStep(this.inBasement, this.lightMiningHelm);
        doHard.addStep(this.notLightMiningHelm, this.lightMiningHelmTask);
        this.barrowsGlovesTask = new ConditionalStep((QuestHelper)this, this.moveToBasementForGloves, new Requirement[0]);
        this.barrowsGlovesTask.addStep(this.inBasement, this.barrowsGloves);
        doHard.addStep(this.notBarrowsGloves, this.barrowsGlovesTask);
        this.hundredTearsTask = new ConditionalStep((QuestHelper)this, this.moveToBasementForTears, new Requirement[0]);
        this.hundredTearsTask.addStep(this.inUnderground, this.hundredTears);
        doHard.addStep(this.notHundredTears, this.hundredTearsTask);
        this.trainToKeldTask = new ConditionalStep((QuestHelper)this, this.moveToBasementForTrain, new Requirement[0]);
        this.trainToKeldTask.addStep(this.inUnderground, this.moveToDorg);
        this.trainToKeldTask.addStep(this.inDorg1, this.dorgStairs);
        this.trainToKeldTask.addStep(this.inDorg2, this.stationDoor);
        this.trainToKeldTask.addStep(this.inStation, this.trainToKeld);
        doHard.addStep(this.notTrainToKeld, this.trainToKeldTask);
        this.juttingWallTask = new ConditionalStep((QuestHelper)this, this.moveToZanarisForWall, new Requirement[0]);
        this.juttingWallTask.addStep(this.inZanaris, this.juttingWall);
        doHard.addStep(this.notJuttingWall, this.juttingWallTask);
        this.cosmicsTask = new ConditionalStep((QuestHelper)this, this.moveToZanarisForCosmics, new Requirement[0]);
        this.cosmicsTask.addStep(this.inZanaris, this.moveToCosmic);
        this.cosmicsTask.addStep(this.inCosmicAltar, this.cosmics);
        doHard.addStep(this.notCosmics, this.cosmicsTask);
        return doHard;
    }

    @Override
    public void setupRequirements() {
        this.notBonesToPeachesPalace = new VarplayerRequirement(1194, false, 25);
        this.notJuttingWall = new VarplayerRequirement(1194, false, 26);
        this.notCosmics = new VarplayerRequirement(1194, false, 27);
        this.notWakaToEdge = new VarplayerRequirement(1194, false, 28);
        this.notHundredTears = new VarplayerRequirement(1194, false, 29);
        this.notTrainToKeld = new VarplayerRequirement(1194, false, 30);
        this.notBarrowsGloves = new VarplayerRequirement(1194, false, 31);
        this.notBelladonna = new VarplayerRequirement(1195, false, 0);
        this.notLightMiningHelm = new VarplayerRequirement(1195, false, 1);
        this.notSmiteAltar = new VarplayerRequirement(1195, false, 2);
        this.notPowerAmmy = new VarplayerRequirement(1195, false, 3);
        this.bothEarth = new ComplexRequirement(LogicType.AND, "Earth runes", this.notBonesToPeachesPalace, this.notPowerAmmy);
        this.smiteActive = new PrayerRequirement("Smite prayer active", Prayer.SMITE);
        this.bonesToPeaches = new VarbitRequirement(1505, Operation.EQUAL, 1, "Bones to peaches unlocked");
        this.ringOfDueling = new ItemRequirement("Ring of dueling", ItemCollections.RING_OF_DUELINGS).showConditioned(new Conditions(LogicType.OR, this.notSmiteAltar, this.notBonesToPeachesPalace));
        this.bones = new ItemRequirement("Bones", 526).showConditioned(this.notBonesToPeachesPalace);
        this.earthRune4 = new ItemRequirement("Earth runes", 557, 4).showConditioned(new Conditions(this.notBonesToPeachesPalace, new Conditions(LogicType.NOR, this.bothEarth)));
        this.earthRune10 = new ItemRequirement("Earth runes", 557, 10).showConditioned(new Conditions(this.notPowerAmmy, new Conditions(LogicType.NOR, this.bothEarth)));
        this.earthRune14 = new ItemRequirement("Earth runes", 557, 14).showConditioned(this.bothEarth);
        this.earthRune = new ItemRequirement("Earth runes", 557);
        this.waterRune = new ItemRequirement("Water rune", 555, 4).showConditioned(this.notBonesToPeachesPalace);
        this.natureRune = new ItemRequirement("Nature rune", 561, 2).showConditioned(this.notBonesToPeachesPalace);
        this.fairyAccess = new ItemRequirement("Lunar or Dramen staff", ItemCollections.FAIRY_STAFF).showConditioned(new Conditions(LogicType.OR, this.notCosmics, this.notJuttingWall)).isNotConsumed();
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(this.notWakaToEdge).isNotConsumed();
        this.goldBar = new ItemRequirement("Gold bar", 2357).showConditioned(this.notPowerAmmy);
        this.cutDiamond = new ItemRequirement("Diamond", 1601).showConditioned(this.notPowerAmmy);
        this.amuletMould = new ItemRequirement("Amulet mould", 1595).showConditioned(this.notPowerAmmy).isNotConsumed();
        this.ballOfWool = new ItemRequirement("Ball of wool", 1759).showConditioned(this.notPowerAmmy);
        this.cosmicRune = new ItemRequirement("Cosmic rune", 564).showConditioned(this.notPowerAmmy);
        this.diamondAmuletU = new ItemRequirement("Diamond amulet (u)", 1681).showConditioned(this.notPowerAmmy);
        this.diamondAmulet = new ItemRequirement("Diamond amulet", 1700).showConditioned(this.notPowerAmmy);
        this.miningHelm = new ItemRequirement("Mining helmet", ItemCollections.MINING_HELM).showConditioned(this.notLightMiningHelm).isNotConsumed();
        this.tinderbox = new ItemRequirement("Tinderbox", 590).showConditioned(this.notLightMiningHelm).isNotConsumed();
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS, 130000).showConditioned(this.notBarrowsGloves);
        this.gamesNeck = new ItemRequirement("Games Necklace", ItemCollections.GAMES_NECKLACES).showConditioned(this.notHundredTears);
        this.dorgSphere = new ItemRequirement("Dorgesh-kaan Sphere", 10972).showConditioned(this.notTrainToKeld);
        this.essence = new ItemRequirement("Pure or Daeyalt essence", ItemCollections.ESSENCE_HIGH, 28).showConditioned(this.notCosmics);
        this.cosmicAccessOrAbyss = new ItemRequirement("Access to cosmic altar, or travel through abyss. Tiara recommended unless using essence pouches", ItemCollections.COSMIC_ALTAR).showConditioned(this.notCosmics).isNotConsumed();
        this.cosmicAccessOrAbyss.setTooltip("Cosmic talisman or tiara");
        this.bellaSeed = new ItemRequirement("Belladonna seed", 5281).showConditioned(this.notBelladonna);
        this.seedDib = new ItemRequirement("Seed dibber", 5343).showConditioned(this.notBelladonna).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notBelladonna).isNotConsumed();
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(this.notBelladonna).isNotConsumed();
        this.gloves = new ItemRequirement("Gloves", ItemCollections.BELLADONNA_GLOVES).showConditioned(this.notBelladonna).isNotConsumed();
        this.gloves.addAlternates(ItemCollections.GRACEFUL_GLOVES);
        this.gloves.setUrlSuffix("Belladonna#Gloves");
        this.gloves.setTooltip("'Go to wiki..' to see valid options for handling belladonna");
        this.lightsource = new ItemRequirement("A lightsource", ItemCollections.LIGHT_SOURCES).showConditioned(new Conditions(LogicType.OR, this.notHundredTears, this.notTrainToKeld)).isNotConsumed();
        this.inZanaris = new ZoneRequirement(this.zanaris);
        this.inBasement = new ZoneRequirement(this.basement);
        this.inPalace = new ZoneRequirement(this.palace);
        this.inLumby = new ZoneRequirement(this.lumby);
        this.inUnderground = new ZoneRequirement(this.underground);
        this.inDorg1 = new ZoneRequirement(this.dorg1);
        this.inDorg2 = new ZoneRequirement(this.dorg2);
        this.inCosmicAltar = new ZoneRequirement(this.cosmicAltar);
        this.inStation = new ZoneRequirement(this.station);
        this.madeAmuletU = new ChatMessageRequirement(this.inLumby, "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.madeAmuletU).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inLumby), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
        this.recipeForDisaster = new QuestRequirement(QuestHelperQuest.RECIPE_FOR_DISASTER, QuestState.FINISHED);
        this.anotherSliceOfHAM = new QuestRequirement(QuestHelperQuest.ANOTHER_SLICE_OF_HAM, QuestState.FINISHED);
        this.tearOfGuth = new QuestRequirement(QuestHelperQuest.TEARS_OF_GUTHIX, QuestState.FINISHED);
        this.lostCity = new QuestRequirement(QuestHelperQuest.LOST_CITY, QuestState.FINISHED);
    }

    public void loadZones() {
        this.zanaris = new Zone(new WorldPoint(2369, 4481, 0), new WorldPoint(2497, 4352, 0));
        this.basement = new Zone(new WorldPoint(3206, 9626, 0), new WorldPoint(3221, 9613, 0));
        this.palace = new Zone(new WorldPoint(3282, 3166, 0), new WorldPoint(3303, 3159, 0));
        this.lumby = new Zone(new WorldPoint(3216, 3261, 0), new WorldPoint(3234, 3247, 0));
        this.underground = new Zone(new WorldPoint(3137, 9706, 0), new WorldPoint(3332, 9465, 2));
        this.dorg1 = new Zone(new WorldPoint(2688, 5377, 0), new WorldPoint(2751, 5251, 0));
        this.dorg2 = new Zone(new WorldPoint(2688, 5377, 1), new WorldPoint(2751, 5251, 1));
        this.cosmicAltar = new Zone(new WorldPoint(2111, 4863, 0), new WorldPoint(2174, 4804, 0));
        this.station = new Zone(new WorldPoint(2478, 5558, 0), new WorldPoint(2491, 5513, 0));
    }

    public void setupSteps() {
        this.smiteAltar = new ObjectStep((QuestHelper)this, 409, new WorldPoint(3377, 3285, 0), "Pray at the altar at the Emir's Arena with smite active.", this.smiteActive);
        this.moveToPalace = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3293, 3164, 0), "Enter the Al Kharid palace.", new Requirement[0]);
        this.bonesToPeachesPalace = new DetailedQuestStep((QuestHelper)this, "Cast bones to peaches.", this.bones, this.earthRune4, this.waterRune, this.natureRune);
        this.unlockBonesToPeaches = new DetailedQuestStep((QuestHelper)this, "Unlock bones to peaches from the Mage Training Arena.", new Requirement[0]);
        this.wakaToEdge = new ObjectStep((QuestHelper)this, 12163, new WorldPoint(3242, 3237, 0), "Use the canoe station in lumbridge to make a Waka and travel to Edgeville.", this.axe);
        this.smeltAmmy = new ObjectStep((QuestHelper)this, 24009, new WorldPoint(3227, 3257, 0), "Smelt a Diamond Amulet (u), at the furnace in Lumbridge.", this.goldBar.highlighted(), this.cutDiamond);
        this.smeltAmmy.addIcon(2357);
        this.stringAmmy = new ItemStep((QuestHelper)this, "String the diamond amulet.", this.ballOfWool.highlighted(), this.diamondAmuletU.highlighted());
        this.powerAmmy = new ItemStep((QuestHelper)this, "Enchant the strung diamond amulet.", this.diamondAmulet, this.cosmicRune.quantity(1), this.earthRune10);
        this.moveToLumby = new TileStep((QuestHelper)this, new WorldPoint(3228, 3238, 0), "Move to the Lumbridge smithy.", this.ballOfWool, this.cutDiamond, this.goldBar);
        this.moveToBasementForHelm = new ObjectStep((QuestHelper)this, 14880, new WorldPoint(3209, 3216, 0), "Climb down the trapdoor in the Lumbridge Castle.", this.miningHelm, this.tinderbox);
        this.lightMiningHelm = new ItemStep((QuestHelper)this, "Light your mining helmet.", this.miningHelm.highlighted(), this.tinderbox.highlighted());
        this.moveToBasementForGloves = new ObjectStep((QuestHelper)this, 14880, new WorldPoint(3209, 3216, 0), "Climb down the trapdoor in the Lumbridge Castle.", this.coins);
        this.barrowsGloves = new ObjectStep((QuestHelper)this, 12308, new WorldPoint(3219, 9623, 0), "Purchase the barrows gloves from the bank chest. Right click and select 'Buy-items'.", this.coins);
        this.moveToBasementForTears = new ObjectStep((QuestHelper)this, 14880, new WorldPoint(3209, 3216, 0), "Climb down the trapdoor in the Lumbridge Castle.", new Requirement[0]);
        this.hundredTears = new ObjectStep((QuestHelper)this, 28929, new WorldPoint(3252, 9517, 2), "Talk to Juna to start collecting tears. You MUST collect 100 or more and only have one try a week.", new Requirement[0]);
        this.hundredTears.addDialogStep("Okay...");
        this.moveToBasementForTrain = new ObjectStep((QuestHelper)this, 14880, new WorldPoint(3209, 3216, 0), "Climb down the trapdoor in the Lumbridge Castle.", new Requirement[0]);
        this.moveToDorg = new ObjectStep((QuestHelper)this, 6919, new WorldPoint(3317, 9601, 0), "Go through the doors to Dorgesh-Kaan.", new Requirement[0]);
        this.dorgStairs = new ObjectStep((QuestHelper)this, 22937, new WorldPoint(2714, 5283, 0), "Climb the stairs to the second level of Dorgesh-Kaan.", new Requirement[0]);
        this.stationDoor = new ObjectStep((QuestHelper)this, 23052, new WorldPoint(2695, 5277, 1), "Enter the Dorgesh-Kaan train station.", new Requirement[0]);
        this.trainToKeld = new TileStep((QuestHelper)this, new WorldPoint(2480, 5538, 0), "Board the train and wait for it to leave.", new Requirement[0]);
        this.moveToZanarisForWall = new ObjectStep((QuestHelper)this, 2406, new WorldPoint(3202, 3169, 0), "Go to Zanaris through the shed in Lumbridge swamp or any fairy ring in the world if you've partially completed Fairytale II.", this.fairyAccess.equipped());
        this.juttingWall = new ObjectStep((QuestHelper)this, 17002, new WorldPoint(2400, 4403, 0), "Squeeze-through the jutting wall.", new Requirement[0]);
        this.moveToZanarisForCosmics = new ObjectStep((QuestHelper)this, 2406, new WorldPoint(3202, 3169, 0), "Go to Zanaris through the shed in Lumbridge swamp or any fairy ring in the world if you've partially completed Fairytale II.", this.fairyAccess.equipped());
        this.moveToCosmic = new ObjectStep((QuestHelper)this, 31607, new WorldPoint(2408, 4377, 0), "Enter the cosmic altar.", this.cosmicAccessOrAbyss.highlighted());
        this.moveToCosmic.addIcon(1454);
        this.cosmics = new ObjectStep((QuestHelper)this, 34766, new WorldPoint(2142, 4833, 0), "Craft 56 cosmic runes.", this.essence);
        this.belladonna = new ObjectStep((QuestHelper)this, 7572, new WorldPoint(3087, 3355, 0), "Grow and pick some belladonna from the Draynor Manor farming patch. If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", this.bellaSeed, this.rake, this.spade, this.gloves, this.seedDib);
        this.claimReward = new NpcStep((QuestHelper)this, 5523, new WorldPoint(3235, 3213, 0), "Talk to Hatius Cosaintus in Lumbridge to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins, this.bones, this.earthRune4, this.earthRune10, this.earthRune14, this.waterRune, this.natureRune, this.essence, this.fairyAccess, this.axe, this.goldBar, this.cutDiamond, this.amuletMould, this.ballOfWool, this.cosmicRune, this.miningHelm, this.tinderbox, this.bellaSeed, this.seedDib, this.spade, this.rake, this.gloves);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.ringOfDueling, this.gamesNeck, this.dorgSphere, this.lightsource);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.AGILITY, 46));
        reqs.add(new SkillRequirement(Skill.CRAFTING, 70, true));
        reqs.add(new SkillRequirement(Skill.FARMING, 63));
        reqs.add(new SkillRequirement(Skill.FIREMAKING, 65));
        reqs.add(new SkillRequirement(Skill.MAGIC, 60));
        reqs.add(new SkillRequirement(Skill.PRAYER, 52));
        reqs.add(new SkillRequirement(Skill.RUNECRAFT, 59, true));
        reqs.add(new SkillRequirement(Skill.WOODCUTTING, 57));
        reqs.add(this.tearOfGuth);
        reqs.add(this.anotherSliceOfHAM);
        reqs.add(this.recipeForDisaster);
        reqs.add(this.lostCity);
        reqs.add(this.bonesToPeaches);
        return reqs;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Explorer's ring 3", 13127), new ItemReward("15,000 Exp. Lamp (Any skill over 50)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("50% run energy replenish 4 times a day from Explorer's ring"), new UnlockReward("Unlimited teleports to cabbage patch near Falador farm for Explorer's ring"), new UnlockReward("Access to a shortcut from Lumbridge Swamp to the desert"), new UnlockReward("10% increased experience from Tears of Guthix"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails belladonnaSteps = new PanelDetails("Belladonna", Collections.singletonList(this.belladonna), this.bellaSeed, this.seedDib, this.spade, this.rake, this.gloves);
        belladonnaSteps.setDisplayCondition(this.notBelladonna);
        belladonnaSteps.setLockingStep(this.belladonnaTask);
        allSteps.add(belladonnaSteps);
        PanelDetails smiteAltarSteps = new PanelDetails("Smite Altar", Collections.singletonList(this.smiteAltar), new SkillRequirement(Skill.PRAYER, 52));
        smiteAltarSteps.setDisplayCondition(this.notSmiteAltar);
        smiteAltarSteps.setLockingStep(this.smiteAltarTask);
        allSteps.add(smiteAltarSteps);
        PanelDetails peachesPalaceSteps = new PanelDetails("Bones to Peaches Palace", Arrays.asList(this.unlockBonesToPeaches, this.moveToPalace, this.bonesToPeachesPalace), new SkillRequirement(Skill.MAGIC, 60), this.bonesToPeaches, this.bones, this.earthRune.quantity(4), this.waterRune, this.natureRune);
        peachesPalaceSteps.setDisplayCondition(this.notBonesToPeachesPalace);
        peachesPalaceSteps.setLockingStep(this.bonesToPeachesPalaceTask);
        allSteps.add(peachesPalaceSteps);
        PanelDetails wakaToEdgevilleSteps = new PanelDetails("Waka to Edgeville", Collections.singletonList(this.wakaToEdge), new SkillRequirement(Skill.WOODCUTTING, 57), this.axe);
        wakaToEdgevilleSteps.setDisplayCondition(this.notWakaToEdge);
        wakaToEdgevilleSteps.setLockingStep(this.wakaToEdgeTask);
        allSteps.add(wakaToEdgevilleSteps);
        PanelDetails powerAmuletSteps = new PanelDetails("Power Amulet", Arrays.asList(this.moveToLumby, this.smeltAmmy, this.stringAmmy, this.powerAmmy), new SkillRequirement(Skill.CRAFTING, 70, true), new SkillRequirement(Skill.MAGIC, 57), this.goldBar, this.cutDiamond, this.amuletMould, this.ballOfWool, this.cosmicRune.quantity(1), this.earthRune.quantity(10));
        powerAmuletSteps.setDisplayCondition(this.notPowerAmmy);
        powerAmuletSteps.setLockingStep(this.powerAmmyTask);
        allSteps.add(powerAmuletSteps);
        PanelDetails miningHelmetSteps = new PanelDetails("Mining Helmet", Arrays.asList(this.moveToBasementForHelm, this.lightMiningHelm), new SkillRequirement(Skill.FIREMAKING, 65), this.miningHelm, this.tinderbox);
        miningHelmetSteps.setDisplayCondition(this.notLightMiningHelm);
        miningHelmetSteps.setLockingStep(this.lightMiningHelmTask);
        allSteps.add(miningHelmetSteps);
        PanelDetails barrowsGlovesSteps = new PanelDetails("Barrows Gloves", Arrays.asList(this.moveToBasementForGloves, this.barrowsGloves), this.recipeForDisaster, this.coins);
        barrowsGlovesSteps.setDisplayCondition(this.notBarrowsGloves);
        barrowsGlovesSteps.setLockingStep(this.barrowsGlovesTask);
        allSteps.add(barrowsGlovesSteps);
        PanelDetails hundredTearsSteps = new PanelDetails("100 Tears", Arrays.asList(this.moveToBasementForTears, this.hundredTears), this.tearOfGuth);
        hundredTearsSteps.setDisplayCondition(this.notHundredTears);
        hundredTearsSteps.setLockingStep(this.hundredTearsTask);
        allSteps.add(hundredTearsSteps);
        PanelDetails dorgeshTrainSteps = new PanelDetails("Dorgesh Train", Arrays.asList(this.moveToBasementForTrain, this.moveToDorg, this.dorgStairs, this.stationDoor, this.trainToKeld), this.anotherSliceOfHAM);
        dorgeshTrainSteps.setDisplayCondition(this.notTrainToKeld);
        dorgeshTrainSteps.setLockingStep(this.trainToKeldTask);
        allSteps.add(dorgeshTrainSteps);
        PanelDetails juttingWallSteps = new PanelDetails("Jutting Wall", Arrays.asList(this.moveToZanarisForWall, this.juttingWall), new SkillRequirement(Skill.AGILITY, 46), this.lostCity, this.fairyAccess);
        juttingWallSteps.setDisplayCondition(this.notJuttingWall);
        juttingWallSteps.setLockingStep(this.juttingWallTask);
        allSteps.add(juttingWallSteps);
        PanelDetails cosmicsSteps = new PanelDetails("56 Cosmic Runes", Arrays.asList(this.moveToZanarisForCosmics, this.moveToCosmic, this.cosmics), new SkillRequirement(Skill.RUNECRAFT, 59, true), this.lostCity, this.essence, this.cosmicAccessOrAbyss, this.fairyAccess);
        cosmicsSteps.setDisplayCondition(this.notCosmics);
        cosmicsSteps.setLockingStep(this.cosmicsTask);
        allSteps.add(cosmicsSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

