/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.lumbridgeanddraynor;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.EmoteStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.TileStep;
import com.questhelper.steps.emote.QuestEmote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.LUMBRIDGE_ELITE)
public class LumbridgeElite
extends ComplexStateQuestHelper {
    ItemRequirement lockpick;
    ItemRequirement crossbow;
    ItemRequirement mithgrap;
    ItemRequirement lightsource;
    ItemRequirement axe;
    ItemRequirement addyBar;
    ItemRequirement hammer;
    ItemRequirement essence;
    ItemRequirement waterAccessOrAbyss;
    ItemRequirement qcCape;
    ItemRequirement ringOfDueling;
    ItemRequirement dorgSphere;
    Requirement notRichChest;
    Requirement notMovario;
    Requirement notChopMagic;
    Requirement notAddyPlatebody;
    Requirement notWaterRunes;
    Requirement notQCEmote;
    Requirement allQuests;
    Requirement deathToDorg;
    Requirement templeOfIkov;
    QuestStep claimReward;
    QuestStep richChest;
    QuestStep movario;
    QuestStep chopMagic;
    QuestStep addyPlatebody;
    QuestStep waterRunes;
    QuestStep qcEmote;
    QuestStep moveToWater;
    QuestStep dorgStairsChest;
    QuestStep dorgStairsMovario;
    QuestStep moveToOldman;
    QuestStep moveToUndergroundChest;
    QuestStep moveToUndergroundMovario;
    QuestStep moveToDorgAgi;
    ObjectStep moveToDraySewer;
    ObjectStep moveToDorgChest;
    ObjectStep moveToDorgMovario;
    Zone underground;
    Zone dorg1;
    Zone dorg2;
    Zone draySewer;
    Zone oldman;
    Zone waterAltar;
    Zone dorgAgi;
    ZoneRequirement inUnderground;
    ZoneRequirement inDorg1;
    ZoneRequirement inDorg2;
    ZoneRequirement inDraySewer;
    ZoneRequirement inOldman;
    ZoneRequirement inWaterAltar;
    ZoneRequirement inDorgAgi;
    ConditionalStep richChestTask;
    ConditionalStep movarioTask;
    ConditionalStep chopMagicTask;
    ConditionalStep addyPlatebodyTask;
    ConditionalStep waterRunesTask;
    ConditionalStep qcEmoteTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doElite = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.addyPlatebodyTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.moveToDraySewer, new Requirement[0]);
        this.addyPlatebodyTask.addStep(this.inDraySewer, this.addyPlatebody);
        doElite.addStep(this.notAddyPlatebody, this.addyPlatebodyTask);
        this.qcEmoteTask = new ConditionalStep((QuestHelper)this, this.moveToOldman, new Requirement[0]);
        this.qcEmoteTask.addStep(this.inOldman, this.qcEmote);
        doElite.addStep(this.notQCEmote, this.qcEmoteTask);
        this.richChestTask = new ConditionalStep((QuestHelper)this, this.moveToUndergroundChest, new Requirement[0]);
        this.richChestTask.addStep(this.inUnderground, this.moveToDorgChest);
        this.richChestTask.addStep(this.inDorg1, this.dorgStairsChest);
        this.richChestTask.addStep(this.inDorg2, this.richChest);
        doElite.addStep(this.notRichChest, this.richChestTask);
        this.movarioTask = new ConditionalStep((QuestHelper)this, this.moveToUndergroundMovario, new Requirement[0]);
        this.movarioTask.addStep(this.inUnderground, this.moveToDorgMovario);
        this.movarioTask.addStep(this.inDorg1, this.dorgStairsMovario);
        this.movarioTask.addStep(this.inDorg2, this.moveToDorgAgi);
        this.movarioTask.addStep(this.inDorgAgi, this.movario);
        doElite.addStep(this.notMovario, this.movarioTask);
        this.waterRunesTask = new ConditionalStep((QuestHelper)this, this.moveToWater, new Requirement[0]);
        this.waterRunesTask.addStep(this.inWaterAltar, this.waterRunes);
        doElite.addStep(this.notWaterRunes, this.waterRunesTask);
        this.chopMagicTask = new ConditionalStep((QuestHelper)this, this.chopMagic, new Requirement[0]);
        doElite.addStep(this.notChopMagic, this.chopMagicTask);
        return doElite;
    }

    @Override
    public void setupRequirements() {
        this.notRichChest = new VarplayerRequirement(1195, false, 4);
        this.notMovario = new VarplayerRequirement(1195, false, 5);
        this.notChopMagic = new VarplayerRequirement(1195, false, 6);
        this.notAddyPlatebody = new VarplayerRequirement(1195, false, 7);
        this.notWaterRunes = new VarplayerRequirement(1195, false, 8);
        this.notQCEmote = new VarplayerRequirement(1195, false, 9);
        this.allQuests = new Requirement(){

            @Override
            public boolean check(Client client) {
                boolean allQuestsCompleted = true;
                for (QuestHelperQuest quest : QuestHelperQuest.values()) {
                    if (quest.getQuestType() != QuestDetails.Type.F2P && quest.getQuestType() != QuestDetails.Type.P2P || quest.getState(client, LumbridgeElite.this.configManager) == QuestState.FINISHED) continue;
                    allQuestsCompleted = false;
                    break;
                }
                return allQuestsCompleted;
            }

            @Override
            @Nonnull
            public String getDisplayText() {
                return "All Quests are Completed";
            }
        };
        this.lockpick = new ItemRequirement("Lockpick", 1523).showConditioned(this.notRichChest).isNotConsumed();
        this.crossbow = new ItemRequirement("Crossbow", ItemCollections.CROSSBOWS).showConditioned(this.notMovario).isNotConsumed();
        this.mithgrap = new ItemRequirement("Mith grapple", 9419).showConditioned(this.notMovario).isNotConsumed();
        this.lightsource = new ItemRequirement("A lightsource", ItemCollections.LIGHT_SOURCES).showConditioned(this.notMovario).isNotConsumed();
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(this.notChopMagic).isNotConsumed();
        this.addyBar = new ItemRequirement("Adamantite bar", 2361).showConditioned(this.notAddyPlatebody);
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(this.notAddyPlatebody).isNotConsumed();
        this.essence = new ItemRequirement("Essence", ItemCollections.ESSENCE_LOW).showConditioned(this.notWaterRunes);
        this.waterAccessOrAbyss = new ItemRequirement("Access to water altar, or travel through abyss", 5531).showConditioned(this.notWaterRunes).isNotConsumed();
        this.waterAccessOrAbyss.setTooltip("Water talisman or tiara");
        this.qcCape = new ItemRequirement("Quest cape", ItemCollections.QUEST_CAPE).showConditioned(this.notQCEmote).isNotConsumed();
        this.dorgSphere = new ItemRequirement("Dorgesh-kaan Sphere", 10972).showConditioned(new Conditions(this.notMovario, this.notRichChest));
        this.ringOfDueling = new ItemRequirement("Ring of dueling", ItemCollections.RING_OF_DUELINGS).showConditioned(this.notChopMagic);
        this.inUnderground = new ZoneRequirement(this.underground);
        this.inDorg1 = new ZoneRequirement(this.dorg1);
        this.inDorg2 = new ZoneRequirement(this.dorg2);
        this.inDraySewer = new ZoneRequirement(this.draySewer);
        this.inWaterAltar = new ZoneRequirement(this.waterAltar);
        this.inOldman = new ZoneRequirement(this.oldman);
        this.inDorgAgi = new ZoneRequirement(this.dorgAgi);
        this.deathToDorg = new QuestRequirement(QuestHelperQuest.DEATH_TO_THE_DORGESHUUN, QuestState.FINISHED);
        this.templeOfIkov = new QuestRequirement(QuestHelperQuest.TEMPLE_OF_IKOV, QuestState.FINISHED);
    }

    public void loadZones() {
        this.waterAltar = new Zone(new WorldPoint(2688, 4863, 0), new WorldPoint(2751, 4800, 0));
        this.underground = new Zone(new WorldPoint(3137, 9706, 0), new WorldPoint(3332, 9465, 2));
        this.draySewer = new Zone(new WorldPoint(3077, 9699, 0), new WorldPoint(3132, 9641, 0));
        this.dorg1 = new Zone(new WorldPoint(2688, 5377, 0), new WorldPoint(2751, 5251, 0));
        this.dorg2 = new Zone(new WorldPoint(2688, 5377, 1), new WorldPoint(2751, 5251, 1));
        this.oldman = new Zone(new WorldPoint(3087, 3255, 0), new WorldPoint(3094, 3251, 0));
        this.dorgAgi = new Zone(new WorldPoint(2688, 5247, 0), new WorldPoint(2752, 5183, 3));
    }

    public void setupSteps() {
        this.moveToDraySewer = new ObjectStep((QuestHelper)this, 6435, new WorldPoint(3118, 3244, 0), "Climb down into the Draynor Sewer.", new Requirement[0]);
        this.moveToDraySewer.addAlternateObjects(6434);
        this.addyPlatebody = new ObjectStep((QuestHelper)this, 2097, new WorldPoint(3112, 9689, 0), "Smith a adamant platebody at the anvil in Draynor Sewer.", this.addyBar.quantity(5), this.hammer);
        this.moveToOldman = new TileStep((QuestHelper)this, new WorldPoint(3088, 3253, 0), "Go to the Wise Old Man's house in Draynor Village.", new Requirement[0]);
        this.qcEmote = new EmoteStep((QuestHelper)this, QuestEmote.SKILL_CAPE, new WorldPoint(3088, 3253, 0), "Perform the skill cape emote with the quest cape equipped.", this.qcCape.equipped());
        this.moveToWater = new ObjectStep((QuestHelper)this, 34815, new WorldPoint(3185, 3165, 0), "Enter the water altar.", this.waterAccessOrAbyss.highlighted(), this.essence.quantity(28));
        this.waterRunes = new ObjectStep((QuestHelper)this, 34762, new WorldPoint(2716, 4836, 0), "Craft water runes.", this.essence.quantity(28));
        this.moveToUndergroundMovario = new ObjectStep((QuestHelper)this, 14880, new WorldPoint(3209, 3216, 0), "Climb down the trapdoor in the Lumbridge Castle.", this.mithgrap, this.crossbow, this.lightsource);
        this.moveToUndergroundChest = new ObjectStep((QuestHelper)this, 14880, new WorldPoint(3209, 3216, 0), "Climb down the trapdoor in the Lumbridge Castle.", this.lockpick, this.lightsource);
        this.moveToDorgChest = new ObjectStep((QuestHelper)this, 6919, new WorldPoint(3317, 9601, 0), "Go through the doors to Dorgesh-Kaan.", true, this.lockpick, this.lightsource);
        this.moveToDorgChest.addAlternateObjects(6920);
        this.moveToDorgMovario = new ObjectStep((QuestHelper)this, 6919, new WorldPoint(3317, 9601, 0), "Go through the doors to Dorgesh-Kaan.", true, this.mithgrap, this.crossbow, this.lightsource);
        this.moveToDorgMovario.addAlternateObjects(6920);
        this.dorgStairsMovario = new ObjectStep((QuestHelper)this, 22939, new WorldPoint(2721, 5360, 0), "Climb the stairs to the second level of Dorgesh-Kaan.", this.mithgrap, this.crossbow, this.lightsource);
        this.dorgStairsChest = new ObjectStep((QuestHelper)this, 22939, new WorldPoint(2721, 5360, 0), "Climb the stairs to the second level of Dorgesh-Kaan.", this.lockpick);
        this.richChest = new ObjectStep((QuestHelper)this, 22681, new WorldPoint(2703, 5348, 1), "Lockpick the chest.", this.lockpick);
        this.moveToDorgAgi = new ObjectStep((QuestHelper)this, 22941, new WorldPoint(2723, 5253, 1), "Climb the stairs to enter the Dorgesh-Kaan agility course.", new Requirement[0]);
        this.movario = new NpcStep((QuestHelper)this, 2341, new WorldPoint(2706, 5237, 3), "Pickpocket Movario near the end of the agility course.", new Requirement[0]);
        this.chopMagic = new ObjectStep((QuestHelper)this, 10834, new WorldPoint(3357, 3312, 0), "Chop some magic logs near the Magic Training Arena.", this.axe);
        this.claimReward = new NpcStep((QuestHelper)this, 5523, new WorldPoint(3235, 3213, 0), "Talk to Hatius Cosaintus in Lumbridge to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.qcCape, this.lockpick, this.mithgrap, this.hammer, this.waterAccessOrAbyss, this.axe, this.addyBar.quantity(5), this.essence.quantity(28), this.crossbow);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.ringOfDueling, this.dorgSphere);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.AGILITY, 70));
        reqs.add(new SkillRequirement(Skill.RANGED, 70));
        reqs.add(new ComplexRequirement(LogicType.OR, "76 Runecraft or 57 with Raiments of the Eye set", new SkillRequirement(Skill.RUNECRAFT, 76, true, "76 Runecraft"), new ItemRequirements("57 with Raiments of the Eye set", new ItemRequirement("Hat", ItemCollections.EYE_HAT).alsoCheckBank(this.questBank), new ItemRequirement("Top", ItemCollections.EYE_TOP).alsoCheckBank(this.questBank), new ItemRequirement("Bottom", ItemCollections.EYE_BOTTOM).alsoCheckBank(this.questBank), new ItemRequirement("Boot", 26856)).alsoCheckBank(this.questBank)));
        reqs.add(new SkillRequirement(Skill.SMITHING, 88, true));
        reqs.add(new SkillRequirement(Skill.STRENGTH, 70));
        reqs.add(new SkillRequirement(Skill.THIEVING, 78, true));
        reqs.add(new SkillRequirement(Skill.WOODCUTTING, 75));
        reqs.add(this.allQuests);
        return reqs;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Explorer's ring 4", 13128), new ItemReward("50,000 Exp. Lamp (Any skill over 70)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("100% run energy replenish 3 times a day from Explorer's ring"), new UnlockReward("30 casts of High Level Alchemy per day (does not provide experience) from Explorer's ring"), new UnlockReward("20% discount on items in the Culinaromancer's Chest"), new UnlockReward("Ability to use Fairy rings without the need of a Dramen or Lunar staff"), new UnlockReward("Unlocked the 6th slot for blocking Slayer tasks"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails adamantitePlatebodySteps = new PanelDetails("Adamantite Platebody", Arrays.asList(this.moveToDraySewer, this.addyPlatebody), new SkillRequirement(Skill.SMITHING, 88, true), this.addyBar.quantity(5), this.hammer);
        adamantitePlatebodySteps.setDisplayCondition(this.notAddyPlatebody);
        adamantitePlatebodySteps.setLockingStep(this.addyPlatebodyTask);
        allSteps.add(adamantitePlatebodySteps);
        PanelDetails questCapeEmoteSteps = new PanelDetails("Quest Cape Emote", Arrays.asList(this.moveToOldman, this.qcEmote), this.allQuests, this.qcCape);
        questCapeEmoteSteps.setDisplayCondition(this.notQCEmote);
        questCapeEmoteSteps.setLockingStep(this.qcEmoteTask);
        allSteps.add(questCapeEmoteSteps);
        PanelDetails richChestSteps = new PanelDetails("Dorgesh-Kaan Rich Chest", Arrays.asList(this.moveToUndergroundChest, this.moveToDorgChest, this.dorgStairsChest, this.richChest), new SkillRequirement(Skill.THIEVING, 78, true), this.deathToDorg, this.lightsource, this.lockpick);
        richChestSteps.setDisplayCondition(this.notRichChest);
        richChestSteps.setLockingStep(this.richChestTask);
        allSteps.add(richChestSteps);
        PanelDetails movarioSteps = new PanelDetails("Movario", Arrays.asList(this.moveToUndergroundMovario, this.moveToDorgMovario, this.dorgStairsMovario, this.moveToDorgAgi, this.movario), new SkillRequirement(Skill.THIEVING, 42), new SkillRequirement(Skill.AGILITY, 70), new SkillRequirement(Skill.RANGED, 70), new SkillRequirement(Skill.STRENGTH, 70), this.deathToDorg, this.templeOfIkov, this.mithgrap, this.crossbow, this.lightsource);
        movarioSteps.setDisplayCondition(this.notMovario);
        movarioSteps.setLockingStep(this.movarioTask);
        allSteps.add(movarioSteps);
        PanelDetails waterRunesSteps = new PanelDetails("140 Water Runes", Arrays.asList(this.moveToWater, this.waterRunes), new SkillRequirement(Skill.RUNECRAFT, 76), this.essence.quantity(28), this.waterAccessOrAbyss);
        waterRunesSteps.setDisplayCondition(this.notWaterRunes);
        waterRunesSteps.setLockingStep(this.waterRunesTask);
        allSteps.add(waterRunesSteps);
        PanelDetails chopMagicsSteps = new PanelDetails("Chop Magics", Collections.singletonList(this.chopMagic), new SkillRequirement(Skill.WOODCUTTING, 75), this.axe);
        chopMagicsSteps.setDisplayCondition(this.notChopMagic);
        chopMagicsSteps.setLockingStep(this.chopMagicTask);
        allSteps.add(chopMagicsSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

