/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.lumbridgeanddraynor;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.LUMBRIDGE_EASY)
public class LumbridgeEasy
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement lightSource;
    ItemRequirement rope;
    ItemRequirement runeEss;
    ItemRequirement axe;
    ItemRequirement tinderbox;
    ItemRequirement smallFishingNet;
    ItemRequirement pickaxe;
    ItemRequirement waterAccessOrAbyss;
    ItemRequirement spinyHelm;
    ItemRequirement dough;
    ItemRequirement oakLogs;
    ItemRequirement food;
    Requirement runeMysteries;
    Requirement cooksAssistant;
    Requirement notDrayAgi;
    Requirement notKillCaveBug;
    Requirement notSedridor;
    Requirement notWaterRune;
    Requirement notHans;
    Requirement notPickpocket;
    Requirement notOak;
    Requirement notKillZombie;
    Requirement notFishAnchovies;
    Requirement notBread;
    Requirement notIron;
    Requirement notEnterHAM;
    Requirement choppedLogs;
    Requirement addedRopeToHole;
    QuestStep claimReward;
    QuestStep drayAgi;
    QuestStep killCaveBug;
    QuestStep addRopeToHole;
    QuestStep moveToDarkHole;
    QuestStep sedridor;
    QuestStep moveToSed;
    QuestStep moveToWaterAltar;
    QuestStep waterRune;
    QuestStep hans;
    QuestStep chopOak;
    QuestStep burnOak;
    QuestStep fishAnchovies;
    QuestStep bread;
    QuestStep mineIron;
    NpcStep pickpocket;
    NpcStep killZombie;
    ObjectStep moveToDraySewer;
    ObjectStep enterHAM;
    Zone cave;
    Zone sewer;
    Zone water;
    Zone mageTower;
    Zone lumby;
    ZoneRequirement inCave;
    ZoneRequirement inSewer;
    ZoneRequirement inWater;
    ZoneRequirement inMageTower;
    ZoneRequirement inLumby;
    ConditionalStep drayAgiTask;
    ConditionalStep killCaveBugTask;
    ConditionalStep sedridorTask;
    ConditionalStep waterRuneTask;
    ConditionalStep hansTask;
    ConditionalStep pickpocketTask;
    ConditionalStep oakTask;
    ConditionalStep killZombieTask;
    ConditionalStep fishAnchoviesTask;
    ConditionalStep breadTask;
    ConditionalStep ironTask;
    ConditionalStep enterHAMTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doEasy = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.drayAgiTask = new ConditionalStep((QuestHelper)this, this.drayAgi, new Requirement[0]);
        doEasy.addStep(this.notDrayAgi, this.drayAgiTask);
        this.killZombieTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.moveToDraySewer, new Requirement[0]);
        this.killZombieTask.addStep(this.inSewer, this.killZombie);
        doEasy.addStep(this.notKillZombie, this.killZombieTask);
        this.sedridorTask = new ConditionalStep((QuestHelper)this, this.moveToSed, new Requirement[0]);
        this.sedridorTask.addStep(this.inMageTower, this.sedridor);
        doEasy.addStep(this.notSedridor, this.sedridorTask);
        this.enterHAMTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterHAM, new Requirement[0]);
        doEasy.addStep(this.notEnterHAM, this.enterHAMTask);
        this.killCaveBugTask = new ConditionalStep((QuestHelper)this, this.addRopeToHole, new Requirement[0]);
        this.killCaveBugTask.addStep(this.addedRopeToHole, this.moveToDarkHole);
        this.killCaveBugTask.addStep(this.inCave, this.killCaveBug);
        doEasy.addStep(this.notKillCaveBug, this.killCaveBugTask);
        this.waterRuneTask = new ConditionalStep((QuestHelper)this, this.moveToWaterAltar, new Requirement[0]);
        this.waterRuneTask.addStep(this.inWater, this.waterRune);
        doEasy.addStep(this.notWaterRune, this.waterRuneTask);
        this.breadTask = new ConditionalStep((QuestHelper)this, this.bread, new Requirement[0]);
        doEasy.addStep(this.notBread, this.breadTask);
        this.hansTask = new ConditionalStep((QuestHelper)this, this.hans, new Requirement[0]);
        doEasy.addStep(this.notHans, this.hansTask);
        this.pickpocketTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.pickpocket, new Requirement[0]);
        doEasy.addStep(this.notPickpocket, this.pickpocketTask);
        this.oakTask = new ConditionalStep((QuestHelper)this, this.chopOak, new Requirement[0]);
        this.oakTask.addStep(new Conditions(this.oakLogs, this.choppedLogs), this.burnOak);
        doEasy.addStep(this.notOak, this.oakTask);
        this.ironTask = new ConditionalStep((QuestHelper)this, this.mineIron, new Requirement[0]);
        doEasy.addStep(this.notIron, this.ironTask);
        this.fishAnchoviesTask = new ConditionalStep((QuestHelper)this, this.fishAnchovies, new Requirement[0]);
        doEasy.addStep(this.notFishAnchovies, this.fishAnchoviesTask);
        return doEasy;
    }

    @Override
    public void setupRequirements() {
        this.notDrayAgi = new VarplayerRequirement(1194, false, 1);
        this.notKillCaveBug = new VarplayerRequirement(1194, false, 2);
        this.notSedridor = new VarplayerRequirement(1194, false, 3);
        this.notWaterRune = new VarplayerRequirement(1194, false, 4);
        this.notHans = new VarplayerRequirement(1194, false, 5);
        this.notPickpocket = new VarplayerRequirement(1194, false, 6);
        this.notOak = new VarplayerRequirement(1194, false, 7);
        this.notKillZombie = new VarplayerRequirement(1194, false, 8);
        this.notFishAnchovies = new VarplayerRequirement(1194, false, 9);
        this.notBread = new VarplayerRequirement(1194, false, 10);
        this.notIron = new VarplayerRequirement(1194, false, 11);
        this.notEnterHAM = new VarplayerRequirement(1194, false, 12);
        this.addedRopeToHole = new VarbitRequirement(279, 1);
        this.lightSource = new ItemRequirement("Light source", ItemCollections.LIGHT_SOURCES).showConditioned(this.notKillCaveBug).isNotConsumed();
        this.rope = new ItemRequirement("Rope", 954).showConditioned(this.notKillCaveBug);
        this.spinyHelm = new ItemRequirement("Spiny helmet or slayer helmet (Recommended for low combat levels / Ironmen)", ItemCollections.WALL_BEAST).showConditioned(this.notKillCaveBug).isNotConsumed();
        this.waterAccessOrAbyss = new ItemRequirement("Access to water altar, or travel through abyss.", ItemCollections.WATER_ALTAR).showConditioned(this.notWaterRune).isNotConsumed();
        this.waterAccessOrAbyss.setTooltip("Water talisman or tiara");
        this.runeEss = new ItemRequirement("Essence", ItemCollections.ESSENCE_LOW).showConditioned(this.notWaterRune);
        this.dough = new ItemRequirement("Bread dough", 2307).showConditioned(this.notBread);
        this.oakLogs = new ItemRequirement("Oak logs", 1521).showConditioned(this.notOak);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).showConditioned(this.notOak).isNotConsumed();
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(this.notOak).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notIron).isNotConsumed();
        this.smallFishingNet = new ItemRequirement("Small fishing net", 303).showConditioned(this.notFishAnchovies).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.inCave = new ZoneRequirement(this.cave);
        this.inSewer = new ZoneRequirement(this.sewer);
        this.inMageTower = new ZoneRequirement(this.mageTower);
        this.inWater = new ZoneRequirement(this.water);
        this.inLumby = new ZoneRequirement(this.lumby);
        this.choppedLogs = new ChatMessageRequirement("<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.choppedLogs).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inLumby), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
        this.runeMysteries = new QuestRequirement(QuestHelperQuest.RUNE_MYSTERIES, QuestState.FINISHED);
        this.cooksAssistant = new QuestRequirement(QuestHelperQuest.COOKS_ASSISTANT, QuestState.FINISHED);
    }

    public void loadZones() {
        this.lumby = new Zone(new WorldPoint(3212, 3213, 0), new WorldPoint(3227, 3201, 0));
        this.cave = new Zone(new WorldPoint(3140, 9602, 0), new WorldPoint(3261, 9537, 0));
        this.sewer = new Zone(new WorldPoint(3077, 9699, 0), new WorldPoint(3132, 9641, 0));
        this.mageTower = new Zone(new WorldPoint(3095, 9578, 0), new WorldPoint(3122, 9554, 0));
        this.water = new Zone(new WorldPoint(2688, 4863, 0), new WorldPoint(2751, 4800, 0));
    }

    public void setupSteps() {
        this.drayAgi = new ObjectStep((QuestHelper)this, 11404, new WorldPoint(3103, 3279, 0), "Complete a lap of the Draynor Rooftop Course.", new Requirement[0]);
        this.moveToDraySewer = new ObjectStep((QuestHelper)this, 6435, new WorldPoint(3118, 3244, 0), "Climb down into the Draynor Sewer.", new Requirement[0]);
        this.moveToDraySewer.addAlternateObjects(6434);
        this.killZombie = new NpcStep((QuestHelper)this, 38, new WorldPoint(3123, 9648, 0), "Kill a zombie.", true, new Requirement[0]);
        this.killZombie.addAlternateNpcs(40, 57, 55, 56);
        this.moveToSed = new ObjectStep((QuestHelper)this, 2147, new WorldPoint(3104, 3162, 0), "Climb down the ladder in the Wizards' Tower.", new Requirement[0]);
        this.sedridor = new NpcStep((QuestHelper)this, 11432, new WorldPoint(3103, 9571, 0), "Teleport to the Rune essence mine via Sedridor.", new Requirement[0]);
        this.sedridor.addDialogStep("Can you teleport me to the Rune Essence?");
        this.enterHAM = new ObjectStep((QuestHelper)this, 5490, new WorldPoint(3166, 3252, 0), "Lock pick and enter the HAM hideout.", new Requirement[0]);
        this.enterHAM.addAlternateObjects(5491);
        this.moveToDarkHole = new ObjectStep((QuestHelper)this, 5947, new WorldPoint(3169, 3172, 0), "Enter the dark hole in the Lumbridge Swamp.", this.lightSource, this.combatGear);
        this.addRopeToHole = new ObjectStep((QuestHelper)this, 5947, new WorldPoint(3169, 3172, 0), "Use a rope on the dark hole in the Lumbridge Swamp, and then enter it.", this.lightSource, this.rope.highlighted(), this.combatGear);
        this.addRopeToHole.addSubSteps(this.moveToDarkHole);
        this.addRopeToHole.addIcon(954);
        this.killCaveBug = new NpcStep((QuestHelper)this, 481, new WorldPoint(3151, 9574, 0), "Kill a Cave Bug.", this.combatGear, this.lightSource);
        this.moveToWaterAltar = new ObjectStep((QuestHelper)this, 34815, new WorldPoint(3185, 3165, 0), "Enter the water altar in Lumbridge Swamp.", this.waterAccessOrAbyss.highlighted(), this.runeEss);
        this.moveToWaterAltar.addIcon(1444);
        this.waterRune = new ObjectStep((QuestHelper)this, 34762, new WorldPoint(2716, 4836, 0), "Craft water runes.", this.runeEss);
        this.bread = new ObjectStep((QuestHelper)this, 114, new WorldPoint(3212, 3216, 0), "Cook bread on the cooking range in Lumbridge Castle.", this.dough);
        this.hans = new NpcStep((QuestHelper)this, 3105, new WorldPoint(3215, 3219, 0), "Talk to Hans to learn your age.", new Requirement[0]);
        this.hans.addDialogStep("Can you tell me how long I've been here?");
        this.pickpocket = new NpcStep((QuestHelper)this, 3107, new WorldPoint(3215, 3219, 0), "Pickpocket a man or woman infront of Lumbridge Castle.", true, new Requirement[0]);
        this.pickpocket.addAlternateNpcs(3108, 3111, 3106);
        this.chopOak = new ObjectStep((QuestHelper)this, 10820, new WorldPoint(3219, 3206, 0), "Chop the oak tree in the Lumbridge Castle Courtyard.", this.axe);
        this.burnOak = new ItemStep((QuestHelper)this, "Burn the oak logs you've chopped.", this.tinderbox.highlighted(), this.oakLogs.highlighted());
        this.mineIron = new ObjectStep((QuestHelper)this, 11364, new WorldPoint(3303, 3284, 0), "Mine some iron ore at the Al-Kharid mine.", this.pickaxe);
        this.fishAnchovies = new NpcStep((QuestHelper)this, 1528, new WorldPoint(3267, 3148, 0), "Fish for anchovies in Al-Kharid.", this.smallFishingNet);
        this.claimReward = new NpcStep((QuestHelper)this, 5523, new WorldPoint(3235, 3213, 0), "Talk to Hatius Cosaintus in Lumbridge to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.lightSource, this.runeEss, this.axe, this.tinderbox, this.smallFishingNet, this.pickaxe, this.waterAccessOrAbyss, this.dough, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.rope, this.spinyHelm);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.AGILITY, 10));
        reqs.add(new SkillRequirement(Skill.FIREMAKING, 15));
        reqs.add(new SkillRequirement(Skill.FISHING, 15));
        reqs.add(new SkillRequirement(Skill.MINING, 15));
        reqs.add(new SkillRequirement(Skill.RUNECRAFT, 5));
        reqs.add(new SkillRequirement(Skill.SLAYER, 7));
        reqs.add(new SkillRequirement(Skill.WOODCUTTING, 15));
        reqs.add(this.runeMysteries);
        reqs.add(this.cooksAssistant);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Zombie (lvl 13) and cave bug (lvl 6)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Explorer's ring 1", 13125), new ItemReward("2,500 Exp. Lamp (Any skill over 30)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("30 casts of Low Level Alchemy per day without runes (does not provide experience) from Explorer's ring"), new UnlockReward("50% run energy replenish twice a day from Explorer's ring"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails draynorRooftopsSteps = new PanelDetails("Draynor Rooftops", Collections.singletonList(this.drayAgi), new SkillRequirement(Skill.AGILITY, 10));
        draynorRooftopsSteps.setDisplayCondition(this.notDrayAgi);
        draynorRooftopsSteps.setLockingStep(this.drayAgiTask);
        allSteps.add(draynorRooftopsSteps);
        PanelDetails zombieSteps = new PanelDetails("Kill Zombie in Draynor Sewers", Arrays.asList(this.moveToDraySewer, this.killZombie), this.combatGear);
        zombieSteps.setDisplayCondition(this.notKillZombie);
        zombieSteps.setLockingStep(this.killZombieTask);
        allSteps.add(zombieSteps);
        PanelDetails sedridorSteps = new PanelDetails("Rune Essence Mine", Arrays.asList(this.moveToSed, this.sedridor), this.runeMysteries);
        sedridorSteps.setDisplayCondition(this.notSedridor);
        sedridorSteps.setLockingStep(this.sedridorTask);
        allSteps.add(sedridorSteps);
        PanelDetails enterTheHamHideoutSteps = new PanelDetails("Enter the HAM Hideout", Collections.singletonList(this.enterHAM), new Requirement[0]);
        enterTheHamHideoutSteps.setDisplayCondition(this.notEnterHAM);
        enterTheHamHideoutSteps.setLockingStep(this.enterHAMTask);
        allSteps.add(enterTheHamHideoutSteps);
        PanelDetails killCaveBugSteps = new PanelDetails("Kill Cave Bug", Arrays.asList(this.addRopeToHole, this.killCaveBug), new SkillRequirement(Skill.SLAYER, 7), this.lightSource, this.rope, this.spinyHelm);
        killCaveBugSteps.setDisplayCondition(this.notKillCaveBug);
        killCaveBugSteps.setLockingStep(this.killCaveBugTask);
        allSteps.add(killCaveBugSteps);
        PanelDetails waterRunesSteps = new PanelDetails("Craft Water Runes", Arrays.asList(this.moveToWaterAltar, this.waterRune), new SkillRequirement(Skill.RUNECRAFT, 5), this.waterAccessOrAbyss, this.runeEss);
        waterRunesSteps.setDisplayCondition(this.notWaterRune);
        waterRunesSteps.setLockingStep(this.waterRuneTask);
        allSteps.add(waterRunesSteps);
        PanelDetails breadSteps = new PanelDetails("Cooking Bread", Collections.singletonList(this.bread), this.cooksAssistant, this.dough);
        breadSteps.setDisplayCondition(this.notBread);
        breadSteps.setLockingStep(this.breadTask);
        allSteps.add(breadSteps);
        PanelDetails hansSteps = new PanelDetails("Learn Age from Hans", Collections.singletonList(this.hans), new Requirement[0]);
        hansSteps.setDisplayCondition(this.notHans);
        hansSteps.setLockingStep(this.hansTask);
        allSteps.add(hansSteps);
        PanelDetails pickpocketSteps = new PanelDetails("Pickpocket Man or Woman", Collections.singletonList(this.pickpocket), new Requirement[0]);
        pickpocketSteps.setDisplayCondition(this.notPickpocket);
        pickpocketSteps.setLockingStep(this.pickpocketTask);
        allSteps.add(pickpocketSteps);
        PanelDetails oakSteps = new PanelDetails("Chop and Burn Oak Logs", Arrays.asList(this.chopOak, this.burnOak), new SkillRequirement(Skill.WOODCUTTING, 15), new SkillRequirement(Skill.FIREMAKING, 15), this.tinderbox, this.axe);
        oakSteps.setDisplayCondition(this.notOak);
        oakSteps.setLockingStep(this.oakTask);
        allSteps.add(oakSteps);
        PanelDetails mineIronSteps = new PanelDetails("Mine Iron in Al-Kharid", Collections.singletonList(this.mineIron), new SkillRequirement(Skill.MINING, 15), this.pickaxe);
        mineIronSteps.setDisplayCondition(this.notIron);
        mineIronSteps.setLockingStep(this.ironTask);
        allSteps.add(mineIronSteps);
        PanelDetails anchoviesSteps = new PanelDetails("Fish Anchovies in Al-Kharid", Collections.singletonList(this.fishAnchovies), new SkillRequirement(Skill.FISHING, 15), this.smallFishingNet);
        anchoviesSteps.setDisplayCondition(this.notFishAnchovies);
        anchoviesSteps.setLockingStep(this.fishAnchoviesTask);
        allSteps.add(anchoviesSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

