/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.kourend;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.Favour;
import com.questhelper.requirements.player.FavourRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;

@QuestDescriptor(quest=QuestHelperQuest.KOUREND_MEDIUM)
public class KourendMedium
extends ComplexStateQuestHelper {
    ItemRequirement dramenStaff;
    ItemRequirement kharedstsMemoirs;
    ItemRequirement pickaxe;
    ItemRequirement faceMask;
    ItemRequirement hammer;
    ItemRequirement nails;
    ItemRequirement planks;
    ItemRequirement kingWorm;
    ItemRequirement axe;
    ItemRequirement tinderbox;
    ItemRequirement boxTrap;
    ItemRequirement intelligence;
    ItemRequirement knife;
    ItemRequirement warmClothing;
    ItemRequirement combatGear;
    ItemRequirement food;
    ItemRequirement antipoison;
    ItemRequirement radasBlessing1;
    Requirement fairytaleII;
    Requirement depthsOfDespair;
    Requirement queenOfThieves;
    Requirement taleOfTheRighteous;
    Requirement forsakenTower;
    Requirement ascentOfArceuus;
    Requirement eaglesPeak;
    Requirement arceuusFavour;
    Requirement hosidiusFavour;
    Requirement shayzienFavour;
    Requirement memoirHos;
    Requirement memoirShay;
    Requirement memoirPis;
    Requirement memoirLova;
    Requirement memoirArc;
    Requirement notFairyRing;
    Requirement notKillLizardman;
    Requirement notTravelWithMemoirs;
    Requirement notMineSulphur;
    Requirement notEnterFarmingGuild;
    Requirement notSwitchSpellbooks;
    Requirement notRepairCrane;
    Requirement notDeliverIntelligence;
    Requirement notCatchBluegill;
    Requirement notUseBoulderShortcut;
    Requirement notSubdueWintertodt;
    Requirement notCatchChinchompa;
    Requirement notChopMahoganyTree;
    Requirement hasBird;
    QuestStep killGangBoss;
    QuestStep travelFairyRing;
    QuestStep travelWithMemoirs;
    QuestStep repairCrane;
    QuestStep catchBluegill;
    QuestStep useBoulderShortcut;
    QuestStep subdueWintertodt;
    QuestStep catchChinchompa;
    QuestStep chopMahoganyTree;
    QuestStep claimReward;
    QuestStep pickupWorms;
    ObjectStep mineSulphur;
    ObjectStep travelToMolchIsland;
    ObjectStep enterFarmingGuild;
    NpcStep killLizardman;
    NpcStep switchSpellbooks;
    NpcStep deliverIntelligence;
    NpcStep talkToAlry;
    ZoneRequirement inMolchIsland;
    Zone molchIsland;
    ConditionalStep fairyRingTask;
    ConditionalStep killLizardmanTask;
    ConditionalStep travelWithMemoirsTask;
    ConditionalStep mineSulphurTask;
    ConditionalStep enterFarmingGuildTask;
    ConditionalStep switchSpellbooksTask;
    ConditionalStep repairCraneTask;
    ConditionalStep deliverIntelligenceTask;
    ConditionalStep catchBluegillTask;
    ConditionalStep useBoulderShortcutTask;
    ConditionalStep subdueWintertodtTask;
    ConditionalStep catchChinchompaTask;
    ConditionalStep chopMahoganyTreeTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doMedium = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.fairyRingTask = new ConditionalStep((QuestHelper)this, this.travelFairyRing, new Requirement[0]);
        doMedium.addStep(this.notFairyRing, this.fairyRingTask);
        this.chopMahoganyTreeTask = new ConditionalStep((QuestHelper)this, this.chopMahoganyTree, new Requirement[0]);
        doMedium.addStep(this.notChopMahoganyTree, this.chopMahoganyTreeTask);
        this.enterFarmingGuildTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterFarmingGuild, new Requirement[0]);
        doMedium.addStep(this.notEnterFarmingGuild, this.enterFarmingGuildTask);
        this.catchBluegillTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.travelToMolchIsland, new Requirement[0]);
        this.catchBluegillTask.addStep(this.inMolchIsland, this.pickupWorms);
        this.catchBluegillTask.addStep(new Conditions(this.inMolchIsland, this.kingWorm), this.talkToAlry);
        this.catchBluegillTask.addStep(new Conditions(this.inMolchIsland, this.kingWorm, this.hasBird), this.catchBluegill);
        doMedium.addStep(this.notCatchBluegill, this.catchBluegillTask);
        this.mineSulphurTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.mineSulphur, new Requirement[0]);
        doMedium.addStep(this.notMineSulphur, this.mineSulphurTask);
        this.killLizardmanTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.killLizardman, new Requirement[0]);
        doMedium.addStep(this.notKillLizardman, this.killLizardmanTask);
        this.catchChinchompaTask = new ConditionalStep((QuestHelper)this, this.catchChinchompa, new Requirement[0]);
        doMedium.addStep(this.notCatchChinchompa, this.catchChinchompaTask);
        this.repairCraneTask = new ConditionalStep((QuestHelper)this, this.repairCrane, new Requirement[0]);
        doMedium.addStep(this.notRepairCrane, this.repairCraneTask);
        this.switchSpellbooksTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.switchSpellbooks, new Requirement[0]);
        doMedium.addStep(this.notSwitchSpellbooks, this.switchSpellbooksTask);
        this.useBoulderShortcutTask = new ConditionalStep((QuestHelper)this, this.useBoulderShortcut, new Requirement[0]);
        doMedium.addStep(this.notUseBoulderShortcut, this.useBoulderShortcutTask);
        this.subdueWintertodtTask = new ConditionalStep((QuestHelper)this, this.subdueWintertodt, new Requirement[0]);
        doMedium.addStep(this.notSubdueWintertodt, this.subdueWintertodtTask);
        this.deliverIntelligenceTask = new ConditionalStep((QuestHelper)this, this.killGangBoss, new Requirement[0]);
        this.deliverIntelligenceTask.addStep(this.intelligence.alsoCheckBank(this.questBank), this.deliverIntelligence);
        doMedium.addStep(this.notDeliverIntelligence, this.deliverIntelligenceTask);
        this.travelWithMemoirsTask = new ConditionalStep((QuestHelper)this, this.travelWithMemoirs, new Requirement[0]);
        doMedium.addStep(this.notTravelWithMemoirs, this.travelWithMemoirsTask);
        return doMedium;
    }

    @Override
    public void setupRequirements() {
        this.notFairyRing = new VarplayerRequirement(2085, false, 25);
        this.notKillLizardman = new VarplayerRequirement(2085, false, 13);
        this.notTravelWithMemoirs = new VarplayerRequirement(2085, false, 14);
        this.notMineSulphur = new VarplayerRequirement(2085, false, 15);
        this.notEnterFarmingGuild = new VarplayerRequirement(2085, false, 21);
        this.notSwitchSpellbooks = new VarplayerRequirement(2085, false, 16);
        this.notRepairCrane = new VarplayerRequirement(2085, false, 17);
        this.notDeliverIntelligence = new VarplayerRequirement(2085, false, 18);
        this.notCatchBluegill = new VarplayerRequirement(2085, false, 19);
        this.notUseBoulderShortcut = new VarplayerRequirement(2085, false, 22);
        this.notSubdueWintertodt = new VarplayerRequirement(2085, false, 20);
        this.notCatchChinchompa = new VarplayerRequirement(2085, false, 23);
        this.notChopMahoganyTree = new VarplayerRequirement(2085, false, 24);
        this.memoirArc = new VarbitRequirement(7917, Operation.EQUAL, 0, "");
        this.memoirHos = new VarbitRequirement(7918, Operation.EQUAL, 0, "");
        this.memoirLova = new VarbitRequirement(7919, Operation.EQUAL, 0, "");
        this.memoirShay = new VarbitRequirement(7920, Operation.EQUAL, 0, "");
        this.memoirPis = new VarbitRequirement(7921, Operation.EQUAL, 0, "");
        this.dramenStaff = new ItemRequirement("Dramen or Lunar staff", ItemCollections.FAIRY_STAFF, 1, true).showConditioned(this.notFairyRing).isNotConsumed();
        this.kharedstsMemoirs = new ItemRequirement("Kharedst's Memoirs or Book of the Dead", Arrays.asList(25818, 21760)).showConditioned(this.notTravelWithMemoirs).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notMineSulphur).isNotConsumed();
        this.faceMask = new ItemRequirement("Facemask or slayer helmet", ItemCollections.SLAYER_HELMETS, 1, true).showConditioned(this.notMineSulphur).isNotConsumed();
        this.faceMask.addAlternates(4164, 1506);
        this.hammer = new ItemRequirement("A hammer", ItemCollections.HAMMER).showConditioned(this.notRepairCrane).isNotConsumed();
        this.nails = new ItemRequirement("Nails", ItemCollections.NAILS, 50).showConditioned(this.notRepairCrane);
        this.planks = new ItemRequirement("Plank", 960, 3).showConditioned(this.notRepairCrane);
        this.kingWorm = new ItemRequirement("King worm or fish chunks", 2162).showConditioned(this.notCatchBluegill);
        this.kingWorm.addAlternates(22818);
        this.kingWorm.setTooltip("Obtainable on Molch Island");
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(new Conditions(LogicType.OR, this.notSubdueWintertodt, this.notChopMahoganyTree)).isNotConsumed();
        this.tinderbox = new ItemRequirement("Tinderbox", Arrays.asList(20720, 590)).showConditioned(this.notSubdueWintertodt).isNotConsumed();
        this.boxTrap = new ItemRequirement("Box trap", 10008).showConditioned(this.notCatchChinchompa).isNotConsumed();
        this.intelligence = new ItemRequirement("Intelligence", 13395).showConditioned(this.notDeliverIntelligence);
        this.knife = new ItemRequirement("Knife", 946).showConditioned(this.notSubdueWintertodt).isNotConsumed();
        this.warmClothing = new ItemRequirement("Warm clothing", ItemCollections.WARM_CLOTHING, 4, true).showConditioned(this.notSubdueWintertodt).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1).showConditioned(this.notKillLizardman);
        this.antipoison = new ItemRequirement("Anti-poison", ItemCollections.ANTIPOISONS).showConditioned(this.notKillLizardman);
        this.radasBlessing1 = new ItemRequirement("Rada's Blessing (1)", 22941, -1).showConditioned(this.notCatchChinchompa).isNotConsumed();
        this.fairytaleII = new QuestRequirement(QuestHelperQuest.FAIRYTALE_II__CURE_A_QUEEN, QuestState.IN_PROGRESS);
        this.depthsOfDespair = new QuestRequirement(QuestHelperQuest.THE_DEPTHS_OF_DESPAIR, QuestState.FINISHED);
        this.queenOfThieves = new QuestRequirement(QuestHelperQuest.THE_QUEEN_OF_THIEVES, QuestState.FINISHED);
        this.taleOfTheRighteous = new QuestRequirement(QuestHelperQuest.TALE_OF_THE_RIGHTEOUS, QuestState.FINISHED);
        this.forsakenTower = new QuestRequirement(QuestHelperQuest.THE_FORSAKEN_TOWER, QuestState.FINISHED);
        this.ascentOfArceuus = new QuestRequirement(QuestHelperQuest.THE_ASCENT_OF_ARCEUUS, QuestState.FINISHED);
        this.eaglesPeak = new QuestRequirement(QuestHelperQuest.EAGLES_PEAK, QuestState.FINISHED);
        this.arceuusFavour = new FavourRequirement(Favour.ARCEUUS, 60);
        this.hosidiusFavour = new FavourRequirement(Favour.HOSIDIUS, 60);
        this.shayzienFavour = new FavourRequirement(Favour.SHAYZIEN, 40);
        this.inMolchIsland = new ZoneRequirement(this.molchIsland);
        this.hasBird = new VarbitRequirement(5983, 1);
    }

    public void loadZones() {
        this.molchIsland = new Zone(new WorldPoint(1360, 3640, 0), new WorldPoint(1376, 3625, 0));
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.memoirArc == null) {
            return;
        }
        this.travelWithMemoirs.resetDialogSteps();
        if (this.memoirArc.check(this.client)) {
            this.travelWithMemoirs.addDialogStep("'A Dark Disposition' - Arceuus");
        }
        if (this.memoirHos.check(this.client)) {
            this.travelWithMemoirs.addDialogStep("'Lunch by the Lancalliums' - Hosidius");
        }
        if (this.memoirLova.check(this.client)) {
            this.travelWithMemoirs.addDialogStep("'Jewellery of Jubilation' - Lovakengj");
        }
        if (this.memoirShay.check(this.client)) {
            this.travelWithMemoirs.addDialogStep("'History and Hearsay' - Shayzien");
        }
        if (this.memoirPis.check(this.client)) {
            this.travelWithMemoirs.addDialogStep("'The Fisher's Flute' - Piscarilius");
        }
    }

    public void setupSteps() {
        this.travelFairyRing = new ObjectStep((QuestHelper)this, 11761, new WorldPoint(2658, 3230, 0), "Travel from any fairy ring to south of Mount Karuulm (CIR).", this.dramenStaff.highlighted());
        this.killLizardman = new NpcStep((QuestHelper)this, 6914, new WorldPoint(1507, 3683, 0), "Kill a lizardman.", true, this.combatGear, this.antipoison, this.food);
        this.killLizardman.addAlternateNpcs(6915, 6916, 6917, 6918, 6919);
        this.travelWithMemoirs = new ItemStep((QuestHelper)this, "Teleport to each of the five cities via the memoirs.", this.kharedstsMemoirs.highlighted());
        this.mineSulphur = new ObjectStep((QuestHelper)this, 28496, new WorldPoint(1444, 3860, 0), "Mine some volcanic sulfur in Lovakengj.", true, this.pickaxe, this.faceMask.equipped());
        this.mineSulphur.addAlternateObjects(28497, 28498);
        this.enterFarmingGuild = new ObjectStep((QuestHelper)this, 34463, new WorldPoint(1249, 3725, 0), "Enter the Farming Guild.", true, this.hosidiusFavour);
        this.enterFarmingGuild.addAlternateObjects(34464);
        this.switchSpellbooks = new NpcStep((QuestHelper)this, 7050, new WorldPoint(1712, 3882, 0), "Switch to the Arceuus spellbook via Tyss.", this.arceuusFavour);
        this.switchSpellbooks.addDialogStep("Can I try the magicks myself?");
        this.repairCrane = new ObjectStep((QuestHelper)this, 27555, new WorldPoint(1830, 3735, 0), "Repair a crane within Port Piscarilius.", true, this.hammer, this.nails, this.planks);
        this.killGangBoss = new DetailedQuestStep((QuestHelper)this, "Kill a gang boss or gang members for intelligence.", this.combatGear, this.food, this.shayzienFavour);
        this.deliverIntelligence = new NpcStep((QuestHelper)this, 6895, new WorldPoint(1504, 3632, 0), "Turn in the intelligence to Captain Ginea.", this.intelligence);
        this.deliverIntelligence.addAlternateNpcs(10931);
        this.deliverIntelligence.addIcon(13395);
        this.travelToMolchIsland = new ObjectStep((QuestHelper)this, 33614, new WorldPoint(1405, 3611, 0), "Board the boaty to Molch Island.", new Requirement[0]);
        this.travelToMolchIsland.addDialogStep("Molch Island");
        this.pickupWorms = new ItemStep((QuestHelper)this, new WorldPoint(1371, 3633, 0), "Collect some King Worms.", new Requirement[0]);
        this.talkToAlry = new NpcStep((QuestHelper)this, 8521, new WorldPoint(1366, 3631, 0), "Talk to Alry the Angler to receive a bird.", new Requirement[0]);
        this.talkToAlry.addDialogStep(2, "Could I have a go with your bird?");
        this.catchBluegill = new NpcStep((QuestHelper)this, 8523, new WorldPoint(1379, 3627, 0), "Catch a bluegill.", this.kingWorm);
        this.catchBluegill.addSubSteps(this.pickupWorms);
        this.useBoulderShortcut = new ObjectStep((QuestHelper)this, 27990, new WorldPoint(1776, 3883, 0), "Use the boulder leap shortcut from the path to the Soul Altar.", new SkillRequirement(Skill.AGILITY, 49));
        this.subdueWintertodt = new ObjectStep((QuestHelper)this, 29322, new WorldPoint(1631, 3962, 0), "Subdue the Wintertodt (earn at least 500 points).", this.axe, this.tinderbox, this.food, this.warmClothing, this.knife, this.hammer);
        this.catchChinchompa = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1485, 3507, 0), "Catch a chinchompa in the Kourend Woodland.", this.boxTrap.highlighted());
        this.catchChinchompa.addIcon(10008);
        this.chopMahoganyTree = new ObjectStep((QuestHelper)this, 36688, new WorldPoint(1238, 3771, 0), "Chop some logs from a mahogany tree North of the Farming Guild.", true, this.axe);
        this.claimReward = new NpcStep((QuestHelper)this, 8538, new WorldPoint(1647, 3665, 0), "Talk to Elise in the Kourend castle courtyard to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary");
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Kill a Lizardman (level 53)");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.dramenStaff, this.kharedstsMemoirs, this.pickaxe, this.faceMask, this.hammer, this.nails.quantity(50), this.planks.quantity(3), this.kingWorm, this.axe, this.tinderbox, this.boxTrap);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.knife, this.warmClothing, this.combatGear, this.food, this.antipoison, this.radasBlessing1);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.AGILITY, 49, true));
        req.add(new SkillRequirement(Skill.CRAFTING, 30));
        req.add(new SkillRequirement(Skill.FARMING, 45));
        req.add(new SkillRequirement(Skill.FIREMAKING, 50));
        req.add(new SkillRequirement(Skill.FISHING, 43));
        req.add(new SkillRequirement(Skill.HUNTER, 53, true));
        req.add(new SkillRequirement(Skill.MINING, 42));
        req.add(new SkillRequirement(Skill.WOODCUTTING, 50, true));
        req.add(this.arceuusFavour);
        req.add(this.hosidiusFavour);
        req.add(this.shayzienFavour);
        req.add(this.fairytaleII);
        req.add(this.depthsOfDespair);
        req.add(this.queenOfThieves);
        req.add(this.taleOfTheRighteous);
        req.add(this.forsakenTower);
        req.add(this.ascentOfArceuus);
        req.add(this.eaglesPeak);
        return req;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Rada's Blessing (2)", 22943, 1), new ItemReward("7,500 Exp. Lamp (Any skill over 40)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Free access cost for Crabclaw Isle"), new UnlockReward("5% chance to mine two Dense essence blocks at once"), new UnlockReward("20 free Dynamite per day from Thirus"), new UnlockReward("Reduced tanning prices at Eodan in Forthos Dungeon to 60%."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails fairyRingStep = new PanelDetails("Fairy Ring To Mount Karuulm", Collections.singletonList(this.travelFairyRing), this.dramenStaff, this.fairytaleII);
        fairyRingStep.setDisplayCondition(this.notFairyRing);
        fairyRingStep.setLockingStep(this.fairyRingTask);
        allSteps.add(fairyRingStep);
        PanelDetails chopMahoganyStep = new PanelDetails("Chop Mahogany Tree", Collections.singletonList(this.chopMahoganyTree), new SkillRequirement(Skill.WOODCUTTING, 50), this.axe);
        chopMahoganyStep.setDisplayCondition(this.notChopMahoganyTree);
        chopMahoganyStep.setLockingStep(this.chopMahoganyTreeTask);
        allSteps.add(chopMahoganyStep);
        PanelDetails enterFarmingGuildStep = new PanelDetails("Enter The Farming Guild", Collections.singletonList(this.enterFarmingGuild), new SkillRequirement(Skill.FARMING, 45), this.hosidiusFavour);
        enterFarmingGuildStep.setDisplayCondition(this.notEnterFarmingGuild);
        enterFarmingGuildStep.setLockingStep(this.enterFarmingGuildTask);
        allSteps.add(enterFarmingGuildStep);
        PanelDetails catchBluegillStep = new PanelDetails("Catch A Bluegill", Arrays.asList(this.travelToMolchIsland, this.pickupWorms, this.talkToAlry, this.catchBluegill), new SkillRequirement(Skill.FISHING, 43), new SkillRequirement(Skill.HUNTER, 35), this.kingWorm);
        catchBluegillStep.setDisplayCondition(this.notCatchBluegill);
        catchBluegillStep.setLockingStep(this.catchBluegillTask);
        allSteps.add(catchBluegillStep);
        PanelDetails mineSulphurStep = new PanelDetails("Mine volcanic sulphur", Collections.singletonList(this.mineSulphur), new SkillRequirement(Skill.MINING, 42), this.pickaxe, this.faceMask);
        mineSulphurStep.setDisplayCondition(this.notMineSulphur);
        mineSulphurStep.setLockingStep(this.mineSulphurTask);
        allSteps.add(mineSulphurStep);
        PanelDetails killLizardmanStep = new PanelDetails("Kill A Lizardman", Collections.singletonList(this.killLizardman), this.food, this.combatGear, this.antipoison);
        killLizardmanStep.setDisplayCondition(this.notKillLizardman);
        killLizardmanStep.setLockingStep(this.killLizardmanTask);
        allSteps.add(killLizardmanStep);
        PanelDetails catchChinStep = new PanelDetails("Catch A Chinchompa", Collections.singletonList(this.catchChinchompa), new SkillRequirement(Skill.HUNTER, 53), this.boxTrap, this.eaglesPeak);
        catchChinStep.setDisplayCondition(this.notCatchChinchompa);
        catchChinStep.setLockingStep(this.catchChinchompaTask);
        allSteps.add(catchChinStep);
        PanelDetails repairCraneStep = new PanelDetails("Repair Crane", Collections.singletonList(this.repairCrane), new SkillRequirement(Skill.CRAFTING, 30), this.hammer, this.nails, this.planks);
        repairCraneStep.setDisplayCondition(this.notRepairCrane);
        repairCraneStep.setLockingStep(this.repairCraneTask);
        allSteps.add(repairCraneStep);
        PanelDetails switchSpellbookStep = new PanelDetails("Arceuus Spellbook", Collections.singletonList(this.switchSpellbooks), this.arceuusFavour);
        switchSpellbookStep.setDisplayCondition(this.notSwitchSpellbooks);
        switchSpellbookStep.setLockingStep(this.switchSpellbooksTask);
        allSteps.add(switchSpellbookStep);
        PanelDetails leapBoulderStep = new PanelDetails("Leap the boulder", Collections.singletonList(this.useBoulderShortcut), new SkillRequirement(Skill.AGILITY, 49));
        leapBoulderStep.setDisplayCondition(this.notUseBoulderShortcut);
        leapBoulderStep.setLockingStep(this.useBoulderShortcutTask);
        allSteps.add(leapBoulderStep);
        PanelDetails subdueWintertodtStep = new PanelDetails("Subdue the Wintertodt", Collections.singletonList(this.subdueWintertodt), new SkillRequirement(Skill.FIREMAKING, 50), this.axe, this.tinderbox, this.food, this.warmClothing, this.knife, this.hammer);
        subdueWintertodtStep.setDisplayCondition(this.notSubdueWintertodt);
        subdueWintertodtStep.setLockingStep(this.subdueWintertodtTask);
        allSteps.add(subdueWintertodtStep);
        PanelDetails deliverIntelligenceStep = new PanelDetails("Deliver intelligence", Arrays.asList(this.killGangBoss, this.deliverIntelligence), this.combatGear, this.food, this.shayzienFavour);
        deliverIntelligenceStep.setDisplayCondition(this.notDeliverIntelligence);
        deliverIntelligenceStep.setLockingStep(this.deliverIntelligenceTask);
        allSteps.add(deliverIntelligenceStep);
        PanelDetails travelMemoirsStep = new PanelDetails("Travel With Kharedst's Memoirs", Collections.singletonList(this.travelWithMemoirs), this.depthsOfDespair, this.queenOfThieves, this.taleOfTheRighteous, this.forsakenTower, this.ascentOfArceuus, this.kharedstsMemoirs);
        travelMemoirsStep.setDisplayCondition(this.notTravelWithMemoirs);
        travelMemoirsStep.setLockingStep(this.travelWithMemoirsTask);
        allSteps.add(travelMemoirsStep);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

